<?php
if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

if (function_exists('telo_aff_pro_is_active') && telo_aff_pro_is_active()) {
    return; // No cargar esta parte si el PRO está activo
}

/**
 * Helper Lite
 */
if (! function_exists('telo_aff_is_lite')) {
    function telo_aff_is_lite()
    {
        return defined('TELO_AFFILIATES_IS_LITE') && TELO_AFFILIATES_IS_LITE;
    }
}

/**
 * Submenú: Solicitudes de cobro
 * - En Lite: render bloqueado
 * - En PRO: página funcional
 */
// add_action('admin_menu', function () {
//     add_submenu_page(
//         'telo-affiliates-lite',
//         __('Solicitudes de cobro', 'telo-affiliates-lite'),
//         __('Solicitudes de cobro', 'telo-affiliates-lite'),
//         'manage_options',
//         'telo-affiliates-requests',
//         telo_aff_is_lite() ? 'telo_affiliates_requests_locked_page' : 'telo_affiliates_requests_page'
//     );
// });

/**
 * Helpers internos
 */
function telo_aff_get_requests()
{
    $r = get_option('telo_affiliates_payout_requests', array());
    return is_array($r) ? $r : array();
}
function telo_aff_save_requests($arr)
{
    update_option('telo_affiliates_payout_requests', array_values($arr), false);
}
function telo_aff_find_request_index($id, &$list)
{
    foreach ($list as $i => $r) {
        if (! empty($r['id']) && $r['id'] === $id) return $i;
    }
    return -1;
}

// Solo CSS de solicitudes en su página
add_action('admin_enqueue_scripts', function ($hook) {
    $page = isset($_GET['page'])
        ? sanitize_key(wp_unslash($_GET['page']))
        : '';

    if ($page !== 'telo-affiliates-requests') {
        return;
    }

    wp_enqueue_style(
        'telo-affiliates-admin',
        TELO_AFFILIATES_URL . 'assets/css/telo-affiliates.css',
        [],
        defined('TELO_AFFILIATES_VERSION') ? TELO_AFFILIATES_VERSION : (function_exists('wp_get_theme') ? wp_get_theme()->get('Version') : '1.0.0')
    );
});


/**
 * Pantalla BLOQUEADA (Lite)
 */
function telo_affiliates_requests_locked_page()
{
    if (! current_user_can('manage_options')) {
        wp_die(esc_html__('No tienes permisos suficientes.', 'telo-affiliates-lite'));
    }

    echo '<div class="wrap telo-aff-admin telo-aff-req telo-aff-locked"><h1>' . esc_html__('Solicitudes de cobro', 'telo-affiliates-lite') . '</h1>';
    echo '<div class="telo-aff-blurred" style="min-height:240px;"></div>';
    // Caja upgrade
    if (! function_exists('telo_aff_upgrade_box')) {
        function telo_aff_upgrade_box($title = '')
        { ?>
            <div class="telo-aff-upgrade-wrap" style="margin-top:16px;">
                <div class="telo-aff-upgrade-box" style="background:#fff;border:1px solid #ccd0d4;padding:20px;border-radius:6px;">
                    <h2><?php echo esc_html($title ?: __('Desbloquea esta función', 'telo-affiliates-lite')); ?></h2>
                    <p><?php esc_html_e('La gestión de solicitudes y pagos está disponible en la versión PRO.', 'telo-affiliates-lite'); ?></p>
                    <p><a class="button button-primary button-hero" target="_blank" rel="noopener" href="https://licencias.qagencia.com/"><?php esc_html_e('Pásate a la versión PRO', 'telo-affiliates-lite'); ?></a></p>
                </div>
            </div>
<?php }
    }
    telo_aff_upgrade_box(__('Gestiona solicitudes y paga con un clic (PRO)', 'telo-affiliates-lite'));
    echo '</div>';
}

/**
 * Página: lista y procesa acciones (SOLO PRO)
 */
function telo_affiliates_requests_page()
{
    if (telo_aff_is_lite()) {
        // Salvaguarda por si alguien fuerza el callback
        telo_affiliates_requests_locked_page();
        return;
    }

    if (! current_user_can('manage_options')) {
        wp_die(esc_html__('No tienes permisos suficientes.', 'telo-affiliates-lite'));
    }
    if (!(function_exists('telo_aff_has_wc') ? telo_aff_has_wc() : class_exists('WooCommerce'))) {
        echo '<div class="wrap"><h1>' . esc_html__('Solicitudes de cobro', 'telo-affiliates-lite') . '</h1>';
        echo '<div class="notice notice-error"><p>'
            . esc_html__('WooCommerce no está activo. Actívalo para gestionar solicitudes de cobro.', 'telo-affiliates-lite')
            . '</p></div></div>';
        return;
    }

    $requests = telo_aff_get_requests();
    $notice   = '';

    // --------- Procesar acciones (aprobar / rechazar) ---------
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['telo_aff_req_action'])) {
        $action  = sanitize_key(wp_unslash($_POST['telo_aff_req_action']));
        $req_id  = isset($_POST['telo_aff_req_id']) ? sanitize_text_field(wp_unslash($_POST['telo_aff_req_id'])) : '';
        $note    = isset($_POST['telo_aff_req_note']) ? sanitize_textarea_field(wp_unslash($_POST['telo_aff_req_note'])) : '';

        check_admin_referer('telo_aff_req_do', 'telo_aff_req_nonce');

        $idx = telo_aff_find_request_index($req_id, $requests);
        if ($idx < 0) {
            $notice = '<div class="notice notice-error is-dismissible"><p>' . esc_html__('Solicitud no encontrada.', 'telo-affiliates-lite') . '</p></div>';
        } else {
            $req = $requests[$idx];

            // Ya procesada
            if (($req['status'] ?? '') !== 'pending') {
                $notice = '<div class="notice notice-warning is-dismissible"><p>' . esc_html__('Esta solicitud ya fue procesada.', 'telo-affiliates-lite') . '</p></div>';
            } else {
                if ($action === 'reject') {
                    // Rechazar
                    $req['status']       = 'rejected';
                    $req['processed_ts'] = time();
                    $req['note']         = $note;
                    $requests[$idx]      = $req;
                    telo_aff_save_requests($requests);

                    $notice = '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Solicitud rechazada.', 'telo-affiliates-lite') . '</p></div>';
                } elseif ($action === 'approve') {
                    // Aprobar → pagar pedidos incluidos (si siguen pendientes)
                    $slug    = $req['slug'] ?? '';
                    $rate    = isset($req['rate']) ? (float)$req['rate'] : 0.0;
                    $orders  = isset($req['orders']) && is_array($req['orders']) ? array_map('absint', $req['orders']) : array();

                    if (! $slug || empty($orders)) {
                        $notice = '<div class="notice notice-error is-dismissible"><p>' . esc_html__('Faltan datos en la solicitud (slug u órdenes).', 'telo-affiliates-lite') . '</p></div>';
                    } else {
                        $to_pay_orders = array();
                        $base_total    = 0.0;
                        foreach ($orders as $oid) {
                            $o = function_exists('wc_get_order') ? wc_get_order($oid) : null;
                            if (! $o) continue;

                            $is_this_aff = (string) $o->get_meta('_telo_affiliate', true) === $slug;
                            $already_paid = (string) $o->get_meta('_telo_aff_paid', true) === 'yes';

                            if ($is_this_aff && ! $already_paid) {
                                $to_pay_orders[] = $o;
                                $base_total     += (float) $o->get_total();
                            }
                        }

                        if (empty($to_pay_orders)) {
                            $req['status']       = 'empty';
                            $req['processed_ts'] = time();
                            $req['note']         = trim(($req['note'] ?? '') . ($note ? "\n" . $note : ''));
                            $requests[$idx]      = $req;
                            telo_aff_save_requests($requests);

                            $notice = '<div class="notice notice-warning is-dismissible"><p>' . esc_html__('No quedaban pedidos pendientes en esta solicitud.', 'telo-affiliates-lite') . '</p></div>';
                        } else {
                            $amount    = round($base_total * ($rate / 100), 2);
                            $payout_id = uniqid('telo_payout_', true);
                            $paid_ids  = array();

                            foreach ($to_pay_orders as $o) {
                                $o->update_meta_data('_telo_aff_paid', 'yes');
                                $o->update_meta_data('_telo_aff_payout_id', $payout_id);
                                $o->update_meta_data('_telo_aff_paid_ts', time());
                                $o->save();
                                $paid_ids[] = $o->get_id();
                            }

                            $payouts = get_option('telo_affiliates_payouts', array());
                            $payouts[] = array(
                                'id'         => $payout_id,
                                'slug'       => $slug,
                                'rate'       => $rate,
                                'orders'     => $paid_ids,
                                'base_total' => $base_total,
                                'amount'     => $amount,
                                'note'       => $note,
                                'timestamp'  => time(),
                            );
                            update_option('telo_affiliates_payouts', $payouts);

                            $req['status']        = 'approved';
                            $req['processed_ts']  = time();
                            $req['payout_id']     = $payout_id;
                            $req['paid_orders']   = $paid_ids;
                            $req['paid_base']     = $base_total;
                            $req['paid_amount']   = $amount;
                            $req['note']          = trim(($req['note'] ?? '') . ($note ? "\n" . $note : ''));
                            $requests[$idx]       = $req;
                            telo_aff_save_requests($requests);

                            if (function_exists('rocket_clean_domain')) {
                                rocket_clean_domain();
                            }
                            if (class_exists('\LiteSpeed_Cache_API')) {
                                \LiteSpeed_Cache_API::purge_all();
                            }
                            if (function_exists('w3tc_flush_all')) {
                                w3tc_flush_all();
                            }
                            if (function_exists('wpfc_clear_all_cache')) {
                                wpfc_clear_all_cache();
                            }
                            if (function_exists('wp_cache_flush')) {
                                wp_cache_flush();
                            }

                            do_action('telo_affiliates_payout_recorded', $payout_id, $slug, $paid_ids, $amount);

                            $notice = '<div class="notice notice-success is-dismissible"><p>' .
                                sprintf(
                                    esc_html__('Pago registrado para %1$s por %2$s.', 'telo-affiliates-lite'),
                                    esc_html($slug),
                                    function_exists('wc_price') ? wp_kses_post(wc_price($amount)) : esc_html(number_format_i18n($amount, 2))
                                ) .
                                '</p></div>';
                        }
                    }
                }
            }
        }
    }

    // Ordena: pendientes primero, luego por fecha desc.
    usort($requests, function ($a, $b) {
        $sa = $a['status'] ?? 'pending';
        $sb = $b['status'] ?? 'pending';
        if ($sa !== $sb) return ($sa === 'pending') ? -1 : 1;
        return ($b['timestamp'] ?? 0) <=> ($a['timestamp'] ?? 0);
    });

    // ---------- Render ----------
    echo '<div class="wrap telo-aff-admin telo-aff-req"><h1>' . esc_html__('Solicitudes de cobro', 'telo-affiliates-lite') . '</h1>';
    if (! empty($notice)) echo $notice;

    $requests_clean = array_values($requests);
    if (empty($requests_clean)) {
        echo '<p>' . esc_html__('No hay solicitudes registradas.', 'telo-affiliates-lite') . '</p></div>';
        return;
    }

    echo '<div class="telo-req-table-wrap">';
    echo '<table class="widefat fixed striped telo-req-table"><thead><tr>
    <th>' . esc_html__('Fecha', 'telo-affiliates-lite') . '</th>
    <th>' . esc_html__('Afiliado', 'telo-affiliates-lite') . '</th>
    <th>' . esc_html__('Email', 'telo-affiliates-lite') . '</th>
    <th>' . esc_html__('Pedidos', 'telo-affiliates-lite') . '</th>
    <th class="telo-req-num">' . esc_html__('Base', 'telo-affiliates-lite') . '</th>
    <th class="telo-req-num">' . esc_html__('%', 'telo-affiliates-lite') . '</th>
    <th class="telo-req-num">' . esc_html__('Importe', 'telo-affiliates-lite') . '</th>
    <th>' . esc_html__('Estado', 'telo-affiliates-lite') . '</th>
    <th>' . esc_html__('Acciones', 'telo-affiliates-lite') . '</th>
</tr></thead><tbody>';

    foreach ($requests_clean as $r) {
        $ts    = (int) ($r['timestamp'] ?? 0);
        $date  = $ts ? date_i18n(get_option('date_format') . ' ' . get_option('time_format'), $ts) : '—';
        $slug  = $r['slug']  ?? '';
        $name  = $r['name']  ?? $slug;
        $email = $r['email'] ?? '';
        $rate  = isset($r['rate']) ? (float)$r['rate'] : 0.0;
        $base  = isset($r['base_total']) ? (float)$r['base_total'] : 0.0;
        $amt   = isset($r['amount']) ? (float)$r['amount'] : 0.0;
        $orders = isset($r['orders']) && is_array($r['orders']) ? array_map('absint', $r['orders']) : array();
        $status = $r['status'] ?? 'pending';

        if (!empty($orders)) {
            $count = count($orders);
            $summary = sprintf(_n('%d pedido', '%d pedidos', $count, 'telo-affiliates-lite'), $count);

            $chips = [];
            foreach ($orders as $oid) {
                $chips[] = '<a class="telo-req-order" href="' . esc_url(admin_url('post.php?post=' . $oid . '&action=edit')) . '" target="_blank" rel="noopener">#' . absint($oid) . '</a>';
            }

            $orders_html = '<details class="telo-req-orders">'
                . '<summary>' . esc_html($summary) . '</summary>'
                . '<div class="telo-req-orders-grid">' . implode(' ', $chips) . '</div>'
                . '</details>';
        } else {
            $orders_html = '—';
        }

        $status_label = array(
            'pending'  => __('Pendiente', 'telo-affiliates-lite'),
            'approved' => __('Aprobada', 'telo-affiliates-lite'),
            'rejected' => __('Rechazada', 'telo-affiliates-lite'),
            'empty'    => __('Sin pedidos pendientes', 'telo-affiliates-lite'),
        )[$status] ?? $status;

        echo '<tr>
        <td>' . esc_html($date) . '</td>
        <td>' . esc_html($name) . ' <code>(' . esc_html($slug) . ')</code></td>
        <td class="telo-req-email">' . ($email ? esc_html($email) : '—') . '</td>
        <td>' . $orders_html . '</td>
        <td class="telo-req-num">' . (function_exists('wc_price') ? wp_kses_post(wc_price($base)) : esc_html(number_format_i18n($base, 2))) . '</td>
        <td class="telo-req-num">' . esc_html(number_format_i18n($rate, 2)) . '%</td>
        <td class="telo-req-num">' . (function_exists('wc_price') ? wp_kses_post(wc_price($amt)) : esc_html(number_format_i18n($amt, 2))) . '</td>
        <td>' . esc_html($status_label) . '</td>
        <td>';

        if ($status === 'pending') {
            echo '<form method="post" class="telo-req-actions">';
            wp_nonce_field('telo_aff_req_do', 'telo_aff_req_nonce');
            echo '<input type="hidden" name="telo_aff_req_id" value="' . esc_attr($r['id']) . '">';
            echo '<textarea name="telo_aff_req_note" rows="1" class="telo-req-note" placeholder="' . esc_attr__('Nota (opcional)', 'telo-affiliates-lite') . '"></textarea>';
            echo '<div class="telo-req-buttons">';
            echo '<button class="button button-primary" name="telo_aff_req_action" value="approve">' . esc_html__('Aprobar y pagar', 'telo-affiliates-lite') . '</button>';
            echo '<button class="button" name="telo_aff_req_action" value="reject">' . esc_html__('Rechazar', 'telo-affiliates-lite') . '</button>';
            echo '</div>';
            echo '</form>';
        } else {
            if ($status === 'approved') {
                $paid_amount = isset($r['paid_amount']) ? (float)$r['paid_amount'] : 0.0;
                echo '<em>' . esc_html__('Pagada', 'telo-affiliates-lite') . '</em> — '
                    . (function_exists('wc_price') ? wp_kses_post(wc_price($paid_amount)) : esc_html(number_format_i18n($paid_amount, 2)));
            } else {
                echo '<em>' . esc_html($status_label) . '</em>';
            }
        }

        echo '</td></tr>';
    }

    echo '</tbody></table></div>'; // .telo-req-table-wrap
    echo '</div>'; // .wrap
}
