(function () {
  document.addEventListener('click', function (e) {
    var btn = e.target && e.target.closest('.telo_copy_btn');
    if (!btn) return;

    var text = btn.getAttribute('data-copy') || '';
    if (!text) return;

    function done(ok) {
      var original = btn.textContent;
      btn.textContent = ok
        ? (window.teloAffI18n && window.teloAffI18n.copied) || 'Copiado'
        : (window.teloAffI18n && window.teloAffI18n.fallbackError) || 'No se pudo copiar';
      btn.disabled = true;
      setTimeout(function () {
        btn.textContent = original;
        btn.disabled = false;
      }, 1500);
    }

    // API moderna
    if (navigator.clipboard && window.isSecureContext) {
      navigator.clipboard.writeText(text).then(
        function () { done(true); },
        function () {
          // Fallback si falla
          tryFallback();
        }
      );
      return;
    }

    // Fallback para contextos no seguros
    tryFallback();

    function tryFallback() {
      try {
        var tmp = document.createElement('textarea');
        tmp.value = text;
        tmp.setAttribute('readonly', 'readonly');
        tmp.style.position = 'absolute';
        tmp.style.left = '-9999px';
        document.body.appendChild(tmp);
        tmp.select();
        tmp.setSelectionRange(0, 99999);
        var ok = document.execCommand('copy');
        document.body.removeChild(tmp);
        done(!!ok);
      } catch (err) {
        console && console.warn && console.warn('Copy failed:', err);
        done(false);
      }
    }
  });
})();
