<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once taxonomy_note_PLUGIN_DIR . 'includes/class-tn-settings.php';
require_once taxonomy_note_PLUGIN_DIR . 'includes/class-tn-metabox.php';

class taxonomy_note_Plugin {

    /**
     * @var taxonomy_note_Plugin
     */
    protected static $instance = null;

    /**
     * @var taxonomy_note_Settings
     */
    public $settings;

    /**
     * @var taxonomy_note_Metabox
     */
    public $metabox;

    /**
     * Get singleton instance.
     *
     * @return taxonomy_note_Plugin
     */
    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Constructor.
     */
    private function __construct() {
        $this->settings = new taxonomy_note_Settings();
        $this->metabox  = new taxonomy_note_Metabox( $this->settings );
    }
}
