<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://taxonomy.builders
 * @since             1.1.6
 * @package           Taxonomy_Builders
 *
 * @wordpress-plugin
 * Plugin Name:       Taxonomy.Builders
 * Plugin URI:        https://taxonomy.builders
 * Description:       Customize the WordPress term taxonomy page and enhance functionality by adding new settings.
 * Version:           2.0.0
 * Author:
 * Author URI:        https://taxonomy.builders
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       taxonomy-builders
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'TAXONOMY_BUILDERS_VERSION', '2.0.0' );
define( 'TAXONOMY_BUILDERS_PLUGIN_PATH', plugin_dir_url( __FILE__ ) );
define( 'TAXONOMY_BUILDERS_PLUGIN_URL', plugins_url( '/', __FILE__ ) );
define( 'TAXONOMY_BUILDERS_DIR', dirname( __FILE__ ) ); // Plugin dir



// Custom hook for content filter.
add_filter( 'se152488_the_content', 'do_blocks', 9 );
add_filter( 'se152488_the_content', 'wptexturize' );
add_filter( 'se152488_the_content', 'convert_smilies', 20 );
add_filter( 'se152488_the_content', 'convert_chars' );
add_filter( 'se152488_the_content', 'wpautop' );
add_filter( 'se152488_the_content', 'shortcode_unautop' );
add_filter( 'se152488_the_content', 'prepend_attachment' );
add_filter( 'se152488_the_content', 'wp_filter_content_tags' );
add_filter( 'se152488_the_content', 'wp_replace_insecure_home_url' );
add_filter( 'se152488_the_content', 'wc_do_oembeds' );

/**
 * Save the plugin activation data.
 */
register_activation_hook( __FILE__, 'txb_save_plugin_activation_data' );
function txb_save_plugin_activation_data() {
	// Save plugin activation timestamp , to show popup at specific time.
	$txb_plugin_activation_timestamp = get_option( 'txb_plugin_activation_timestamp', true );
	$txb_first_popup_display         = get_option( 'txb_first_popup_display', true );

	if ( empty( $txb_plugin_activation_timestamp ) ) {
		update_option( 'txb_plugin_activation_timestamp', mktime( 0 ) );
	}

	if ( empty( $txb_first_popup_display ) ) {
		update_option( 'txb_first_popup_display', 'txb_first_popup_no' );
	}

	// Save default array for hook archive page settings.
	txb_defualt_taxonomy_settings_save();
}

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-taxonomy-builders.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_taxonomy_builders() {
	$plugin = new Taxonomy_Builders();
	$plugin->run();
}
run_taxonomy_builders();

/**
 * Add iFrame to allowed wp_kses_post tags
 *
 * @param array  $tags Allowed tags, attributes, and/or entities.
 * @param string $context Context to judge allowed tags by. Allowed values are 'post'.
 *
 * @return array
 */
function wdm_custom_wpkses_post_tags( $tags, $context ) {
	// if ( 'post' === $context ) {
		$tags[ 'iframe' ] = array(
			'src'             => true,
			'height'          => true,
			'width'           => true,
			'frameborder'     => true,
			'allowfullscreen' => true,
		);
	// }

	return $tags;
}

add_filter( 'wp_kses_allowed_html', 'wdm_custom_wpkses_post_tags', 10, 2 );

/**
 * Get plugin default settings
 *
 * @since 2.0
 */
function txb_defualt_taxonomy_settings_save() {

	$txb_options = get_option( 'txb_options' );

	if ( ! empty( $txb_options ) ) {

		// Save default array for hook archive page settings.
		$args_taxonomies = array(
			'public'  => true,
			'show_ui' => true,
		);

		$txb_options = array();
		$output_taxonomies   = 'names';
		$operator_taxonomies = 'and';

		$get_taxonomy_slug = get_taxonomies( $args_taxonomies );
		
		if ( ! empty( $get_taxonomy_slug ) && is_array( $get_taxonomy_slug ) ) {
		
			$txb_options = array();
			foreach ( $get_taxonomy_slug as $tax_key => $tax_value ) {
				$txb_options['txb_hook_settings_archive'][$tax_value] = array(
					'txb_taxonomy_slug_archive' => $tax_value,
					'txb_hook_type_archive'     => '',
					'txb_hook_name_archive'     => '',
				);

				$txb_options['txb_hook_settings_single'][$tax_value] = array(
					'txb_taxonomy_slug_single' => $tax_value,
					'txb_hook_type_single'     => '',
					'txb_hook_name_single'     => '',
				);
			}

			update_option( 'txb_options', $txb_options );
		}
	}
}

/**
 * Clean variables using sanitize_text_field. Arrays are cleaned recursively.
 * Non-scalar values are ignored.
 * 
 * @since 2.0
 */
function txb_clean( $var ) {

	if ( is_array( $var ) ) {
		return array_map( 'txb_clean', $var );
	} else {
		$data = is_scalar( $var ) ? sanitize_text_field( $var ) : $var;
		return wp_unslash($data);
	}
}