<?php
get_header();

$current_term_id       = get_queried_object_id();
$current_term_taxonomy = get_term( $current_term_id );
$post_type             = get_taxonomy( $current_term_taxonomy->taxonomy )->object_type[0];
$current_term_name     = get_term_by( 'id', $current_term_id, $current_term_taxonomy->taxonomy );

// Get page number.
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 0; ?>

<div class="txb-taxonomy-card-block">

	<h2 align="center"><?php echo esc_attr( $current_term_name->name ); ?></h2>
	<div class="txb-taxonomy-card-section"> 

		<?php

		// Show page content for First page of pagination.
		$txb_all_data = get_term_meta( $current_term_id, 'txb_all_data', true );
		if ( ! empty( $txb_all_data ) ) {
			$txb_all_data_array = get_post( $txb_all_data );
			?>
			<div class="txb-taxonomy-page-details-section">
				<div class="txb-taxonomy-page-title-and-image">
					<h4></h4>
					<?php
					$txb_taxonomy_page_image = wp_get_attachment_image_src( get_post_thumbnail_id( $txb_all_data_array->ID ), 'large' );
					$txb_taxonomy_page_image = ! empty( $txb_taxonomy_page_image ) ? $txb_taxonomy_page_image[0] : '';
					echo(
						has_post_thumbnail( $txb_all_data_array->ID )
						? '<img class="txb-taxonomy-page-image" src="' . esc_url( $txb_taxonomy_page_image ) . '">'
						: ''
					);
					?>
				</div>
				<div class="txb-taxonomy-page-content">
					<?php
					$content = apply_filters( 'the_content', get_post_field( 'post_content', $txb_all_data_array->ID ) );
					echo wp_kses_post( $content );
					?>
				</div>
			</div>

			<?php
			// Show the default grid listing query and pagination.
			$txb_hide_listing = get_term_meta( $current_term_id, 'txb_hide_listing', true );
			if ( empty( $txb_hide_listing ) ) {
				$post_list = new WP_Query(
					array(
						'post_type'   => $post_type,
						'paged'       => $paged,
						'post_status' => 'publish',
						'tax_query'   => array(
							array(
								'taxonomy' => $current_term_taxonomy->taxonomy,
								'field'    => 'term_id',
								'terms'    => $current_term_id,
							),
						),
					)
				);


				// Hide the pagination and show default grid listing query.
				$txb_hide_paging = get_term_meta( $current_term_id, 'txb_hide_paging', true );
				if ( 'txb-hide-paging-yes' === $txb_hide_paging && empty( $txb_hide_listing ) ) {
					$posts_per_page = get_option( 'posts_per_page' );
					$post_list      = new WP_Query(
						array(
							'post_type'      => $post_type,
							'posts_per_page' => $posts_per_page,
							'post_status'    => 'publish',
							'tax_query'      => array(
								array(
									'taxonomy' => $current_term_taxonomy->taxonomy,
									'field'    => 'term_id',
									'terms'    => $current_term_id,
								),
							),
						)
					);
				}

				// Show the grid list based on setting selcted.
				if ( $post_list->have_posts() ) {
					?>
					<div class="card txb-taxonomy-post-card">
						<?php
						while ( $post_list->have_posts() ) {
							$post_list->the_post();
							$txb_post_image = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'medium' );
							$txb_post_image = ! empty( $txb_post_image ) ? $txb_post_image[0] : '';
							
							echo '<div class="txb-taxonomy-post-image-block">' .
							'<a href="' . esc_url( get_post_permalink( get_the_ID() ) ) . '" class="txb-taxonomy-link">' .
								(
									has_post_thumbnail( get_the_ID() )
									? '<img class="txb-taxonomy-post-image" src="' . esc_url( $txb_post_image ) . '">'
									: ''
								) .
								'<h6 class="txb-taxonomy-post-title">' . esc_attr( get_the_title() ) . '</h6>' .
								'<p class="txb-taxonomy-post-content">' . wp_kses_post( get_the_excerpt() ) . '</p>' .
							'</a>' .
							'</div>';
						}
						?>
					</div>

					<?php
				} else {
					echo '<div class="txb-no-data-found">' . esc_attr__( 'No Data Found', 'taxonomy-builders' ) . '</div>';
				}
			} else {
				// echo '<div class="txb-no-data-found">' . esc_attr__( 'No Data Found', 'taxonomy-builders' ) . '</div>';
			}
			// Show the numeric pagination.
			if ( empty( $txb_hide_listing ) && empty( $txb_hide_paging ) ) {
				$GLOBALS['wp_query']->max_num_pages = $post_list->max_num_pages;
				the_posts_pagination(
					array(
						'screen_reader_text' => ' ',
						'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'taxonomy-builders' ) . ' </span>',
					)
				);
			}
			wp_reset_query();
			wp_reset_postdata();
		} else {
			// echo '<div class="txb-no-data-found">' . esc_attr__( 'No Data Found', 'taxonomy-builders' ) . '</div>';
		}
		?>

	</div>

	<?php
	// Show the taxonomy builder link at the bottom of term archive page.
	if ( ! empty( $txb_all_data ) ) {
		$txb_tax_build = get_term_meta( $current_term_id, 'txb_taxanomy_builders', true );

		if ( empty( $txb_tax_build ) ) {
			?>
			<div class="txb-tax-build">
				<br/>

				<?php
				if ( is_tag() ) {
					$tax_val = 'tag';
				} else {
					$tax_val = 'category';
				}
				echo '<p>
					<small>' .
						esc_attr__( 'This ', 'taxonomy-builders' ) . esc_attr( $tax_val ) . esc_attr__( ' page content is built by ', 'taxonomy-builders' ) .
						'<a target="_blank" href="' . esc_url( 'https://taxonomy.builders' ) . '">' . esc_attr__( 'Taxonomy Content Builder', 'taxonomy-builders' ) . '</a>.
					</small>
				</p>';
				?>
			</div>
			<?php
		}
	}
	?>


</div>

<?php
get_footer();