(function($) {

    // Call to AJAX on click of numeric pagination : Term archive page.
    $(document).on( 'click', '.txb-taxonomy-card-section .nav-links a', function( event ) {
        event.preventDefault();
        $(window).scrollTop(0,0);

        var href = $(this).attr('href');
        parts = href.split("/"),
        last_part = parts[parts.length-2];

        if ( isNaN( parseInt( last_part ) ) ) {
            last_part = parts[parts.length - 1]
        }

        $.ajax({
            url: taxonomybuilders.ajaxurl,
            type: 'post',
            data: {
                action: 'txb_taxonomy_ajax_pagination',
                page: last_part,
                current_term_id: taxonomybuilders.current_term_id,
                current_term_taxonomy: taxonomybuilders.current_term_taxonomy,
                post_type: taxonomybuilders.post_type
            },
            success: function( html ) {
                $('.txb-taxonomy-card-section').html( html );
            }
        })

    })

})(jQuery);