<?php
/**
 * Settings Page
 *
 * @package Taxonomy.Builder
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$get_taxonomy_slug_text = array();
$args_taxonomies = array(
	'public'  => true,
	'show_ui' => true,
);

$output_taxonomies   = 'names';
$operator_taxonomies = 'and';
$get_taxonomy_slug = get_taxonomies( $args_taxonomies, $output_taxonomies, $operator_taxonomies );

$txb_options = get_option( 'txb_options' );
$txb_hook_settings_archive = ! empty( $txb_options['txb_hook_settings_archive'] ) ? $txb_options['txb_hook_settings_archive'] : array();
$txb_hook_settings_single = ! empty( $txb_options['txb_hook_settings_single'] ) ? $txb_options['txb_hook_settings_single'] : array();
?>
<div class="wrap txb-settings">
	<h2 align="center" class="txb_hook_setting_title">
		<?php esc_html_e( 'Configure below settings for Category/Taxonomy Archive Page and Single Post', 'taxonomy-builders' ); ?>
	</h2>
	<br/><br/>

	<?php
	if ( ! empty( $get_taxonomy_slug ) && is_array( $get_taxonomy_slug ) ) {
		foreach ( $get_taxonomy_slug as $get_taxonomy_slug_key => $get_taxonomy_slug_value ) {
			$get_taxonomy_slug_text[] = $get_taxonomy_slug_value;
		}
		?>

		<div class="txb_hook_settings_section" id="txb_hook_settings_section">

			<form action="options.php" method="post" class="txb_hook_settings_form_archive" id="txb_hook_settings_form_archive" name='txb_hook_settings_form_archive'>
				<?php settings_fields( 'txb_plugin_options' ); ?>
				<div class="txb-hook-setting-inr-wrap">
					<?php // Setting fields for category/taxonomy archive page : start. ?>	
					<h3>
						<?php esc_html_e( 'Category/Taxonomy Archive Page Settings', 'taxonomy-builders' ); ?>
					</h3>

					<div class="txb_hook_settings_archive" id="txb_hook_settings_archive">
						<div class="txb_hook_settings_form_archive" id="txb_hook_settings_form_archive">
							<table class="wp-list-table widefat fixed striped txb_hook_settings_table_archive">
								<!-- Table Headings -->
								<tr>
									<th><?php esc_html_e( 'Taxonomy Name', 'taxonomy-builders' ); ?></th>
									<th><?php esc_html_e( 'Select Hook Type', 'taxonomy-builders' ); ?></th>
									<th><?php esc_html_e( 'Add Hook Name', 'taxonomy-builders' ); ?></th>
									<th><?php esc_html_e( 'Action', 'taxonomy-builders' ); ?></th>
								</tr>

								<?php
								$txb_taxonomy_slug_archive = array_column( $txb_hook_settings_archive, 'txb_taxonomy_slug_archive' );
								foreach ( $get_taxonomy_slug as $get_taxonomy_slug_key => $get_taxonomy_slug_value ) {
									
									$get_taxonomy_details_archive = get_taxonomy( $get_taxonomy_slug_value );
									$get_taxonomy_name_archive    = $get_taxonomy_details_archive->labels->name;
									$txb_hook_archive = $txb_hook_settings_archive[$get_taxonomy_slug_key];
									?>
									<tr>
										<td>
											<input type="text" name="txb_options[txb_hook_settings_archive][<?php echo esc_attr( $get_taxonomy_slug_value ); ?>][txb_taxonomy_name_archive]" class="txb_taxonomy_name_archive" value="<?php echo esc_attr( $get_taxonomy_name_archive ); ?>" disabled>
											<input type="hidden" name="txb_options[txb_hook_settings_archive][<?php echo esc_attr( $get_taxonomy_slug_value ); ?>][txb_taxonomy_slug_archive]" class="txb_taxonomy_slug_archive" value="<?php echo esc_attr( $get_taxonomy_slug_value ); ?>">
										</td>

										<td>
											<select id="txb_select_archive_<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" class="txb_hook_type_archive txb_tax_archive_<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" name="txb_options[txb_hook_settings_archive][<?php echo esc_attr( $get_taxonomy_slug_value ); ?>][txb_hook_type_archive]">
												<option value=""><?php esc_html_e( 'Select Hook', '' ); ?></option>
												<option <?php selected( 'txb_action_archive', $txb_hook_archive['txb_hook_type_archive'] ); ?> value="txb_action_archive"><?php esc_html_e( 'Action', '' ); ?></option>
												<option <?php selected( 'txb_filter_archive', $txb_hook_archive['txb_hook_type_archive'] ); ?> value="txb_filter_archive"><?php esc_html_e( 'Filter', '' ); ?></option>
											</select>
										</td>

										<td>
											<input type="text" class="txb_hook_name_archive txb_tax_archive_<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" id="txb_enable_archive_<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" name="txb_options[txb_hook_settings_archive][<?php echo esc_attr( $get_taxonomy_slug_value ); ?>][txb_hook_name_archive]" value="<?php echo esc_attr( $txb_hook_archive['txb_hook_name_archive'] ); ?>">
										</td>

										<td>
											<a id="txb_reset_archive-<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" href="#" class="button-primary txb_hook_setting_reset_archive"><?php esc_html_e( 'Reset', 'taxonomy-builders' ); ?></a>
										</td>
									</tr>
									<?php
								}
								?>
								<tr> 
									<td align="center" colspan="4">
										<input type="submit" name="txb_options[txb_hook_setting_save]" class="button button-primary txb_hook_setting_save_archive" value="<?php _e('Save','taxonomy-builders'); ?>" />
									</td>
								</tr>

							</table>
						</div>
					</div>
					<?php // Setting fields for category/taxonomy archive page : end. ?>	

					<?php // Setting fields for single post : start. ?>
					<h3>
						<?php esc_html_e( 'Single Post Settings', 'taxonomy-builders' ); ?>
					</h3>

					<div class="txb_hook_settings_single" id="txb_hook_settings_single">
						<div class="txb_hook_settings_form_single" id="txb_hook_settings_form_single">
							<table class="wp-list-table widefat fixed striped txb_hook_settings_table_single">
								<tr>
									<th><?php esc_html_e( 'Taxonomy Name', 'taxonomy-builders' ); ?></th>
									<th><?php esc_html_e( 'Select Hook Type', 'taxonomy-builders' ); ?></th>
									<th><?php esc_html_e( 'Add Hook Name', 'taxonomy-builders' ); ?></th>
									<th><?php esc_html_e( 'Action', 'taxonomy-builders' ); ?></th>
								</tr>

								<?php
								$txb_taxonomy_slug_single 			= array_column( $txb_hook_settings_single, 'txb_taxonomy_slug_single' );
								foreach ( $get_taxonomy_slug as $get_taxonomy_slug_key => $get_taxonomy_slug_value ) {
											
									$get_taxonomy_details_single = get_taxonomy( $get_taxonomy_slug_value );
									$get_taxonomy_name_single    = $get_taxonomy_details_single->labels->name;
									$txb_hook_single = $txb_hook_settings_single[$get_taxonomy_slug_key];
									?>
									<tr>
										<td>
											<input type="text" name="txb_options[txb_hook_settings_single][<?php echo esc_attr( $get_taxonomy_slug_value ); ?>][txb_taxonomy_name_single]" class="txb_taxonomy_name_single" value="<?php echo esc_attr( $get_taxonomy_name_single ); ?>" disabled>
											<input type="hidden" name="txb_options[txb_hook_settings_single][<?php echo esc_attr( $get_taxonomy_slug_value ); ?>][txb_taxonomy_slug_single]" class="txb_taxonomy_slug_single" value="<?php echo esc_attr( $get_taxonomy_slug_value ); ?>">
										</td>
										<td>
											<select id="txb_select_single_<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" class="txb_hook_type_single txb_tax_single_<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" name="txb_options[txb_hook_settings_single][<?php echo esc_attr( $get_taxonomy_slug_value ); ?>][txb_hook_type_single]">
												<option value=""><?php esc_html_e( 'Select Hook', 'taxonomy-builders' ); ?></option>
												<option <?php selected( 'txb_action_single', $txb_hook_single['txb_hook_type_single'] ); ?> value="txb_action_single"><?php esc_html_e( 'Action', 'taxonomy-builders' ); ?></option>
												<option <?php selected( 'txb_filter_single', $txb_hook_single['txb_hook_type_single'] ); ?> value="txb_filter_single"><?php esc_html_e( 'Filter', 'taxonomy-builders' ); ?></option>
											</select>
										</td>
										<td>
											<input type="text" class="txb_hook_name_single txb_tax_single_<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" id="txb_enable_single_<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" name="txb_options[txb_hook_settings_single][<?php echo esc_attr( $get_taxonomy_slug_value ); ?>][txb_hook_name_single]" value="<?php echo esc_attr( $txb_hook_single['txb_hook_name_single'] ); ?>">
										</td>
										<td>
											<a id="txb_reset_single-<?php echo esc_attr( $get_taxonomy_slug_value ); ?>" href="#" class="button-primary txb_hook_setting_reset_single"><?php esc_html_e( 'Reset', 'taxonomy-builders' ); ?></a>
										</td>
									</tr>
									<?php
								}
								?>
								
								<tr>
									<td align="center" colspan="4">
										<input type="submit" name="txb_options[txb_hook_setting_save]" class="button button-primary txb_hook_setting_save_single" value="<?php _e('Save','taxonomy-builders'); ?>" />
									</td>
								</tr>
							</table>
						</div>
					</div>
					<?php // Setting fields for single post : end. ?>
				</div>
			</form>

		</div>

		<div class="txb-hook-setting-donation">
			<p>
				<small><?php esc_html_e( 'Please consider a small donation to keep this free plugin development going.', 'taxonomy-builders' ); ?>
				<a target="_blank" href="<?php esc_url( 'https://taxonomy.builders' ); ?>"><?php esc_html_e( 'Payment', 'taxonomy-builders' ); ?>'</a>
				</small>
			</p>
			<p>
				<small><?php esc_html_e( 'Please let us know how we can improve by giving your feedback here!', 'taxonomy-builders' ); ?>
				<a target="_blank" href="<?php esc_url( 'https://taxonomy.builders' ); ?> '"> <?php esc_html_e( 'Feedback', 'taxonomy-builders' ); ?> '</a>
				</small>
			</p>
		</div>
	<?php
	}
	?>
</div>