(function($) {
    'use strict';

    jQuery(document).ready(function(){

        // Get current date and time in timestamp format.
        var txb_get_current_date = new Date().getTime(); 

        // Get plugin activation date.
        var txb_plugin_activation_timestamp = taxonomybuildersadmin.txb_plugin_activation_timestamp; 

        var txb_first_popup_display = taxonomybuildersadmin.txb_first_popup_display; 

        // Calculate time : After 6 days of plugin activation.
        var calculate_first_popup_time = +txb_plugin_activation_timestamp + +518400000;

        // Show the popup after 6 days of plugin activation.
        if ( txb_get_current_date >= calculate_first_popup_time && txb_first_popup_display == "txb_first_popup_no" ) {
            setTimeout(function(){ 
                jQuery('#txb-open-popup').click();
            }, 2000);
        }
        
        // Get next popup show date.
        var txb_next_popup_timestamp = taxonomybuildersadmin.txb_next_popup_timestamp; 
        var txb_next_popup_display = taxonomybuildersadmin.txb_next_popup_display;

        // Show the popup after 24 hours , if "Cancel" or "Cross" icon is clicked.
        if ( txb_get_current_date >= txb_next_popup_timestamp && txb_next_popup_display == "txb_next_popup_no" ) {
            setTimeout(function(){ 
                jQuery('#txb-open-popup').click();
            }, 2000);
        } 


        // Call to AJAX , when "Cross" icon is clicked , and save next popup show timings.
        setTimeout(function(){ 
            $('#TB_closeWindowButton').click(function(){

                var txb_current_date = new Date(); 
                var txb_next_date = txb_current_date.getTime() + 86400000;
                var params =  {"txb_next_date":txb_next_date,action:"txb_save_next_popup_time"}

                jQuery.post(taxonomybuildersadmin.ajaxurl,params,function(data){
                    if(data){
                        console.log("Next popup timing saved");
                    }else{
                        console.log("Error saving next popup timing");
                    }

                });

            })
        }, 3000);

        // Call to AJAX , when "Cancel" button is clicked , and save next popup show timings.
        $( document ).on('click','.txb-cancel-btn',function(event) {

            var txb_current_date = new Date(); 
            var txb_next_date = txb_current_date.getTime() + 86400000;
            var params =  {"txb_next_date":txb_next_date,action:"txb_save_next_popup_time"}

            jQuery.post(taxonomybuildersadmin.ajaxurl,params,function(data){
                if(data){
                    console.log("Next popup timing saved.");
                }else{
                    console.log("Error saving next popup timing.");
                }

            });

        })

        // Call to AJAX , when "Don't show again" button is clicked , and remove popup show timings.
        $( document ).on('click','.txb-not-show-btn',function(event) {

            var txb_never_show_popup = "txb_never";
            var params =  {"txb_never_show_popup":txb_never_show_popup,action:"txb_not_show_popup"}

            jQuery.post(taxonomybuildersadmin.ajaxurl,params,function(data){
                if(data){
                    console.log("Popup will not shown again.");
                }else{
                    console.log("Error removing popup timing.");
                }

            });

        })


        //Blur out sub fields if page is not selected for archive page.
        $( document ).on('change','select#txb-all-data',function(event) {
       
            var selected_txb_all_data = $( this ).val();

            if(selected_txb_all_data==''){
                $(".txb-description-subfields").addClass("txb-disable-description");
                $(".txb-description-exta-subfields").addClass("txb-disable-description");
                $(".txb-disable-description").css("opacity", "0.5");
                $(".txb-disable-description").css("pointer-events", "none");
            }else{
                $(".txb-disable-description").css("opacity", "unset");
                $(".txb-disable-description").css("pointer-events", "unset");
                $(".txb-description-subfields").removeClass("txb-disable-description");
            }

        })

        //Blur out Content sub fields if page is not selected for archive page.
        $( document ).on('change','#txb-show-page-content',function(event) {
       
            if($(this).is(":checked")){
                $(".txb-disable-content-subfields").css("opacity", "unset");
                $(".txb-disable-content-subfields").css("pointer-events", "unset");
                $(".txb-all-page-content-wrap").removeClass("txb-disable-content-subfields");
            }else{
                $(".txb-all-page-content-wrap").addClass("txb-disable-content-subfields");
                $(".txb-disable-content-subfields").css("opacity", "0.5");
                $(".txb-disable-content-subfields").css("pointer-events", "none");
            }

        })

        //Blur out sub fields if page is not selected for single post page.
        $( document ).on('change','select#txb-append-data',function(event) {
       
            var selected_txb_append_data = $( this ).val();

            if(selected_txb_append_data==''){
                $(".txb-append-subfields").addClass("txb-disable-append");
                $(".txb-disable-append").css("opacity", "0.5");
                $(".txb-disable-append").css("pointer-events", "none");
            }else{
                $(".txb-disable-append").css("opacity", "unset");
                $(".txb-disable-append").css("pointer-events", "unset");
                $(".txb-description-subfields").removeClass("txb-disable-append");
            }

        })

    });

})(jQuery);