<?php
/**
 * Add Taxonomy Form Field
 *
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// $callback = function ( $term, $taxonomy ) use ( $get_taxonomy_slug_value ) {
$txb_all_data = get_term_meta( $term->term_id, 'txb_all_data', true );

if ( empty( $txb_all_data ) ) {
	$description_class = 'txb-disable-description';
} else {
	$description_class = '';
} 
?>

<!-- Setting fields for term archive page : start. -->
<tbody class="txb-description-section">
<!-- Setting field : Select a Page. -->
	<tr class="form-field txb-all-data-wrap">
		<th scope="row">
			<label for="txb-all-data"> <?php esc_html_e( 'Description', 'taxonomy-builders' ); ?> </label>
		</th>
		<td>
			<?php
			wp_dropdown_pages(
				array(
					'show_option_none' => esc_html__( 'Select a Page', 'taxonomy-builders' ),
					'name'     => 'txb_all_data',
					'id'       => 'txb-all-data',
					'class'    => 'txb-all-data',
					'selected' => esc_attr( $txb_all_data ),
				)
			);
			?>
			<p class="txb-all-data-description"> <?php esc_html_e( 'Select a WordPress page to append the content of the page.', 'taxonomy-builders' ); ?> </p>
			<p class="txb-all-data-description-note"> <?php esc_html_e( 'This settings will override default Archive Page Layout , To keep existing theme\'s layout for Archive Page , you can set page setting from here and configure hook setting from here.', 'taxonomy-builders' ); ?>
			<a target="_blank" href="<?php echo esc_url( admin_url( '/options-general.php?page=txb-hook-setting' ) ); ?>"> <?php esc_html_e( 'Taxonomy Hooks', 'taxonomy-builders' ); ?> </a>
			</p>
		</td>
	</tr>
</tbody>
<?php
$txb_hide_listing = get_term_meta( $term->term_id, 'txb_hide_listing', true );
$txb_hide_listing = ! empty( $txb_hide_listing ) ? true : false;

$txb_hide_paging = get_term_meta( $term->term_id, 'txb_hide_paging', true );
$txb_hide_paging = ! empty( $txb_hide_paging ) ? true : false;

$txb_show_page_content = get_term_meta( $term->term_id, 'txb_show_page_content', true );
if ( empty( $txb_show_page_content ) ) {
	$txb_show_page_content_checked = false;
	$txb_show_content_class        = 'txb-disable-content-subfields';
} else {
	$txb_show_page_content_checked = true;
	$txb_show_content_class        = '';
}
?>
<tbody class="txb-description-subfields <?php echo esc_attr( $description_class ); ?>">
	<!-- Setting field : Hide Listing. -->
	<tr class="form-field txb-tax-build-wrap">
		<td></td>
		<td>
			<input type="checkbox" class="txb-hide-listing" id="txb-hide-listing" name="txb_hide_listing" value="txb-hide-listing-yes" <?php checked( $txb_hide_listing, true ); ?>>
			<label for="txb-hide-listing"> <?php esc_html_e( 'Hide Listing', 'taxonomy-builders' ); ?></label>
		</td>
	</tr>
	<!-- Setting field : Hide Paging. -->
	<tr class="form-field txb-hide-paging-wrap">
		<td></td>
		<td>
			<input type="checkbox" id="txb-hide-paging" class="txb-hide-paging" name="txb_hide_paging" value="txb-hide-paging-yes" <?php checked( $txb_hide_paging, true ); ?>>
			<label for="txb-hide-paging"><?php esc_html_e( 'Hide Paging', 'taxonomy-builders' ); ?></label>
		</td>
	</tr>
	<!-- Setting field : Show content for all page. -->
	<tr class="form-field txb-show-page-content-wrap">
		<td></td>
		<td>
			<input type="checkbox" id="txb-show-page-content" class="txb-show-page-content" name="txb_show_page_content" value="show-page-content-yes" <?php checked( $txb_show_page_content_checked, true ); ?>>
			<label for="txb-show-page-content"> <?php esc_html_e( 'Show different content from 2nd page', 'taxonomy-builders' ); ?></label>
		</td>
	</tr>
	<!-- Setting field : Select a Page. To show the different description from 2nd page of pagination. -->
	<tr class="form-field txb-all-page-content-wrap <?php echo esc_attr( $txb_show_content_class ); ?>">
		<td></td>
		<td>

			<?php
			$txb_all_page_content = get_term_meta( $term->term_id, 'txb_all_page_content', true );
			wp_dropdown_pages(
				array(
					'show_option_none' => esc_html__( 'Select a Page', 'taxonomy-builders' ),
					'name'             => 'txb_all_page_content',
					'id'               => 'txb-all-page-content',
					'class'            => 'txb-all-page-content',
					'selected'         => esc_attr( $txb_all_page_content ),
				)
			);
			?>
			<p class="txb-all-page-content-description"><?php esc_html_e( 'Select a different page to show different content from 2nd page of pagination.', 'taxonomy-builders' ); ?></p>
		</td>
	</tr>
</tbody>
<tbody class="txb-description-exta-subfields <?php echo esc_attr( $description_class ); ?>">
</tbody>
<!-- Setting fields for term archive page : end. -->

<!-- Setting fields for single post page : start. -->
<tbody class="txb-append-section">
	<!-- Setting field : Select a Page. To append page content. -->
	<tr class="form-field txb-append-data-wrap">
		<th scope="row">
			<label for="txb-append-data"><?php esc_html_e( 'Append', 'taxonomy-builders' ); ?></label>
		</th>
		<td>
		<?php
		$txb_append_data = get_term_meta( $term->term_id, 'txb_append_data', true );
		wp_dropdown_pages(
			array(
				'show_option_none' => esc_html__( 'Select a Page', 'taxonomy-builders' ),
				'name'             => 'txb_append_data',
				'id'               => 'txb-append-data',
				'class'            => 'txb-append-data',
				'selected'         => esc_attr( $txb_append_data ),
			)
		);
		?>
			<p class="txb-append-data-description"> <?php esc_html_e( 'Select a page to append the description to single post content.', 'taxonomy-builders' ); ?></p>
			<p class="txb-all-data-description-note"><?php esc_html_e( 'Please note: The append, prepend setting only works with filters. It will not work as expected with Action hooks, as it will only show once when the action is called.', 'taxonomy-builders' ); ?></p>
			<p class="txb-all-data-description-note"> <?php esc_html_e( 'This settings will override default Single Post Page Layout , To keep existing theme\'s layout for Single Post Page , you can set page setting from here and configure hook setting from here.', 'taxonomy-builders' ); ?>
			<a target="_blank" href="<?php echo esc_url( admin_url( '/options-general.php?page=txb-hook-setting' ) ); ?>"><?php esc_html_e( 'Taxonomy Hooks', 'taxonomy-builders' ); ?></a>
			</p>
			<p><?php esc_html_e( 'The below settings only work with filter hook to attach content before or after original content, action hook will only show once when called' ); ?> </p>
		</td>
	</tr>
</tbody>

<?php
$txb_description_position = get_term_meta( $term->term_id, 'txb_description_position', true );
$append_class = empty( $txb_append_data ) ? 'txb-disable-append' : '';
?>
<tbody class="txb-append-subfields <?php echo esc_attr( $append_class ); ?>">
	<!-- Setting field : Content placement. Append/Prepend/Both. -->
	<tr class="form-field txb-append-wrap">
		<td></td>
		<td>
			<input type="radio" id="txb-append" class="txb-position" name="txb_description_position" value="txb-append-yes" <?php checked( 'txb-append-yes', $txb_description_position ); ?>>
			<label for="txb-append"><?php esc_html_e( 'Append', 'taxonomy-builders' ); ?></label>
		</td>
	</tr>
	<tr class="form-field txb-prepend-wrap">
		<td></td>
		<td>
			<input type="radio" id="txb-prepend" class="txb-position" name="txb_description_position" value="txb-prepend-yes" <?php checked( 'txb-prepend-yes', $txb_description_position ); ?>>
			<label for="txb-prepend"> <?php esc_html_e( 'Prepend', 'taxonomy-builders' ); ?></label>
		</td>
	</tr>
	<tr class="form-field txb-both-wrap">
		<td></td>
		<td>
			<input type="radio" id="txb-both" class="txb-position" name="txb_description_position" value="txb-both-yes" <?php checked( 'txb-both-yes', $txb_description_position ); ?>>
			<label for="txb-both"><?php esc_html_e( 'Both', 'taxonomy-builders' ); ?></label>
		</td>
	</tr>
	<!-- Setting field : Priority. -->
	<tr class="form-field txb-priority-wrap">
		<td></td>
		<td>
			<select name="txb_priority" id="txb-priority" class="txb-priority">
				<option value="0"><?php esc_html_e( 'Priority', 'taxonomy-builders' ); ?></option>
				<?php
				$txb_priority = get_term_meta( $term->term_id, 'txb_priority', true );
				for ( $p = 1; $p <= 255; $p++ ) { ?>
					<option value="<?php echo esc_attr( $p ); ?>" <?php selected( $txb_priority, $p ); ?>><?php echo esc_attr( $p ); ?></option>
				<?php } ?>
			</select>
		</td>
	</tr>
</tbody>
<!-- Setting fields for single post page : end. -->

<!-- Setting fields for feedback/donation : start. -->
<tbody class="txb-donation-feedback-wrap">
	<tr class="form-field txb-donation-wrap">
		<td></td>
		<td>
			<p>
				<small>
					<?php esc_html_e( 'Please consider a small donation to keep this free plugin development going.', 'taxonomy-builders' ); ?>
					<a target="_blank" href="<?php echo esc_url( 'https://taxonomy.builders' ); ?>"><?php esc_html_e( 'Payment', 'taxonomy-builders' ); ?></a>
				</small>
			</p>
			<p>
				<small>
					<?php esc_html_e( 'Please let us know how we can improve by giving your feedback here!', 'taxonomy-builders' ); ?>
					<a target="_blank" href="<?php echo esc_url( 'https://taxonomy.builders' ); ?>"><?php esc_html_e( 'Feedback', 'taxonomy-builders' ); ?></a>
				</small>
			</p>
		</td>
	</tr>
	<tr class="form-field txb-feedback-wrap">
		<td></td>
		<td></td>
	</tr>
</tbody>
<!-- Setting fields for feedback/donation : end. -->
