<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://bizzmags.ro
 * @since             1.0.0
 * @package           SyncNexusWC
 *
 * @wordpress-plugin
 * Plugin Name:       Sync for Nexus ERP and WC
 * Plugin URI:        https://bizzmags.ro
 * Description:       Seamlessly connect your WooCommerce store with Nexus ERP. Automatically sync invoices and products. eMAG Marketplace integration supported via the Bizzmags Marketplace plugin.
 * Version:           1.0.9
 * Author:            Claudiu Maftei
 * Author URI:        https://bizzmags.ro/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       sync-nexus-wc
 * Domain Path:       /languages
 * Requires Plugins: woocommerce
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'CLAUDIUS_SYNCNEXUSWC_VERSION', '1.0.9' );
define( 'CLAUDIUS_SYNCNEXUSWC_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'CLAUDIUS_SYNCNEXUSWC_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-syncnexuswc-activator.php
 */
function claudius_syncnexuswc_activate() {
    require_once plugin_dir_path( __FILE__ ) . 'includes/class-syncnexuswc-activator.php';
    $activator = new ClaudiuMaftei\SyncNexusWC\SyncNexusWC_Activator;
    $activator->activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-syncnexuswc-deactivator.php
 */
function claudius_syncnexuswc_deactivate() {
    require_once plugin_dir_path( __FILE__ ) . 'includes/class-syncnexuswc-deactivator.php';
    $deactivator = new ClaudiuMaftei\SyncNexusWC\SyncNexusWC_Deactivator;
    $deactivator->deactivate();
}

register_activation_hook( __FILE__, 'claudius_syncnexuswc_activate' );
register_deactivation_hook( __FILE__, 'claudius_syncnexuswc_deactivate' );

// Creating table whenever a new blog is created
function claudius_syncnexuswc_new_blog_plugin_check($blog_id, $user_id, $domain, $path, $site_id, $meta) {
    require_once plugin_dir_path( __FILE__ ) . 'includes/class-syncnexuswc-activator.php';
    $activator=new ClaudiuMaftei\SyncNexusWC\SyncNexusWC_Activator;
    $activator->on_create_blog($blog_id, $user_id, $domain, $path, $site_id, $meta);
}
add_action( 'wpmu_new_blog', 'claudius_syncnexuswc_new_blog_plugin_check', 10, 6 );

// Deleting the table whenever a blog is deleted
function claudius_syncnexuswc_on_delete_blog_syncnexuswc_plugin_check( $tables ) {
    require_once plugin_dir_path( __FILE__ ) . 'includes/class-syncnexuswc-activator.php';
    $activator=new ClaudiuMaftei\SyncNexusWC\SyncNexusWC_Activator;
    return $activator->on_delete_blog($tables);
}
add_filter( 'wpmu_drop_tables', 'claudius_syncnexuswc_on_delete_blog_syncnexuswc_plugin_check' );

function claudius_syncnexuswc_check_version_plugin_check() {
    if (CLAUDIUS_SYNCNEXUSWC_VERSION !== get_option('CLAUDIUS_SYNCNEXUSWC_VERSION')){
        require_once plugin_dir_path( __FILE__ ) . 'includes/class-syncnexuswc-activator.php';
        $activator=new ClaudiuMaftei\SyncNexusWC\SyncNexusWC_Activator;
        $activator->versionChanges();
    }
}
add_action('plugins_loaded', 'claudius_syncnexuswc_check_version_plugin_check');

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-syncnexuswc.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function claudius_syncnexuswc_plugin_start_run() {

    $plugin = new ClaudiuMaftei\SyncNexusWC\SyncNexusWC_Main();
    $plugin->run();

}
claudius_syncnexuswc_plugin_start_run();

function claudius_syncnexuswc_plugin_admin_main_page(){
    require_once dirname( __FILE__ )  . '/admin/partials/syncnexuswc-admin-display.php';
}
add_action('admin_menu', 'claudius_syncnexuswc_plugin_admin_menu_items');
function claudius_syncnexuswc_plugin_admin_menu_items()
{
    require_once dirname( __FILE__ )  . '/admin/partials/syncnexuswc_svg.php';
    add_menu_page( "Sync Nexus WC", "Sync Nexus WC", "administrator", "claudius_syncnexuswc_main", "claudius_syncnexuswc_plugin_admin_main_page", $syncnexuswc_icon, 53.9);
    add_submenu_page( "claudius_syncnexuswc_main", __('Configuration','sync-nexus-wc'), __('Configuration','sync-nexus-wc'), "administrator", "claudius_syncnexuswc_main","claudius_syncnexuswc_plugin_admin_main_page",1);
    add_submenu_page( "claudius_syncnexuswc_main", __('Logs','sync-nexus-wc'), __('Logs','sync-nexus-wc'), "administrator", "claudius_syncnexuswc_main-logs","claudius_syncnexuswc_plugin_admin_main_page",2);
    add_submenu_page( "claudius_syncnexuswc_main", __('Help','sync-nexus-wc'), __('Help','sync-nexus-wc'), "administrator", "claudius_syncnexuswc_main-help","claudius_syncnexuswc_plugin_admin_main_page",3);
}

add_filter( 'plugin_action_links', 'claudius_syncnexuswc_show_plugin_admin_settings_link', 10, 2 );

function claudius_syncnexuswc_show_plugin_admin_settings_link( $links, $file ) 
{
    if ( $file == plugin_basename(dirname(__FILE__) . '/sync-nexus-wc.php') ) 
    {
        $links = array_merge(array('<a href="'.esc_url(admin_url().'admin.php?page=claudius_syncnexuswc_main').'">'.__('Configuration','sync-nexus-wc').'</a>'),$links);
    }
    return $links;
}

add_action('woocommerce_order_status_changed', 'claudius_syncnexuswc_on_status_change_trigger', 9999, 4);

function claudius_syncnexuswc_on_status_change_trigger($order_id, $old_status, $new_status, $order)
{
    require_once plugin_dir_path( __FILE__ )  . 'includes/syncnexuswc.php';
    $nexus=new ClaudiuMaftei\SyncNexusWC\Nexus;
    $nexus->sendInvoiceToNexusServer($new_status, $order);
}

add_action('woocommerce_admin_order_data_after_billing_address', 'claudius_syncnexuswc_display_nexus_address_details', 10, 1);

function claudius_syncnexuswc_display_nexus_address_details($order) {
    require_once plugin_dir_path( __FILE__ )  . 'includes/syncnexuswc.php';
    $nexus=new ClaudiuMaftei\SyncNexusWC\Nexus;
    $nexus->displayNexusAddressToBeSent($order);
}

add_action('admin_notices', 'claudius_syncnexuswc_invoice_error_messages_display');

function claudius_syncnexuswc_invoice_error_messages_display() {
    global $pagenow, $post;
    
    if ($pagenow === 'post.php' || $pagenow === 'admin.php' && isset($post)) {
        $order_id = $post->ID;
        $messages = get_transient('claudius_syncnexuswc_invoice_error_messages_' . $order_id);

        if ($messages && is_array($messages)) {
            echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__("SyncNexusWC Server ERROR","sync-nexus-wc") . ": " . esc_html(implode(", ",$messages)) . '</p></div>';
            delete_transient('claudius_syncnexuswc_invoice_error_messages_' . $order_id);
        }
    }
}

add_action( 'claudius_syncnexuswc_import_products_hook', 'claudius_syncnexuswc_import_products', 10, 2 );
function claudius_syncnexuswc_import_products() {
    $args = array(
        'role'    => 'administrator',
        'number' => 1
    );
    $users = get_users( $args );
    if(is_array($users) && count($users)==1)
        wp_set_current_user($users[0]->ID);
    require_once plugin_dir_path( __FILE__ )  . 'includes/syncnexuswc.php';
    $nexus=new ClaudiuMaftei\SyncNexusWC\Nexus;
    $nexus->importNexusProducts();
    wp_set_current_user(0);
}

add_action( 'claudius_syncnexuswc_import_products_batch_reschedule_hook', 'claudius_syncnexuswc_import_products_batch_reschedule', 10, 2 );
function claudius_syncnexuswc_import_products_batch_reschedule() {
    $args = array(
        'role'    => 'administrator',
        'number' => 1
    );
    $users = get_users( $args );
    if(is_array($users) && count($users)==1)
        wp_set_current_user($users[0]->ID);
    require_once plugin_dir_path( __FILE__ )  . 'includes/syncnexuswc.php';
    $nexus=new ClaudiuMaftei\SyncNexusWC\Nexus;
    $nexus->importNexusProductsBatchReschedule();
    wp_set_current_user(0);
}

add_action( 'wp_ajax_syncnexuswc_get_import_prod_status', 'claudius_syncnexuswc_get_import_prod_status' );
function claudius_syncnexuswc_get_import_prod_status() {
    check_ajax_referer( 'syncnexuswc_get_import_prod_status_nonce', 'security' );
    require_once plugin_dir_path( __FILE__ )  . 'includes/syncnexuswc.php';
    $nexus=new ClaudiuMaftei\SyncNexusWC\Nexus;
    $nexus->getImportProdStatusAjax();
    wp_die();
}