<?php
/**
 * @package    SyncNexusWC
 * @author     Claudiu Maftei <admin@bizzmags.ro>
 */
namespace ClaudiuMaftei\SyncNexusWC;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

class SyncNexusWC_Main {

	protected $loader;
	protected $plugin_name;
	protected $version;
	public function __construct() {
		if ( defined( 'CLAUDIUS_SYNCNEXUSWC_VERSION' ) ) {
			$this->version = CLAUDIUS_SYNCNEXUSWC_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'sync-nexus-wc';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();

	}

	private function load_dependencies() {
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-syncnexuswc-loader.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-syncnexuswc-i18n.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-syncnexuswc-admin.php';
		$this->loader = new SyncNexusWC_Loader();
	}

	private function set_locale() {

		$plugin_i18n = new SyncNexusWC_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	private function define_admin_hooks() {

		$plugin_admin = new SyncNexusWC_Admin( $this->get_plugin_name(), $this->get_version() );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );

	}

	public function run() {
		$this->loader->run();
	}

	public function get_plugin_name() {
		return $this->plugin_name;
	}

	public function get_loader() {
		return $this->loader;
	}

	public function get_version() {
		return $this->version;
	}

}
