<?php
/**
 * @package    SyncNexusWC
 * @author     Claudiu Maftei <admin@bizzmags.ro>
 */
namespace ClaudiuMaftei\SyncNexusWC;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class SyncNexusWC_Activator {

    public $emagTables = array();
    public $sql=array();

    public function __construct()
    {
        global $wpdb;

        $this->emagTables[] = 'syncnexuswc_config';
        $this->emagTables[] = 'syncnexuswc_logs';

        $this->sql[]=$wpdb->prepare("insert INTO `".$wpdb->prefix."syncnexuswc_config` 
        (`config_name`, `config_value`, `show_front`, `mdate`) VALUES
        ('delete_tables_upon_uninstall', 'yes', '1', 1),
        ('nexus_protocol', 'http', '1', 1),
        ('nexus_ip', '', '1', 1),
        ('nexus_port', '', '1', 1),
        ('nexus_api_key', '', '1', 1),
        ('send_wc_invoices', 'yes', '1', 1),
        ('send_emag_invoices', 'no', '1', 1),
        ('nexus_send_invoice_status', 'wc-completed', '1', 1),
        ('nexus_invoice_source', 'WEBSITE', '1', 1),
        ('nexus_order_meta_cui', '', '1', 1),
        ('nexus_order_meta_cui_child', '', '1', 1),
        ('nexus_order_meta_reg_com', '', '1', 1),
        ('nexus_order_meta_reg_com_child', '', '1', 1),
        ('nexus_order_meta_pers_jur', '', '1', 1),
        ('nexus_order_meta_pers_jur_child', '', '1', 1),
        ('nexus_order_meta_pers_jur_value', '', '1', 1),
        ('nexus_prod_import_started', '0', '1', 1),
        ('nexus_prod_imported_cnt', '0', '1', 1),
        ('nexus_prod_batch_import_nr', '25', '1', 1),
        ('nexus_prod_import_start', '0', '1', 1),
        ('nexus_prod_import_interval', '60', '1', 1),
        ('nexus_invoice_cont_produs', '371 .02', '1', 1),
        ('nexus_invoice_tip_produs', 'GAA', '1', 1),
        ('nexus_invoice_cont_produs_discount', '667 . . . .', '1', 1),
        ('nexus_invoice_tip_produs_discount', 'WDA', '1', 1),
        ('nexus_invoice_cont_produs_livrare', '', '1', 1),
        ('nexus_invoice_tip_produs_livrare', '', '1', 1),
        ('nexus_send_invoices_auto_validate', 'no', '1', 1),
        ('nexus_send_invoices_live', 'no', '1', 1)
        ON DUPLICATE KEY UPDATE mdate=%d",time());
    }

	public function activate() {
        $this->runFunctionsForMultiOrSingleBlog("createTables");
	}

    public function createTables(){
        global $wpdb;

        require_once( ABSPATH . "wp-admin/includes/upgrade.php" );
        if(get_option('CLAUDIUS_SYNCNEXUSWC_VERSION')==false)
            update_option('CLAUDIUS_SYNCNEXUSWC_VERSION',CLAUDIUS_SYNCNEXUSWC_VERSION);

        $table_name=$wpdb->prefix.'syncnexuswc_config';
        //if( $wpdb->get_var( $wpdb->prepare("show tables like %s", $table_name)) != $table_name ) {
            $sql=$wpdb->prepare("CREATE TABLE `".$wpdb->prefix."syncnexuswc_config` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `config_name` varchar(255) NOT NULL,
                `config_value` text NOT NULL DEFAULT '',
                `show_front` tinyint(1) NOT NULL,
                `mdate` int(11) NOT NULL, 
                PRIMARY KEY (`id`),
                UNIQUE KEY config_name (`config_name`)
            )
            DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
            ");
            dbDelta( $sql );
        //}

        $table_name=$wpdb->prefix.'syncnexuswc_logs';
        //if( $wpdb->get_var( $wpdb->prepare("show tables like %s", $table_name)) != $table_name ) {
            $sql=$wpdb->prepare("CREATE TABLE `".$wpdb->prefix."syncnexuswc_logs` (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `user_id` int(11) NOT NULL,
                `log` text NOT NULL,
                `mdate` double NOT NULL,
                PRIMARY KEY (`id`)
            )
            DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
            ");
            dbDelta( $sql );
        //}

        $table_name=$wpdb->prefix.'syncnexuswc_siruta';
        //if( $wpdb->get_var( $wpdb->prepare("show tables like %s", $table_name)) != $table_name ) {
            $sql=$wpdb->prepare("CREATE TABLE `".$wpdb->prefix."syncnexuswc_siruta` (
                `id` int(11) NOT NULL,
                `id_extern` varchar(255) NOT NULL DEFAULT '',
                `id_importex` varchar(255) NOT NULL DEFAULT '',
                `nume` varchar(255) NOT NULL DEFAULT '',
                `cod_tara` varchar(32) NOT NULL DEFAULT '',
                `id_jud` int(11) NOT NULL DEFAULT 0,
                `siruta` int(11) NOT NULL DEFAULT 0,
                `tip` varchar(32) NOT NULL DEFAULT 'FALSE',
                `accesari` int(11) NOT NULL DEFAULT 0,
                `id_revsal` varchar(32) NOT NULL DEFAULT '',
                `nume_fd` varchar(255) NOT NULL DEFAULT '',
                `data_md` varchar(255) NOT NULL DEFAULT '',
                `user_md` varchar(32) NOT NULL DEFAULT '',
                `data_cr` varchar(255) NOT NULL DEFAULT '',
                `user_cr` varchar(255) NOT NULL DEFAULT '',
                `judet` varchar(255) NOT NULL DEFAULT '',
                `judet_fd` varchar(255) NOT NULL DEFAULT '',
                `zona` varchar(255) NOT NULL DEFAULT '',
                `tara` varchar(255) NOT NULL DEFAULT '',
                `continent` varchar(255) NOT NULL DEFAULT '',
                `id_zona` int(11) NOT NULL DEFAULT 0,
                `id_cont` int(11) NOT NULL DEFAULT 0,
                `cod_judet` varchar(255) NOT NULL DEFAULT '',
                `cod_judet_mf` varchar(255) NOT NULL DEFAULT '',
                `mdate` int(11) NOT NULL DEFAULT 0,
                PRIMARY KEY (`id`)
            )
            DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
            ");
            dbDelta( $sql );
        //}

        dbDelta( $this->sql );

        require_once CLAUDIUS_SYNCNEXUSWC_PLUGIN_PATH  . 'includes/siruta.php';

        if(is_array($siruta_sql))
        {
            foreach($siruta_sql as $s_sql)
            {
                dbDelta( $s_sql );
            }
        }
    }
    public function runFunctionsForMultiOrSingleBlog($the_function=""){
        global $wpdb;
        if($the_function!=""){
            if ( is_multisite() ) {
                    // Get all blogs in the network and activate plugin on each one
                    $blog_ids = $wpdb->get_col( "SELECT blog_id FROM $wpdb->blogs" );
                    foreach ( $blog_ids as $blog_id ) {
                        switch_to_blog( $blog_id );
                        $this->$the_function();
                        restore_current_blog();
                    }
                } else {
                    $this->$the_function();
            }
        }
    }
    // Creating table whenever a new blog is created
    function on_create_blog( $blog_id, $user_id, $domain, $path, $site_id, $meta ) {
        if ( is_plugin_active_for_network( 'sync-nexus-wc/sync-nexus-wc.php' ) ) {
            switch_to_blog( $blog_id );
            $this->createTables();
            restore_current_blog();
        }
    }
    // Deleting the table whenever a blog is deleted
    function on_delete_blog( $tables ) {
        global $wpdb;
        $current_blog_tables=array();
        foreach ($this->honeybadgerTables as $table) {
            $current_blog_tables[]=$wpdb->prefix.$table;
        }
        $tables=array_merge($tables,$current_blog_tables);
        return $tables;
    }
    function deleteSyncNexusWCTables(){
        global $wpdb;
        $result=$wpdb->get_row($wpdb->prepare("select config_value from ".$wpdb->prefix."syncnexuswc_config where config_name=%s","delete_tables_upon_uninstall"));
        if(isset($result->config_value) && $result->config_value=='yes')
        {
            $sql=$wpdb->prepare("DROP TABLE IF EXISTS " . $wpdb->prefix."syncnexuswc_config where %d",1);
            $sql=str_replace("where 1","",$sql);
            $wpdb->query($sql);
            $sql=$wpdb->prepare("DROP TABLE IF EXISTS " . $wpdb->prefix."syncnexuswc_logs where %d",1);
            $sql=str_replace("where 1","",$sql);
            $wpdb->query($sql);
            $sql=$wpdb->prepare("DROP TABLE IF EXISTS " . $wpdb->prefix."syncnexuswc_siruta where %d",1);
            $sql=str_replace("where 1","",$sql);
            $wpdb->query($sql);
        }
        delete_option('CLAUDIUS_SYNCNEXUSWC_VERSION');
    }
    function deleteTables(){
        $this->runFunctionsForMultiOrSingleBlog("deleteSyncNexusWCTables");
    }
    function versionChanges(){
        $this->runFunctionsForMultiOrSingleBlog("doVersionChanges");
    }
    function doVersionChanges(){
        global $wpdb;
        $current_version=get_option('CLAUDIUS_SYNCNEXUSWC_VERSION');
        if (CLAUDIUS_SYNCNEXUSWC_VERSION !== $current_version){
            update_option('CLAUDIUS_SYNCNEXUSWC_VERSION',CLAUDIUS_SYNCNEXUSWC_VERSION);
            $this->activate();
        }
    }
}
