<?php
/**
 * @package    SyncNexusWC
 * @author     Claudiu Maftei <admin@bizzmags.ro>
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly   
if ( ! current_user_can( 'manage_options' ) ) {
    return;
}

require_once CLAUDIUS_SYNCNEXUSWC_PLUGIN_PATH  . 'includes/syncnexuswc.php';
$nexus=new ClaudiuMaftei\SyncNexusWC\Nexus;


$default_tab = "sync-nexus-wc";
$tab = isset($_GET['page']) ? sanitize_text_field(wp_unslash($_GET['page'])) : $default_tab;
?>
<div class="wrap syncnexuswc-wrap">
<!-- Print the page title -->
<h1 id="syncnexuswc_top_row">
    <?php esc_html_e("Sync for Nexus ERP and WC","sync-nexus-wc");?>
</h1>
<!-- Here are our tabs -->
<nav class="nav-tab-wrapper">
  <a href="<?php echo esc_url(admin_url()."admin.php?page=claudius_syncnexuswc_main");?>" class="nav-tab <?php if($tab==='claudius_syncnexuswc_main'):?>nav-tab-active<?php endif; ?>"><?php esc_html_e('Configuration','sync-nexus-wc');?></a>
   <a href="<?php echo esc_url(admin_url()."admin.php?page=claudius_syncnexuswc_main-logs");?>" class="nav-tab <?php if($tab==='claudius_syncnexuswc_main-logs'):?>nav-tab-active<?php endif; ?>"><?php esc_html_e('Logs','sync-nexus-wc');?></a>
  <a href="<?php echo esc_url(admin_url()."admin.php?page=claudius_syncnexuswc_main-help");?>" class="nav-tab <?php if($tab==='claudius_syncnexuswc_main-help'):?>nav-tab-active<?php endif; ?>"><?php esc_html_e('Help','sync-nexus-wc');?></a>
</nav>

<div class="tab-content">
<?php switch($tab) :
case 'claudius_syncnexuswc_main-logs':
    require_once plugin_dir_path(__FILE__)."syncnexuswc-admin-display-logs.php";
    break;
case 'claudius_syncnexuswc_main-help':
    require_once plugin_dir_path(__FILE__)."syncnexuswc-admin-display-help.php";
    break;
default:
    require_once plugin_dir_path(__FILE__)."syncnexuswc-admin-display-dashboard.php";
    break;
endswitch; ?>
</div>
</div>
