<?php
/**
 * @package    SyncNexusWC
 * @author     Claudiu Maftei <admin@bizzmags.ro>
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
if ( ! current_user_can( 'manage_options' ) ) {
    return;
}

?>

<h2><?php esc_html_e('Help','sync-nexus-wc');?></h2>

<div class="container nexus-no-pad">
<div class="nexus-dash-row">

<div class="row">
    <div class="col">
        <p style="font-weight:bold;"><?php esc_html_e("Please read this section before using the plugin","sync-nexus-wc");?>.</p>
        <p><?php esc_html_e("The plugin works with the Nexus ERP server, you need to know the IP of your server, the Port and have an API Key, to test if your Nexus server is online you can check it over your browser by accessing http://YOUR_NEXUS_SERVER_IP:YOUR_NEXUS_SERVER_API_PORT in example http://192.168.0.1:123332, mind the protocol, http or https, depending on your server configuration you need to access it over the specific protocol","sync-nexus-wc");?>.</p>
        <p><strong><?php esc_html_e("Dependencies","sync-nexus-wc");?>:</strong> <?php esc_html_e("Nexus ERP server, WooCommerce, Bizzmags Marketplace, PDF Invoices & Packing Slips for WooCommerce","sync-nexus-wc");?></p>
        <p><strong><?php esc_html_e("Optional","sync-nexus-wc");?>:</strong> <?php esc_html_e("Bizzmags Marketplace, PDF Invoices & Packing Slips for WooCommerce","sync-nexus-wc");?></p>
        <p><?php esc_html_e("First you need to configure the plugin with your credentials in the Configuration tab, when saving the credentials the plugin does a request to the specified Nexus ERP server, if any error occur they will be displayed","sync-nexus-wc");?>.</p>
        <p><?php esc_html_e("Invoices are sent to the Nexus ERP server when an order is set to the Completed status, it will create a partner, an address and the invoice. Please note that this will happen only once, in the case of an order status change and back again to Completed it will not send the invoice again","sync-nexus-wc");?>.</p>
        <p><?php esc_html_e("If an error message is shown in red in the WC order page before the address to be sent to Nexus do not set the order to Completed status until the problem is fixed because Nexus will not create the invoice. In this case you may change the status of the order to be able to edit it and when set to Completed it will send the invoice to Nexus ERP server","sync-nexus-wc");?>.</p>
        <p><?php esc_html_e("If in the WC order page the address to be sent to Nexus is colored in orange, the address doesn't seam complete, please edit and format the address in a good format like: Str Street, Bl Block number etc, keep the format, spaces and commas","sync-nexus-wc");?>.</p>
    </div>
    

</div>
</div>
