<?php
/**
 * @package    SyncNexusWC
 * @author     Claudiu Maftei <admin@bizzmags.ro>
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly   
if ( ! current_user_can( 'manage_options' ) ) {
    return;
}

$msg="";
$action=isset($_POST['action'])?sanitize_text_field(wp_unslash($_POST['action'])):"";
if($action=="nexus_save_api_credentials")
{
    check_admin_referer( 'syncnexuswc_save_api_credentials' );
    $msg=$nexus->saveNexusApiCredentials();
}
if($action=="syncnexuswc_save_configuration")
{
    check_admin_referer( 'syncnexuswc_save_configuration' );
    $msg=$nexus->saveNexusConfiguration();
}
if($action=="nexus_import_products")
{
    check_admin_referer( 'syncnexuswc_import_nexus_products' );
    $msg=$nexus->importNexusProductsHook();
}
?>
<h2><?php esc_html_e('Configuration','sync-nexus-wc');?></h2>
<p><strong><?php esc_html_e("Configure your Nexus ERP server details","sync-nexus-wc");?>.</strong></p>
<p><strong><?php esc_html_e("Please Note: The port used by the Nexus ERP API must be open on your server (the server where your website is hosted) and WooCommerce plugin needs to be installed","sync-nexus-wc");?>.</strong></p>
<p><strong><?php esc_html_e("This is the FREE version of the plugin and includes limited functionality. To access all features, please consider upgrading to the","sync-nexus-wc");?></strong> <a href="https://bizzmags.ro/integrare-nexus-erp-si-woocommerce/" target="_blank"><?php esc_html_e("PRO version","sync-nexus-wc");?></a>.</p>
<?php

if($msg!="")
{
    if(is_array($msg['msg']))
    {
        foreach($msg['msg'] as $m)
        {
            ?>
            <div class="<?php echo esc_attr($msg['status']);?> notice is-dismissible inline">
                <p><?php echo esc_html($m);?></p>
            </div>
            <?php
        }
    }
    else
    {
    ?>
    <div class="<?php echo esc_attr($msg['status']);?> notice is-dismissible inline">
        <p><?php echo esc_html($msg['msg']);?></p>
    </div>
    <?php
    }
}
$have_errors=false;
$php_version_good=false;
if(version_compare( PHP_VERSION, '7.2' ) >= 0)
    $php_version_good=true;

if(!$nexus->is_woocommerce_activated())
{
    ?>
    <div class="nexus-error-div">
        <?php esc_html_e("WooCommerce is not installed or activated, please install or activate it in order to continue","sync-nexus-wc");?>.
    </div>
    <?php
    $have_errors=true;
}
if(!class_exists('Transliterator'))
{
    ?>
    <div class="nexus-error-div">
        <?php esc_html_e("The PHP Transliterator class does not exist, please install the php-intl extension in order to continue","sync-nexus-wc");?>.
    </div>
    <?php
    $have_errors=true;
}
/*
if(!$nexus->is_wpo_wcpdf_activated())
{
    ?>
    <div class="nexus-error-div">
        <?php esc_html_e("PDF Invoices & Packing Slips for WooCommerce is not installed or activated, please install or activate it in order to continue","sync-nexus-wc");?>.
    </div>
    <?php
    $have_errors=true;
}
*/
if($nexus->config->send_emag_invoices=='yes' && !$nexus->is_bizzmagsmarketplace_activated())
{
    ?>
    <div class="nexus-error-div">
        <?php esc_html_e("Bizzmags Marketpmace is not installed or activated, please install or activate it in order to continue","sync-nexus-wc");?>.
    </div>
    <?php
    //$have_errors=true;
}

if(!$php_version_good)
{
    ?>
    <div class="nexus-error-div">
        <?php esc_html_e("PHP version must be at least 7.2","sync-nexus-wc");?>.
    </div>
    <?php
    $have_errors=true;
}
if(!$have_errors)
{
?>
<div class="container nexus-no-pad">
<div class="nexus-dash-row">
<form method="post" action="" autocomplete="off" name="save_api_details">
<?php $nonce=wp_create_nonce( 'syncnexuswc_save_api_credentials' );?>
<input type="hidden" name="action" value="nexus_save_api_credentials" />
<input type="hidden" name="_wpnonce" value="<?php echo esc_attr($nonce);?>" />
<div class="row">
    <div class="col-2">
        <label for="nexus_ip"><?php esc_html_e("Nexus API IP","sync-nexus-wc");?></label>
    </div>
    <div class="col-8">
        <input type="text" placeholder="<?php echo esc_attr(__("Your Nexus ERP server IP address","sync-nexus-wc"));?>" id="nexus_ip" name="nexus_ip" class="button" value="<?php echo esc_attr($nexus->config->nexus_ip);?>" style="width:100%;" />
    </div>
    <div class="col-2">
        <select name="nexus_protocol">
            <option value="http" <?php echo (($nexus->config->nexus_protocol=="http")?'selected="selected"':'');?> >HTTP</option>
            <option value="https" <?php echo (($nexus->config->nexus_protocol=="https")?'selected="selected"':'');?> >HTTPS</option>
        </select>
    </div>
</div>
<div class="row mt-3">
    <div class="col-2">
        <label for="nexus_port"><?php esc_html_e("Nexus Port","sync-nexus-wc");?></label>
    </div>
    <div class="col-3">
        <input autocomplete="new-password" placeholder="<?php echo esc_attr(__("Your Nexus ERP server Port number","sync-nexus-wc"));?>" name="nexus_port" id="nexus_port" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_port);?>" />
    </div>
    <div class="col-2">
        <label for="nexus_api_key"><?php esc_html_e("Nexus API key","sync-nexus-wc");?></label>
    </div>
    <div class="col-3">
        <input autocomplete="new-password" placeholder="<?php echo esc_attr(__("Your Nexus ERP server API key","sync-nexus-wc"));?>" name="nexus_api_key" id="nexus_api_key" type="password" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_api_key);?>" />
    </div>
    <div class="col-2">
        <input type="submit" class="button-primary" value="<?php echo esc_attr(__("Save",'sync-nexus-wc'));?>" />
    </div>
</div>
</form>
</div>

<?php
}
if(!$have_errors && $nexus->config->nexus_ip!="" && $nexus->config->nexus_port!="" && $nexus->config->nexus_api_key!="")
{
?>
<div class="nexus-dash-row">
<form method="post" action="" autocomplete="off">
<?php $nonce=wp_create_nonce( 'syncnexuswc_save_configuration' );?>
<input type="hidden" name="action" value="syncnexuswc_save_configuration" />
<input type="hidden" name="_wpnonce" value="<?php echo esc_attr($nonce);?>" />
<div class="row">
    <div class="col">
         <strong><?php esc_html_e("Settings","sync-nexus-wc");?></strong>
    </div>
</div>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Send WC Invoices to Nexus ERP","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <input <?php echo (($nexus->config->send_wc_invoices=='yes')?'checked="checked"':'');?> type="radio" id="send_wc_invoices_yes" name="send_wc_invoices" value="yes" />
        <label for="send_wc_invoices_yes"><?php esc_html_e("Yes","sync-nexus-wc");?></label>
    </div>
    <div class="col-6">
        <input <?php echo (($nexus->config->send_wc_invoices=='no')?'checked="checked"':'');?> type="radio" id="send_wc_invoices_no" name="send_wc_invoices" value="no" />
        <label for="send_wc_invoices_no"><?php esc_html_e("No","sync-nexus-wc");?></label>
    </div>
</div>
<?php
$disabled=true;
if($nexus->checkIfProBizzmags())
    $disabled=false;
else
{
    $nexus->updateConfigValue('send_emag_invoices', 'no');
    $nexus->config->send_emag_invoices='no';
}
?>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Send eMAG Invoices to Nexus ERP PRO","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <input type="radio" id="send_emag_invoices_yes" name="send_emag_invoices" value="yes" disabled="disabled" />
        <label for="send_emag_invoices_yes"><?php esc_html_e("Yes","sync-nexus-wc");?></label>
    </div>
    <div class="col-1">
        <input checked="checked" type="radio" id="send_emag_invoices_no" name="send_emag_invoices" value="no" disabled="disabled" />
        <label for="send_emag_invoices_no"><?php esc_html_e("No","sync-nexus-wc");?></label>
    </div>
    <div class="col-5 nexus-error-div">
        <?php
        if($disabled!="")
            esc_html_e("Bizmags Marketplace PRO version required","sync-nexus-wc");
        ?>
    </div>
</div>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Send Invoices to Nexus ERP for Status","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <?php
        if($nexus->is_woocommerce_activated())
        {
            $statuses = wc_get_order_statuses();
            ?>
            <select id="nexus_send_invoice_status" name="nexus_send_invoice_status" class="button">
                <?php
                foreach($statuses as $status_slug => $status_name)
                {
                    ?>
                    <option <?php echo (($nexus->config->nexus_send_invoice_status==$status_slug)?'selected="selected"':'');?> value="<?php echo esc_attr($status_slug);?>"><?php echo esc_html($status_name);?></option>
                    <?php
                }
                ?>
            </select>
            <?php
        }
        ?>
    </div>
    <div class="col-6">
        <?php esc_html_e("Send the Invoice to Nexus server when an order has the selected status, it will be sent only once, in example if the order changes its status multiple times to the selected one it will only be created once on Nexus server","sync-nexus-wc");?>
    </div>
</div>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Invoice Source","sync-nexus-wc");?></strong>
    </div>
    <div class="col-4">
        <input autocomplete="new-password" maxlength="25" placeholder="<?php echo esc_attr(__("An identifier for invoices imported from this website","sync-nexus-wc"));?>" name="nexus_invoice_source" id="nexus_invoice_source" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_invoice_source);?>" />
    </div>
    <div class="col-4">
        <?php esc_html_e("When invoices are imported in the Nexus server they will be recognizable by this identifier, 25 chars max","sync-nexus-wc");?>
    </div>
</div>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("CUI/CNP Order Meta","sync-nexus-wc");?></strong><br />
        <small><?php esc_html_e("The third party plugin meta key used for order custom field for CUI","sync-nexus-wc");?></small>
    </div>
    <div class="col-2">
        <?php
        $order_meta_keys = $nexus->getOrderMetaKeys();
        ?>
        <select id="nexus_order_meta_cui" name="nexus_order_meta_cui" class="button" style="width:100%;">
            <option value=""> - </option>
        <?php
        foreach($order_meta_keys as $order_meta_key)
        {
            ?>
            <option <?php echo (($order_meta_key==$nexus->config->nexus_order_meta_cui)?'selected="selected"':'');?> value="<?php echo esc_attr($order_meta_key);?>"><?php echo esc_html($order_meta_key);?></option>
            <?php
        }
        ?>
        </select>
    </div>
    <div class="col-2">
        <strong><?php esc_html_e("Child Key","sync-nexus-wc");?></strong>
    </div>
    <div class="col-4">
        <input autocomplete="new-password" placeholder="<?php echo esc_attr(__("The child name of the value, i.e.: cui/nr_reg_com/tip_facturare","sync-nexus-wc"));?>" name="nexus_order_meta_cui_child" id="nexus_order_meta_cui_child" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_order_meta_cui_child);?>" />
    </div>
</div>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Nr Reg Com Order Meta","sync-nexus-wc");?></strong><br />
        <small><?php esc_html_e("The third party plugin meta key used for order custom field for Nr Reg Com","sync-nexus-wc");?></small>
    </div>
    <div class="col-2">
        <?php
        $order_meta_keys = $nexus->getOrderMetaKeys();
        ?>
        <select id="nexus_order_meta_reg_com" name="nexus_order_meta_reg_com" class="button" style="width:100%;">
            <option value=""> - </option>
        <?php
        foreach($order_meta_keys as $order_meta_key)
        {
            ?>
            <option <?php echo (($order_meta_key==$nexus->config->nexus_order_meta_reg_com)?'selected="selected"':'');?> value="<?php echo esc_attr($order_meta_key);?>"><?php echo esc_html($order_meta_key);?></option>
            <?php
        }
        ?>
        </select>
    </div>
    <div class="col-2">
        <strong><?php esc_html_e("Child Key","sync-nexus-wc");?></strong>
    </div>
    <div class="col-4">
        <input autocomplete="new-password" placeholder="<?php echo esc_attr(__("The child name of the value, i.e.: cui/nr_reg_com/tip_facturare","sync-nexus-wc"));?>" name="nexus_order_meta_reg_com_child" id="nexus_order_meta_reg_com_child" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_order_meta_reg_com_child);?>" />
    </div>
</div>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Pers Jur Order Meta","sync-nexus-wc");?></strong><br />
        <small><?php esc_html_e("The third party plugin meta key used for order custom field for Pers Jur","sync-nexus-wc");?></small>
    </div>
    <div class="col-2">
        <?php
        $order_meta_keys = $nexus->getOrderMetaKeys();
        ?>
        <select id="nexus_order_meta_pers_jur" name="nexus_order_meta_pers_jur" class="button" style="width:100%;">
            <option value=""> - </option>
        <?php
        foreach($order_meta_keys as $order_meta_key)
        {
            ?>
            <option <?php echo (($order_meta_key==$nexus->config->nexus_order_meta_pers_jur)?'selected="selected"':'');?> value="<?php echo esc_attr($order_meta_key);?>"><?php echo esc_html($order_meta_key);?></option>
            <?php
        }
        ?>
        </select>
    </div>
    <div class="col-2">
        <strong><?php esc_html_e("Child Key and Value","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <input autocomplete="new-password" placeholder="<?php echo esc_attr(__("The child name of the value, i.e.: cui/nr_reg_com/tip_facturare","sync-nexus-wc"));?>" name="nexus_order_meta_pers_jur_child" id="nexus_order_meta_pers_jur_child" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_order_meta_pers_jur_child);?>" />
    </div>
    <div class="col-2">
        <input autocomplete="new-password" placeholder="<?php echo esc_attr(__("Check for? pers-jur value","sync-nexus-wc"));?>" name="nexus_order_meta_pers_jur_value" id="nexus_order_meta_pers_jur_value" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_order_meta_pers_jur_value);?>" />
    </div>
</div>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Import products batch","sync-nexus-wc");?></strong><br />
    </div>
    <div class="col-2">
        <input type="number" min="1" placeholder="5/10/25/50/100" id="nexus_prod_batch_import_nr" name="nexus_prod_batch_import_nr" class="button" value="<?php echo esc_attr($nexus->config->nexus_prod_batch_import_nr);?>" style="width:100%;" />
    </div>
    <div class="col-6">
        <?php esc_html_e("How many products to be sent to Nexus server at once, default is 25, if the import process stops it means that the maximum execution time was exceeded, in this case you need to lower the number","sync-nexus-wc");?>
    </div>
</div>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Import products cron interval in minutes PRO","sync-nexus-wc");?></strong><br />
    </div>
    <div class="col-2">
        <input type="number" min="30" disabled="disabled" placeholder="30/60/120/180/240" id="nexus_prod_import_interval" name="nexus_prod_import_interval" class="button" value="<?php echo esc_attr($nexus->config->nexus_prod_import_interval);?>" style="width:100%;" />
    </div>
    <div class="col-6">
        <?php esc_html_e("The interval in minutes when the import products cron should run, you should use the manual import button above prior to starting the cron to make an idea how long it takes","sync-nexus-wc");?>
    </div>
</div>

<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Cont Produs","sync-nexus-wc");?></strong><br />
    </div>
    <div class="col-2">
        <input autocomplete="new-password" placeholder="<?php echo esc_attr(__("i.e.: 371 .02","sync-nexus-wc"));?>" name="nexus_invoice_cont_produs" id="nexus_invoice_cont_produs" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_invoice_cont_produs);?>" />
    </div>
    <div class="col-2">
        <strong><?php esc_html_e("Tip Produs","sync-nexus-wc");?></strong>
    </div>
    <div class="col-4">
        <input autocomplete="new-password" placeholder="<?php echo esc_attr(__("i.e.: GAA","sync-nexus-wc"));?>" name="nexus_invoice_tip_produs" id="nexus_invoice_tip_produs" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_invoice_tip_produs);?>" />
    </div>
</div>
<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Cont Produs Discount PRO","sync-nexus-wc");?></strong><br />
    </div>
    <div class="col-2">
        <input autocomplete="new-password" disabled="disabled" placeholder="<?php echo esc_attr(__("i.e.: 667 . . . .","sync-nexus-wc"));?>" name="nexus_invoice_cont_produs_discount" id="nexus_invoice_cont_produs_discount" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_invoice_cont_produs_discount);?>" />
    </div>
    <div class="col-2">
        <strong><?php esc_html_e("Tip Produs Discount PRO","sync-nexus-wc");?></strong>
    </div>
    <div class="col-4">
        <input autocomplete="new-password" disabled="disabled" placeholder="<?php echo esc_attr(__("i.e.: WDA","sync-nexus-wc"));?>" name="nexus_invoice_tip_produs_discount" id="nexus_invoice_tip_produs_discount" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_invoice_tip_produs_discount);?>" />
    </div>
</div>

<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Cont Produs Livrare PRO","sync-nexus-wc");?></strong><br />
    </div>
    <div class="col-2">
        <input autocomplete="new-password" disabled="disabled" placeholder="<?php echo esc_attr(__("i.e.: 345 . . . .","sync-nexus-wc"));?>" name="nexus_invoice_cont_produs_livrare" id="nexus_invoice_cont_produs_livrare" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_invoice_cont_produs_livrare);?>" />
    </div>
    <div class="col-2">
        <strong><?php esc_html_e("Tip Produs Livrare PRO","sync-nexus-wc");?></strong>
    </div>
    <div class="col-4">
        <input autocomplete="new-password" disabled="disabled" placeholder="<?php echo esc_attr(__("i.e.: LVR","sync-nexus-wc"));?>" name="nexus_invoice_tip_produs_livrare" id="nexus_invoice_tip_produs_livrare" type="text" class="button" style="width:100%;" value="<?php echo esc_attr($nexus->config->nexus_invoice_tip_produs_livrare);?>" />
    </div>
</div>

<div class="row mt-4">
    <div class="col-4">
        <strong><?php esc_html_e("Auto Validate Invoices","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <select id="nexus_send_invoices_auto_validate" name="nexus_send_invoices_auto_validate" class="button" style="width:100%;">
            <option <?php echo (($nexus->config->nexus_send_invoices_auto_validate=="yes")?'selected="selected"':'');?> value="yes"><?php esc_html_e("Yes","sync-nexus-wc");?></option>
            <option <?php echo (($nexus->config->nexus_send_invoices_auto_validate=="no")?'selected="selected"':'');?> value="no"><?php esc_html_e("No","sync-nexus-wc");?></option>
        </select>
    </div>
    <div class="col-6">
        <?php esc_html_e("When an invoice is sent to the Nexus ERP server should it be Validated or not. This is useful for checking if the invoice was imported correctly before validating it and sending it to SPV","sync-nexus-wc");?>
    </div>
</div>

<div class="row mt-4">
    <div class="col-2">
        <input type="submit" class="button-primary" value="<?php echo esc_attr(__("Save",'sync-nexus-wc'));?>" />
    </div>
    <div class="col-2">
        <strong><?php esc_html_e("Send to Nexus Live","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <select id="nexus_send_invoices_live" name="nexus_send_invoices_live" class="button" style="width:100%;">
            <option <?php echo (($nexus->config->nexus_send_invoices_live=="yes")?'selected="selected"':'');?> value="yes"><?php esc_html_e("Yes","sync-nexus-wc");?></option>
            <option <?php echo (($nexus->config->nexus_send_invoices_live=="no")?'selected="selected"':'');?> value="no"><?php esc_html_e("No","sync-nexus-wc");?></option>
        </select>
    </div>
    <div class="col-6">
        <?php esc_html_e("Set to Yes when you tested and are happy with the data sent to the Nexus server, when set to No the data is just displayed in Logs","sync-nexus-wc");?>
    </div>
</div>
</form>
</div>
<?php
$nonce=wp_create_nonce( 'syncnexuswc_import_nexus_products' );
?>
<div class="nexus-dash-row">
    <form method="post" action="" autocomplete="off">
        <input type="hidden" name="action" value="nexus_import_products" />
        <input type="hidden" name="_wpnonce" value="<?php echo esc_attr($nonce);?>" />
        <div class="row">
            <div class="col-2">
                <?php esc_html_e("Import WC products in Nexus","sync-nexus-wc");?>
            </div>
            <?php
            if($nexus->config->nexus_prod_import_started==1)
            {
            ?>
            <div class="col-6">
                <input type="hidden" name="nexus_prod_import_cancel" value="1" />
                <input type="submit" class="button-secondary" value="<?php echo esc_attr(__("Cancel",'sync-nexus-wc'));?>" onClick="return confirm('<?php echo esc_js(__("Are you sure you want to cancel the process","sync-nexus-wc"));?>?');" />
            </div>
            <?php
            }
            else
            {
            ?>
            <div class="col-6">
                <?php esc_html_e("Send the WooCommerce products to Nexus ERP, new products will be created and existing ones updated","sync-nexus-wc");?>
            </div>
            <?php
            }
            ?>
            <div class="col-4 text-center">
                <?php
                if($nexus->config->nexus_prod_import_started!=1)
                {
                ?>
                    <input type="submit" class="button-primary" value="<?php echo esc_attr(__("Import Products",'sync-nexus-wc'));?>"  onClick="return confirm('<?php echo esc_js(__("Import products to Nexus","sync-nexus-wc"));?>? <?php echo esc_js(__("NOTE: If a product does not exist in Nexus ERP with the same Title it will be created","sync-nexus-wc"));?>.');" />
                <?php
                }
                else
                {
                    $nonce=wp_create_nonce( 'syncnexuswc_get_import_prod_status_nonce' );
                    $data_js='
                    jQuery(document).ready(function() {
                        setInterval(function(){
                            jQuery.ajax({
                                method: "POST",
                                data: { 
                                    "action": "syncnexuswc_get_import_prod_status", 
                                    "security": \''.esc_js($nonce).'\',
                                },
                                url: \''.esc_url(admin_url('admin-ajax.php')).'\',
                                async: true
                            })
                            .done(function( msg ) {
                                if(msg==1)
                                {
                                    location.reload();
                                }
                                else
                                {
                                    jQuery(\'#nexus_import_prod_status\').html(msg);
                                }
                            });
                        }, 5000);
                    });
                    ';
                    wp_register_script( 'syncnexuswc_get_import_prod_status_js', '' );
                    wp_enqueue_script( 'syncnexuswc_get_import_prod_status_js' );
                    wp_add_inline_script("syncnexuswc_get_import_prod_status_js",$data_js);

                    $imported=(int)$nexus->config->nexus_prod_imported_cnt;
                    $total_product_to_push=$nexus->getWcProductsCount();
                    $import_percent=0;
                    if((int)$total_product_to_push>0)
                        $import_percent=intval(($imported*100)/$total_product_to_push);
                    ?>
                    <div id="nexus_import_prod_status">
                    <div class="progress-bar">
                        <span class="progress-bar-fill" style="width: <?php echo esc_attr($import_percent);?>%;"></span>
                    </div>
                    <?php
                    echo esc_html($imported)."/".esc_html($total_product_to_push);
                    ?>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <p><strong><?php esc_html_e("Please note","sync-nexus-wc");?>:</strong>
                    <?php esc_html_e("Importing products in Nexus ERP will create new product classes and products for products that do not already exist with the product Title","sync-nexus-wc");?>
                </p>
            </div>
        </div>
    </form>
</div>









<?php
$products_cron_status=$nexus->getCronStatus("syncnexuswc_import_products_cron_hook");
$nonce_1=wp_create_nonce( 'syncnexuswc_import_products_cron_hook' );
$nonce_2=wp_create_nonce( 'syncnexuswc_import_products_cron_stop' );
?>
<div class="nexus-dash-row">
    <div class="row">
    <div class="col">
        <?php esc_html_e("Products Cron Status PRO","sync-nexus-wc");?>
    </div>
    <div class="col">
        <strong>
        <?php
        if(!$products_cron_status)
        {
            esc_html_e("Products cron is not started","sync-nexus-wc");
        }
        else if($products_cron_status=="running")
        {
            esc_html_e("Running","sync-nexus-wc");
        }
        else if($products_cron_status=="pending")
        {
            esc_html_e("Pending","sync-nexus-wc");
        }
        ?>
        </strong>
    </div>
    <div class="col">
        <?php esc_html_e("Next run","sync-nexus-wc");?>
    </div>
    <div class="col">
        <strong>
            <?php
            if(!$products_cron_status)
                esc_html_e("Never","sync-nexus-wc");
            else
            {
                $next_run=$nexus->getCronNextRun("syncnexuswc_import_products_cron_hook");
                echo esc_html(gmdate("d/m/Y h:i:s",strtotime($next_run)));
            }
            ?>
        </strong>
    </div>
    <?php
    if(!$products_cron_status)
    {
    ?>
    <div class="col">
    <input type="button" disabled="disabled" <?php echo (($nexus->config->nexus_prod_import_started==1)?'disabled="disabled"':'');?> class="button-primary" value="<?php echo esc_attr(__("Start Cron PRO","sync-nexus-wc"));?>" />
    </div>
    <?php
    }
    else
    {
    ?>
    <div class="col">
    <form method="post" action="" onSubmit="return confirm('<?php echo esc_js(__("Are you sure you want to stop the Products Cron","sync-nexus-wc"));?>?')">
        <input type="hidden" name="_wpnonce" value="<?php echo esc_attr($nonce_2);?>" />
        <input type="hidden" name="action" value="stop_products_cron" />
        <input type="submit" class="button-secondary" value="<?php echo esc_attr(__("Stop Cron","sync-nexus-wc"));?>" />
    </form>
    </div>
    <?php
    }
    ?>
    <div class="col">
        <?php esc_html_e("Last run","sync-nexus-wc");?>
    </div>
    <div class="col">
        <strong>
        <?php
        $last_run=$nexus->getCronLastRun("syncnexuswc_import_products_cron_hook");
        if($last_run!="")
            echo esc_html(gmdate("d/m/Y h:i:s",strtotime($last_run)));
        else
            esc_html_e("Never","sync-nexus-wc");
        ?>
        </strong>
    </div>
    </div>
</div>


















<div class="nexus-dash-row">
<div class="row">
    <div class="col">
         <strong><?php esc_html_e("Status","sync-nexus-wc");?></strong>
    </div>
</div>
<div class="row mt-3">
    <div class="col-2">
         <strong><?php esc_html_e("Nexus ERP Server tatus","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
         <?php echo esc_html($nexus->getNexusServerStatus());?>
    </div>
    <div class="col-2">
         <strong><?php esc_html_e("Nexus ERP server","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <a href="<?php echo esc_attr($nexus->config->nexus_protocol);?>://<?php echo esc_attr($nexus->config->nexus_ip);?>:<?php echo esc_attr($nexus->config->nexus_port);?>" target="_blank"><?php echo esc_html($nexus->config->nexus_protocol);?>://<?php echo esc_html($nexus->config->nexus_ip);?>:<?php echo esc_html($nexus->config->nexus_port);?></a>
    </div>
    <div class="col-2">
         <strong><?php esc_html_e("Bizzmags Marketplace version","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <?php
        if ( defined( 'BIZZMAGSMARKETPLACE_VERSION' ) )
            echo esc_html(BIZZMAGSMARKETPLACE_VERSION);
        else
            echo esc_html('-');
         ?>
    </div>
</div>
<div class="row mt-3">
    <div class="col-4">
         <strong><?php esc_html_e("PDF Invoices & Packing Slips for WooCommerce version","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <?php
        if (class_exists('WPO_WCPDF')) {
        $plugin_version = WPO_WCPDF()->version;
            echo esc_html($plugin_version);
        } else {
            echo esc_html('-');
        }
        ?>
    </div>
    <div class="col-2">
         <strong><?php esc_html_e("WooCommerce version","sync-nexus-wc");?></strong>
    </div>
    <div class="col-4">
        <?php
        if (class_exists('WooCommerce')) {
            $woocommerce_version = WC()->version;
            echo esc_html($woocommerce_version);
        } else {
            echo esc_html('-');
        }
        ?>
    </div>
</div>
<div class="row mt-3">
    <div class="col-4">
         <strong><?php esc_html_e("PDF Invoices & Packing Slips for WooCommerce prefix","sync-nexus-wc");?></strong>
    </div>
    <div class="col-2">
        <a href="<?php echo esc_attr(admin_url());?>admin.php?page=wpo_wcpdf_options_page&tab=documents" target="_blank"><?php echo esc_html($nexus->get_wpo_wcpdf_invoice_prefix());?></a>
    </div>
    <div class="col-2">
         <strong><?php esc_html_e("Last invoice number","sync-nexus-wc");?></strong>
    </div>
    <div class="col-4">
        <?php echo esc_html($nexus->getLastWPOinvoiceNumber());?>
    </div>
</div>
</div>


<?php
}

?>

</div>
