<?php
/**
 * @package    SyncNexusWC
 * @author     Claudiu Maftei <admin@bizzmags.ro>
 */
namespace ClaudiuMaftei\SyncNexusWC;
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

class SyncNexusWC_Admin {

	private $plugin_name;
	private $version;

	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	public function enqueue_styles($hook) {

		if($hook && in_array($hook,array('toplevel_page_claudius_syncnexuswc_main','sync-nexus-wc_page_claudius_syncnexuswc_main-logs','sync-nexus-wc_page_claudius_syncnexuswc_main-help')))
		{
			wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/syncnexuswc-admin.css', array(), $this->version, 'all' );
			wp_enqueue_style( $this->plugin_name."-bootstrap", plugin_dir_url( __FILE__ ) . 'css/grid.css', array(), $this->version, 'all' );
		}

	}

	public function enqueue_scripts() {

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/syncnexuswc-admin.js', array( 'jquery' ), $this->version, false );

	}

}
