<?php
/**
 * Plugin Name: Sync Forms with Brilliant Directories
 * Description: Easily sync WordPress form submissions to Brilliant Directories with the ‘Sync Forms with Brilliant Directories’ plugin. Automatically create Members and Leads using Contact Form 7, WPForms, Ninja Forms, Gravity Forms, Elementor Forms, and more plugin support coming soon. Just install, connect your BD account, and start syncing.
 * Version: 1.3.1
 * Author: Brilliant Directories
 * Text Domain: sync-forms-with-brilliant-directories
 * License: GPL2
 */


// Exit if accessed directly
if (! defined('ABSPATH')) {
    exit;
}

// Define the plugin version
define('BRILDIR_SFWBD_VERSION', '1.3.1');

// Define plugin constants
define('BRILDIR_SFWBD_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('BRILDIR_SFWBD_PLUGIN_URL', plugin_dir_url(__FILE__));

// Include required files
require_once BRILDIR_SFWBD_PLUGIN_DIR . 'includes/class-brildirformsync-activator.php';
require_once BRILDIR_SFWBD_PLUGIN_DIR . 'includes/class-brildirformsync-settings.php';
require_once BRILDIR_SFWBD_PLUGIN_DIR . 'includes/class-brildirformsync-menu.php';
require_once BRILDIR_SFWBD_PLUGIN_DIR . 'includes/class-brildirformsync-api.php';
require_once BRILDIR_SFWBD_PLUGIN_DIR . 'includes/class-brildirformsync-display.php';
require_once BRILDIR_SFWBD_PLUGIN_DIR . 'includes/class-brildirformsync-errorlog.php';
require_once BRILDIR_SFWBD_PLUGIN_DIR . 'includes/class-brildirformsync-deactivator.php';

// Hook for plugin activation
register_activation_hook(__FILE__, 'Brildir_Sfwbd_activate');

// Hook for plugin deactivation
register_deactivation_hook(__FILE__, 'Brildir_Sfwbd_deactivate');

// Initialize the plugin
function Brildir_Sfwbd_Initialize_plugin() 
{
    add_action('init', 'Brildir_Sfwbd_Post_type');
    add_action('admin_enqueue_scripts', 'Brildir_Sfwbd_Enqueue_All_Admin_assets');
}
add_action('plugins_loaded', 'Brildir_Sfwbd_Initialize_plugin');

function Brildir_Sfwbd_Post_type()
{
    $labels = array(
        'name'               => 'All Syncs',
        'singular_name'      => 'Sync',
        'menu_name'          => 'BD Form Syncs',
        'name_admin_bar'     => 'Sync',
        'add_new'            => 'Add New Sync',
        'add_new_item'       => 'Add New Sync',
        'new_item'           => 'New Sync',
        'edit_item'          => 'Edit Sync',
        'view_item'          => 'View Sync',
        'all_items'          => 'All Syncs',
        'search_items'       => 'Search Syncs',
        'not_found'          => 'No Syncs found.',
        'not_found_in_trash' => 'No Syncs found in Trash.',
    );

    $args = array(
        'labels'             => $labels,
        'public'             => false,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'menu_icon'          => 'dashicons-lightbulb',
        'capability_type'    => 'post',
        'supports'           => array( 'title' ),
    );

    register_post_type('brildir-sfwbd', $args);
}

// Change placeholder text to "Enter Nickname here"
function Brildir_Sfwbd_Title_placeholder( $title )
{
    $screen = get_current_screen();
    if ('brildir-sfwbd' === $screen->post_type) {
        $title = esc_html__( 'Enter Nickname', 'sync-forms-with-brilliant-directories' );
    }
    return $title;
}
add_filter('enter_title_here', 'Brildir_Sfwbd_Title_placeholder');

add_action('admin_menu', 'Brildir_Sfwbd_Add_Settings_Submenu');
function Brildir_Sfwbd_Add_Settings_Submenu()
{
    add_submenu_page(
        'edit.php?post_type=brildir-sfwbd',     // Parent slug (your custom post type menu)
        'Brillforms Settings',         // Page title
        'API Connection Status',        // Menu title
        'manage_options',              // Capability
        'brildir_sfwbd-settings',         // Menu slug
        'Brildir_Sfwbd_Settings_Pages'     // Callback function
    );
}

// Callback function for settings page
function Brildir_Sfwbd_Settings_Pages()
{
    $brillforms_settings = new Brildir_Sfwbd_Settings();
    $brillforms_settings->render();
}

function Brildir_Sfwbd_Enqueue_All_Admin_assets($hook)
{
    // Always needed: base styles/scripts
    wp_enqueue_script('jquery');

    wp_register_style('brildir_sfwbd_css', BRILDIR_SFWBD_PLUGIN_URL . 'assets/css/brildirformsync-style.css', array(), BRILDIR_SFWBD_VERSION);
    wp_enqueue_style('brildir_sfwbd_css');

    wp_register_script('brildir_sfwbd_js', BRILDIR_SFWBD_PLUGIN_URL . 'assets/js/brildirformsync-script.js', array('jquery'), BRILDIR_SFWBD_VERSION, true);
    wp_enqueue_script('brildir_sfwbd_js');

    wp_register_style('brill-select2-css', BRILDIR_SFWBD_PLUGIN_URL . 'assets/css/select2.min.css', array(), '4.0.13');
    wp_enqueue_style('brill-select2-css');

    wp_register_script('brill-select2-js', BRILDIR_SFWBD_PLUGIN_URL . 'assets/js/select2.min.js', array('jquery'), '4.0.13', true);
    wp_enqueue_script('brill-select2-js');

    // Localize main script
    $brildirpost_nonce = wp_create_nonce('brildir_sfwbd_settings_nonce_action');
    wp_localize_script('brildir_sfwbd_js', 'brildirformsyncSettings', array(
        'nonce' => $brildirpost_nonce,
        'ajax_url' => admin_url('admin-ajax.php'),
        'post_id' => get_the_ID(),
        'redirect_url' => admin_url('edit.php?post_type=brildir-sfwbd'),
    ));


    // Only enqueue these additional files on post-new and post.php pages
    global $post_type;

    // Only load assets for your custom post type
    if ($post_type == 'brildir-sfwbd') {
    
        if ($hook === 'post-new.php' || $hook === 'post.php') {
            wp_register_style('brildir-sfwbd-admin-style', plugin_dir_url(__FILE__) . 'assets/css/admin-style.css', array(), BRILDIR_SFWBD_VERSION);
            wp_enqueue_style('brildir-sfwbd-admin-style');

            wp_register_script('brildir-sfwbd-admin-script', plugin_dir_url(__FILE__) . 'assets/js/admin-script.js', array('jquery'), BRILDIR_SFWBD_VERSION, true);
            wp_enqueue_script('brildir-sfwbd-admin-script');
        }
    }
}