<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

add_action('admin_init', 'Brildir_Sfwbd_Api_settings');
function Brildir_Sfwbd_Api_settings()
{
    register_setting('brildir_sfwbd_api_settings_group', 'brildir_sfwbd_api_key', 'sanitize_text_field');
    register_setting('brildir_sfwbd_api_settings_group', 'brildir_sfwbd_base_url', 'sanitize_text_field');
}

add_action('admin_init', 'Brildir_Sfwbd_Action_settings');
function Brildir_Sfwbd_Action_settings() 
{
    register_setting('brildir_sfwbd_action_settings_group', 'brildir_sfwbd_allow_lead', 'sanitize_text_field');
}

class Brildir_Sfwbd_Settings
{
    public function render()
    {
        $brillformsync_nonce = isset($_GET['_nonce']) ? sanitize_key(wp_unslash($_GET['_nonce'])) : '';

        if (! empty($brillformsync_nonce) && ! wp_verify_nonce($brillformsync_nonce, 'tab_change_nonce')) {
            die('Security check failed!');
        }

        $brillformsync_active_tab = isset($_GET['tab']) ? sanitize_text_field(wp_unslash($_GET['tab'])) : 'general-settings';
        ?>
        <div class="swc-bd-wrapper">
            <div class="sync-bd-header">
                <a href="https://www.brilliantdirectories.com?utm=wp-formsync-plugin" target="_blank"><div class="sync-bd-icon"></div></a>
                <div class="sync-bd-name-header"><?php echo esc_html__('Form Sync', 'sync-forms-with-brilliant-directories'); ?></div>
            </div>
            <div class="settings_error_wrap">
                <?php
                $errors = get_settings_errors();
                if (!empty($errors)) {
                    echo '<div id="custom-error-container">';
                    foreach ($errors as $error) {
                        echo '<div class="' . esc_attr($error['type']) . ' is-dismissable custom-error-wrap"><p>' . esc_html($error['message']) . '</p></div>';
                    }
                    echo '</div>';
                }
                ?>
                <div id="swbd-saved-msg" class="bd-error-msg-container" style="display:none;">
                    <div class="bd-error-msg-wrap bd-success"><p class="bd-suc-err-txt bd-error-msg-text"><?php echo esc_html__('Settings Saved.', 'sync-forms-with-brilliant-directories'); ?></p></div>
                </div>
			</div>
            <h2 class="swc-bd-nav nav-tab-wrapper">
                <a href="edit.php?post_type=brildir-sfwbd&page=brildir_sfwbd-settings&tab=general-settings" class="nav-tab <?php echo $brillformsync_active_tab == 'general-settings' ? 'nav-tab-active' : ''; ?>">
                    <?php echo esc_html__('General Settings', 'sync-forms-with-brilliant-directories'); ?>
                </a>
                <a href="edit.php?post_type=brildir-sfwbd&page=brildir_sfwbd-settings&tab=log-panel" class="nav-tab <?php echo $brillformsync_active_tab == 'log-panel' ? 'nav-tab-active' : ''; ?>">
                    <?php echo esc_html__('Error Log', 'sync-forms-with-brilliant-directories'); ?>
                </a>
            </h2>
            <?php
            switch ($brillformsync_active_tab) {
            case 'log-panel':
                $this->_brillformsyncLogTab();
                break;
            case 'general-settings':
            default:
                $this->_brillformsyncGeneralTab();
                break;
            }
            ?>
        </div>
        <?php
    }
    private function _brillformsyncGeneralTab() 
    {
        $bd_encryptedApiKey = get_option('brildir_sfwbd_api_key');
        $bd_decryptedApiKey = $bd_encryptedApiKey ? Brildir_Sfwbd_Decrypt_Api_key($bd_encryptedApiKey) : '';
        ?>
        <div class="bd-two-coloumn-wrap">
            <div class="bd-general-configuration-wrap">
                <div class="bd-form-section">
                    <div class="sync-bd-title-wrap">
                        <h2><?php echo esc_html__('Connect Brilliant Directories API', 'sync-forms-with-brilliant-directories'); ?></h2>
                    </div>
                    <div class="bd-form-container">
                        <p class="description brill-api-note">
                            <?php echo esc_html__('Note: Form syncs will only work if a valid API connection is established. ', 'sync-forms-with-brilliant-directories'); ?>
                        </p>
                        <form id="brillforms-api-form" method="POST" action="options.php">
                            <?php 
                                wp_nonce_field('brildir_sfwbd_settings_nonce_action', 'brildir_sfwbd_settings_nonce');
                                settings_fields('brildir_sfwbd_api_settings_group'); 
                            ?>

                            <div class="bd-form-input-wrap">
                                <div class="bd-label-wrap">
                                    <label for="brildir_sfwbd_base_url" id="label_brillforms_base_url">
                                        <?php echo esc_html__('BD Website URL', 'sync-forms-with-brilliant-directories'); ?>
                                    </label>
                                </div>
                                <div class="bd-input-wrap">
                                    <input type="url" id="brildir_sfwbd_base_url" name="brildir_sfwbd_base_url" value="<?php echo esc_attr(get_option('brildir_sfwbd_base_url')); ?>" placeholder="https://example.brilliantdirectories.com" class="regular-text" oninput="this.value = this.value.replace(/\s/g, '')" />
                                </div>
                                <p class="description">
                                    <?php echo esc_html__('Enter the complete website URL including http:// or https://', 'sync-forms-with-brilliant-directories'); ?>
                                </p>
                            </div>

                            <div class="bd-form-input-wrap">
                                <div class="bd-label-wrap">
                                    <label for="brildir_sfwbd_api_key" id="label_brillforms_api">
                                        <?php echo esc_html__('BD API KEY', 'sync-forms-with-brilliant-directories'); ?>
                                    </label>
                                </div>
                                <div class="bd-input-wrap">
                                    <input type="password" id="brildir_sfwbd_api_key" name="brildir_sfwbd_api_key" value="<?php echo esc_attr($bd_encryptedApiKey); ?>" placeholder="<?php echo esc_attr__( 'Enter the API key', 'sync-forms-with-brilliant-directories' ); ?>" class="regular-text" oninput="this.value = this.value.replace(/\s/g, '')" />
                                </div>
                                <p class="description">
                                    <?php echo esc_html__('Documentation: ', 'sync-forms-with-brilliant-directories'); ?><a href="https://support.brilliantdirectories.com/support/solutions/articles/12000088768" target="_blank"><?php echo esc_html__('How to Generate API Key', 'sync-forms-with-brilliant-directories'); ?></a>
                                </p>
                            </div>

                            <div class="api-btn-wrapper">
                                <div>
                                    <?php 
                                        submit_button(esc_html__('Save & Check Connection', 'sync-forms-with-brilliant-directories'), 'primary', 'submit', false, ['id' => 'brillforms-api-form-btn']);
                                    ?>
                                </div>
                                <div>
                                    <p class="brillforms-api-invalid brillforms-error-msg" style="display:none;">
                                        <span class="dashicons dashicons-no-alt"></span> 
                                        <?php echo esc_html__('Ensure API Credentials are Valid', 'sync-forms-with-brilliant-directories'); ?>
                                    </p>
                                    <p class="brillforms-api-valid brillforms-success-msg" style="display:none;">
                                        <span class="dashicons dashicons-saved"></span> 
                                        <?php echo esc_html__('Successful Connection', 'sync-forms-with-brilliant-directories'); ?>
                                    </p>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="bd-form-section">
                    <div class="sync-bd-title-wrap">
                        <h2><?php echo esc_html__('Additional Settings', 'sync-forms-with-brilliant-directories'); ?></h2>
                    </div>
                    <div class="bd-form-container">
                        <form id="brillforms-action-form" method="POST" action="options.php">
                            <?php 
                                wp_nonce_field('brildir_sfwbd_settings_nonce_action', 'brildir_sfwbd_settings_nonce');
                                settings_fields('brildir_sfwbd_action_settings_group'); 
                            ?>

                            <div class="bd-form-input-wrap">
                                <div class="bd-label-wrap">
                                    <label for="brildir_sfwbd_allow_lead" id="brillforms_allow_lead_label">
                                        <?php echo esc_html__('Allow Multiple Lead Submissions from Same Email Address', 'sync-forms-with-brilliant-directories'); ?>
                                    </label>
                                </div>
                                <div class="bd-input-wrap bd-label-wrap">
                                    <select id="brillforms_allow_lead" name="brildir_sfwbd_allow_lead" class="regular-text">
                                        <option value="no" <?php selected(get_option('brildir_sfwbd_allow_lead'), 'no'); ?>><?php echo esc_html__('No – One lead per email address', 'sync-forms-with-brilliant-directories'); ?></option>
                                        <option value="yes" <?php selected(get_option('brildir_sfwbd_allow_lead'), 'yes'); ?>><?php echo esc_html__('Yes – Allow multiple leads from the same email address', 'sync-forms-with-brilliant-directories'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <?php
                                submit_button(esc_html__('Save Changes', 'sync-forms-with-brilliant-directories'), 'primary', 'submit', false, ['id' => 'brillforms-action-form']);
                            ?>
                        </form>
                    </div>
                </div>
            </div>
            <div class="bd-video-container">
                <iframe src="https://get.brilliantdirectories.com/wordpress-form-sync-plugin-iframe"></iframe>
            </div>
        <?php
    }

    private function _brillformsyncLogTab() 
    {
        ?>
        <div class="bd-two-coloumn-wrap">
            <div class="bd-general-configuration-wrap">
                <div class="bd-form-section">
                    <div class="sync-bd-title-wrap brill-clear-log-wrap">
                        <div><h2><?php echo esc_html__('Error Log', 'sync-forms-with-brilliant-directories'); ?></h2></div>
                        <div class="brill-log-clear"><span id="brill_clear_log">Clear All Logs</span></div>
                    </div>
                    <div>
                        <?php echo do_shortcode('[brildir_sfwbd_error_log]'); ?>
                    </div>
                    <div id="brill_clear_log_modal"  class="brill-popup-wrap" style="display:none;">
                        <div class="brill-modal-overlay"></div>
                        <div class="brill-modal-content">
                            <h1><?php echo esc_html__('Confirm Action', 'sync-forms-with-brilliant-directories'); ?></h1>
                            <div class="brill-confirmation-btn-wrap">
                                <button id="brill_confirm_clear" class="brill-popup-confirm-btn"><?php echo esc_html__('Yes, continue', 'sync-forms-with-brilliant-directories'); ?></button>
                                <button id="brill_cancel_clear" class="brill-popup-cancel-btn"><?php echo esc_html__('No, cancel', 'sync-forms-with-brilliant-directories'); ?></button>
                            </div>
                        </div>
                    </div>     
                </div>
            </div>
            <div class="bd-video-container">
                <iframe src="https://get.brilliantdirectories.com/wordpress-form-sync-plugin-iframe"></iframe>
            </div>
        <?php
    }
}

// Function start: Encrypt API key for secure storage
function Brildir_Sfwbd_Encrypt_Api_key($api_key)
{
    $encryption_key = wp_salt();
    $iv_length = openssl_cipher_iv_length('AES-256-CBC');
    $iv = openssl_random_pseudo_bytes($iv_length);
    $encrypted_data = openssl_encrypt($api_key, 'AES-256-CBC', $encryption_key, 0, $iv);
    return base64_encode($encrypted_data . '::' . $iv);
}
// Function end: Encrypt API key for secure storage

// Function start: Decrypt API key for usage
function Brildir_Sfwbd_Decrypt_Api_key($encrypted_api_key)
{
    $encryption_key = wp_salt();
    list($encrypted_data, $iv) = explode('::', base64_decode($encrypted_api_key), 2);
    return openssl_decrypt($encrypted_data, 'AES-256-CBC', $encryption_key, 0, $iv);
}
// Function end: Decrypt API key for usage

// Function start: Validate API key via AJAX request
add_action('wp_ajax_brildir_sfwbd_validate_api_key', 'Brildir_Sfwbd_Validate_Api_Key_ajax');
add_action('wp_ajax_nopriv_brildir_sfwbd_validate_api_key', 'Brildir_Sfwbd_Validate_Api_Key_ajax');
function Brildir_Sfwbd_Validate_Api_Key_ajax()
{
    if (! isset($_POST['brildir_sfwbd_settings_nonce']) || ! wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_settings_nonce'])), 'brildir_sfwbd_settings_nonce_action') ) {
        wp_send_json_error(array('message' => 'Invalid nonce.'));
        return;
    }

    if (isset($_POST['brildir_sfwbd_api_key']) && isset($_POST['brildir_sfwbd_base_url']) ) {
        $apiKey = sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_api_key']));
        $apiBaseUrl = sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_base_url']));

        if (!empty($apiKey)) {
            if (strlen($apiKey) > 50) {
                $apiKey = sanitize_text_field($apiKey);
                update_option('brildir_sfwbd_api_key', $apiKey);
            } else {
                $bd_encryptedApiKey = Brildir_Sfwbd_Encrypt_Api_key($apiKey);
                update_option('brildir_sfwbd_api_key', $bd_encryptedApiKey);
            }
        } else {
            $apiKey = sanitize_text_field($apiKey);
            update_option('brildir_sfwbd_api_key', '');
        }
        
        $apiBaseUrl = sanitize_text_field($apiBaseUrl);
        update_option('brildir_sfwbd_base_url', $apiBaseUrl);

        $is_valid = Brildir_Sfwbd_validateApiKey($apiKey, $apiBaseUrl);

        if ($is_valid) {
            update_option('brildir_sfwbd_api_status', 'valid');
            wp_send_json_success('API Key is valid');
        } else {
            update_option('brildir_sfwbd_api_status', 'invalid');
            wp_send_json_error('Invalid API Key');
        }
    } else {
        wp_send_json_error('Missing API Key or Base URL');
    }
}
// Function end: Validate API key via AJAX request

// Function start: Validate the API key with external API
function Brildir_Sfwbd_validateApiKey($apiKey, $apiBaseUrl)
{
    $url = rtrim($apiBaseUrl, '/') . '/api/v2/token/verify';

    $args = array(
        'headers' => array(
            'x-api-key' => strlen($apiKey) > 50 ? Brildir_Sfwbd_Decrypt_Api_key($apiKey) : $apiKey ,
        ),
        'timeout' => 15, 
    );
    $response = wp_remote_get($url, $args);

    if (is_wp_error($response)) {
        return false; 
    }

    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    if (isset($data['status']) && $data['status'] == 'success') {
        return true;  
    } else {
        return false;
    }

    return true; 
}
// Function end: Validate the API key with external API