<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

add_action('edit_form_after_title', 'Brildir_Sfwbd_Custom_form');
function Brildir_Sfwbd_Custom_form($post) {
    if ($post->post_type !== 'brildir-sfwbd') {
        return;
    }
    wp_nonce_field('save_sync_meta_box', 'sync_meta_box_nonce');

    // Load existing meta values
    $brillforms_selected_plugin = get_post_meta($post->ID, '_brildir_sfwbd_form_plugin', true);
    $brillforms_selected_form_id = get_post_meta($post->ID, '_brildir_sfwbd_form_id', true);
    $brillforms_create_option = get_post_meta($post->ID, '_brildir_sfwbd_create_option', true);
    $brillforms_subscription_id = get_post_meta($post->ID, '_brildir_sfwbd_subscription_id', true);

    // Get CF7 forms
    $brillforms_cf7_forms = [];
    if (post_type_exists('wpcf7_contact_form')) {
        $cf7_query = new WP_Query(
            [
            'post_type' => 'wpcf7_contact_form',
            'posts_per_page' => -1,
            'orderby' => 'title',
            'order' => 'ASC',
            ]
        );
        foreach ($cf7_query->posts as $form) {
            $brillforms_cf7_forms[$form->ID] = esc_html($form->post_title);
        }
    }

    $brillforms_wpforms = [];
    if (post_type_exists('wpforms')) {
        $wpforms_query = new WP_Query([
            'post_type' => 'wpforms',
            'posts_per_page' => -1,
            'orderby' => 'title',
            'order' => 'ASC',
        ]);

        foreach ($wpforms_query->posts as $form) {
            $brillforms_wpforms[$form->ID] = esc_html($form->post_title);
        }
    }

    $brillforms_ninja_forms = [];

    if (function_exists('Ninja_Forms')) {
        $ninja_forms = Ninja_Forms()->form()->get_forms();

        foreach ($ninja_forms as $form) {
            $brillforms_ninja_forms[$form->get_id()] = esc_html($form->get_setting('title'));
        }
    }

    $brillforms_gf_forms = [];
    if (class_exists('GFAPI')) {
        $gf_forms = GFAPI::get_forms();

        foreach ($gf_forms as $form) {
            $brillforms_gf_forms[$form['id']] = esc_html($form['title']);
        }
    }

    $brillforms_elementor_forms = [];

    // Get all public post types that support 'elementor'
    $post_types = get_post_types([
        'public' => true,
    ], 'names');

    $elementor_query = new WP_Query([
        'post_type' => $post_types,
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'meta_query' => [
            [
                'key' => '_elementor_data',
                'compare' => 'EXISTS',
            ]
        ]
    ]);

    foreach ($elementor_query->posts as $post) {
        $elementor_data = get_post_meta($post->ID, '_elementor_data', true);

        if (!empty($elementor_data)) {
            $widgets = json_decode($elementor_data, true);

            if (is_array($widgets)) {
                $iterator = new RecursiveIteratorIterator(new RecursiveArrayIterator($widgets));

                foreach ($iterator as $key => $value) {
                    // Check if it's a form widget
                    if ($key === 'widgetType' && $value === 'form') {
                        // Find the closest parent with form settings
                        $depth = $iterator->getDepth();
                        for ($i = $depth; $i >= 0; $i--) {
                            $current = $iterator->getSubIterator($i);
                            if (isset($current['settings']['form_name'])) {
                                $form_name = $current['settings']['form_name'];
                                $form_id = $post->ID . ':' . $form_name;
                                $form_label = $form_name . ' (Title: ' . get_the_title($post) . ')';
                                $brillforms_elementor_forms[$form_id] = esc_html($form_label);
                                break;
                            }
                        }
                    }
                }
            }
        }
    }

    ?>
    <div class="brillforms-add-sync-wrap">
        <div class="brill-field-wrap brill-single-select">
            <label for="brillforms_form_plugin" id="brillforms_select_plugin_label"><?php echo esc_html__('Select Plugin', 'sync-forms-with-brilliant-directories'); ?></label>
            <select name="brildir_sfwbd_form_plugin" id="brillforms_form_plugin" required>
                <option value="" selected="true" disabled="disabled">
                    <?php echo esc_html__('Select a Form Plugin', 'sync-forms-with-brilliant-directories'); ?>
                </option>

                <?php
                if (is_plugin_active('contact-form-7/wp-contact-form-7.php')) {
                    echo '<option value="contact_form_7" ' . selected($brillforms_selected_plugin, 'contact_form_7', false) . '>' . esc_html__('Contact Form 7', 'sync-forms-with-brilliant-directories') . '</option>';
                } else {
                    echo '<option value="contact_form_7" disabled>' . esc_html__('Contact Form 7 (Plugin not available)', 'sync-forms-with-brilliant-directories') . '</option>';
                }
                if (is_plugin_active('wpforms-lite/wpforms.php')) {
                    echo '<option value="wpforms" ' . selected($brillforms_selected_plugin, 'wpforms', false) . '>' . esc_html__('WPForms', 'sync-forms-with-brilliant-directories') . '</option>';
                } else {
                    echo '<option value="wpforms" disabled>' . esc_html__('WPForms (Plugin not available)', 'sync-forms-with-brilliant-directories') . '</option>';
                }
                if (is_plugin_active('ninja-forms/ninja-forms.php')) {
                    echo '<option value="ninjaform" ' . selected($brillforms_selected_plugin, 'ninjaform', false) . '>' . esc_html__('Ninja Forms', 'sync-forms-with-brilliant-directories') . '</option>';
                } else {
                    echo '<option value="ninjaform" disabled>' . esc_html__('Ninja Form (Plugin not available)', 'sync-forms-with-brilliant-directories') . '</option>';
                }
                if (is_plugin_active('gravityforms/gravityforms.php')) {
                    echo '<option value="gform" ' . selected($brillforms_selected_plugin, 'gform', false) . '>' . esc_html__('Gravity Forms', 'sync-forms-with-brilliant-directories') . '</option>';
                } else {
                    echo '<option value="gform" disabled>' . esc_html__('Gravity Forms (Plugin not available)', 'sync-forms-with-brilliant-directories') . '</option>';
                }
                if (is_plugin_active('elementor/elementor.php')) {
                    echo '<option value="elementor" ' . selected($brillforms_selected_plugin, 'elementor', false) . '>' . esc_html__('Elementor Forms', 'sync-forms-with-brilliant-directories') . '</option>';
                } else {
                    echo '<option value="elementor" disabled>' . esc_html__('Elementor Forms (Plugin not available)', 'sync-forms-with-brilliant-directories') . '</option>';
                }
                ?>
            </select>
        </div>

        <div class="brill-field-wrap brill-single-select" id="brillforms_cf7_forms_wrap" style="<?php echo ($brillforms_selected_plugin === 'contact_form_7') ? '' : 'display:none;'; ?>">
            <label for="brillforms_cf7_forms" id="brillforms_select_form_label"><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></label>
            <select name="brildir_sfwbd_cf7_form_id" id="brillforms_cf7_forms" required>
                <option value=""><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></option>
                <?php foreach ($brillforms_cf7_forms as $id => $title): ?>
                    <option value="<?php echo esc_attr($id); ?>" <?php selected($brillforms_selected_form_id, $id); ?>>
                        <?php echo esc_html($title); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="brill-field-wrap brill-single-select" id="brillforms_wpforms_wrap" style="<?php echo ($brillforms_selected_plugin === 'wpforms') ? '' : 'display:none;'; ?>">
            <label for="brillforms_wpforms_forms" id="brillforms_select_wpforms_label"><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></label>
            <select name="brildir_sfwbd_wpforms_form_id" id="brillforms_wpforms_forms" required>
                <option value=""><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></option>
                <?php foreach ($brillforms_wpforms as $id => $title): ?>
                    <option value="<?php echo esc_attr($id); ?>" <?php selected($brillforms_selected_form_id, $id); ?>>
                        <?php echo esc_html($title); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="brill-field-wrap brill-single-select" id="brillforms_ninjaforms_wrap" style="<?php echo ($brillforms_selected_plugin === 'ninjaform') ? '' : 'display:none;'; ?>">
            <label for="brillforms_ninja_forms" id="brillforms_ninjaforms_label"><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></label>
            <select name="brildir_sfwbd_ninjaform_form_id" id="brillforms_ninja_forms" required>
                <option value=""><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></option>
                <?php foreach ($brillforms_ninja_forms as $id => $title): ?>
                    <option value="<?php echo esc_attr($id); ?>" <?php selected($brillforms_selected_form_id, $id); ?>>
                        <?php echo esc_html($title); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="brill-field-wrap brill-single-select" id="brillforms_gf_wrap" style="<?php echo ($brillforms_selected_plugin === 'gform') ? '' : 'display:none;'; ?>">
            <label for="brillforms_gf_forms" id="brillforms_gf_label"><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></label>
            <select name="brildir_sfwbd_gf_form_id" id="brillforms_gf_forms" required>
                <option value=""><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></option>
                <?php foreach ($brillforms_gf_forms as $id => $title): ?>
                    <option value="<?php echo esc_attr($id); ?>" <?php selected($brillforms_selected_form_id, $id); ?>>
                        <?php echo esc_html($title); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="brill-field-wrap brill-single-select" id="brillforms_elementor_wrap" style="<?php echo ($brillforms_selected_plugin === 'elementor') ? '' : 'display:none;'; ?>">
            <label for="brillforms_elementor_forms" id="brillforms_elementor_label"><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></label>
            <select name="brildir_sfwbd_elementor_form_id" id="brillforms_elementor_forms" required>
                <option value=""><?php echo esc_html__('Select Form', 'sync-forms-with-brilliant-directories'); ?></option>
                <?php foreach ($brillforms_elementor_forms as $id => $title): ?>
                    <option value="<?php echo esc_attr($id); ?>" <?php selected($brillforms_selected_form_id, $id); ?>>
                        <?php echo esc_html($title) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="brill-field-wrap brill-single-select" id="brill_create_option_wrap">
            <label for="brillforms_create_option" id="brillforms_create_option_label"><?php echo esc_html__('Type of Record to Create in Brilliant Directories', 'sync-forms-with-brilliant-directories'); ?></label>
            <select name="brildir_sfwbd_create_option" id="brillforms_create_option" required>
                <option value="" selected="true" disabled="disabled"><?php echo esc_html__('Select Create Action', 'sync-forms-with-brilliant-directories'); ?></option>
                <option value="user" <?php selected($brillforms_create_option, 'user'); ?>>
                    <?php echo esc_html__('Create Member', 'sync-forms-with-brilliant-directories'); ?>
                </option>
                <option value="leads" <?php selected($brillforms_create_option, 'leads'); ?>>
                    <?php echo esc_html__('Create Lead', 'sync-forms-with-brilliant-directories'); ?>
                </option>
            </select>
        </div>
        <div class="brill-field-wrap">
            <p class="brill-note-txt"><?php echo esc_html__('Note: Actions already used with the same form are marked as "Unavailable" and cannot be selected again.', 'sync-forms-with-brilliant-directories'); ?></p>
        </div>
        <div class="brill-field-wrap" id="brill_plan_id" style="display:none;">
            <label for="brillforms_subscription_id"><?php echo esc_html__('Assign Membership Plan ID', 'sync-forms-with-brilliant-directories'); ?></label>
            <input type="text" name="brildir_sfwbd_subscription_id" id="brillforms_subscription_id" value="<?php echo esc_attr($brillforms_subscription_id); ?>" placeholder="<?php echo esc_attr__('Enter Membership Plan ID', 'sync-forms-with-brilliant-directories'); ?>" />
            <p class="brill-note-txt">
                <?php echo esc_html__('Documentation: ', 'sync-forms-with-brilliant-directories'); ?><a href="https://support.brilliantdirectories.com/support/solutions/articles/12000048836" target="_blank"><?php echo esc_html__('Where to Find Membership Plan ID Number', 'sync-forms-with-brilliant-directories'); ?></a>
            </p>
            <p class="brill-note-txt bril-required-msg" id="brill_planid_req_msg" style="display:none;"><?php echo esc_html__('Membership Plan ID is required', 'sync-forms-with-brilliant-directories'); ?></p>
        </div>

        <div class="" id="brillforms_fields_wrap">
            <?php
            if (!empty($brillforms_selected_form_id) && isset($all_mappings[$brillforms_selected_form_id])) {
                $all_mappings = get_post_meta($post->ID, '_brildir_sfwbd_field_map', true);
                $saved_mapping = [];
                $saved_mapping = $all_mappings[$brillforms_selected_form_id];
                echo wp_kses_post(Brildir_Sfwbd_Get_Cf7_fields($brillforms_selected_form_id, $saved_mapping));
            }
            ?>
        </div>
        <div class="brill-field-wrap" id="brill_member_map_req_msg" style="display:none;">
            <p class="brill-note-txt bril-required-msg"><?php echo esc_html__('Required Mapping Fields Missing.', 'sync-forms-with-brilliant-directories'); ?></p>
        </div>
        <div class="brill-field-wrap" id="brill_lead_map_req_msg" style="display:none;">
            <p class="brill-note-txt bril-required-msg"><?php echo esc_html__('Required Mapping Fields Missing.', 'sync-forms-with-brilliant-directories'); ?></p>
        </div>
        <div class="brill-field-wrap bril-required-msg" id="brill_mapping_err" style="display:none;">

        </div>
        <div class="brill-field-wrap bril-required-msg" id="brill_same_map_err" style="display:none;">
        
        </div>
        <p class="brill-note-txt"><strong><?php echo esc_html__('Important: ', 'sync-forms-with-brilliant-directories'); ?></strong><?php echo esc_html__("If you're not using any spam protection, such as ReCAPTCHA or a honeypot field, it's highly recommended to add one to help minimize and prevent spam. While you can still continue without it, using spam protection is the best way to safeguard your forms. If you've already added protection, feel free to ignore this message.", 'sync-forms-with-brilliant-directories'); ?><p>
    </div>
    <?php
}

add_action('wp_ajax_brildir_sfwbd_validate_mappings', 'Brildir_Sfwbd_Validate_Mappings_ajax');
function Brildir_Sfwbd_Validate_Mappings_ajax()
{
    if (!isset($_POST['brildir_sfwbd_settings_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_settings_nonce'])), 'brildir_sfwbd_settings_nonce_action')) {
        wp_send_json_error(array('message' => esc_html__('Invalid nonce.', 'sync-forms-with-brilliant-directories')));
        return;
    }

    $create_option = isset($_POST['create_option']) ? sanitize_text_field(wp_unslash($_POST['create_option'])) : '';
    $mappings = isset($_POST['mappings']) && is_array($_POST['mappings']) ? array_map('sanitize_text_field', wp_unslash($_POST['mappings'])) : [];
    $bd_plan_id = isset($_POST['member_id']) ? sanitize_text_field(wp_unslash($_POST['member_id'])) : '';

    // Check for duplicate values excluding 'skip'
    $filtered_mappings = array_filter($mappings, function($value) {
        return $value !== 'skip'; // Only keep values that are not 'skip'
    });

    $unique_mappings = array_unique($filtered_mappings);
    
    // If there are duplicate non-'skip' values, send an error
    $unique_mappings = array_unique($filtered_mappings);

    // If there are duplicate non-'skip' values, send an error
    if (count($unique_mappings) !== count($filtered_mappings)) {
        $duplicate_values = array_diff_assoc($filtered_mappings, $unique_mappings);

        wp_send_json_error(array(
            'mapping' => 'maperr',
            'dubicate'=> implode(', ', $duplicate_values)
        ));
        return;
    }

    if ($create_option === 'user') {
        if (empty($bd_plan_id)) {
            wp_send_json_error(
                [
                'message' => esc_html__('planid', 'sync-forms-with-brilliant-directories')
                ]
            );
        }
        $required = ['email', 'active'];
        $missing = array_diff($required, $mappings);

        if (!empty($missing)) {
            wp_send_json_error(
                [
                'message' => esc_html__('useremail', 'sync-forms-with-brilliant-directories')
                ]
            );
        }        
    } elseif ($create_option === 'leads') {
        $required = ['lead_email'];
        $missing = array_diff($required, $mappings);

        if (!empty($missing)) {
            wp_send_json_error(
                [
                'message' => esc_html__('leademail', 'sync-forms-with-brilliant-directories')
                ]
            );
        }
    }
    wp_send_json_success(['message' => esc_html__('Validation passed.', 'sync-forms-with-brilliant-directories')]);
}

add_action('save_post', 'Brildir_Sfwbd_Save_Create_Sync_data');
function Brildir_Sfwbd_Save_Create_Sync_data($post_id)
{
    // Verify nonce
    if (!isset($_POST['sync_meta_box_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['sync_meta_box_nonce'])), 'save_sync_meta_box')) {
        return;
    }

    // Prevent autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    // Check user permissions
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    $brill_selected_plugin = isset($_POST['brildir_sfwbd_form_plugin']) ? sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_form_plugin'])) : '';
    $form_id = 0;

    switch ($brill_selected_plugin) {
        case 'contact_form_7':
            $form_id = isset($_POST['brildir_sfwbd_cf7_form_id']) ? intval(wp_unslash($_POST['brildir_sfwbd_cf7_form_id'])) : 0;
            break;
        case 'wpforms':
            $form_id = isset($_POST['brildir_sfwbd_wpforms_form_id']) ? intval(wp_unslash($_POST['brildir_sfwbd_wpforms_form_id'])) : 0;
            break;
        case 'ninjaform':
            $form_id = isset($_POST['brildir_sfwbd_ninjaform_form_id']) ? intval(wp_unslash($_POST['brildir_sfwbd_ninjaform_form_id'])) : 0;
            break;
        case 'gform':
            $form_id = isset($_POST['brildir_sfwbd_gf_form_id']) ? intval(wp_unslash($_POST['brildir_sfwbd_gf_form_id'])) : 0;
            break;
        case 'elementor':
            $form_id = isset($_POST['brildir_sfwbd_elementor_form_id']) ? sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_elementor_form_id'])) : 0;
            break;
    }

    if ($brill_selected_plugin) {
        update_post_meta($post_id, '_brildir_sfwbd_form_plugin', $brill_selected_plugin);

        $plugin_name_map = [
            'contact_form_7' => 'Contact Form 7',
            'wpforms'        => 'WPForms',
            'ninjaform'      => 'Ninja Form',
            'gform'          => 'Gravity Forms',
            'elementor'      => 'Elementor Form',
        ];

        $plugin_name = isset($plugin_name_map[$brill_selected_plugin]) ? $plugin_name_map[$brill_selected_plugin] : 'Unknown Plugin';
        update_post_meta($post_id, '_brildir_sfwbd_plugin_name', $plugin_name);

        if ($form_id) {
            update_post_meta($post_id, '_brildir_sfwbd_form_id', $form_id);

            if ($brill_selected_plugin === 'ninjaform') {
                // For Ninja Forms, get form title
                $ninja_form = Ninja_Forms()->form($form_id)->get();
                if ($ninja_form) {
                    $form_title = $ninja_form->get_setting('title');
                }
            } elseif ($brill_selected_plugin === 'gform') {
                // For Gravity Forms, get form title
                $gf_form = GFAPI::get_form($form_id);
                if ($gf_form) {
                    $form_title = $gf_form['title'];  // Get form title from Gravity Forms
                }
            } elseif ($brill_selected_plugin === 'elementor') {
                // Handle composite ID like "123:newsletter-signup"
                list($page_id, $form_name) = explode(':', $form_id, 2);
                $page_title = get_the_title(intval($page_id));
                $form_title = $form_name . ' (Title: ' . $page_title . ')';
            } else {
                // For other plugins (CF7, WPForms), get the post title
                $form_post = get_post($form_id);
                if ($form_post) {
                    $form_title = $form_post->post_title;
                }
            }

            if (!empty($form_title)) {
                update_post_meta($post_id, '_brildir_sfwbd_form_title', sanitize_text_field($form_title));
            }
        }
    }

    if (isset($_POST['brildir_sfwbd_create_option'])) {
        update_post_meta($post_id, '_brildir_sfwbd_create_option', sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_create_option'])));
        if (sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_create_option'])) === 'user' ) {
            update_post_meta($post_id, '_brildir_sfwbd_create_type', 'Member');
        } elseif (sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_create_option'])) === 'leads' ) {
            update_post_meta($post_id, '_brildir_sfwbd_create_type', 'Lead');
        }
    }

    if (isset($_POST['brildir_sfwbd_subscription_id'])) {
        update_post_meta($post_id, '_brildir_sfwbd_subscription_id', sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_subscription_id'])));
    }
    
    if (isset($_POST['brildir_sfwbd_create_option'], $form_id)) {
        $form_id = $form_id;
        $brill_create_option = sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_create_option']));
    
        // Get current mapping of used combinations
        $used_combos = get_option('brildir_sfwbd_used_form_actions', []);
    
        // Create unique key for this combo
        $combo_key = $form_id . '|' . $brill_create_option;
    
        if (!in_array($combo_key, $used_combos, true)) {
            $used_combos[] = $combo_key;
            update_option('brildir_sfwbd_used_form_actions', $used_combos);
        }
    }

    // Save form field mappings
    if (isset($_POST['brildir_sfwbd_field_map']) && is_array($_POST['brildir_sfwbd_field_map'])) {
        $form_id = $form_id;
        if ($form_id) {
            // Get existing mappings or initialize an empty array if none exist
            $existing_mappings = get_post_meta($post_id, '_brildir_sfwbd_field_map', true);
            if (!is_array($existing_mappings)) {
                $existing_mappings = [];
            }
        
            // Ensure $_POST['brildir_sfwbd_field_map'] is an array before proceeding
            if (isset($_POST['brildir_sfwbd_field_map']) && is_array($_POST['brildir_sfwbd_field_map'])) {
                // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Data is sanitized below
                $field_map_raw = wp_unslash($_POST['brildir_sfwbd_field_map']);
            
                $field_map_sanitized = [];
            
                foreach ( $field_map_raw as $form_field => $mapped_lead_field ) {
                    $mapped_lead_field = sanitize_text_field($mapped_lead_field);

                    // Skip storing fields mapped as "skip"
                    if ($mapped_lead_field === 'skip') {
                        continue;
                    }
                    $field_map_sanitized[sanitize_text_field($form_field)] = sanitize_text_field($mapped_lead_field);
                }
            
                $existing_mappings[ $form_id ] = $field_map_sanitized;

                update_post_meta($post_id, '_brildir_sfwbd_field_map', $existing_mappings);
            }
        }
    }

    // Save additional custom field mappings
    if (isset($_POST['brildir_sfwbd_field_map_custom']) && is_array($_POST['brildir_sfwbd_field_map_custom'])) {
        $form_id = $form_id;
        if ($form_id) {
            $custom_fields_raw = wp_unslash($_POST['brildir_sfwbd_field_map_custom']); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized

            foreach ($custom_fields_raw as $field_data) {
                if (!empty($field_data['name']) && !empty($field_data['map_to'])) {
                    $field_name = sanitize_text_field($field_data['name']);
                    $mapped_field = sanitize_text_field($field_data['map_to']);
                    $brill_custom_mapping[$form_id][$mapped_field] = $field_name;
                }
            }
            // Save merged mappings
            update_post_meta($post_id, '_brildir_sfwbd_field_map_custom', $brill_custom_mapping);
        }
    } else {
        update_post_meta($post_id, '_brildir_sfwbd_field_map_custom', '');
    }
}

add_action('wp_ajax_brildir_sfwbd_check_form_actions', 'Brildir_Sfwbd_Check_Form_Actions_ajax');
function Brildir_Sfwbd_Check_Form_Actions_ajax()
{
    if (
        !isset($_POST['brildir_sfwbd_settings_nonce']) ||
        !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_settings_nonce'])), 'brildir_sfwbd_settings_nonce_action')
    ) {
        wp_send_json_error(['message' => esc_html__('Invalid nonce.', 'sync-forms-with-brilliant-directories')]);
        return;
    }

    if (!current_user_can('edit_posts')) {
        wp_send_json_error(['message' => esc_html__('Unauthorized', 'sync-forms-with-brilliant-directories')]);
        return;
    }

    $form_id = isset($_POST['form_id']) ? sanitize_text_field(wp_unslash($_POST['form_id'])) : 0;
    $current_post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : 0;
    $bril_plugin_name = isset($_POST['plugin_name']) ? sanitize_text_field(wp_unslash($_POST['plugin_name'])) : 0;
    $used_actions = [];

    // Use WP_Query instead of get_posts
    $query = new WP_Query([
        'post_type'      => 'brildir-sfwbd',
        'posts_per_page' => -1,
        'post_status'    => 'any',
        'meta_query'     => [
            [
                'key'   => '_brildir_sfwbd_form_plugin',
                'value' => $bril_plugin_name,
            ],
            [
                'key'   => '_brildir_sfwbd_form_id',
                'value' => $form_id,
            ],
        ],
        'no_found_rows' => true, // Performance boost
        'fields'        => 'ids' // We only need post IDs
    ]);

    if ($query->have_posts()) {
        foreach ($query->posts as $post_id) {
            if ($post_id === $current_post_id) {
                continue; // Skip the current post
            }

            $action = get_post_meta($post_id, '_brildir_sfwbd_create_option', true);
            if ($action) {
                $used_actions[] = $action;
            }
        }
    }

    wp_send_json_success(['used_actions' => $used_actions]);
}

add_action('wp_ajax_brildir_sfwbd_load_cf7_form_fields', 'Brildir_Sfwbd_Load_Form_Fields_ajax');
function Brildir_Sfwbd_Load_Form_Fields_ajax()
{
    if (!isset($_POST['brildir_sfwbd_settings_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_settings_nonce'])), 'brildir_sfwbd_settings_nonce_action')) {
        wp_send_json_error(array('message' => esc_html__('Invalid nonce.', 'sync-forms-with-brilliant-directories')));
        return;
    }

    $form_id = isset($_POST['form_id']) ? sanitize_text_field(wp_unslash($_POST['form_id'])) : 0;
    $post_id = isset($_POST['post_id']) ? intval(wp_unslash($_POST['post_id'])) : 0;
    $create_sub = isset($_POST['create_option']) ? sanitize_text_field(wp_unslash($_POST['create_option'])) : '';
    $brill_form_plugin = isset($_POST['brill_plugin']) ? sanitize_text_field(wp_unslash($_POST['brill_plugin'])) : '';

    if (!$form_id) {
        wp_send_json_error(array('message' => esc_html__('Invalid form ID.', 'sync-forms-with-brilliant-directories')));
        return;
    }

    $form_id = isset($_POST['form_id']) ? sanitize_text_field(wp_unslash($_POST['form_id'])) : 0;
    $post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : 0;

    $saved_mapping = [];
    if ($post_id) {
        $all_mappings = get_post_meta($post_id, '_brildir_sfwbd_field_map', true);
        if (isset($all_mappings[$form_id])) {
            $saved_mapping = $all_mappings[$form_id];
        }
    }

    $brill_get_custom_mapping = '';
    if ($post_id) {
        $brill_get_custom_mapping = get_post_meta($post_id, '_brildir_sfwbd_field_map_custom', true);
    }

    $brill_allowed_html = array(
        'div' => array(
            'class' => array(),
            'id' => array(),
            'data-index' => array(),
        ),
        'span' => array(
            'class' => array(),
            'id' => array(),
            'data-index' => array(),
        ),
        'label' => array(
            'class' => array(),
            'id' => array(),
        ),
        'optgroup' => array(
            'label' => array(),
            'id' => array(),
        ),
        'table' => array(
            'class' => array(),
        ),
        'thead' => array(),
        'tbody' => array(),
        'tr' => array(),
        'th' => array(
            'id' => array(),
            'class' => array(),
            'style' => array()
        ),
        'td' => array(),
        'select' => array(
            'name' => array(),
            'class' => array(),
            'style' => array(),
        ),
        'option' => array(
            'value' => array(),
            'selected' => array(),
        ),
        'input' => array(
            'type' => array(),
            'name' => array(),
            'value' => array(),
            'placeholder' => array(),
            'class' => array(),
            'required' => array(),
        ),
        'button' => array(
            'type' => array(),
            'id' => array(),
            'class' => array(),
            'style' => array(),
        ),
        'em' => array(),
    ); 
    
    if ($brill_form_plugin === 'contact_form_7'){
        echo wp_kses(Brildir_Sfwbd_Get_Cf7_fields($form_id, $create_sub, $saved_mapping, $brill_get_custom_mapping), $brill_allowed_html);
    } elseif ($brill_form_plugin === 'wpforms'){
        echo wp_kses(Brildir_Sfwbd_Get_WPForms_fields($form_id, $create_sub, $saved_mapping, $brill_get_custom_mapping), $brill_allowed_html);
    } elseif($brill_form_plugin === 'ninjaform'){
        echo wp_kses (Brildir_Sfwbd_Get_NinjaForms_fields($form_id, $create_sub, $saved_mapping, $brill_get_custom_mapping), $brill_allowed_html);
    } elseif($brill_form_plugin === 'gform'){
        echo wp_kses (Brildir_Sfwbd_Get_GF_fields($form_id, $create_sub, $saved_mapping, $brill_get_custom_mapping), $brill_allowed_html);
    } elseif($brill_form_plugin === 'elementor'){
        echo wp_kses (Brildir_Sfwbd_Get_elementor_fields($form_id, $create_sub, $saved_mapping, $brill_get_custom_mapping), $brill_allowed_html);
    }  

    wp_die();   
}



function Brildir_Sfwbd_Get_Cf7_fields($form_id, $create_sub, $saved_mapping = [], $brill_get_custom_mapping = []) 
{
    ob_start();
    $brill_cf7_form_post = get_post($form_id);
    if (!$brill_cf7_form_post) {
        return '<p><em>' . esc_html__('Form not found.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    $brill_cf7_form_content = $brill_cf7_form_post->post_content;
    
    preg_match_all('/\[(checkbox|date|select|email|hidden|number|radio|tel|text|url|textarea)\*?\s+([^\s\]]+)/i', $brill_cf7_form_content, $matches, PREG_SET_ORDER);

    preg_match_all(
        '/(?:<label[^>]*>\s*(.*?)\s*)?\[(checkbox|date|select|email|hidden|number|radio|tel|text|url|textarea)\*?\s+([^\s\]]+)(.*?)\](?:\s*<\/label>)?/is',
        $brill_cf7_form_content,
        $matches,
        PREG_SET_ORDER
    );
    $bril_selected_label_name = array();
    foreach ($matches as $match) {
        $label_text = trim(wp_strip_all_tags($match[1] ?? '')); // If label exists
        $field_type = $match[2];
        $field_name = $match[3];
        $attributes = $match[4];
    
        // Try to extract placeholder
        preg_match('/placeholder\s+(["\'])(.*?)\1/', $attributes, $placeholder_match);
        $placeholder = $placeholder_match[2] ?? '';
    
        if ($label_text) {
            $bril_selected_label_name[$field_name] = $label_text ?? '';
        } elseif ($placeholder) {
            $bril_selected_label_name[$field_name] = $placeholder ?? '';
        } else {
            $bril_selected_label_name[$field_name] = $field_name ?? '';
        }
    }

    if ($create_sub == 'leads') {
        $required_fields = [
            'lead_email' => 'lead_email (string, email)',
        ];
        $additional_fields = [
            'adm_lvl_1_sn' => 'adm_lvl_1_sn (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_match' => 'auto_match (integer)',
            'country_sn' => 'country_sn (string)',
            'date_added' => 'date_added (string, datetime)',
            'flow_source' => 'flow_source (string)',
            'formname' => 'formname (string)',
            'lat' => 'lat (number)',
            'lead_location' => 'lead_location (string)',
            'lead_message' => 'lead_message (string)',
            'lead_name' => 'lead_name (string)',
            'lead_notes' => 'lead_notes (string)',
            'lead_phone' => 'lead_phone (string)',
            'lead_price' => 'lead_price (number)',
            'lng' => 'lng (number)',
            'location_type' => 'location_type (string)',
            'nelat' => 'nelat (number)',
            'nelng' => 'nelng (number)',
            'origin_ip' => 'origin_ip (string)',
            'revision_timestamp' => 'revision_timestamp (string, datetime)',
            'send_lead_email_notification' => 'send_lead_email_notification (integer)',
            'sub_category_name' => 'sub_category_name(string)',
            'sub_id' => 'sub_id (integer)',
            'sub_sub_category_name' => 'sub_sub_category_name (string)',
            'sub_sub_id' => 'sub_sub_id (integer)',
            'swlat' => 'swlat (number)',
            'swlng' => 'swlng (number)',
            'top_category_name' => 'top_category_name (string)',
            'top_id' => 'top_id (integer)',
            'url_from' => 'url_from (string)',
        ];
    } elseif ($create_sub == 'user') {
        $required_fields = [
            'active' => 'Account Status (2 is active, 1 is deactive)',
            'email' => 'email (string, email)',
        ];
        $additional_fields = [
            'about_me' => 'about_me (string)',
            'address1' => 'address1 (string)',
            'address2' => 'address2 (string)',
            'affiliation' => 'affiliation (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_image_import' => 'auto_image_import (integer)',
            'awards' => 'awards (string)',
            'blog' => 'blog (string, uri)',
            'city' => 'city (string)',
            'company' => 'company (string)',
            'country_code' => 'country_code (string)',
            'country_ln' => 'country_ln (string)',
            'cover_photo' => 'cover_photo (string)',
            'credentials' => 'credentials (string)',
            'cv' => 'cv (string)',
            'experience' => 'experience (integer)',
            'facebook' => 'facebook (string, uri)',
            'facebook_id' => 'facebook_id (string)',
            'featured' => 'featured (integer)',
            'first_name' => 'first_name (string)',
            'google_id' => 'google_id (string)',
            'instagram' => 'instagram (string, uri)',
            'last_login' => 'last_login (string, datetime)',
            'last_name' => 'last_name (string)',
            'lat' => 'lat (number)',
            'linkedin' => 'linkedin (string, uri)',
            'listing_type' => 'listing_type (string)',
            'logo' => 'logo (string)',
            'lon' => 'lon (number)',
            'member_tags' => 'member_tags (string)',
            'modtime' => 'modtime (string, datetime)',
            'nationwide' => 'nationwide (integer)',
            'phone_number' => 'phone_number (string)',
            'pinterest' => 'pinterest (string, uri)',
            'position' => 'position (string)',
            'profession_id' => 'profession_id (integer)',
            'profile_photo' => 'profile_photo (string)',
            'quote' => 'quote (string)',
            'rep_matters' => 'rep_matters (string)',
            'search_description' => 'search_description (string)',
            'send_email_notifications' => 'send_email_notifications (integer)',
            'services' => 'services (string)',
            'signup_date' => 'signup_date (string, datetime)',
            'snapchat' => 'snapchat (string)',
            'state_code' => 'state_code (string)',
            'state_ln' => 'state_ln (string)',
            'twitter' => 'twitter (string, uri)',
            'verified' => 'verified (integer)',
            'website' => 'website (string, uri)',
            'whatsapp' => 'whatsapp (string)',
            'youtube' => 'youtube (string, uri)',
            'zip_code' => 'zip_code (string)',
        ];
    } else {
        $required_fields = [];
        $additional_fields = [];
    }

    // Combine both required and additional fields for the lead fields
    $lead_fields = array_merge($required_fields, $additional_fields);

    if (!empty($saved_mapping)) {
        foreach ($saved_mapping as $form_field => $mapped_lead_field) {
            // Check if it's a custom field not present in $lead_fields already
            if (!isset($lead_fields[$mapped_lead_field])) {
                // If it's not already a predefined lead field, add it as a custom field
                $lead_fields[$mapped_lead_field] = $mapped_lead_field;
            }
        }
    }

    $form_field_names = array_column($matches, 3);

    $brill_custom_combined = [];

    // Collect and structure custom_variables
    foreach ($lead_fields as $value => $label) {
        if (!in_array($value, array_keys($required_fields)) &&
            !in_array($value, array_keys($additional_fields)) &&
            $value !== 'skip') {
            $brill_custom_combined[$value] = $label;
        }
    }

    if (!is_array($brill_get_custom_mapping)) {
        $brill_get_custom_mapping = [];
    }
    // Collect and structure custom_variable_options
    foreach($brill_get_custom_mapping as $form_field => $mapped_field) {
        foreach($mapped_field as $brill_cus_key => $brill_cus_value) {
            if (!isset($required_fields[$brill_cus_key]) &&
                !isset($additional_fields[$brill_cus_key]) &&
                $brill_cus_key !== 'skip') {
                $brill_custom_combined[$brill_cus_key] = $brill_cus_key; 
            }
        }
    }

    // Sort by label
    asort($brill_custom_combined);

    if (!empty($matches)) {
        ob_start();
        ?>
        <div class="brillforms-mapping-wrap">
            <div class="brill-label-wrap">
                <label class="brill-label" id="brillforms_fieldmap_label"><?php echo esc_html__('Map WP Form Fields to Brilliant Directories', 'sync-forms-with-brilliant-directories'); ?></label>
            </div>
            <table class="widefat brillforms-field-map-table">
                <thead>
                    <tr>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Type', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Label', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-mapping-datas"><div class="brill-mapping-data-wrap"><?php echo esc_html__('Map to Field ', 'sync-forms-with-brilliant-directories'); ?> <span id="requiredFieldsCount"></span></div></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($matches as $field): 
                    $form_field_type = $field[2];
                    $form_field_name = $field[3];
                    $selected_value = isset($saved_mapping[$form_field_name]) ? $saved_mapping[$form_field_name] : '';
                    $form_label = isset($bril_selected_label_name[$form_field_name]) ? $bril_selected_label_name[$form_field_name] : '—'; 
                    ?>
                    <tr>
                    <td><?php echo esc_html($form_field_type); ?></td>
                    <td><?php echo esc_html($form_label); ?></td>
                        <td>
                            <?php
                                // Default to "skip" if nothing is mapped yet
                                if (empty($selected_value)) {
                                    $selected_value = 'skip';
                                }
                            ?>
                            <select class="brillforms_lead_fields brill-lead-fields" name="brildir_sfwbd_field_map[<?php echo esc_attr($form_field_name); ?>]" >
                                <option value=""><?php esc_html_e('-- Select --', 'sync-forms-with-brilliant-directories'); ?></option>
                                <option value="skip" <?php selected($selected_value, 'skip'); ?>>
                                    <?php esc_html_e('Skip Field - Do Not Map', 'sync-forms-with-brilliant-directories'); ?>
                                </option>
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                </optgroup>
                                <!-- Grouped options by required and additional fields -->
                                 <?php if (!empty($required_fields)) : ?> 
                                    <optgroup label="Required Mapping Fields">
                                        <?php foreach ($required_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <?php if (!empty($additional_fields)) : ?>
                                    <optgroup label="Additional Fields">
                                        <?php foreach ($additional_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                            </select>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="brill-label-wrap">
            <span class="brill-label" id="brillforms_custom_fields_label"><?php echo esc_html__('Additional Data Sent with Every Form Submission', 'sync-forms-with-brilliant-directories'); ?></span>
        </div>

        <?php if (!empty($brill_get_custom_mapping)) : 
            ?>
            <div id="additional-mapping-fields-container">
                <?php foreach ($brill_get_custom_mapping as $form_field => $mapped_field) :
                    foreach ($mapped_field as $brill_cus_key => $brill_cus_value) : 
                ?>
                    <div class="brill-additional-field-row" data-index="<?php echo esc_attr($brill_cus_key); ?>">
                        <div class="brill-additional-field-delete">
                            <span class="brill-del-custom-field" data-index="<?php echo esc_attr($brill_cus_key); ?>"><span aria-hidden="true" class="dashicons dashicons-trash"></span></span>
                        </div>
                        <div class="brill-additional-field-select">
                            <select class="brillforms_lead_fields" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][map_to]" style="width: 250px;">
                                <option value=""><?php esc_html_e('Select Variable to Map', 'sync-forms-with-brilliant-directories'); ?></option>
                                <!-- Custom Fields Optgroup -->
                                // Check if there are custom variables to display
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <!-- Required Fields Optgroup -->
                                <optgroup label="Required Mapping Fields">
                                    <?php foreach ($required_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>

                                <!-- Additional Fields Optgroup -->
                                <optgroup label="Additional Fields">
                                    <?php foreach ($additional_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>
                            </select>
                        </div>
                        <div class="brill-additional-field-input">
                            <input type="text" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][name]" value="<?php echo esc_attr($brill_cus_value); ?>" placeholder="Enter Value to Pass" required />
                        </div>
                    </div>
                <?php endforeach;
                endforeach;
                 ?>
            </div>
        <?php else : ?>
            <div id="additional-mapping-fields-container"></div>
        <?php endif; ?>
        <!-- Button to add new mapping -->
        <button type="button" id="add-additional-mapping-field" class="button button-secondary" style="margin-top: 10px;">
            <?php esc_html_e('+ Add Data Field', 'sync-forms-with-brilliant-directories'); ?>
        </button>
        <?php
        return ob_get_clean();
    } else {
        return wp_kses_post('<p><em>' . esc_html__('No supported fields found in this form.', 'sync-forms-with-brilliant-directories') . '</em></p>');
    }
}


function Brildir_Sfwbd_Get_WPForms_fields($form_id, $create_sub, $saved_mapping = [], $brill_get_custom_mapping = []) 
{
    ob_start();
    $form_post = get_post($form_id);
    if (!$form_post) {
        return '<p><em>' . esc_html__('Form not found.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    $form_content = json_decode($form_post->post_content, true);
    if (!isset($form_content['fields']) || !is_array($form_content['fields'])) {
        return '<p><em>' . esc_html__('No fields found in this WPForm.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    // Allowed standard WPForms field types
    $Wpforms_allowed_types = ['text', 'textarea', 'email', 'name', 'phone', 'address', 'number', 'checkbox', 'radio', 'select', 'date', 'time'];

    $wpfields = [];

    foreach ($form_content['fields'] as $field) {
        $type  = $field['type'] ?? 'text';
        $id    = $field['id'] ?? '';
        $label = $field['label'] ?? $id;

        // Skip non-standard or disallowed field types
        if ($id && in_array($type, $Wpforms_allowed_types, true)) {
            $wpfields[] = [
                'type'  => $type,
                'name'  => $id,    // WPForms uses field ID, not "name"
                'label' => $label
            ];
        }
    }

    if ($create_sub == 'leads') {
        $required_fields = [
            'lead_email' => 'lead_email (string, email)',
        ];
        $additional_fields = [
            'adm_lvl_1_sn' => 'adm_lvl_1_sn (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_match' => 'auto_match (integer)',
            'country_sn' => 'country_sn (string)',
            'date_added' => 'date_added (string, datetime)',
            'flow_source' => 'flow_source (string)',
            'formname' => 'formname (string)',
            'lat' => 'lat (number)',
            'lead_location' => 'lead_location (string)',
            'lead_message' => 'lead_message (string)',
            'lead_name' => 'lead_name (string)',
            'lead_notes' => 'lead_notes (string)',
            'lead_phone' => 'lead_phone (string)',
            'lead_price' => 'lead_price (number)',
            'lng' => 'lng (number)',
            'location_type' => 'location_type (string)',
            'nelat' => 'nelat (number)',
            'nelng' => 'nelng (number)',
            'origin_ip' => 'origin_ip (string)',
            'revision_timestamp' => 'revision_timestamp (string, datetime)',
            'send_lead_email_notification' => 'send_lead_email_notification (integer)',
            'sub_category_name' => 'sub_category_name(string)',
            'sub_id' => 'sub_id (integer)',
            'sub_sub_category_name' => 'sub_sub_category_name (string)',
            'sub_sub_id' => 'sub_sub_id (integer)',
            'swlat' => 'swlat (number)',
            'swlng' => 'swlng (number)',
            'top_category_name' => 'top_category_name (string)',
            'top_id' => 'top_id (integer)',
            'url_from' => 'url_from (string)',
        ];
    } elseif ($create_sub == 'user') {
        $required_fields = [
            'active' => 'Account Status (2 is active, 1 is deactive)',
            'email' => 'email (string, email)',
        ];
        $additional_fields = [
            'about_me' => 'about_me (string)',
            'address1' => 'address1 (string)',
            'address2' => 'address2 (string)',
            'affiliation' => 'affiliation (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_image_import' => 'auto_image_import (integer)',
            'awards' => 'awards (string)',
            'blog' => 'blog (string, uri)',
            'city' => 'city (string)',
            'company' => 'company (string)',
            'country_code' => 'country_code (string)',
            'country_ln' => 'country_ln (string)',
            'cover_photo' => 'cover_photo (string)',
            'credentials' => 'credentials (string)',
            'cv' => 'cv (string)',
            'experience' => 'experience (integer)',
            'facebook' => 'facebook (string, uri)',
            'facebook_id' => 'facebook_id (string)',
            'featured' => 'featured (integer)',
            'first_name' => 'first_name (string)',
            'google_id' => 'google_id (string)',
            'instagram' => 'instagram (string, uri)',
            'last_login' => 'last_login (string, datetime)',
            'last_name' => 'last_name (string)',
            'lat' => 'lat (number)',
            'linkedin' => 'linkedin (string, uri)',
            'listing_type' => 'listing_type (string)',
            'logo' => 'logo (string)',
            'lon' => 'lon (number)',
            'member_tags' => 'member_tags (string)',
            'modtime' => 'modtime (string, datetime)',
            'nationwide' => 'nationwide (integer)',
            'phone_number' => 'phone_number (string)',
            'pinterest' => 'pinterest (string, uri)',
            'position' => 'position (string)',
            'profession_id' => 'profession_id (integer)',
            'profile_photo' => 'profile_photo (string)',
            'quote' => 'quote (string)',
            'rep_matters' => 'rep_matters (string)',
            'search_description' => 'search_description (string)',
            'send_email_notifications' => 'send_email_notifications (integer)',
            'services' => 'services (string)',
            'signup_date' => 'signup_date (string, datetime)',
            'snapchat' => 'snapchat (string)',
            'state_code' => 'state_code (string)',
            'state_ln' => 'state_ln (string)',
            'twitter' => 'twitter (string, uri)',
            'verified' => 'verified (integer)',
            'website' => 'website (string, uri)',
            'whatsapp' => 'whatsapp (string)',
            'youtube' => 'youtube (string, uri)',
            'zip_code' => 'zip_code (string)',
        ];
    } else {
        $required_fields = [];
        $additional_fields = [];
    }

    // Combine both required and additional fields for the lead fields
    $lead_fields = array_merge($required_fields, $additional_fields);

    if (!empty($saved_mapping)) {
        foreach ($saved_mapping as $form_field => $mapped_lead_field) {
            // Check if it's a custom field not present in $lead_fields already
            if (!isset($lead_fields[$mapped_lead_field])) {
                // If it's not already a predefined lead field, add it as a custom field
                $lead_fields[$mapped_lead_field] = $mapped_lead_field;
            }
        }
    }


    $brill_custom_combined = [];
    // Collect and structure custom_variables
    foreach ($lead_fields as $value => $label) {
        if (!in_array($value, array_keys($required_fields)) &&
            !in_array($value, array_keys($additional_fields)) &&
            $value !== 'skip') {
            $brill_custom_combined[$value] = $label;
        }
    }

    if (!is_array($brill_get_custom_mapping)) {
        $brill_get_custom_mapping = [];
    }
    // Collect and structure custom_variable_options
    foreach($brill_get_custom_mapping as $form_field => $mapped_field) {
        foreach($mapped_field as $brill_cus_key => $brill_cus_value) {
            if (!isset($required_fields[$brill_cus_key]) &&
                !isset($additional_fields[$brill_cus_key]) &&
                $brill_cus_key !== 'skip') {
                $brill_custom_combined[$brill_cus_key] = $brill_cus_key; 
            }
        }
    }

    // Sort by label
    asort($brill_custom_combined);

    if (!empty($wpfields)) {
        ob_start();
        ?>
        <div class="brillforms-mapping-wrap">
            <div class="brill-label-wrap">
                <label class="brill-label" id="brillforms_fieldmap_label"><?php echo esc_html__('Map WP Form Fields to Brilliant Directories', 'sync-forms-with-brilliant-directories'); ?></label>
            </div>
            <table class="widefat brillforms-field-map-table">
                <thead>
                    <tr>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Type', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Label', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-mapping-datas"><div class="brill-mapping-data-wrap"><?php echo esc_html__('Map to Field ', 'sync-forms-with-brilliant-directories'); ?> <span id="requiredFieldsCount"></span></div></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($wpfields as $field): 
                    $selected_value = $saved_mapping[$field['name']] ?? 'skip';
                    ?>
                    <tr>
                        <td><?php echo esc_html($field['type']); ?></td>
                        <td><?php echo esc_html($field['label']); ?></td>
                        <td>
                            <?php
                                // Default to "skip" if nothing is mapped yet
                                if (empty($selected_value)) {
                                    $selected_value = 'skip';
                                }
                            ?>
                            <select class="brillforms_lead_fields brill-lead-fields" name="brildir_sfwbd_field_map[<?php echo esc_attr($field['name']); ?>]" >
                                <option value=""><?php esc_html_e('-- Select --', 'sync-forms-with-brilliant-directories'); ?></option>
                                <option value="skip" <?php selected($selected_value, 'skip'); ?>>
                                    <?php esc_html_e('Skip Field - Do Not Map', 'sync-forms-with-brilliant-directories'); ?>
                                </option>
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                </optgroup>
                                <!-- Grouped options by required and additional fields -->
                                 <?php if (!empty($required_fields)) : ?> 
                                    <optgroup label="Required Mapping Fields">
                                        <?php foreach ($required_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <?php if (!empty($additional_fields)) : ?>
                                    <optgroup label="Additional Fields">
                                        <?php foreach ($additional_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                            </select>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="brill-label-wrap">
            <span class="brill-label" id="brillforms_custom_fields_label"><?php echo esc_html__('Additional Data Sent with Every Form Submission', 'sync-forms-with-brilliant-directories'); ?></span>
        </div>

        <?php if (!empty($brill_get_custom_mapping)) : 
            ?>
            <div id="additional-mapping-fields-container">
                <?php foreach ($brill_get_custom_mapping as $form_field => $mapped_field) :
                    foreach ($mapped_field as $brill_cus_key => $brill_cus_value) : 
                ?>
                    <div class="brill-additional-field-row" data-index="<?php echo esc_attr($brill_cus_key); ?>">
                        <div class="brill-additional-field-delete">
                            <span class="brill-del-custom-field" data-index="<?php echo esc_attr($brill_cus_key); ?>"><span aria-hidden="true" class="dashicons dashicons-trash"></span></span>
                        </div>
                        <div class="brill-additional-field-select">
                            <select class="brillforms_lead_fields" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][map_to]" style="width: 250px;">
                                <option value=""><?php esc_html_e('Select Variable to Map', 'sync-forms-with-brilliant-directories'); ?></option>
                                <!-- Custom Fields Optgroup -->
                                // Check if there are custom variables to display
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <!-- Required Fields Optgroup -->
                                <optgroup label="Required Mapping Fields">
                                    <?php foreach ($required_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>

                                <!-- Additional Fields Optgroup -->
                                <optgroup label="Additional Fields">
                                    <?php foreach ($additional_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>
                            </select>
                        </div>
                        <div class="brill-additional-field-input">
                            <input type="text" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][name]" value="<?php echo esc_attr($brill_cus_value); ?>" placeholder="Enter Value to Pass" required />
                        </div>
                    </div>
                <?php endforeach;
                endforeach;
                 ?>
            </div>
        <?php else : ?>
            <div id="additional-mapping-fields-container"></div>
        <?php endif; ?>
        <!-- Button to add new mapping -->
        <button type="button" id="add-additional-mapping-field" class="button button-secondary" style="margin-top: 10px;">
            <?php esc_html_e('+ Add Data Field', 'sync-forms-with-brilliant-directories'); ?>
        </button>
        <?php
        return ob_get_clean();
    } else {
        return wp_kses_post('<p><em>' . esc_html__('No supported fields found in this form.', 'sync-forms-with-brilliant-directories') . '</em></p>');
    }
}


function Brildir_Sfwbd_Get_NinjaForms_fields($form_id, $create_sub, $saved_mapping = [], $brill_get_custom_mapping = []) {
    ob_start();

    if (!function_exists('Ninja_Forms')) {
        return '<p><em>' . esc_html__('Ninja Forms is not active.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    // Try to get form using Ninja Forms object-oriented API
    try {
        $form = Ninja_Forms()->form($form_id);
        if (!$form) {
            return '<p><em>' . esc_html__('Form not found.', 'sync-forms-with-brilliant-directories') . '</em></p>';
        }

        $fields = $form->get_fields();
    } catch (Throwable $e) {
        return '<p><em>' . esc_html__('Unable to load fields from this Ninja Form.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    if (empty($fields)) {
        return '<p><em>' . esc_html__('No fields found in this Ninja Form.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    // Supported field types (customize if needed)
    $ninja_allowed_types = ['textbox', 'textarea', 'email', 'firstname', 'lastname', 'phone', 'number', 'address', 'city', 'liststate', 'zip', 'checkbox', 'radio', 'list', 'date', 'select', 'listselect', 'listcheckbox', 'listradio', 'listmultiselect', 'listcountry', 'hidden'];

    $ninja_fields = [];
    foreach ($fields as $field) {
        $type  = $field->get_setting('type');
        $key   = $field->get_id(); // Field ID
        $label = $field->get_setting('label') ?: 'Field ' . $key;

        if ($type && in_array($type, $ninja_allowed_types, true)) {
            $ninja_fields[] = [
                'type'  => $type,
                'name'  => $key,
                'label' => $label
            ];
        }
    }

    // Define required & additional fields
    if ($create_sub == 'leads') {
        $required_fields = [
            'lead_email' => 'lead_email (string, email)',
        ];
        $additional_fields = [
            'adm_lvl_1_sn' => 'adm_lvl_1_sn (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_match' => 'auto_match (integer)',
            'country_sn' => 'country_sn (string)',
            'date_added' => 'date_added (string, datetime)',
            'flow_source' => 'flow_source (string)',
            'formname' => 'formname (string)',
            'lat' => 'lat (number)',
            'lead_location' => 'lead_location (string)',
            'lead_message' => 'lead_message (string)',
            'lead_name' => 'lead_name (string)',
            'lead_notes' => 'lead_notes (string)',
            'lead_phone' => 'lead_phone (string)',
            'lead_price' => 'lead_price (number)',
            'lng' => 'lng (number)',
            'location_type' => 'location_type (string)',
            'nelat' => 'nelat (number)',
            'nelng' => 'nelng (number)',
            'origin_ip' => 'origin_ip (string)',
            'revision_timestamp' => 'revision_timestamp (string, datetime)',
            'send_lead_email_notification' => 'send_lead_email_notification (integer)',
            'sub_category_name' => 'sub_category_name(string)',
            'sub_id' => 'sub_id (integer)',
            'sub_sub_category_name' => 'sub_sub_category_name (string)',
            'sub_sub_id' => 'sub_sub_id (integer)',
            'swlat' => 'swlat (number)',
            'swlng' => 'swlng (number)',
            'top_category_name' => 'top_category_name (string)',
            'top_id' => 'top_id (integer)',
            'url_from' => 'url_from (string)',
        ];
    } elseif ($create_sub == 'user') {
        $required_fields = [
            'active' => 'Account Status (2 is active, 1 is deactive)',
            'email' => 'email (string, email)',
        ];
        $additional_fields = [
            'about_me' => 'about_me (string)',
            'address1' => 'address1 (string)',
            'address2' => 'address2 (string)',
            'affiliation' => 'affiliation (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_image_import' => 'auto_image_import (integer)',
            'awards' => 'awards (string)',
            'blog' => 'blog (string, uri)',
            'city' => 'city (string)',
            'company' => 'company (string)',
            'country_code' => 'country_code (string)',
            'country_ln' => 'country_ln (string)',
            'cover_photo' => 'cover_photo (string)',
            'credentials' => 'credentials (string)',
            'cv' => 'cv (string)',
            'experience' => 'experience (integer)',
            'facebook' => 'facebook (string, uri)',
            'facebook_id' => 'facebook_id (string)',
            'featured' => 'featured (integer)',
            'first_name' => 'first_name (string)',
            'google_id' => 'google_id (string)',
            'instagram' => 'instagram (string, uri)',
            'last_login' => 'last_login (string, datetime)',
            'last_name' => 'last_name (string)',
            'lat' => 'lat (number)',
            'linkedin' => 'linkedin (string, uri)',
            'listing_type' => 'listing_type (string)',
            'logo' => 'logo (string)',
            'lon' => 'lon (number)',
            'member_tags' => 'member_tags (string)',
            'modtime' => 'modtime (string, datetime)',
            'nationwide' => 'nationwide (integer)',
            'phone_number' => 'phone_number (string)',
            'pinterest' => 'pinterest (string, uri)',
            'position' => 'position (string)',
            'profession_id' => 'profession_id (integer)',
            'profile_photo' => 'profile_photo (string)',
            'quote' => 'quote (string)',
            'rep_matters' => 'rep_matters (string)',
            'search_description' => 'search_description (string)',
            'send_email_notifications' => 'send_email_notifications (integer)',
            'services' => 'services (string)',
            'signup_date' => 'signup_date (string, datetime)',
            'snapchat' => 'snapchat (string)',
            'state_code' => 'state_code (string)',
            'state_ln' => 'state_ln (string)',
            'twitter' => 'twitter (string, uri)',
            'verified' => 'verified (integer)',
            'website' => 'website (string, uri)',
            'whatsapp' => 'whatsapp (string)',
            'youtube' => 'youtube (string, uri)',
            'zip_code' => 'zip_code (string)',
        ];
    } else {
        $required_fields = [];
        $additional_fields = [];
    }

    // Add custom fields from saved mapping
    $lead_fields = array_merge($required_fields, $additional_fields);

    if (!empty($saved_mapping)) {
        foreach ($saved_mapping as $form_field => $mapped_lead_field) {
            if (!isset($lead_fields[$mapped_lead_field])) {
                $lead_fields[$mapped_lead_field] = $mapped_lead_field;
            }
        }
    }

    $brill_custom_combined = [];
    foreach ($lead_fields as $value => $label) {
        if (!isset($required_fields[$value]) &&
            !isset($additional_fields[$value]) &&
            $value !== 'skip') {
            $brill_custom_combined[$value] = $label;
        }
    }

    if (!is_array($brill_get_custom_mapping)) {
        $brill_get_custom_mapping = [];
    }

    foreach ($brill_get_custom_mapping as $form_field => $mapped_field) {
        foreach ($mapped_field as $brill_cus_key => $brill_cus_value) {
            if (!isset($required_fields[$brill_cus_key]) &&
                !isset($additional_fields[$brill_cus_key]) &&
                $brill_cus_key !== 'skip') {
                $brill_custom_combined[$brill_cus_key] = $brill_cus_key;
            }
        }
    }

    asort($brill_custom_combined);

    if (!empty($ninja_fields)) {
        ob_start();
        ?>
        <div class="brillforms-mapping-wrap">
            <div class="brill-label-wrap">
                <label class="brill-label" id="brillforms_fieldmap_label"><?php echo esc_html__('Map WP Form Fields to Brilliant Directories', 'sync-forms-with-brilliant-directories'); ?></label>
            </div>
            <table class="widefat brillforms-field-map-table">
                <thead>
                     <tr>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Type', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Label', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-mapping-datas"><div class="brill-mapping-data-wrap"><?php echo esc_html__('Map to Field ', 'sync-forms-with-brilliant-directories'); ?> <span id="requiredFieldsCount"></span></div></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($ninja_fields as $field):
                    $selected_value = $saved_mapping[$field['name']] ?? 'skip'; ?>
                    <tr>
                        <td><?php echo esc_html($field['type']); ?></td>
                        <td><?php echo esc_html($field['label']); ?></td>
                        <td>
                            <select class="brillforms_lead_fields brill-lead-fields" name="brildir_sfwbd_field_map[<?php echo esc_attr($field['name']); ?>]" >
                                <option value=""><?php esc_html_e('-- Select --', 'sync-forms-with-brilliant-directories'); ?></option>
                                <option value="skip" <?php selected($selected_value, 'skip'); ?>>
                                    <?php esc_html_e('Skip Field - Do Not Map', 'sync-forms-with-brilliant-directories'); ?>
                                </option>
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                </optgroup>
                                <!-- Grouped options by required and additional fields -->
                                 <?php if (!empty($required_fields)) : ?> 
                                    <optgroup label="Required Mapping Fields">
                                        <?php foreach ($required_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <?php if (!empty($additional_fields)) : ?>
                                    <optgroup label="Additional Fields">
                                        <?php foreach ($additional_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                            </select>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="brill-label-wrap">
            <span class="brill-label" id="brillforms_custom_fields_label"><?php echo esc_html__('Additional Data Sent with Every Form Submission', 'sync-forms-with-brilliant-directories'); ?></span>
        </div>

        <?php if (!empty($brill_get_custom_mapping)) : 
            ?>
            <div id="additional-mapping-fields-container">
                <?php foreach ($brill_get_custom_mapping as $form_field => $mapped_field) :
                    foreach ($mapped_field as $brill_cus_key => $brill_cus_value) : 
                ?>
                    <div class="brill-additional-field-row" data-index="<?php echo esc_attr($brill_cus_key); ?>">
                        <div class="brill-additional-field-delete">
                            <span class="brill-del-custom-field" data-index="<?php echo esc_attr($brill_cus_key); ?>"><span aria-hidden="true" class="dashicons dashicons-trash"></span></span>
                        </div>
                        <div class="brill-additional-field-select">
                            <select class="brillforms_lead_fields" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][map_to]" style="width: 250px;">
                                <option value=""><?php esc_html_e('Select Variable to Map', 'sync-forms-with-brilliant-directories'); ?></option>
                                <!-- Custom Fields Optgroup -->
                                // Check if there are custom variables to display
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <!-- Required Fields Optgroup -->
                                <optgroup label="Required Mapping Fields">
                                    <?php foreach ($required_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>

                                <!-- Additional Fields Optgroup -->
                                <optgroup label="Additional Fields">
                                    <?php foreach ($additional_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>
                            </select>
                        </div>
                        <div class="brill-additional-field-input">
                            <input type="text" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][name]" value="<?php echo esc_attr($brill_cus_value); ?>" placeholder="Enter Value to Pass" required />
                        </div>
                    </div>
                <?php endforeach;
                endforeach;
                 ?>
            </div>
        <?php else : ?>
            <div id="additional-mapping-fields-container"></div>
        <?php endif; ?>
        <!-- Button to add new mapping -->
        <button type="button" id="add-additional-mapping-field" class="button button-secondary" style="margin-top: 10px;">
            <?php esc_html_e('+ Add Data Field', 'sync-forms-with-brilliant-directories'); ?>
        </button>
        <?php
        return ob_get_clean();
    }

    return '<p><em>' . esc_html__('No supported fields found in this form.', 'sync-forms-with-brilliant-directories') . '</em></p>';
}

function Brildir_Sfwbd_Get_GF_fields($form_id, $create_sub, $saved_mapping = [], $brill_get_custom_mapping = [])
{
    ob_start();

    $form = GFAPI::get_form($form_id);
    if (!$form || empty($form['fields'])) {
        return '<p><em>' . esc_html__('Form not found or has no fields.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    // Allowed standard Gravity Forms field types
    $gf_allowed_types = ['text', 'textarea', 'email', 'name', 'phone', 'address', 'number', 'checkbox', 'radio', 'select', 'date', 'time', 'hidden', 'website', 'list', 'multiselect'];


    $multi_input_types = ['name', 'address', 'checkbox']; 
    $gfields = [];

    foreach ($form['fields'] as $field) {
        if (!is_object($field)) {
            continue;
        }

        $type  = $field->get_input_type(); // More accurate than $field->type
        $id    = $field->id;
        $label = $field->label ?? $id;

        if (in_array($type, $gf_allowed_types, true)) {
            if (in_array($type, $multi_input_types, true) && !empty($field->inputs) && is_array($field->inputs)) {
                // Handle multi-input fields (name, address, time)
                foreach ($field->inputs as $input) {
                    if (!isset($input['isHidden']) || !$input['isHidden']) {
                        $gfields[] = [
                            'type'  => $type,
                            'name'  => $input['id'], // e.g., "1.3"
                            'label' => $label . ' - ' . $input['label']
                        ];
                    }
                }
            } else {
                // Single input field
                $gfields[] = [
                    'type'  => $type,
                    'name'  => (string) $id,
                    'label' => $label
                ];
            }
        }
    }

    // Define required & additional fields
    if ($create_sub == 'leads') {
        $required_fields = [
            'lead_email' => 'lead_email (string, email)',
        ];
        $additional_fields = [
            'adm_lvl_1_sn' => 'adm_lvl_1_sn (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_match' => 'auto_match (integer)',
            'country_sn' => 'country_sn (string)',
            'date_added' => 'date_added (string, datetime)',
            'flow_source' => 'flow_source (string)',
            'formname' => 'formname (string)',
            'lat' => 'lat (number)',
            'lead_location' => 'lead_location (string)',
            'lead_message' => 'lead_message (string)',
            'lead_name' => 'lead_name (string)',
            'lead_notes' => 'lead_notes (string)',
            'lead_phone' => 'lead_phone (string)',
            'lead_price' => 'lead_price (number)',
            'lng' => 'lng (number)',
            'location_type' => 'location_type (string)',
            'nelat' => 'nelat (number)',
            'nelng' => 'nelng (number)',
            'origin_ip' => 'origin_ip (string)',
            'revision_timestamp' => 'revision_timestamp (string, datetime)',
            'send_lead_email_notification' => 'send_lead_email_notification (integer)',
            'sub_category_name' => 'sub_category_name(string)',
            'sub_id' => 'sub_id (integer)',
            'sub_sub_category_name' => 'sub_sub_category_name (string)',
            'sub_sub_id' => 'sub_sub_id (integer)',
            'swlat' => 'swlat (number)',
            'swlng' => 'swlng (number)',
            'top_category_name' => 'top_category_name (string)',
            'top_id' => 'top_id (integer)',
            'url_from' => 'url_from (string)',
        ];
    } elseif ($create_sub == 'user') {
        $required_fields = [
            'active' => 'Account Status (2 is active, 1 is deactive)',
            'email' => 'email (string, email)',
        ];
        $additional_fields = [
            'about_me' => 'about_me (string)',
            'address1' => 'address1 (string)',
            'address2' => 'address2 (string)',
            'affiliation' => 'affiliation (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_image_import' => 'auto_image_import (integer)',
            'awards' => 'awards (string)',
            'blog' => 'blog (string, uri)',
            'city' => 'city (string)',
            'company' => 'company (string)',
            'country_code' => 'country_code (string)',
            'country_ln' => 'country_ln (string)',
            'cover_photo' => 'cover_photo (string)',
            'credentials' => 'credentials (string)',
            'cv' => 'cv (string)',
            'experience' => 'experience (integer)',
            'facebook' => 'facebook (string, uri)',
            'facebook_id' => 'facebook_id (string)',
            'featured' => 'featured (integer)',
            'first_name' => 'first_name (string)',
            'google_id' => 'google_id (string)',
            'instagram' => 'instagram (string, uri)',
            'last_login' => 'last_login (string, datetime)',
            'last_name' => 'last_name (string)',
            'lat' => 'lat (number)',
            'linkedin' => 'linkedin (string, uri)',
            'listing_type' => 'listing_type (string)',
            'logo' => 'logo (string)',
            'lon' => 'lon (number)',
            'member_tags' => 'member_tags (string)',
            'modtime' => 'modtime (string, datetime)',
            'nationwide' => 'nationwide (integer)',
            'phone_number' => 'phone_number (string)',
            'pinterest' => 'pinterest (string, uri)',
            'position' => 'position (string)',
            'profession_id' => 'profession_id (integer)',
            'profile_photo' => 'profile_photo (string)',
            'quote' => 'quote (string)',
            'rep_matters' => 'rep_matters (string)',
            'search_description' => 'search_description (string)',
            'send_email_notifications' => 'send_email_notifications (integer)',
            'services' => 'services (string)',
            'signup_date' => 'signup_date (string, datetime)',
            'snapchat' => 'snapchat (string)',
            'state_code' => 'state_code (string)',
            'state_ln' => 'state_ln (string)',
            'twitter' => 'twitter (string, uri)',
            'verified' => 'verified (integer)',
            'website' => 'website (string, uri)',
            'whatsapp' => 'whatsapp (string)',
            'youtube' => 'youtube (string, uri)',
            'zip_code' => 'zip_code (string)',
        ];
    } else {
        $required_fields = [];
        $additional_fields = [];
    }

    // Merge saved mapping fields
    $lead_fields = array_merge($required_fields, $additional_fields);

    if (!empty($saved_mapping)) {
        foreach ($saved_mapping as $form_field => $mapped_lead_field) {
            if (!isset($lead_fields[$mapped_lead_field])) {
                $lead_fields[$mapped_lead_field] = $mapped_lead_field;
            }
        }
    }

    // Build custom variables
    $brill_custom_combined = [];
    foreach ($lead_fields as $value => $label) {
        if (!isset($required_fields[$value]) && !isset($additional_fields[$value]) && $value !== 'skip') {
            $brill_custom_combined[$value] = $label;
        }
    }

    if (!is_array($brill_get_custom_mapping)) {
        $brill_get_custom_mapping = [];
    }

    foreach ($brill_get_custom_mapping as $form_field => $mapped_field) {
        foreach ($mapped_field as $brill_cus_key => $brill_cus_value) {
            if (!isset($required_fields[$brill_cus_key]) &&
                !isset($additional_fields[$brill_cus_key]) &&
                $brill_cus_key !== 'skip') {
                $brill_custom_combined[$brill_cus_key] = $brill_cus_key;
            }
        }
    }

    asort($brill_custom_combined);

    // Render field mapping interface
    if (!empty($gfields)) {
        ob_start();
        ?>
        <div class="brillforms-mapping-wrap">
            <div class="brill-label-wrap">
                <label class="brill-label" id="brillforms_fieldmap_label"><?php echo esc_html__('Map WP Form Fields to Brilliant Directories', 'sync-forms-with-brilliant-directories'); ?></label>
            </div>
            <table class="widefat brillforms-field-map-table">
                <thead>
                     <tr>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Type', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Label', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-mapping-datas"><div class="brill-mapping-data-wrap"><?php echo esc_html__('Map to Field ', 'sync-forms-with-brilliant-directories'); ?> <span id="requiredFieldsCount"></span></div></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($gfields as $field):
                    $form_field_id = (string) $field['name'];
                    $selected_value = $saved_mapping[$form_field_id] ?? 'skip'; ?>
                    <tr>
                        <td><?php echo esc_html($field['type']); ?></td>
                        <td><?php echo esc_html($field['label']); ?></td>
                        <td>
                            <select class="brillforms_lead_fields brill-lead-fields" name="brildir_sfwbd_field_map[<?php echo esc_attr($field['name']); ?>]" >
                                <option value=""><?php esc_html_e('-- Select --', 'sync-forms-with-brilliant-directories'); ?></option>
                                <option value="skip" <?php selected($selected_value, 'skip'); ?>>
                                    <?php esc_html_e('Skip Field - Do Not Map', 'sync-forms-with-brilliant-directories'); ?>
                                </option>
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                </optgroup>
                                <!-- Grouped options by required and additional fields -->
                                 <?php if (!empty($required_fields)) : ?> 
                                    <optgroup label="Required Mapping Fields">
                                        <?php foreach ($required_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <?php if (!empty($additional_fields)) : ?>
                                    <optgroup label="Additional Fields">
                                        <?php foreach ($additional_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                            </select>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="brill-label-wrap">
            <span class="brill-label" id="brillforms_custom_fields_label"><?php echo esc_html__('Additional Data Sent with Every Form Submission', 'sync-forms-with-brilliant-directories'); ?></span>
        </div>

        <?php if (!empty($brill_get_custom_mapping)) : 
            ?>
            <div id="additional-mapping-fields-container">
                <?php foreach ($brill_get_custom_mapping as $form_field => $mapped_field) :
                    foreach ($mapped_field as $brill_cus_key => $brill_cus_value) : 
                ?>
                    <div class="brill-additional-field-row" data-index="<?php echo esc_attr($brill_cus_key); ?>">
                        <div class="brill-additional-field-delete">
                            <span class="brill-del-custom-field" data-index="<?php echo esc_attr($brill_cus_key); ?>"><span aria-hidden="true" class="dashicons dashicons-trash"></span></span>
                        </div>
                        <div class="brill-additional-field-select">
                            <select class="brillforms_lead_fields" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][map_to]" style="width: 250px;">
                                <option value=""><?php esc_html_e('Select Variable to Map', 'sync-forms-with-brilliant-directories'); ?></option>
                                <!-- Custom Fields Optgroup -->
                                // Check if there are custom variables to display
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <!-- Required Fields Optgroup -->
                                <optgroup label="Required Mapping Fields">
                                    <?php foreach ($required_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>

                                <!-- Additional Fields Optgroup -->
                                <optgroup label="Additional Fields">
                                    <?php foreach ($additional_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>
                            </select>
                        </div>
                        <div class="brill-additional-field-input">
                            <input type="text" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][name]" value="<?php echo esc_attr($brill_cus_value); ?>" placeholder="Enter Value to Pass" required />
                        </div>
                    </div>
                <?php endforeach;
                endforeach;
                 ?>
            </div>
        <?php else : ?>
            <div id="additional-mapping-fields-container"></div>
        <?php endif; ?>
        <!-- Button to add new mapping -->
        <button type="button" id="add-additional-mapping-field" class="button button-secondary" style="margin-top: 10px;">
            <?php esc_html_e('+ Add Data Field', 'sync-forms-with-brilliant-directories'); ?>
        </button>
        <?php
        return ob_get_clean();
    }

    return '<p><em>' . esc_html__('No supported fields found in this Gravity Form.', 'sync-forms-with-brilliant-directories') . '</em></p>';
}


function Brildir_Sfwbd_Get_elementor_fields($form_id, $create_sub, $saved_mapping = [], $brill_get_custom_mapping = [])
{
    ob_start();

    if (strpos($form_id, ':') === false) {
        return '<p><em>' . esc_html__('Invalid Elementor form ID format.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    // Split form_id into post ID and target form name
    [$post_id, $target_form_name_raw] = explode(':', $form_id, 2);
    $post_id = (int) $post_id;

    // Normalize form name: replace dashes with spaces, lowercase if needed
    // $target_form_name = str_replace('-', ' ', $target_form_name_raw);

    $target_form_name = $target_form_name_raw;

    $post = get_post($post_id);
    if (!$post) {
        return '<p><em>' . esc_html__('Elementor post not found.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    $elementor_data = get_post_meta($post_id, '_elementor_data', true);
    $elements = json_decode($elementor_data, true);

    if (!is_array($elements)) {
        return '<p><em>' . esc_html__('Invalid Elementor content data.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    // Recursive function to find the form widget by form_name
    function Brildir_Sfwbd_Find_Form_By_name($elements, $target_form_name, &$found_form) {
        foreach ($elements as $element) {
            if (
                isset($element['widgetType'], $element['settings']['form_name']) &&
                $element['widgetType'] === 'form' &&
                strcasecmp($element['settings']['form_name'], $target_form_name) === 0
            ) {
                $found_form = $element;
                return;
            }
            if (!empty($element['elements']) && is_array($element['elements'])) {
                Brildir_Sfwbd_Find_Form_By_name($element['elements'], $target_form_name, $found_form);
                if ($found_form !== null) {
                    return; // Stop searching once found
                }
            }
        }
    }

    $target_form_widget = null;
    Brildir_Sfwbd_Find_Form_By_name($elements, $target_form_name, $target_form_widget);

    if (!$target_form_widget || empty($target_form_widget['settings']['form_fields'])) {
        return '<p><em>' . esc_html__('Matching Elementor form not found or has no fields.', 'sync-forms-with-brilliant-directories') . '</em></p>';
    }

    $fields = $target_form_widget['settings']['form_fields'];
    $allowed_types = ['text', 'textarea', 'email', 'tel', 'url', 'radio', 'select', 'checkbox', 'number', 'date', 'time', 'hidden'];
    $elfields = [];

    foreach ($fields as $field) {
        $type  = $field['field_type'] ?? 'text';
        $name  = $field['custom_id'] ?? null;
        $label = $field['field_label'] ?? $name;

        if (!$name || !in_array($type, $allowed_types, true)) {
            continue;
        }

        $elfields[] = [
                'type'  => $type,
                'name'  => $name,
                'label' => $label
            ];

        // // ✅ Handle checkbox with space-separated 'field_options'
        // if ($type === 'checkbox' && !empty($field['field_options']) && is_string($field['field_options'])) {
        //     $options = preg_split('/[\s,]+/', $field['field_options']); // split by space or comma
        //     foreach ($options as $option) {
        //         $elfields[] = [
        //             'type'  => 'checkbox',
        //             'name'  => $name . '[]',
        //             'label' => $label . ' - ' . ucfirst(trim($option)),
        //             'option_value' => trim($option)
        //         ];
        //     }
        // } else {
        //     // Regular field
        //     $elfields[] = [
        //         'type'  => $type,
        //         'name'  => $name,
        //         'label' => $label
        //     ];
        // }
    }


    // Define required & additional fields
    if ($create_sub == 'leads') {
        $required_fields = [
            'lead_email' => 'lead_email (string, email)',
        ];
        $additional_fields = [
            'adm_lvl_1_sn' => 'adm_lvl_1_sn (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_match' => 'auto_match (integer)',
            'country_sn' => 'country_sn (string)',
            'date_added' => 'date_added (string, datetime)',
            'flow_source' => 'flow_source (string)',
            'formname' => 'formname (string)',
            'lat' => 'lat (number)',
            'lead_location' => 'lead_location (string)',
            'lead_message' => 'lead_message (string)',
            'lead_name' => 'lead_name (string)',
            'lead_notes' => 'lead_notes (string)',
            'lead_phone' => 'lead_phone (string)',
            'lead_price' => 'lead_price (number)',
            'lng' => 'lng (number)',
            'location_type' => 'location_type (string)',
            'nelat' => 'nelat (number)',
            'nelng' => 'nelng (number)',
            'origin_ip' => 'origin_ip (string)',
            'revision_timestamp' => 'revision_timestamp (string, datetime)',
            'send_lead_email_notification' => 'send_lead_email_notification (integer)',
            'sub_category_name' => 'sub_category_name(string)',
            'sub_id' => 'sub_id (integer)',
            'sub_sub_category_name' => 'sub_sub_category_name (string)',
            'sub_sub_id' => 'sub_sub_id (integer)',
            'swlat' => 'swlat (number)',
            'swlng' => 'swlng (number)',
            'top_category_name' => 'top_category_name (string)',
            'top_id' => 'top_id (integer)',
            'url_from' => 'url_from (string)',
        ];
    } elseif ($create_sub == 'user') {
        $required_fields = [
            'active' => 'Account Status (2 is active, 1 is deactive)',
            'email' => 'email (string, email)',
        ];
        $additional_fields = [
            'about_me' => 'about_me (string)',
            'address1' => 'address1 (string)',
            'address2' => 'address2 (string)',
            'affiliation' => 'affiliation (string)',
            'auto_geocode' => 'auto_geocode (integer)',
            'auto_image_import' => 'auto_image_import (integer)',
            'awards' => 'awards (string)',
            'blog' => 'blog (string, uri)',
            'city' => 'city (string)',
            'company' => 'company (string)',
            'country_code' => 'country_code (string)',
            'country_ln' => 'country_ln (string)',
            'cover_photo' => 'cover_photo (string)',
            'credentials' => 'credentials (string)',
            'cv' => 'cv (string)',
            'experience' => 'experience (integer)',
            'facebook' => 'facebook (string, uri)',
            'facebook_id' => 'facebook_id (string)',
            'featured' => 'featured (integer)',
            'first_name' => 'first_name (string)',
            'google_id' => 'google_id (string)',
            'instagram' => 'instagram (string, uri)',
            'last_login' => 'last_login (string, datetime)',
            'last_name' => 'last_name (string)',
            'lat' => 'lat (number)',
            'linkedin' => 'linkedin (string, uri)',
            'listing_type' => 'listing_type (string)',
            'logo' => 'logo (string)',
            'lon' => 'lon (number)',
            'member_tags' => 'member_tags (string)',
            'modtime' => 'modtime (string, datetime)',
            'nationwide' => 'nationwide (integer)',
            'phone_number' => 'phone_number (string)',
            'pinterest' => 'pinterest (string, uri)',
            'position' => 'position (string)',
            'profession_id' => 'profession_id (integer)',
            'profile_photo' => 'profile_photo (string)',
            'quote' => 'quote (string)',
            'rep_matters' => 'rep_matters (string)',
            'search_description' => 'search_description (string)',
            'send_email_notifications' => 'send_email_notifications (integer)',
            'services' => 'services (string)',
            'signup_date' => 'signup_date (string, datetime)',
            'snapchat' => 'snapchat (string)',
            'state_code' => 'state_code (string)',
            'state_ln' => 'state_ln (string)',
            'twitter' => 'twitter (string, uri)',
            'verified' => 'verified (integer)',
            'website' => 'website (string, uri)',
            'whatsapp' => 'whatsapp (string)',
            'youtube' => 'youtube (string, uri)',
            'zip_code' => 'zip_code (string)',
        ];
    } else {
        $required_fields = [];
        $additional_fields = [];
    }

    // Merge saved mapping fields
    $lead_fields = array_merge($required_fields, $additional_fields);

    if (!empty($saved_mapping)) {
        foreach ($saved_mapping as $form_field => $mapped_lead_field) {
            if (!isset($lead_fields[$mapped_lead_field])) {
                $lead_fields[$mapped_lead_field] = $mapped_lead_field;
            }
        }
    }

    // Build custom variables
    $brill_custom_combined = [];
    foreach ($lead_fields as $value => $label) {
        if (!isset($required_fields[$value]) && !isset($additional_fields[$value]) && $value !== 'skip') {
            $brill_custom_combined[$value] = $label;
        }
    }

    if (!is_array($brill_get_custom_mapping)) {
        $brill_get_custom_mapping = [];
    }

    foreach ($brill_get_custom_mapping as $form_field => $mapped_field) {
        foreach ($mapped_field as $brill_cus_key => $brill_cus_value) {
            if (!isset($required_fields[$brill_cus_key]) &&
                !isset($additional_fields[$brill_cus_key]) &&
                $brill_cus_key !== 'skip') {
                $brill_custom_combined[$brill_cus_key] = $brill_cus_key;
            }
        }
    }

    asort($brill_custom_combined);

    // Render field mapping interface
    if (!empty($elfields)) {
        ob_start();
        ?>
        <div class="brillforms-mapping-wrap">
            <div class="brill-label-wrap">
                <label class="brill-label" id="brillforms_fieldmap_label"><?php echo esc_html__('Map WP Form Fields to Brilliant Directories', 'sync-forms-with-brilliant-directories'); ?></label>
            </div>
            <table class="widefat brillforms-field-map-table">
                <thead>
                     <tr>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Type', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-form-datas"><?php echo esc_html__('Field Label', 'sync-forms-with-brilliant-directories'); ?></th>
                        <th class="brill-mapping-datas"><div class="brill-mapping-data-wrap"><?php echo esc_html__('Map to Field ', 'sync-forms-with-brilliant-directories'); ?> <span id="requiredFieldsCount"></span></div></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($elfields as $field):
                    $form_field_id = (string) $field['name'];
                    $selected_value = $saved_mapping[$form_field_id] ?? 'skip'; ?>
                    <tr>
                        <td><?php echo esc_html($field['type']); ?></td>
                        <td><?php echo esc_html($field['label']); ?></td>
                        <td>
                            <select class="brillforms_lead_fields brill-lead-fields" name="brildir_sfwbd_field_map[<?php echo esc_attr($field['name']); ?>]" >
                                <option value=""><?php esc_html_e('-- Select --', 'sync-forms-with-brilliant-directories'); ?></option>
                                <option value="skip" <?php selected($selected_value, 'skip'); ?>>
                                    <?php esc_html_e('Skip Field - Do Not Map', 'sync-forms-with-brilliant-directories'); ?>
                                </option>
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                </optgroup>
                                <!-- Grouped options by required and additional fields -->
                                 <?php if (!empty($required_fields)) : ?> 
                                    <optgroup label="Required Mapping Fields">
                                        <?php foreach ($required_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <?php if (!empty($additional_fields)) : ?>
                                    <optgroup label="Additional Fields">
                                        <?php foreach ($additional_fields as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($selected_value, $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                            </select>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="brill-label-wrap">
            <span class="brill-label" id="brillforms_custom_fields_label"><?php echo esc_html__('Additional Data Sent with Every Form Submission', 'sync-forms-with-brilliant-directories'); ?></span>
        </div>

        <?php if (!empty($brill_get_custom_mapping)) : 
            ?>
            <div id="additional-mapping-fields-container">
                <?php foreach ($brill_get_custom_mapping as $form_field => $mapped_field) :
                    foreach ($mapped_field as $brill_cus_key => $brill_cus_value) : 
                ?>
                    <div class="brill-additional-field-row" data-index="<?php echo esc_attr($brill_cus_key); ?>">
                        <div class="brill-additional-field-delete">
                            <span class="brill-del-custom-field" data-index="<?php echo esc_attr($brill_cus_key); ?>"><span aria-hidden="true" class="dashicons dashicons-trash"></span></span>
                        </div>
                        <div class="brill-additional-field-select">
                            <select class="brillforms_lead_fields" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][map_to]" style="width: 250px;">
                                <option value=""><?php esc_html_e('Select Variable to Map', 'sync-forms-with-brilliant-directories'); ?></option>
                                <!-- Custom Fields Optgroup -->
                                // Check if there are custom variables to display
                                <?php if (!empty($brill_custom_combined)): ?>
                                    <optgroup label="Custom Variable">
                                        <?php foreach ($brill_custom_combined as $value => $label): ?>
                                            <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key ?? '', $value); ?>>
                                                <?php echo esc_html($label); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </optgroup>
                                <?php endif; ?>
                                <!-- Required Fields Optgroup -->
                                <optgroup label="Required Mapping Fields">
                                    <?php foreach ($required_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>

                                <!-- Additional Fields Optgroup -->
                                <optgroup label="Additional Fields">
                                    <?php foreach ($additional_fields as $value => $label): ?>
                                        <option value="<?php echo esc_attr($value); ?>" <?php selected($brill_cus_key, $value); ?>>
                                            <?php echo esc_html($label); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>
                            </select>
                        </div>
                        <div class="brill-additional-field-input">
                            <input type="text" name="brildir_sfwbd_field_map_custom[<?php echo esc_attr($brill_cus_key); ?>][name]" value="<?php echo esc_attr($brill_cus_value); ?>" placeholder="Enter Value to Pass" required />
                        </div>
                    </div>
                <?php endforeach;
                endforeach;
                 ?>
            </div>
        <?php else : ?>
            <div id="additional-mapping-fields-container"></div>
        <?php endif; ?>
        <!-- Button to add new mapping -->
        <button type="button" id="add-additional-mapping-field" class="button button-secondary" style="margin-top: 10px;">
            <?php esc_html_e('+ Add Data Field', 'sync-forms-with-brilliant-directories'); ?>
        </button>
        <?php
        return ob_get_clean();
    }

    return '<p><em>' . esc_html__('No supported fields found in this Gravity Form.', 'sync-forms-with-brilliant-directories') . '</em></p>';
}
