<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

function Brildir_Sfwbd_Display_Error_Log_table()
{
    if (!is_user_logged_in()) {
        return '<p>'. esc_html__('You must be logged in to view this content.', 'sync-forms-with-brilliant-directories') . '</p>';
    }

    global $wpdb;
    $brill_log_table = $wpdb->prefix . 'brildir_sfwbd_error_log';

    $brill_log_nonce = wp_create_nonce('brildir_sfwbd_view_logs');
    
    // Pagination setup
    $logs_per_page = 10;
    if (isset($_GET['brildir_sfwbd_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['brildir_sfwbd_nonce'])), 'brildir_sfwbd_view_logs')) {

        $current_page = isset($_GET['brildir_sfwbd_page']) ? max(1, intval($_GET['brildir_sfwbd_page'])) : 1;
    } else {
        $current_page = 1;
    }
    $offset = ($current_page - 1) * $logs_per_page;

    $brill_log_table = esc_sql($brill_log_table); // Sanitize the table name

    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Direct database call is required for log count
    $total_logs = wp_cache_get('brildir_sfwbd_total_logs', 'sync-forms-with-brilliant-directories');
    
    if (false === $total_logs) {
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Table name is sanitized and query is cached
        $total_logs = $wpdb->get_var("SELECT COUNT(*) FROM `{$wpdb->prefix}brildir_sfwbd_error_log`");
        // Cache the result for 12 hours (43200 seconds)
        wp_cache_set('brildir_sfwbd_total_logs', $total_logs, 'sync-forms-with-brilliant-directories', 43200);
    }
    
    $total_pages = ceil($total_logs / $logs_per_page);   

    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery -- Table name is sanitized and cannot be used as a placeholder
    $results = $wpdb->get_results(
        $wpdb->prepare(
            "SELECT * FROM `{$wpdb->prefix}brildir_sfwbd_error_log` ORDER BY created_at DESC LIMIT %d OFFSET %d",
            $logs_per_page,
            $offset
        )
    );

    ob_start();

    if (empty($results)) {
        echo '<p>' . esc_html__('No error logs found', 'sync-forms-with-brilliant-directories'). '</p>';
        return ob_get_clean();
    }

    echo '<div class="brillforms-error-log">';
    echo '<table>';
    echo '<thead><tr>
            <th>' . esc_html__('Form Plugin', 'sync-forms-with-brilliant-directories') . '</th>
            <th>' . esc_html__('Form Name', 'sync-forms-with-brilliant-directories') . '</th>
            <th>' . esc_html__('Create Action', 'sync-forms-with-brilliant-directories') . '</th>
            <th>' . esc_html__('Error', 'sync-forms-with-brilliant-directories') . '</th>
            <th>' . esc_html__('Error Date', 'sync-forms-with-brilliant-directories') . '</th>
          </tr></thead><tbody>';

    foreach ($results as $row) {
        echo '<tr>';
        $brill_form_plugin = ucfirst(str_replace('_', ' ', $row->form_plugin));
        if ($row->form_plugin === 'contact_form_7') {
                $brill_form_plugin = 'Contact Form 7';
        }
        if ($row->create_option === 'user') {
            $brill_create_type = 'Member';
        } else {
            $brill_create_type = 'Lead';
        }
        echo '<td>' . esc_html($brill_form_plugin) . '</td>';
        echo '<td>' . esc_html($row->form_id) . '</td>';
        echo '<td>' . esc_html($brill_create_type) . '</td>';
        echo '<td>' . esc_html($row->error_message) . '</td>';
        echo '<td>' . esc_html(date_i18n('M j, Y g:i A', strtotime($row->created_at))) . '</td>';
        echo '</tr>';
}

    echo '</tbody></table>';
    echo '</div>';

    // Pagination links
    if ($total_pages > 1) {
        echo '<div class="brill-Pagination-wrap">';
        
        $base_url = remove_query_arg(array('brildir_sfwbd_page', 'brildir_sfwbd_nonce'));
        
        $pagination_links = paginate_links(array(
            'base' => add_query_arg(array('brildir_sfwbd_page' => '%#%', 'brildir_sfwbd_nonce' => $brill_log_nonce), $base_url),
            'format' => '',
            'current' => $current_page,
            'total' => $total_pages,
            'type' => 'list',
            'prev_text' => esc_html__('« Previous', 'sync-forms-with-brilliant-directories'),
            'next_text' => esc_html__('Next »', 'sync-forms-with-brilliant-directories'),
        ));

        // Add pagination HTML
        if ($pagination_links) {
            echo wp_kses_post($pagination_links);
        }

        echo '</div>';
    }


    return ob_get_clean();
}
add_shortcode('brildir_sfwbd_error_log', 'Brildir_Sfwbd_Display_Error_Log_table');

add_action('wp_ajax_brildir_sfwbd_clear_logs', 'Brildir_Sfwbd_Clear_Logs_ajax');
add_action('wp_ajax_nopriv_brildir_sfwbd_clear_logs', 'Brildir_Sfwbd_Clear_Logs_ajax');
function Brildir_Sfwbd_Clear_Logs_ajax()
{
    if (! isset($_POST['brildir_sfwbd_settings_nonce']) || ! wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_settings_nonce'])), 'brildir_sfwbd_settings_nonce_action') ) {
        wp_send_json_error(array('message' => esc_html__('Invalid nonce.', 'sync-forms-with-brilliant-directories')));
        return;
    }

    global $wpdb;
    
    // Sanitize table name
    $brill_log_table = esc_sql($wpdb->prefix . 'brildir_sfwbd_error_log');

    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Table name is sanitized
    $wpdb->query("TRUNCATE TABLE `$brill_log_table`");
    
    wp_send_json_success('Log Cleared');
}

