<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Step 1: Define custom columns
function Brildir_Sfwbd_Sync_columns($columns) 
{
    unset($columns['date']);
    $columns['title'] = esc_html__('Nickname', 'sync-forms-with-brilliant-directories');
    $columns['brildir_sfwbd_form_plugin'] = esc_html__('Form Plugin', 'sync-forms-with-brilliant-directories');
    $columns['brildir_sfwbd_form_name'] = esc_html__('Form Name', 'sync-forms-with-brilliant-directories');
    $columns['brildir_sfwbd_record_created'] = esc_html__('Create Action', 'sync-forms-with-brilliant-directories');
    $columns['brildir_sfwbd_status'] = esc_html__('Status', 'sync-forms-with-brilliant-directories');
    $columns['brildir_sfwbd_syncs_completed'] = esc_html__('Syncs Completed', 'sync-forms-with-brilliant-directories');
    $columns['brildir_sfwbd_last_sync_date'] = esc_html__('Last Sync Date', 'sync-forms-with-brilliant-directories');
    return $columns;
}
add_filter('manage_brildir-sfwbd_posts_columns', 'Brildir_Sfwbd_Sync_columns');

// Step 2: Populate custom column data
function Brildir_Sfwbd_Sync_Custom_columns($column, $post_id)
{
    switch ($column) {
        
    case 'brildir_sfwbd_form_plugin':
        $brillsync_form_plugin = get_post_meta($post_id, '_brildir_sfwbd_form_plugin', true);

        $brill_form_plugin = '';
        if($brillsync_form_plugin === 'contact_form_7'){
            if (is_plugin_active('contact-form-7/wp-contact-form-7.php')) {
                $brill_form_plugin = 'Contact form 7';
                echo esc_html__('Contact form 7', 'sync-forms-with-brilliant-directories');
            } else {
                $brill_form_plugin = 'Contact Form 7 Plugin Not Found';
                echo esc_html__('Contact Form 7 Plugin Not Found', 'sync-forms-with-brilliant-directories');
            }
        } elseif($brillsync_form_plugin === 'wpforms'){
            if (is_plugin_active('wpforms-lite/wpforms.php')) {
                $brill_form_plugin = 'wpforms';
                echo esc_html__('WPForms', 'sync-forms-with-brilliant-directories');
            } else {
                $brill_form_plugin = 'WPForms Plugin Not Found';
                echo esc_html__('WPForms Plugin Not Found', 'sync-forms-with-brilliant-directories');
            }
        } elseif($brillsync_form_plugin === 'ninjaform'){
            if (is_plugin_active('ninja-forms/ninja-forms.php')) {
                $brill_form_plugin = 'Ninja Forms';
                echo esc_html__('Ninja Forms', 'sync-forms-with-brilliant-directories');
            } else {
                $brill_form_plugin = 'Ninja Forms Plugin Not Found';
                echo esc_html__('Ninja Forms Plugin Not Found', 'sync-forms-with-brilliant-directories');
            }
        } elseif($brillsync_form_plugin === 'gform'){
            if (is_plugin_active('gravityforms/gravityforms.php')) {
                $brill_form_plugin = 'Gravity Forms';
                echo esc_html__('Gravity Forms', 'sync-forms-with-brilliant-directories');
            } else {
                $brill_form_plugin = 'Gravity Forms Plugin Not Found';
                echo esc_html__('Gravity Forms Plugin Not Found', 'sync-forms-with-brilliant-directories');
            }
        } elseif ($brillsync_form_plugin === 'elementor') {
            if (is_plugin_active('elementor/elementor.php')) {
                $brill_form_plugin = 'Elementor Forms';
                echo esc_html__('Elementor Forms', 'sync-forms-with-brilliant-directories');
            } else {
                $brill_form_plugin = 'Elementor Plugin Not Found';
                echo esc_html__('Elementor Plugin Not Found', 'sync-forms-with-brilliant-directories');
            }
        }
        update_post_meta($post_id, '_brildir_sfwbd_plugin_name', $brill_form_plugin);
        break;

    case 'brildir_sfwbd_form_name':
    $form_id    = get_post_meta($post_id, '_brildir_sfwbd_form_id', true);
    $form_title = get_post_meta($post_id, '_brildir_sfwbd_form_title', true);

    if ($form_id && $form_title) {
        echo esc_html($form_title);
    } else {
        echo esc_html__('Form not found', 'sync-forms-with-brilliant-directories');
    }
    break;


    case 'brildir_sfwbd_record_created':
        $brillsync_create_type = get_post_meta($post_id, '_brildir_sfwbd_create_type', true);
        echo esc_html($brillsync_create_type);
        break;

    case 'brildir_sfwbd_status':
    $post_status          = get_post_status($post_id);
    $brill_form_plugin    = get_post_meta($post_id, '_brildir_sfwbd_form_plugin', true);
    $brill_form_id        = get_post_meta($post_id, '_brildir_sfwbd_form_id', true);
    $brill_form_status    = 'Unknown';

    $brill_form_exists = false;

    switch ($brill_form_plugin) {
        case 'contact_form_7':
            if (is_plugin_active('contact-form-7/wp-contact-form-7.php')) {
                $brill_form_exists = get_post($brill_form_id) !== null;
            }
            break;

        case 'wpforms':
            if (is_plugin_active('wpforms-lite/wpforms.php') || is_plugin_active('wpforms/wpforms.php')) {
                $brill_form_exists = get_post($brill_form_id) !== null;
            }
            break;

        case 'ninjaform':
            if (is_plugin_active('ninja-forms/ninja-forms.php') && class_exists('Ninja_Forms')) {
                $form_instance = Ninja_Forms()->form($brill_form_id);
                $brill_form_exists   = $form_instance && $form_instance->get();
            }
            break;
        case 'gform':
            if (is_plugin_active('gravityforms/gravityforms.php') && class_exists('GFAPI')) {
                $form = GFAPI::get_form($brill_form_id);
                $brill_form_exists = !empty($form);
            }
            break; 
        case 'elementor':
            $brill_form_exists = false;

            if (
                is_plugin_active('elementor/elementor.php') &&
                class_exists('\Elementor\Plugin') &&
                !empty($brill_form_id) &&
                strpos($brill_form_id, ':') !== false
            ) {
                list($post_id, $form_name) = explode(':', $brill_form_id, 2);
                $post_id = absint($post_id); // sanitize

                $elementor_data = get_post_meta($post_id, '_elementor_data', true);

                if (!empty($elementor_data)) {
                    $widgets = json_decode($elementor_data, true);

                    if (is_array($widgets)) {
                        $iterator = new RecursiveIteratorIterator(new RecursiveArrayIterator($widgets));

                        foreach ($iterator as $key => $value) {
                            if ($key === 'widgetType' && $value === 'form') {
                                $depth = $iterator->getDepth();
                                for ($i = $depth; $i >= 0; $i--) {
                                    $current = $iterator->getSubIterator($i);
                                    if (isset($current['settings']['form_name']) && $current['settings']['form_name'] === $form_name) {
                                        $brill_form_exists = true;
                                        break 3; // Break out of all loops
                                    }
                                }
                            }
                        }
                    }
                }
            }
            break;
    }

    // Determine and display status
    if ($post_status === 'publish') {
        if ($brill_form_exists) {
            $brill_form_status = 'Active';
            echo '<div class="brill-sync-status-active"><span class="dashicons dashicons-saved"></span> ' . esc_html__('Active', 'sync-forms-with-brilliant-directories') . '</div>';
        } else {
            $brill_form_status = 'Error';
            echo '<div class="brill-sync-status-error"><span class="dashicons dashicons-no-alt"></span> ' . esc_html__('Error', 'sync-forms-with-brilliant-directories') . '</div>';
        }
    } else {
        $brill_form_status = 'Draft';
        echo '<div class="brill-sync-status-draft"><span class="dashicons dashicons-edit"></span> ' . esc_html__('Draft', 'sync-forms-with-brilliant-directories') . '</div>';
    }

    // Save status in meta
    update_post_meta($post_id, '_brildir_sfwbd_sync_status', $brill_form_status);
    break;


    case 'brildir_sfwbd_syncs_completed':
        // Assuming you have a count of syncs somewhere, for example:
        $syncs_completed = get_post_meta($post_id, '_brildir_sfwbd_sync_count', true);
        if($syncs_completed){
            echo esc_html($syncs_completed);
        } else {
            echo esc_html(' — ');
            update_post_meta($post_id, '_brildir_sfwbd_sync_count', '0');
        }
        
        break;

    case 'brildir_sfwbd_last_sync_date':
        $brillforms_last_sync_date = get_post_meta($post_id, '_brildir_sfwbd_last_sync_date', true);
        if ($brillforms_last_sync_date) {
            $brillforms_formatted_date = date_i18n('M j, Y g:i A', strtotime($brillforms_last_sync_date));
            update_post_meta($post_id, '_brildir_sfwbd_last_sync_date', $brillforms_formatted_date);
            echo esc_html($brillforms_formatted_date ? $brillforms_formatted_date : ' — ');
        } else {
            echo esc_html(' — ');
            update_post_meta($post_id, '_brildir_sfwbd_last_sync_date', '0');
        }
        
        break;
    }
}
add_action('manage_brildir-sfwbd_posts_custom_column', 'Brildir_Sfwbd_Sync_Custom_columns', 10, 2);

// Step 3: Make columns sortable (Optional)
function Brildir_Sfwbd_Sync_Sortable_columns($columns)
{
    $columns['brildir_sfwbd_form_plugin'] = 'brildir_sfwbd_form_plugin';
    $columns['brildir_sfwbd_form_name'] = 'brildir_sfwbd_form_name';
    $columns['brildir_sfwbd_record_created'] = 'brildir_sfwbd_record_created';
    $columns['brildir_sfwbd_status'] = 'brildir_sfwbd_status';
    $columns['brildir_sfwbd_syncs_completed'] = 'brildir_sfwbd_syncs_completed';
    $columns['brildir_sfwbd_last_sync_date'] = 'brildir_sfwbd_last_sync_date';
    return $columns;
}
add_filter('manage_edit-brildir-sfwbd_sortable_columns', 'Brildir_Sfwbd_Sync_Sortable_columns');

// Optional: Add sorting logic
function Brildir_Sfwbd_Sync_orderby($query)
{
    if (!is_admin() || !$query->is_main_query()) {
        return;
    }

    if ('brildir-sfwbd' === $query->get('post_type')) {
        $orderby = $query->get('orderby');

        switch ($orderby) {
            case 'brildir_sfwbd_form_plugin':
                $query->set('meta_key', '_brildir_sfwbd_plugin_name');
                $query->set('orderby', 'meta_value');
                break;
            case 'brildir_sfwbd_form_name':
                $query->set('meta_key', '_brildir_sfwbd_form_title');
                $query->set('orderby', 'meta_value');
                break;
            case 'brildir_sfwbd_record_created':
                $query->set('meta_key', '_brildir_sfwbd_create_type');
                $query->set('orderby', 'meta_value');
                break;
            case 'brildir_sfwbd_status':
                $query->set('meta_key', '_brildir_sfwbd_sync_status');
                $query->set('orderby', 'meta_value');
                break;
            case 'brildir_sfwbd_syncs_completed':
                $query->set('meta_key', '_brildir_sfwbd_sync_count');
                $query->set('orderby', 'meta_value_num');
                break;
            case 'brildir_sfwbd_last_sync_date':
                $query->set('meta_key', '_brildir_sfwbd_last_sync_date');
                $query->set('orderby', 'meta_value');
                break;
        }
    }
}
add_action('pre_get_posts', 'Brildir_Sfwbd_Sync_orderby');

add_filter('pre_get_posts', 'Brildir_Sfwbd_Extend_Sync_search');
function Brildir_Sfwbd_Extend_Sync_search($query)
{
    if (
        is_admin() &&
        $query->is_main_query() &&
        $query->is_search() &&
        $query->get('post_type') === 'brildir-sfwbd'
    ) {
        add_filter('posts_search', 'Brildir_Sfwbd_Custom_Meta_search', 10, 2);
    }
}

function Brildir_Sfwbd_Custom_Meta_search($search, $query)
{
    global $wpdb;

    if (!$query->is_main_query() || !$query->is_search()) {
        return $search;
    }

    // Get the search term
    $term = esc_sql($wpdb->esc_like($query->get('s')));

    // Target meta keys
    $meta_keys = array(
        '_brildir_sfwbd_plugin_name',
        '_brildir_sfwbd_form_title',
        '_brildir_sfwbd_create_type',
        '_brildir_sfwbd_sync_status',
        '_brildir_sfwbd_sync_count',
        '_brildir_sfwbd_last_sync_date'
    );

    // Build meta search conditions
    $meta_conditions = array();
    foreach ($meta_keys as $key) {
        $meta_conditions[] = $wpdb->prepare(
            "({$wpdb->postmeta}.meta_key = %s AND {$wpdb->postmeta}.meta_value LIKE %s)",
            $key,
            '%' . $term . '%'
        );
    }

    $meta_search_sql = implode(' OR ', $meta_conditions);

    $search = " AND ({$wpdb->posts}.post_title LIKE '%{$term}%' 
        OR EXISTS (
            SELECT 1 FROM {$wpdb->postmeta}
            WHERE {$wpdb->postmeta}.post_id = {$wpdb->posts}.ID
              AND ({$meta_search_sql})
        ))";

    return $search;
}

add_filter('post_row_actions', 'Brildir_Sfwbd_Remove_Quick_edit', 10, 2);
function Brildir_Sfwbd_Remove_Quick_edit($actions, $post)
{
    if ($post->post_type === 'brildir-sfwbd') {
        unset($actions['inline hide-if-no-js']); // "Quick Edit" is labeled like this
    }
    return $actions;
}

// Remove Trash action and replace with Delete for post type 'brildir-sfwbd'
add_filter('post_row_actions', 'Brildir_Sfwbd_Replace_Trash_With_Delete_action', 10, 2);
function Brildir_Sfwbd_Replace_Trash_With_Delete_action($actions, $post) {
    if ($post->post_type === 'brildir-sfwbd') {
        unset($actions['trash']);
        $delete_url = wp_nonce_url(admin_url('admin.php?action=delete_brildir-sfwbd_post&post=' . $post->ID), 'delete-sync-post_' . $post->ID);
        $actions['delete'] = '<a href="#" class="brill-sync-delete-link brill-list-sync-btn" data-delete-url="' . esc_url($delete_url) . '">Delete</a>';
    }
    return $actions;
}


// Handle the Delete action for post type 'brildir-sfwbd'
add_action('admin_action_delete_brildir-sfwbd_post', 'Brildir_Sfwbd_Handle_Delete_action');
function Brildir_Sfwbd_Handle_Delete_action() {
    if (!isset($_GET['post'], $_GET['_wpnonce'])) {
        wp_die('Invalid request.');
    }

    $post_id = isset($_GET['post']) ? intval($_GET['post']) : 0;
    $nonce = sanitize_text_field(wp_unslash($_GET['_wpnonce']));

    if (!wp_verify_nonce($nonce, 'delete-sync-post_' . $post_id)) {
        wp_die('Nonce verification failed.');
    }

    if (!current_user_can('delete_post', $post_id)) {
        wp_die('You do not have permission to delete this post.');
    }

    wp_delete_post($post_id, true); // permanently delete
    wp_redirect(admin_url('edit.php?post_type=brildir-sfwbd'));
    exit;
}

add_action('admin_footer-edit.php', 'Brildir_Sfwbd_Add_Delete_modal');
function Brildir_Sfwbd_Add_Delete_modal() {
    ?>
    <div id="brill_sync_list_del_modal" class="brill-popup-wrap" style="display:none;">
        <div class="brill-modal-overlay"></div>
        <div class="brill-modal-content">
            <h1><?php echo esc_html__('Confirm Action', 'sync-forms-with-brilliant-directories'); ?></h1>
            <div class="brill-confirmation-btn-wrap">
                <span id="brill_confirm_sync_list_del" class="brill-popup-confirm-btn">
                    <?php echo esc_html__('Yes, continue', 'sync-forms-with-brilliant-directories'); ?>
                </span>
                <span id="brill_cancel_sync_list_del" class="brill-popup-cancel-btn">
                    <?php echo esc_html__('No, cancel', 'sync-forms-with-brilliant-directories'); ?>
                </span>
            </div>
        </div>
    </div>
    <?php
}

add_filter('bulk_actions-edit-brildir-sfwbd', 'Brildir_Sfwbd_Customize_Bulk_actions');
function Brildir_Sfwbd_Customize_Bulk_actions($actions)
{
    // Remove unwanted bulk actions
    unset($actions['edit']);
    unset($actions['trash']);

    // Only allow permanent delete
    return array(
        'delete' => esc_html__('Delete', 'sync-forms-with-brilliant-directories'),
    );
}

add_filter('views_edit-brildir-sfwbd', 'Brildir_Sfwbd_Remove_Post_Status_views');
function Brildir_Sfwbd_Remove_Post_Status_views($views)
{
    return array(); // Removes All, Published, Trash, etc.
}

add_filter('disable_months_dropdown', 'Brildir_Sfwbd_Remove_Date_filter', 10, 2);
function Brildir_Sfwbd_Remove_Date_filter($disable, $post_type)
{
    if ($post_type === 'brildir-sfwbd') {
        return true; // Disables the dropdown
    }
    return $disable;
}

// Replace "Move to Trash" with "Delete Permanently" in the Publish metabox for custom post type "sync"
add_action('post_submitbox_misc_actions', 'Brildir_Sfwbd_Replace_Trash_With_Permanent_delete', 10, 1);
function Brildir_Sfwbd_Replace_Trash_With_Permanent_delete($post)
{
    if ($post->post_type === 'brildir-sfwbd') {
        $post_id = $post->ID;

        if (current_user_can('delete_post', $post_id)) {
            echo '<div class="misc-pub-section misc-pub-trash brill-sync-post">';
            echo '<a href="#" class="submitdelete deletion brill-sync-delete-link" data-url="' . esc_url(wp_nonce_url(admin_url('admin.php?action=delete_brildir-sfwbd_post&post=' . $post_id), 'delete-sync-post_' . $post_id)) . '">Delete</a>';
            echo '</div>';

            // Modal HTML
            ?>
            <div id="brill_sync_del_modal" class="brill-popup-wrap" style="display:none;">
                <div class="brill-modal-overlay"></div>
                <div class="brill-modal-content">
                    <h1><?php echo esc_html__('Confirm Action', 'sync-forms-with-brilliant-directories'); ?></h1>
                    <div class="brill-confirmation-btn-wrap">
                        <span id="brill_confirm_sync_del" class="brill-popup-confirm-btn">
                            <?php echo esc_html__('Yes, continue', 'sync-forms-with-brilliant-directories'); ?>
                        </span>
                        <span id="brill_cancel_sync_del" class="brill-popup-cancel-btn">
                            <?php echo esc_html__('No, cancel', 'sync-forms-with-brilliant-directories'); ?>
                        </span>
                    </div>
                </div>
            </div>
            <?php
        }
    }
}

add_action('wp_ajax_brildir_sfwbd_delete_post', 'Brildir_Sfwbd_Delete_Sync_Post_ajax');
function Brildir_Sfwbd_Delete_Sync_Post_ajax() {
    if (! isset($_POST['brildir_sfwbd_settings_nonce']) || ! wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['brildir_sfwbd_settings_nonce'])), 'brildir_sfwbd_settings_nonce_action') ) {
        wp_send_json_error(array('message' => esc_html__('Invalid nonce.', 'sync-forms-with-brilliant-directories')));
        return;
    }

    $post_id = isset($_POST['post_id']) ? intval($_POST['post_id']) : 0;

    $deleted = wp_delete_post($post_id, true);

    if ($deleted) {
        wp_send_json_success(['message' => esc_html__('Post deleted successfully', 'sync-forms-with-brilliant-directories')]);
    } else {
        wp_send_json_error(['message' => esc_html__('Failed to delete post', 'sync-forms-with-brilliant-directories')]);
    }
}
