<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

add_action('wpcf7_before_send_mail', 'Brildir_Sfwbd_Handle_Cf7_submission');
function Brildir_Sfwbd_Handle_Cf7_submission($contact_form)
{
    $form_id = $contact_form->id();
    $submission = WPCF7_Submission::get_instance();

    if (!$submission) {
        return;
    }

    $posted_data = $submission->get_posted_data();

    // Get all brillforms brildir-sfwbd posts using WP_Query
    $query = new WP_Query(array(
        'post_type'      => 'brildir-sfwbd',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'meta_query'     => array(
            array(
                'key'   => '_brildir_sfwbd_form_plugin',
                'value' => 'contact_form_7',
            ),
            array(
                'key'   => '_brildir_sfwbd_form_id',
                'value' => $form_id,
            ),
        ),
        'no_found_rows'  => true, // Improves performance when pagination isn't needed
        'fields'         => 'all', // could be 'ids' if only post IDs were needed
    ));

    if (!$query->have_posts()) {
        return;
    }

    foreach ($query->posts as $brillsync_form) {
        $post_id = $brillsync_form->ID;

        $brill_create_option = get_post_meta($post_id, '_brildir_sfwbd_create_option', true);
        $brill_field_map = get_post_meta($post_id, '_brildir_sfwbd_field_map', true);
        $brill_custom_field_map = get_post_meta($post_id, '_brildir_sfwbd_field_map_custom', true);
        $brill_form_plugin = 'Contact Form 7';
        $brill_form_name = get_post_meta($post_id, '_brildir_sfwbd_form_title', true);

        // Get the specific form mapping data
        $brill_form_mapping = $brill_field_map[$form_id] ?? [];

        $brill_map_data = [];

        foreach ($brill_form_mapping as $form_field => $bd_field) {
            if (array_key_exists($form_field, $posted_data)) {
                $brill_map_data[$bd_field] = sanitize_text_field($posted_data[$form_field]);
            } else {
                $brill_map_data[$bd_field] = $form_field;
            }
        }

        if (!is_array($brill_custom_field_map)) {
            $brill_custom_field_map = [];
        }

        foreach ($brill_custom_field_map as $brill_field_key => $brill_field_value) {
            foreach ($brill_field_value as $brill_cus_key => $brill_cus_value) {
                $brill_map_data[$brill_cus_key] = $brill_cus_value;
            }
        }

        // Add the subscription ID if it exists
        if ($brill_create_option === 'user') {
            $brill_subscription_id = get_post_meta($post_id, '_brildir_sfwbd_subscription_id', true);
            if (!empty($brill_subscription_id)) {
                $brill_map_data['subscription_id'] = sanitize_text_field($brill_subscription_id);
            }
        } elseif ($brill_create_option === 'leads') {
            $brill_map_data['status'] = '1';
        }

        // Send to BD API
        $Brillforms_api_req = Brildir_Sfwbd_Send_To_Bd_api($brill_create_option, $brill_map_data, $brill_form_plugin, $brill_form_name);

        if ($Brillforms_api_req === "success") {
            // Increment sync count
            $current_count = (int) get_post_meta($post_id, '_brildir_sfwbd_sync_count', true);
            update_post_meta($post_id, '_brildir_sfwbd_sync_count', $current_count + 1);

            // Update last sync time
            update_post_meta($post_id, '_brildir_sfwbd_last_sync_date', current_time('mysql'));
        }
    }

    // Clean up query
    wp_reset_postdata();
}

add_action('wpforms_process_complete', 'Brildir_Sfwbd_Handle_WPForms_Submission', 10, 4);
function Brildir_Sfwbd_Handle_WPForms_Submission($fields, $entry, $form_data, $entry_id)
{
    $form_id = absint($form_data['id']);

    // Get all synced brillforms posts for WPForms
    $query = new WP_Query([
        'post_type'      => 'brildir-sfwbd',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'meta_query'     => [
            [
                'key'   => '_brildir_sfwbd_form_plugin',
                'value' => 'wpforms',
            ],
            [
                'key'   => '_brildir_sfwbd_form_id',
                'value' => $form_id,
            ],
        ],
        'no_found_rows'  => true,
        'fields'         => 'all',
    ]);

    if (!$query->have_posts()) {
        return;
    }

    foreach ($query->posts as $brillsync_form) {
        $post_id = $brillsync_form->ID;

        $brill_create_option = get_post_meta($post_id, '_brildir_sfwbd_create_option', true);
        $brill_field_map = get_post_meta($post_id, '_brildir_sfwbd_field_map', true);
        $brill_custom_field_map = get_post_meta($post_id, '_brildir_sfwbd_field_map_custom', true);
        $brill_form_plugin = 'WPForms';
        $brill_form_name = get_post_meta($post_id, '_brildir_sfwbd_form_title', true);

        // Get the specific form mapping
        $brill_form_mapping = $brill_field_map[$form_id] ?? [];

        $brill_map_data = [];

        // Process mapped fields
        foreach ($brill_form_mapping as $form_field => $bd_field) {
            foreach ($fields as $field_id => $field_data) {
                if ((string) $field_id === (string) $form_field) {
                    $brill_map_data[$bd_field] = sanitize_text_field($field_data['value']);
                }
            }
        }

        // Add custom fields
        if (!is_array($brill_custom_field_map)) {
            $brill_custom_field_map = [];
        }

        foreach ($brill_custom_field_map as $brill_field_key => $brill_field_value) {
            foreach ($brill_field_value as $brill_cus_key => $brill_cus_value) {
                $brill_map_data[$brill_cus_key] = $brill_cus_value;
            }
        }

        // Add subscription ID or status
        if ($brill_create_option === 'user') {
            $brill_subscription_id = get_post_meta($post_id, '_brildir_sfwbd_subscription_id', true);
            if (!empty($brill_subscription_id)) {
                $brill_map_data['subscription_id'] = sanitize_text_field($brill_subscription_id);
            }
        } elseif ($brill_create_option === 'leads') {
            $brill_map_data['status'] = '1';
        }

        // Send to BD API
        $Brillforms_api_req = Brildir_Sfwbd_Send_To_Bd_api($brill_create_option, $brill_map_data, $brill_form_plugin, $brill_form_name);

        if ($Brillforms_api_req === "success") {
            // Sync count
            $current_count = (int) get_post_meta($post_id, '_brildir_sfwbd_sync_count', true);
            update_post_meta($post_id, '_brildir_sfwbd_sync_count', $current_count + 1);

            // Last sync timestamp
            update_post_meta($post_id, '_brildir_sfwbd_last_sync_date', current_time('mysql'));
        }
    }
    wp_reset_postdata();
}


add_action('ninja_forms_after_submission', 'Brildir_Sfwbd_Handle_NinjaForms_Submission', 10, 1);
function Brildir_Sfwbd_Handle_NinjaForms_Submission($form_data) {
    if (empty($form_data) || !isset($form_data['form_id'])) {
        return;
    }

    $form_id = absint($form_data['form_id']);
    $fields  = isset($form_data['fields']) ? $form_data['fields'] : [];

    // Gather submitted fields by field ID
    $submitted_fields = [];
    foreach ($fields as $field) {
        $field_id = (int) $field['id'];
        $value    = isset($field['value']) ? $field['value'] : '';

        // Handle multi-value fields like checkboxes
        if (is_array($value)) {
            $value = implode(', ', array_map('sanitize_text_field', $value));
        } else {
            $value = sanitize_text_field($value);
        }

        $submitted_fields[$field_id] = $value;
    }

    // Query Brillform sync posts for this form
    $query = new WP_Query([
        'post_type'      => 'brildir-sfwbd',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'meta_query'     => [
            [
                'key'   => '_brildir_sfwbd_form_plugin',
                'value' => 'ninjaform',
            ],
            [
                'key'   => '_brildir_sfwbd_form_id',
                'value' => $form_id,
            ],
        ],
        'no_found_rows'  => true,
    ]);

    if (!$query->have_posts()) {
        return;
    }

    foreach ($query->posts as $brillsync_form) {
        $post_id               = $brillsync_form->ID;
        $brill_create_option   = get_post_meta($post_id, '_brildir_sfwbd_create_option', true);
        $brill_field_map       = get_post_meta($post_id, '_brildir_sfwbd_field_map', true);
        $brill_custom_map      = get_post_meta($post_id, '_brildir_sfwbd_field_map_custom', true);
        $brill_form_plugin     = 'NinjaForm';
        $brill_form_name       = get_post_meta($post_id, '_brildir_sfwbd_form_title', true);

        $field_map             = isset($brill_field_map[$form_id]) ? $brill_field_map[$form_id] : [];

        $brill_map_data = [];

        // Field Mapping from ID to Brilliant Directories key
        foreach ($submitted_fields as $field_id => $field_value) {
            if (isset($field_map[$field_id])) {
                $brill_field_key = $field_map[$field_id];
                $brill_map_data[$brill_field_key] = $field_value;
            }
        }

        // Handle any custom static mappings
        if (is_array($brill_custom_map)) {
            foreach ($brill_custom_map as $group) {
                foreach ($group as $custom_key => $custom_value) {
                    $brill_map_data[$custom_key] = sanitize_text_field($custom_value);
                }
            }
        }

        // Add subscription ID or status depending on option
        if ($brill_create_option === 'user') {
            $subscription_id = get_post_meta($post_id, '_brildir_sfwbd_subscription_id', true);
            if (!empty($subscription_id)) {
                $brill_map_data['subscription_id'] = sanitize_text_field($subscription_id);
            }
        } elseif ($brill_create_option === 'leads') {
            $brill_map_data['status'] = '1';
        }

        // Send to Brilliant Directories API
        $api_result = Brildir_Sfwbd_Send_To_Bd_api($brill_create_option, $brill_map_data, $brill_form_plugin, $brill_form_name);

        if ($api_result === 'success') {
            // Increment sync count
            $current_count = (int) get_post_meta($post_id, '_brildir_sfwbd_sync_count', true);
            update_post_meta($post_id, '_brildir_sfwbd_sync_count', $current_count + 1);

            // Update sync timestamp
            update_post_meta($post_id, '_brildir_sfwbd_last_sync_date', current_time('mysql'));
        }
    }

    wp_reset_postdata();
}


add_action('gform_after_submission', 'Brildir_Sfwbd_Handle_GF_Submission', 10, 2);
function Brildir_Sfwbd_Handle_GF_Submission($entry, $form)
{
    $form_id = absint($form['id']);

    // Get all synced brillforms posts for Gravity Forms
    $query = new WP_Query([
        'post_type'      => 'brildir-sfwbd',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'meta_query'     => [
            [
                'key'   => '_brildir_sfwbd_form_plugin',
                'value' => 'gform',
            ],
            [
                'key'   => '_brildir_sfwbd_form_id',
                'value' => $form_id,
            ],
        ],
        'no_found_rows'  => true,
        'fields'         => 'all',
    ]);

    if (!$query->have_posts()) {
        return;
    }

    foreach ($query->posts as $brillsync_form) {
        $post_id = $brillsync_form->ID;

        $brill_create_option     = get_post_meta($post_id, '_brildir_sfwbd_create_option', true);
        $brill_field_map         = get_post_meta($post_id, '_brildir_sfwbd_field_map', true);
        $brill_custom_field_map  = get_post_meta($post_id, '_brildir_sfwbd_field_map_custom', true);
        $brill_form_plugin       = 'Gravity Forms';
        $brill_form_name         = get_post_meta($post_id, '_brildir_sfwbd_form_title', true);

        // Get mapping for this form
        $brill_form_mapping = $brill_field_map[$form_id] ?? [];

        $brill_map_data = [];

        foreach ($brill_form_mapping as $form_field_id => $bd_field) {
            if (!isset($entry[$form_field_id])) {
                continue;
            }

            $value = $entry[$form_field_id];

            // Handle serialized list values (e.g. "list" field)
            if (is_serialized($value)) {
                $unserialized = maybe_unserialize($value);
                if (is_array($unserialized)) {
                    $value = implode(', ', array_map('sanitize_text_field', $unserialized));
                }
            }

            // Handle JSON string (e.g. multi-select field)
            elseif (is_string($value) && ($decoded = json_decode($value, true)) && is_array($decoded)) {
                $value = implode(', ', array_map('sanitize_text_field', $decoded));
            }

            // Handle checkbox values — sometimes returned as array
            elseif (is_array($value)) {
                $value = implode(', ', array_map('sanitize_text_field', $value));
            }

            $brill_map_data[$bd_field] = sanitize_text_field($value);
        }

        // Add custom fields
        if (is_array($brill_custom_field_map)) {
            foreach ($brill_custom_field_map as $custom_group) {
                foreach ($custom_group as $brill_cus_key => $brill_cus_value) {
                    $brill_map_data[$brill_cus_key] = sanitize_text_field($brill_cus_value);
                }
            }
        }

        // Add subscription/status if needed
        if ($brill_create_option === 'user') {
            $subscription_id = get_post_meta($post_id, '_brildir_sfwbd_subscription_id', true);
            if (!empty($subscription_id)) {
                $brill_map_data['subscription_id'] = sanitize_text_field($subscription_id);
            }
        } elseif ($brill_create_option === 'leads') {
            $brill_map_data['status'] = '1';
        }

        // Send to Brilliant Directories
        $Brillforms_api_req = Brildir_Sfwbd_Send_To_Bd_api($brill_create_option, $brill_map_data, $brill_form_plugin, $brill_form_name);

        if ($Brillforms_api_req === 'success') {
            // Update sync count
            $current_count = (int) get_post_meta($post_id, '_brildir_sfwbd_sync_count', true);
            update_post_meta($post_id, '_brildir_sfwbd_sync_count', $current_count + 1);

            // Update last sync time
            update_post_meta($post_id, '_brildir_sfwbd_last_sync_date', current_time('mysql'));
        }
    }

    wp_reset_postdata();
}

add_action('elementor_pro/forms/new_record', 'Brildir_Handle_Elementor_Submission', 10, 2);
function Brildir_Handle_Elementor_Submission($record, $handler) {

     $form_settings = $record->get('form_settings');
    if (empty($form_settings['form_name'])) {
        return;
    }

    $form_name = $form_settings['form_name'];
    $post_id   = get_the_ID();

    // Get raw field data with IDs like field_xxxx
    $raw_fields = $record->get('fields');
    $form_data = [];

    foreach ($raw_fields as $field) {
        $field_id = $field['id']; // e.g. field_8fa341f
        $value    = $field['value'];

        if (is_array($value)) {
            $value = implode(', ', array_map('sanitize_text_field', $value));
        }

        $form_data[$field_id] = sanitize_text_field($value);
    }

    // Unique form identifier: post_id + form_name
    $form_id_combined = $post_id . ':' . $form_name;

    // Get all synced brillforms posts for Elementor
    $query = new WP_Query([
        'post_type'      => 'brildir-sfwbd',
        'posts_per_page' => -1,
        'post_status'    => 'publish',
        'meta_query'     => [
            [
                'key'   => '_brildir_sfwbd_form_plugin',
                'value' => 'elementor',
            ],
            [
                'key'   => '_brildir_sfwbd_form_id',
                'value' => $form_id_combined,
            ],
        ],
        'no_found_rows'  => true,
        'fields'         => 'all',
    ]);

    if (!$query->have_posts()) {
        return;
    }

    foreach ($query->posts as $brillsync_form) {
        $post_id = $brillsync_form->ID;

        $brill_create_option     = get_post_meta($post_id, '_brildir_sfwbd_create_option', true);
        $brill_field_map         = get_post_meta($post_id, '_brildir_sfwbd_field_map', true);
        $brill_custom_field_map  = get_post_meta($post_id, '_brildir_sfwbd_field_map_custom', true);
        $brill_form_plugin       = 'Elementor';
        $brill_form_name         = get_post_meta($post_id, '_brildir_sfwbd_form_title', true);

        $brill_form_mapping = $brill_field_map[$form_id_combined] ?? [];

        $brill_map_data = [];

        foreach ($brill_form_mapping as $form_field_id => $bd_field) {
            if (!isset($form_data[$form_field_id])) {
                continue;
            }

            $value = $form_data[$form_field_id];
            $brill_map_data[$bd_field] = sanitize_text_field($value);
        }

        // Add static custom fields
        if (is_array($brill_custom_field_map)) {
            foreach ($brill_custom_field_map as $custom_group) {
                foreach ($custom_group as $key => $val) {
                    $brill_map_data[$key] = sanitize_text_field($val);
                }
            }
        }

        // Subscription or lead-specific logic
        if ($brill_create_option === 'user') {
            $subscription_id = get_post_meta($post_id, '_brildir_sfwbd_subscription_id', true);
            if (!empty($subscription_id)) {
                $brill_map_data['subscription_id'] = sanitize_text_field($subscription_id);
            }
        } elseif ($brill_create_option === 'leads') {
            $brill_map_data['status'] = '1';
        }

        // Send to BD API
        $Brillforms_api_req = Brildir_Sfwbd_Send_To_Bd_api($brill_create_option, $brill_map_data, $brill_form_plugin, $brill_form_name);

        if ($Brillforms_api_req === 'success') {
            // Sync stats
            $current_count = (int) get_post_meta($post_id, '_brildir_sfwbd_sync_count', true);
            update_post_meta($post_id, '_brildir_sfwbd_sync_count', $current_count + 1);
            update_post_meta($post_id, '_brildir_sfwbd_last_sync_date', current_time('mysql'));
        }
    }

    wp_reset_postdata();
}



function Brildir_Sfwbd_Send_To_Bd_api($brill_create_type, $brill_map_data, $brill_form_plugin, $brill_form_name)
{
    $bd_encryptedApiKey = get_option('brildir_sfwbd_api_key');
    $bd_api_key = $bd_encryptedApiKey ? Brildir_Sfwbd_Decrypt_Api_key($bd_encryptedApiKey) : '';
    $bd_api_url = get_option('brildir_sfwbd_base_url');
    $brillforms_api_status = get_option('brildir_sfwbd_api_status');
    $brillforms_allow_lead = get_option('brildir_sfwbd_allow_lead');

    if ($brillforms_api_status === 'invalid') {
        $error_message = 'Invalid API credentials.';
        Brildir_Sfwbd_Log_Api_error($brill_create_type, $brill_form_plugin, $brill_form_name, $error_message);
        return;
    }

    if ($brill_create_type === 'user') {
        $bd_customer_email = $brill_map_data['email'];
    } elseif ($brill_create_type === 'leads') {
        $bd_customer_email = $brill_map_data['lead_email'];
    }
    

    $bd_customer_password = '';
    if ($brill_create_type === 'user') {
        $bd_customer_email = $brill_map_data['email'];
        $bd_email_prefix = explode('@', $bd_customer_email)[0];
        $bd_customer_password = $bd_email_prefix . '@BD' . gmdate("Y");
        $brill_map_data['password'] = $bd_customer_password;
    }

    $search_url = rtrim($bd_api_url, '/') . '/api/v2/' . $brill_create_type .'/get';

    if ($brill_create_type === 'user') {
        $search_url = add_query_arg(
            array(
                'X-Api-Key' => $bd_api_key,
                'property'  => 'email',
                'property_value' => $bd_customer_email,
            ), 
            $search_url
        );
    } elseif ($brill_create_type === 'leads') {
        $search_url = add_query_arg(
            array(
                'X-Api-Key' => $bd_api_key,
                'property'  => 'lead_email',
                'property_value' => $bd_customer_email,
            ), 
            $search_url
        );
    }

    $search_args = array(
        'headers'     => array(
            'x-api-key' => $bd_api_key,
            'Content-Type' => 'application/x-www-form-urlencoded',
        ),
        'timeout'     => 60,
        'sslverify'   => false,
    );

    $search_response = wp_remote_get($search_url, $search_args);

    $search_body = wp_remote_retrieve_body($search_response);
    $search_data = json_decode($search_body, true);

    if (isset($search_data['message']) && is_array($search_data['message'])) {
        $existing_user = $search_data['message'][0];
        if ($brill_create_type === 'user') {
            if (strtolower($existing_user['email']) === strtolower($bd_customer_email)) {
                $error_message = 'The ' . $bd_customer_email . ' Email already exists';
                Brildir_Sfwbd_Log_Api_error($brill_create_type, $brill_form_plugin, $brill_form_name, $error_message);
                return;
            }
        } elseif ($brill_create_type === 'leads') {
            if ($brillforms_allow_lead === 'no'){
                if (strtolower($existing_user['lead_email']) === strtolower($bd_customer_email)) {
                    $error_message = 'The ' . $bd_customer_email . ' Email already exists';
                    Brildir_Sfwbd_Log_Api_error($brill_create_type, $brill_form_plugin, $brill_form_name, $error_message);
                    return;
                }
            }   
        } else {
        }
    }

    $url = rtrim($bd_api_url, '/') . '/api/v2/' . $brill_create_type . '/create';

    $args = array(
        'body'        => http_build_query($brill_map_data),
        'headers'     => array(
            'x-api-key' => $bd_api_key,
            'Content-Type' => 'application/x-www-form-urlencoded',
        ),
        'timeout'     => 60,
        'sslverify'   => false,
    );

    $response = wp_remote_post($url, $args);

    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    if (isset($data['status']) && $data['status'] == 'success') {
        return "success";
    } else {
        $error_message = $data['message'] ?? 'Unknown error';
        Brildir_Sfwbd_Log_Api_error($brill_create_type, $brill_form_plugin, $brill_form_name, $error_message);
        return "failure";
    }
}

function Brildir_Sfwbd_Log_Api_error($brill_create_type, $brill_form_plugin, $brill_form_name, $error_message)
{
    global $wpdb;
    $brill_log_table = $wpdb->prefix . 'brildir_sfwbd_error_log';

    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Using $wpdb->insert() for safe insertions
    $wpdb->insert(
        $brill_log_table, [
        'form_plugin'   => sanitize_text_field($brill_form_plugin),
        'form_id'       => sanitize_text_field($brill_form_name),
        'create_option' => sanitize_text_field($brill_create_type),
        'error_message' => sanitize_textarea_field($error_message),
        'created_at'    => current_time('mysql')
        ]
    );
}

