jQuery(document).ready(function($) {
    function debounce(fn, delay) {
        let timer;
        return function (...args) {
            clearTimeout(timer);
            timer = setTimeout(() => fn.apply(this, args), delay);
        };
    }
    const debouncedUpdateFieldMappingOptions = debounce(updateFieldMappingOptions, 200);
    $('.brill-additional-field-select .select2-selection__rendered').removeAttr('title');
    $('.brillforms-field-map-table .select2-selection__rendered').removeAttr('title');
    initializeAllSelect2Fields();
    
    

    if (window.location.href.includes('edit.php?post_type=brildir-sfwbd&page=brildir_sfwbd-settings&tab=general-settings') || window.location.href.includes('edit.php?post_type=brildir-sfwbd&page=brildir_sfwbd-settings')) {
        var apiKey = $('#brildir_sfwbd_api_key').val();
        var apiBaseUrl = $('#brildir_sfwbd_base_url').val();
        validateApiKey(apiKey, apiBaseUrl);
    }
    
    function validateApiKey(apiKey, apiBaseUrl) {
        $.ajax({
            url: brildirformsyncSettings.ajax_url,
            method: 'POST',
            data: {
                action: 'brildir_sfwbd_validate_api_key',
                brildir_sfwbd_api_key: apiKey,
                brildir_sfwbd_base_url: apiBaseUrl,
                brildir_sfwbd_settings_nonce: brildirformsyncSettings.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('.brillforms-api-valid').show();
                    $('.brillforms-api-invalid').hide();
                } else {
                    $('.brillforms-api-valid').hide();
                    $('.brillforms-api-invalid').show();
                }
            },
            error: function() {
                // alert('There was an error validating the API Key. Please try again.');
            }
        });
    }

    $('#brillforms-api-form').on('submit', function(e) {
        e.preventDefault();

        var apiKey = $('#brildir_sfwbd_api_key').val();
        var apiBaseUrl = $('#brildir_sfwbd_base_url').val();
        var validateKeybtn = $('#brillforms-api-form-btn');
        var settingSavedMsg = $('#swbd-saved-msg');
        validateKeybtn.prop('disabled', true);

        validateApiKey(apiKey, apiBaseUrl);

        $.ajax({
            url: brildirformsyncSettings.ajax_url,
            method: 'POST',
            data: {
                action: 'brildir_sfwbd_validate_api_key',
                brildir_sfwbd_api_key: apiKey,
                brildir_sfwbd_base_url: apiBaseUrl,
                brildir_sfwbd_settings_nonce: brildirformsyncSettings.nonce
            },
            success: function(response) {
                if (response.success) {
                    settingSavedMsg.show();
                    validateKeybtn.prop('disabled', false);
                    jQuery('#sync-settings-form')[0].submit();
                } else {
                    validateKeybtn.prop('disabled', false);
                    settingSavedMsg.show();
                }
            },
            error: function() {
                // alert('There was an error validating the API Key. Please try again.');
                validateKeybtn.prop('disabled', false);
            }
        });
    });

    const tooltips = [
        { id: 'label_brillforms_base_url', content: 'Enter URL of your Brilliant Directories website (https://example.brilliantdirectories.com). This is required to connect with the API.' },
        { id: 'label_brillforms_api', content: 'Paste API Key generated by your Brilliant Directories website to authenticate the connection.' },
        { id: 'brillforms_select_plugin_label', content: 'Choose the form plugin to use for this sync. Only active plugins on your WordPress site will appear.' },
        { id: 'brillforms_select_form_label', content: 'Choose the form from the selected plugin to sync. Only forms from the selected plugin will appear.' },
        { id: 'brillforms_select_wpforms_label', content: 'Choose the form from the selected plugin to sync. Only forms from the selected plugin will appear.' },
        { id: 'brillforms_ninjaforms_label', content: 'Choose the form from the selected plugin to sync. Only forms from the selected plugin will appear.' },
        { id: 'brillforms_gf_label', content: 'Choose the form from the selected plugin to sync. Only forms from the selected plugin will appear.' },
        { id: 'brillforms_elementor_label', content: 'Choose the form from the selected plugin to sync. Only forms from the selected plugin will appear.' },
        { id: 'brillforms_create_option_label', content: 'Select the type of record you want to create (e.g., Member, Lead). The same action for the same form cannot be created more than once.'},
        { id: 'brillforms_allow_lead_label', content: 'Select whether to allow multiple lead submissions from the same email address. If disabled, only one lead per email is allowed.' },
    ];

    tooltips.forEach(function(tooltip) {
        $('#' + tooltip.id).append(
            '<span class="brillforms-tooltip-icon">' +
            '<span class="brillforms-tooltip-text">' + tooltip.content + '</span></span>'
        );
    }); 

    $(document).on('mouseenter', '.brillforms-tooltip-icon', function() {
        $(this).next('.brillforms-tooltip-text').css({
            'visibility': 'visible',
            'opacity': '1'
        });
    });

    $(document).on('mouseleave', '.brillforms-tooltip-icon', function() {
        $(this).next('.brillforms-tooltip-text').css({
            'visibility': 'hidden',
            'opacity': '0'
        });
    });


    function brillhideformwrap(brillselectPlugin) {
        $('#brillforms_cf7_forms_wrap, #brillforms_wpforms_wrap', '#brillforms_ninjaforms_wrap', '#brillforms_gf_wrap', '#brillforms_elementor_wrap').hide();
        $('#brillforms_cf7_forms, #brillforms_wpforms_forms', '#brillforms_ninja_forms', '#brillforms_gf_forms', '#brillforms_elementor_forms').prop('disabled', true);

        if (brillselectPlugin === 'contact_form_7') {
            $('#brillforms_wpforms_wrap').hide();
            $('#brillforms_ninjaforms_wrap').hide();
            $('#brillforms_gf_wrap').hide();
            $('#brillforms_elementor_wrap').hide();
            $('#brillforms_cf7_forms_wrap').show();
            $('#brillforms_wpforms_forms').prop('disabled', true);
            $('#brillforms_ninja_forms').prop('disabled', true);
            $('#brillforms_gf_forms').prop('disabled', true);
            $('#brillforms_elementor_forms').prop('disabled', true);
            $('#brillforms_cf7_forms').prop('disabled', false);
        } else if (brillselectPlugin === 'wpforms') {
            $('#brillforms_ninjaforms_wrap').hide();
            $('#brillforms_cf7_forms_wrap').hide();
            $('#brillforms_gf_wrap').hide();
            $('#brillforms_elementor_wrap').hide();
            $('#brillforms_wpforms_wrap').show();
            $('#brillforms_cf7_forms').prop('disabled', true);
            $('#brillforms_ninja_forms').prop('disabled', true);
            $('#brillforms_gf_forms').prop('disabled', true);
            $('#brillforms_elementor_forms').prop('disabled', true);
            $('#brillforms_wpforms_forms').prop('disabled', false);
        }else if (brillselectPlugin === 'ninjaform') {
            $('#brillforms_cf7_forms_wrap').hide();
            $('#brillforms_wpforms_wrap').hide();
            $('#brillforms_gf_wrap').hide();
            $('#brillforms_elementor_wrap').hide();
            $('#brillforms_ninjaforms_wrap').show();
            $('#brillforms_cf7_forms').prop('disabled', true);
            $('#brillforms_wpforms_forms').prop('disabled', true);
            $('#brillforms_gf_forms').prop('disabled', true);
            $('#brillforms_elementor_forms').prop('disabled', true);
            $('#brillforms_ninja_forms').prop('disabled', false);
        }else if (brillselectPlugin === 'gform') {
            $('#brillforms_cf7_forms_wrap').hide();
            $('#brillforms_wpforms_wrap').hide();
            $('#brillforms_ninjaforms_wrap').hide();
            $('#brillforms_elementor_wrap').hide();
            $('#brillforms_gf_wrap').show();
            $('#brillforms_cf7_forms').prop('disabled', true);
            $('#brillforms_wpforms_forms').prop('disabled', true);
            $('#brillforms_ninja_forms').prop('disabled', true);
            $('#brillforms_elementor_forms').prop('disabled', true);
            $('#brillforms_gf_forms').prop('disabled', false);
        }else if (brillselectPlugin === 'elementor') {
            $('#brillforms_cf7_forms_wrap').hide();
            $('#brillforms_wpforms_wrap').hide();
            $('#brillforms_ninjaforms_wrap').hide();
            $('#brillforms_gf_wrap').hide();
            $('#brillforms_elementor_wrap').show();
            $('#brillforms_cf7_forms').prop('disabled', true);
            $('#brillforms_wpforms_forms').prop('disabled', true);
            $('#brillforms_ninja_forms').prop('disabled', true);
            $('#brillforms_gf_forms').prop('disabled', true);
            $('#brillforms_elementor_forms').prop('disabled', false);
        }
    }

    $('#brillforms_form_plugin').on('change', function () {
        $('#brillforms_cf7_forms, #brillforms_wpforms_forms', '#brillforms_ninja_forms', '#brillforms_gf_forms', '#brillforms_elementor_forms').val('');
        const brillselectedPlugin = $(this).val();
        brillhideformwrap(brillselectedPlugin);
    });

    const brillinitialcheckPlugin = $('#brillforms_form_plugin').val();
    brillhideformwrap(brillinitialcheckPlugin);


    var brillforms_create_option = $('#brillforms_create_option').val();
    if(brillforms_create_option === 'user'){
        $('#brill_plan_id').show();
    }else if (brillforms_create_option === 'leads'){
        $('#brill_plan_id').hide();
    }else{
        $('#brill_plan_id').hide();
    }

    $('#brillforms_cf7_forms').on('change', function () {
        $('#brillforms_create_option').val('');
        $('#brillforms_fields_wrap').html('');
        $('#brill_plan_id').hide();
    });
    $('#brillforms_wpforms_forms').on('change', function () {
        $('#brillforms_create_option').val('');
        $('#brillforms_fields_wrap').html('');
        $('#brill_plan_id').hide();
    });
    $('#brillforms_ninja_forms').on('change', function () {
        $('#brillforms_create_option').val('');
        $('#brillforms_fields_wrap').html('');
        $('#brill_plan_id').hide();
    });
    $('#brillforms_gf_forms').on('change', function () {
        $('#brillforms_create_option').val('');
        $('#brillforms_fields_wrap').html('');
        $('#brill_plan_id').hide();
    });
    $('#brillforms_elementor_forms').on('change', function () {
        $('#brillforms_create_option').val('');
        $('#brillforms_fields_wrap').html('');
        $('#brill_plan_id').hide();
    });

    $('#brillforms_create_option').on('change', function () {
        var brill_create_option = $(this).val();
        if(brill_create_option === 'user'){
            $('#brill_plan_id').show();   
        }else if (brill_create_option === 'leads'){
            $('#brill_plan_id').hide();  
        }else{
            $('#brill_plan_id').hide();
        }
        var brill_plugin = $('#brillforms_form_plugin').val();
        if(brill_plugin === 'contact_form_7'){
            var formId = $('#brillforms_cf7_forms').val();
        } else if(brill_plugin === 'wpforms'){
            var formId = $('#brillforms_wpforms_forms').val();
        } else if(brill_plugin === 'ninjaform'){
            var formId = $('#brillforms_ninja_forms').val();
        } else if(brill_plugin === 'gform'){
            var formId = $('#brillforms_gf_forms').val();
        } else if(brill_plugin === 'elementor'){
            var formId = $('#brillforms_elementor_forms').val();
        }

        var createOption = $('#brillforms_create_option').val();

        $.ajax({
            url: brildirformsyncSettings.ajax_url,
            type: 'POST',
            data: {
                action: 'brildir_sfwbd_load_cf7_form_fields',
                brill_plugin : brill_plugin,
                form_id: formId,
                post_id: $('#post_ID').val(),
                create_option: createOption,
                brildir_sfwbd_settings_nonce: brildirformsyncSettings.nonce
            },
            success: function (response) {
                if(brill_create_option){
                    $('#brillforms_fields_wrap').html(response);
                    $('.brillforms-field-map-table .select2-selection__rendered').removeAttr('title');
                    initializeAllSelect2Fields();
                    initializeBrillformsTooltips();
                }else{
                    $('#brillforms_fields_wrap').html('');
                }
            },
            error: function () {
                $('#brillforms_fields_wrap').html('<p><em>Error loading fields.</em></p>');
            }
        });
    });
    
    const selectedPlugin = $('#brillforms_form_plugin').val();
    if (selectedPlugin === 'contact_form_7') {
        $('#brillforms_wpforms_wrap').hide();
        $('#brillforms_ninjaforms_wrap').hide();
        $('#brillforms_gf_wrap').hide();
        $('#brillforms_elementor_wrap').hide();
        $('#brillforms_cf7_forms_wrap').show();
        $('#brillforms_create_option').trigger('change');
    }else if (selectedPlugin === 'wpforms') {
        $('#brillforms_cf7_forms_wrap').hide();
        $('#brillforms_ninjaforms_wrap').hide();
        $('#brillforms_gf_wrap').hide();
        $('#brillforms_elementor_wrap').hide();
        $('#brillforms_wpforms_wrap').show();
        $('#brillforms_create_option').trigger('change');
    }else if (selectedPlugin === 'ninjaform') {
        $('#brillforms_cf7_forms_wrap').hide();
        $('#brillforms_wpforms_wrap').hide();
        $('#brillforms_gf_wrap').hide();
        $('#brillforms_elementor_wrap').hide();
        $('#brillforms_ninjaforms_wrap').show();
        $('#brillforms_create_option').trigger('change');
    }else if (selectedPlugin === 'gform') {
        $('#brillforms_cf7_forms_wrap').hide();
        $('#brillforms_wpforms_wrap').hide();
        $('#brillforms_ninjaforms_wrap').hide();
        $('#brillforms_elementor_wrap').hide();
        $('#brillforms_gf_wrap').show();
        $('#brillforms_create_option').trigger('change');
    }else if (selectedPlugin === 'elementor') {
        $('#brillforms_cf7_forms_wrap').hide();
        $('#brillforms_wpforms_wrap').hide();
        $('#brillforms_ninjaforms_wrap').hide();
        $('#brillforms_gf_wrap').hide();
        $('#brillforms_elementor_wrap').show();
        $('#brillforms_create_option').trigger('change');
    }else {
        $('#brillforms_cf7_forms_wrap').hide();
        $('#brillforms_ninjaforms_wrap').hide();
        $('#brillforms_wpforms_wrap').hide();
        $('#brillforms_gf_wrap').hide();
        $('#brillforms_elementor_wrap').hide();
    }
    
    function appendCustomOptionContainer($dropdown) {
        const html = `
            <div class="brill-custom-option-container" id="brill-custom-option-container">
                <input type="text" id="brill_custom_option_input" placeholder="Enter custom field name">
                <button type="button" id="brill_add_custom_option">Add</button>
            </div>
        `;
        $dropdown.find('.select2-results').append(html);

        $('#brill-custom-option-container').css({
            position: 'absolute',
            bottom: '-40px',
            width: '100%',
            background: '#fff',
            padding: '5px 0',
            'border-top': '1px solid #ddd',
            'z-index': '10',
        });

        $('#brill_custom_option_input').off('keydown').on('keydown', function (e) {
            const key = e.key;
            const inputValue = $(this).val();

            if (inputValue.length === 0 && /[0-9]/.test(key)) {
                e.preventDefault();
            }
            if (!/^[a-zA-Z0-9_]$/.test(key) && key !== 'Backspace') {
                e.preventDefault();
            }
        });
    }

    function initializeAllSelect2Fields() {
        $('.brillforms_lead_fields').each(function () {
            const $select = $(this);
    
            // Destroy existing
            if ($select.hasClass('select2-hidden-accessible')) {
                $select.select2('destroy');
            }
    
            $select.select2({
                width: '100%',
                placeholder: 'Select Variable to Map',
                allowClear: true,
                minimumResultsForSearch: 0,
                dropdownParent: $select.closest('td, .brill-additional-field-row'),
            });
    
            $select.on('select2:open', function () {
                requestAnimationFrame(() => {
                    const dropdown = $(this).data('select2').dropdown.$dropdown;
                    if (!dropdown.find('#brill-custom-option-container').length) {
                        appendCustomOptionContainer(dropdown);
                    }
                });
            });

            $('.brillforms-field-map-table .select2-selection__rendered').removeAttr('title');
            debouncedUpdateFieldMappingOptions();
        });
    }

    let suppressDropdown = false;
    // Prevent dropdown from opening immediately after clearing
    $(document).on('select2:opening', '.brillforms_lead_fields', function (e) {
        if (suppressDropdown) {
            e.preventDefault(); // Block dropdown
            suppressDropdown = false; // Reset flag
        }
    });

    $(document).on('select2:clear', '.brillforms_lead_fields', function () {
        suppressDropdown = true;
        $(this).val('skip').trigger('change');
    });
    $(document).on('select2:clear', '.brill-additional-field-row .brillforms_lead_fields', function () {
        suppressDropdown = true;
        $(this).val('').trigger('change');
    });

    $(document).on('select2:open', '.brillforms_lead_fields', function () {
        requestAnimationFrame(() => {
            const dropdown = $(this).data('select2').dropdown.$dropdown;
            if (!dropdown.find('#brill-custom-option-container').length) {
                appendCustomOptionContainer(dropdown);
            }
        });
        debouncedUpdateFieldMappingOptions();
    });

    $(document).on('click', '#add-additional-mapping-field', function () {
        const index = Date.now() + Math.floor(Math.random() * 1000); // Ensure unique ID by adding randomness
        const selectedValues = [];

        // Collect all selected values across all selects
        $('.brillforms_lead_fields').each(function () {
                const val = $(this).val();
                if (val) {
                    selectedValues.push(val);
                }
        });

        // Rebuild options dynamically based on previous selections
        const $firstSelect = $('.brillforms_lead_fields').first();
        const $options = $firstSelect.find('option');

        let requiredFieldsHTML = '';
        let additionalFieldsHTML = '';
        let customFieldsHTML = ''; // To hold custom fields HTML

        $options.each(function () {
            const value = $(this).val();
            const label = $(this).text();
            if (!value) {
                return; // Skip empty values
            }

        // If already selected elsewhere, disable it
        const disabled = selectedValues.includes(value) ? 'disabled' : '';

        // If the option is part of Required Fields, add to requiredFieldsHTML
        if ($(this).closest('optgroup').attr('label') === 'Required Mapping Fields') {
            requiredFieldsHTML += `<option value="${value}" ${disabled}>${label}</option>`;
        } 
        // If the option is part of Additional Fields, add to additionalFieldsHTML
        else if ($(this).closest('optgroup').attr('label') === 'Additional Fields') {
            additionalFieldsHTML += `<option value="${value}" ${disabled}>${label}</option>`;
        } 
        // If it's neither of the above, it belongs to Custom Variable
        else {
            // Only add to custom if not already part of required or additional fields
            if (!selectedValues.includes(value)  && value !== 'skip') {
                customFieldsHTML += `<option value="${value}" ${disabled}>${label}</option>`;
            }
        }
    });

    // Create the new field and append it
    let  newFieldHTML = `
        <div class="brill-additional-field-row">
            <div class="brill-additional-field-delete">
                <span class="brill-del-custom-field" data-index="${index}"><span aria-hidden="true" class="dashicons dashicons-trash"></span></span>
            </div>
            <div class="brill-additional-field-select">
                <select class="brillforms_lead_fields" name="brildir_sfwbd_field_map_custom[${index}][map_to]" style="width: 250px;">
                    <option value="">Select Variable to Map</option>`;

                    if(customFieldsHTML){
                        newFieldHTML += `<optgroup label="Custom Variable"> ${customFieldsHTML} <!-- Add Custom Variable fields here -->
                    </optgroup>`;
                    }
                    if(requiredFieldsHTML){
                        newFieldHTML += `<optgroup label="Required Mapping Fields">${requiredFieldsHTML}</optgroup>`;
                    }
                    if(additionalFieldsHTML){
                    newFieldHTML += `<optgroup label="Additional Fields">${additionalFieldsHTML}</optgroup>`;
                    }
                    newFieldHTML += `
                </select>
            </div>
            <div class="brill-additional-field-input">
                <input type="text" id="brill_additional_input_${index}" name="brildir_sfwbd_field_map_custom[${index}][name]" placeholder="Enter Value to Pass" required />
            </div>
        </div>
    `;

    // Append the new field to the container
    $('#additional-mapping-fields-container').append(newFieldHTML);

        // Initialize Select2 for the new select field
        const $newSelect = $('#brill_additional_input_' + index).closest('.brill-additional-field-row').find('select');
        $newSelect.select2({
            width: '100%',
            placeholder: 'Select Variable to Map',
            allowClear: true,
            minimumResultsForSearch: 0,
            dropdownParent: $newSelect.closest('td, .brill-additional-field-row')
        });
        
        $newSelect.on('select2:clear', function () {
            $(this).val('').trigger('change');
        });
        // Update all dropdowns to reflect current selections
        setTimeout(() => {
            debouncedUpdateFieldMappingOptions();
        }, 100);
    });

    $(document).on('click', '.brill-del-custom-field', function() {
        const index = $(this).data('index');
        $(`#brill_additional_input_${index}`).closest('.brill-additional-field-row').remove();
        $(`[data-index="${index}"]`).remove();
        debouncedUpdateFieldMappingOptions();
    });


    // Custom option handler
    $(document).on('click', '#brill_add_custom_option', function () {
        const input = $('#brill_custom_option_input');
        const value = input.val().trim();

        if (value) {
            const $openSelect = $('.select2-container--open').prev('select');

            // Check if the value already exists in the "Custom Variable" optgroup
            const existingOption = $openSelect.find('optgroup[label="Custom Variable"] option[value="' + value + '"]');

            if (existingOption.length > 0) {
                $('#brill_same_map_err').show();
                $('#brill_same_map_err').html(`The ${value} Custom Variable has already been added!`);
                return; // Exit if the value already exists
            } else{
                $('#brill_same_map_err').hide();
            }

            // Destroy and reinitialize select2
            $openSelect.select2('destroy');

            // Create a new option for the custom value
            const newOption = new Option(value, value, false, false);

            // Check if the "Custom Variable" optgroup exists
            let $customOptgroup = $openSelect.find('optgroup[label="Custom Variable"]');

            // If it doesn't exist, create it
            if ($customOptgroup.length === 0) {
                $customOptgroup = $('<optgroup>', {
                    label: 'Custom Variable'
                });

                // Append the new optgroup at the top or bottom of the dropdown (depends on your preference)
                $openSelect.find('optgroup').first().before($customOptgroup);
            }

             // Append the new option to the optgroup
            $customOptgroup.append(newOption);

            // Sort the options inside the Custom Variable optgroup alphabetically
            const $options = $customOptgroup.find('option');
            $options.sort((a, b) => a.text.localeCompare(b.text));

            $customOptgroup.empty().append($options);

            // Reinitialize select2 and set the new value
            $openSelect.select2({
                width: '100%',
                placeholder: 'Select Variable to Map',
                allowClear: true,
                minimumResultsForSearch: 0,
                dropdownParent: $openSelect.closest('td, .brill-additional-field-row')
            }).val(value).trigger('change');

            input.val('');
        } else {
            // alert('Please enter a custom option!');
        }
    });


    debouncedUpdateFieldMappingOptions();
    function updateFieldMappingOptions() {
        $('.brill-additional-field-select .select2-selection__rendered').removeAttr('title');
        $('.brillforms-field-map-table .select2-selection__rendered').removeAttr('title');
        
        // Step 1: Gather all selected values
        var bril_create_opt = $('#brillforms_create_option').val();
        const selectedValues = [];
        let requiredFields = 0;
        let requiredFieldsMapped = 0;
        
        // Define required fields based on bril_create_opt
        if (bril_create_opt === 'user') {
            requiredFields = ['email', 'active'];
        } else if (bril_create_opt === 'leads') {
            requiredFields = ['lead_email'];
        }
    
        $('.brill-lead-fields').each(function () {
            const val = $(this).val();

            const $container = $(this).next('.select2-container');
            if (val === 'skip') {
                $container.find('.select2-selection__clear').hide();
            }
            
            if (val) {
                selectedValues.push(val);
                // Check if the selected value is a required field
                if (requiredFields.includes(val)) {
                    requiredFieldsMapped++;
                }
            }
        });

        $(document).on('change', '.brillforms_lead_fields, .brill-additional-field-input input', function() {
            debouncedUpdateFieldMappingOptions(); // Trigger count update whenever a new value is selected or entered
        });

        $('.brill-additional-field-row .brillforms_lead_fields').each(function () {
            const $select = $(this);
            const selectedVal = $select.val();

            // Extract index from the select's name
            const nameAttr = $select.attr('name'); // e.g., brildir_sfwbd_field_map_custom[123456][map_to]
            const indexMatch = nameAttr.match(/\[(\d+)\]/);
            const index = indexMatch ? indexMatch[1] : null;

            let $input = $('#brill_additional_input_' + index);

            // If input not found by ID, fallback to finding it via the closest method
            if ($input.length === 0) {
                $input = $select.closest('.brill-additional-field-row').find('.brill-additional-field-input input');
            }

            // Get the input value (trimmed)
            let inputVal = $input.length ? $input.val().trim() : '';

            if (selectedVal) {
                selectedValues.push(selectedVal);

                // Only count required fields in dynamically added rows, and only if input is not empty
                if (requiredFields.includes(selectedVal) && inputVal !== '') {
                    requiredFieldsMapped++;
                }
            }
        });
    
        // Step 2: Disable selected values in other selects
        $('.brillforms_lead_fields').each(function () {
            const $currentSelect = $(this);
            const currentValue = $currentSelect.val();
    
            $currentSelect.find('option').each(function () {
                const $option = $(this);
                const optionValue = $option.val();
    
                if (!optionValue) return;
    
                // Allow the current value to remain selectable in this select
                if (optionValue === 'skip') {
                    $option.prop('disabled', false);
                } else {
                    // Disable the option if it's selected elsewhere
                    if (optionValue !== currentValue && selectedValues.includes(optionValue)) {
                        $option.prop('disabled', true);
                    } else {
                        $option.prop('disabled', false);
                    }
                }
            });
        });

        var totalRequiredFields = requiredFields.length;
        var requiredFieldsText = requiredFieldsMapped + '/' + totalRequiredFields + ' Required Fields Mapped';
        var requiredFieldsCountElem = $('#requiredFieldsCount');

        if(totalRequiredFields){
            requiredFieldsCountElem.text(requiredFieldsText);
        }
        if (requiredFieldsMapped === totalRequiredFields) {
            requiredFieldsCountElem.css('background', ' rgb(0, 128, 0)');
        } else {
            requiredFieldsCountElem.css('background', 'rgb(214, 54, 56)');
        }
    }

    // Bind change handler
    $(document).on('change', '.brillforms_lead_fields', function () {
        debouncedUpdateFieldMappingOptions();
    });
    
    // $('.brillforms_lead_fields').trigger('change.select2');

    const $cfformSelect = $('#brillforms_cf7_forms');
    const $wpformSelect = $('#brillforms_wpforms_forms');
    const $ninjaformSelect = $('#brillforms_ninja_forms');
    const $gfformSelect = $('#brillforms_gf_forms');
    const $elementorformSelect = $('#brillforms_elementor_forms');
    const $actionSelect = $('#brillforms_create_option');
    var post_id = brildirformsyncSettings.post_id;

    function updateCreateOptions(usedActions) {
        $actionSelect.find('option').each(function () {
            const $option = $(this);
            const value = $option.val();
            const originalText = $option.data('original-text') || $option.text(); // Preserve original

            $option.data('original-text', originalText); // Store it for future resets
            $option.prop('disabled', false); // Reset disabled state
            $option.text(originalText);      // Reset text

            if (usedActions.includes(value)) {
                if (!$option.is(':selected')) {
                    $option.prop('disabled', true);
                    $option.text(originalText + ' (Unavailable - Already used with selected form)');
                }
            }
        });
    }


    function fetchUsedActions(formId) {
        var pluginname = $('#brillforms_form_plugin').val();
        $.ajax({
            url: brildirformsyncSettings.ajax_url,
            type: 'POST',
            dataType: 'json',
            data: {
                action: 'brildir_sfwbd_check_form_actions',
                form_id: formId,
                post_id: post_id,
                plugin_name: pluginname,
                brildir_sfwbd_settings_nonce: brildirformsyncSettings.nonce
            },
            success: function (response) {
                if (response.success && response.data.used_actions) {
                    updateCreateOptions(response.data.used_actions);
                }
            },
            error: function (xhr, status, error) {
                console.error('AJAX error:', error);
            }
        });
    }

    // Initial check
    if ($cfformSelect.val()) {
        fetchUsedActions($cfformSelect.val());
    }

    // Re-check on form change
    $cfformSelect.on('change', function () {
        const formId = $(this).val();
        if (formId) {
            fetchUsedActions(formId);
        }
    });

    // Initial check
    if ($wpformSelect.val()) {
        fetchUsedActions($wpformSelect.val());
    }

    // Re-check on form change
    $wpformSelect.on('change', function () {
        const formId = $(this).val();
        if (formId) {
            fetchUsedActions(formId);
        }
    });

    if ($ninjaformSelect.val()) {
        fetchUsedActions($ninjaformSelect.val());
    }

    // Re-check on form change
    $ninjaformSelect.on('change', function () {
        const formId = $(this).val();
        if (formId) {
            fetchUsedActions(formId);
        }
    });

    if ($gfformSelect.val()) {
        fetchUsedActions($gfformSelect.val());
    }

    // Re-check on form change
    $gfformSelect.on('change', function () {
        const formId = $(this).val();
        if (formId) {
            fetchUsedActions(formId);
        }
    });

    if ($elementorformSelect.val()) {
        fetchUsedActions($elementorformSelect.val());
    }

    // Re-check on form change
    $elementorformSelect.on('change', function () {
        const formId = $(this).val();
        if (formId) {
            fetchUsedActions(formId);
        }
    });

    const requiredFields = ['subscription_id', 'email', 'password'];
    $('#publish').on('click', function (e) {
        const createOption = $('#brillforms_create_option').val();
        const formID = $('input[name="brillforms_form_id"]').val();
        const memberId = $('#brillforms_subscription_id').val();

        // if (createOption !== 'user') {
        //     return true; // No check needed for other options
        // }

        // Collect current mappings
        const mappings = {};
        $('.brillforms_lead_fields').each(function () {
            const fieldName = $(this).attr('name').match(/\[([^\]]+)\]/);
            if (fieldName && $(this).val()) {
                mappings[fieldName[1]] = $(this).val();
            }
        });

        e.preventDefault(); // Stop default post submission

        $.ajax({
            url: brildirformsyncSettings.ajax_url,
            type: 'POST',
            data: {
                action: 'brildir_sfwbd_validate_mappings',
                create_option: createOption,
                mappings: mappings,
                form_id: formID,
                member_id: memberId,
                brildir_sfwbd_settings_nonce: brildirformsyncSettings.nonce
            },
            success: function (response) {
                if (response.success) {
                    $('#brill_member_req_msg').hide();
                    $('#publish').off('click').trigger('click'); // Continue with submission
                } else {
                    if(response.data.message === 'planid'){
                        $('#brill_planid_req_msg').show();
                    }else{
                        $('#brill_planid_req_msg').hide();
                    }
                    if(response.data.message === 'useremail'){
                        $('#brill_member_map_req_msg').show();
                    }else{
                        $('#brill_member_map_req_msg').hide();
                    }
                    if(response.data.message === 'leademail'){
                        $('#brill_lead_map_req_msg').show();
                    }else{
                        $('#brill_lead_map_req_msg').hide();
                    }
                    if(response.data.mapping === 'maperr'){
                        $('#brill_mapping_err').show();
                        $('#brill_mapping_err').html('The following mapping values are duplicates: '+ response.data.dubicate +'. Please ensure each mapping is unique (excluding "Skip Field - Do Not Map").');
                    }else{
                        $('#brill_mapping_err').hide();
                    }
                    $('html, body').animate({
                        scrollTop: $("#brillforms_fields_wrap").offset().top - 100
                    }, 300);
                }
            }
        });
    });

    $('#brill_clear_log').on('click', function() {
        $('#brill_clear_log_modal').fadeIn();
    });

    // Handle the cancel action
    $('#brill_cancel_clear').on('click', function() {
        $('#brill_clear_log_modal').fadeOut();
    });

    $('#brill_confirm_clear').on('click', function(){

        var brill_clear_confirm_btn = $('#brill_confirm_clear');

        brill_clear_confirm_btn.prop('disabled', true);
        brill_clear_confirm_btn.html('<span class="brill-popup-process-wrap"><span class="dashicons dashicons-update brill-spin-icon"></span> <span class="brill-process-txt">processing...</span></span>');

       $.ajax({
        url: brildirformsyncSettings.ajax_url,
        method: 'POST',
        data: {
            action: 'brildir_sfwbd_clear_logs',
            brildir_sfwbd_settings_nonce: brildirformsyncSettings.nonce
        },
        success: function(response){
            if (response.success) {
                brill_clear_confirm_btn.prop('disabled', false);
                location.reload();
            }else {
                brill_clear_confirm_btn.prop('disabled', false);
            }
            $('#brill_clear_log_modal').fadeOut();
        },
        error: function() {
            brill_clear_confirm_btn.prop('disabled', false);
            $('#brill_clear_log_modal').fadeOut();
        }
       })
    });
});

document.addEventListener("DOMContentLoaded", function() {
    var membershipPlanInput = document.getElementById("brillforms_subscription_id");
    if (membershipPlanInput) {
        membershipPlanInput.addEventListener("input", function() {
            var input = this.value;
            this.value = input.replace(/[^0-9]/g, '');
        });
    }
});


function initializeBrillformsTooltips() {
    const tooltips = [
        { id: 'brillforms_fieldmap_label', content: 'Map each WP form field to its corresponding field in Brilliant Directories. The data submitted via your WP form will be transferred to BD and used to create a new record.' },
        { id: 'brillforms_custom_fields_label', content: 'Define fixed data values to include with every form submission. This data is not entered by the user but is automatically included, such as a default source, status, or campaign ID.' },
    ];

    tooltips.forEach(function(tooltip) {
        jQuery('#' + tooltip.id).append(
            '<span class="brillforms-tooltip-icon">' +
            '<span class="brillforms-tooltip-text">' + tooltip.content + '</span></span>'
        );
    }); 

    jQuery(document).on('mouseenter', '.brillforms-tooltip-icon', function() {
        jQuery(this).next('.brillforms-tooltip-text').css({
            'visibility': 'visible',
            'opacity': '1'
        });
    });

    jQuery(document).on('mouseleave', '.brillforms-tooltip-icon', function() {
        jQuery(this).next('.brillforms-tooltip-text').css({
            'visibility': 'hidden',
            'opacity': '0'
        });
    });
}

jQuery(document).ready(function($) {
    let deleteUrl = '';

    $('.brill-sync-post .brill-sync-delete-link').on('click', function(e) {
        e.preventDefault();
        $('#brill_sync_del_modal').fadeIn();
    });

    $('#brill_cancel_sync_del').on('click', function() {
        $('#brill_sync_del_modal').fadeOut();
    });

    $('#brill_confirm_sync_del').on('click', function() {

        var brill_confirm_sync_del = $('#brill_confirm_sync_del');

        brill_confirm_sync_del.prop('disabled', true);
        brill_confirm_sync_del.html('<span class="brill-popup-process-wrap"><span class="dashicons dashicons-update brill-spin-icon"></span> <span class="brill-process-txt">processing...</span></span>');

        $.ajax({
            type: 'POST',
            url: brildirformsyncSettings.ajax_url,
            data: {
                action: 'brildir_sfwbd_delete_post',
                brildir_sfwbd_settings_nonce: brildirformsyncSettings.nonce,
                post_id: brildirformsyncSettings.post_id
            },
            success: function(response) {
                if (response.success) {
                    brill_confirm_sync_del.prop('disabled', false);
                    window.location.href = brildirformsyncSettings.redirect_url;
                } else {
                    brill_confirm_sync_del.prop('disabled', false);
                    $('#brill_sync_del_modal').fadeOut();
                }
            },
            error: function() {
                brill_confirm_sync_del.prop('disabled', false);
                $('#brill_sync_del_modal').fadeOut();
            }
        });
    });

    $('.brill-sync-delete-link.brill-list-sync-btn').on('click', function(e) {
        e.preventDefault();
        deleteUrl = $(this).data('delete-url');
        $('#brill_sync_list_del_modal').fadeIn();
    });

    $('#brill_cancel_sync_list_del').on('click', function() {
        $('#brill_sync_list_del_modal').fadeOut();
    });

    $('#brill_confirm_sync_list_del').on('click', function() {
        var brill_confirm_sync_list_del = $('#brill_confirm_sync_list_del');

        brill_confirm_sync_list_del.prop('disabled', true);
        brill_confirm_sync_list_del.html('<span class="brill-popup-process-wrap"><span class="dashicons dashicons-update brill-spin-icon"></span> <span class="brill-process-txt">processing...</span></span>');
        if (deleteUrl !== '') {
            brill_confirm_sync_list_del.prop('disabled', false);
            window.location.href = deleteUrl;
        }
        brill_confirm_sync_list_del.prop('disabled', false);
        $('#brill_sync_list_del_modal').fadeOut();
    });
});
