const { __, sprintf } = wp.i18n;

document.addEventListener('DOMContentLoaded', function() {
    if (typeof FusionCharts === 'undefined') {
        console.error('FusionCharts Error');
        return;
    }
    new FusionCharts({
        id: "myDoughnutChart",
        type: 'doughnut2d',
        renderAt: 'chart-container',
        width: "100%",
        height: "100%",
        dataFormat: "xml",
        dataSource: `
            <chart 
                bgAlpha='0' bgColor='#FFFFFF' canvasBgColor='#FFFFFF'
                anchorBgColor='#FFFFFF' legendBgColor='#FFFFFF'
                borderColor='#D6E1F0' xAxisLineColor='#D6E1F0' yAxisLineColor='#D6E1F0'
                divLineColor='#D6E1F0' baseFontColor='#000000' legendBorderColor='#D6E1F0'
                toolTipBorderColor='#0278BE' toolTipBgColor='#0278BE' toolTipColor='#FFFFFF'
                toolTipBgAlpha='80' palettecolors='#02569C,#0168AD,#0278BE,#0288D1,#039AE3,#03A9F5,#28B6F6,#4DC2F7,#72CFFA,#97DCFB,#BBE8FB,#E1F5FE'
                drawAnchors='0' anchorRadius='2' showLabels='1' showToolTip='1'
                allowSelection='1' captionpadding='0' showLimits='0' displayValue='1'
                showValues='0' adjustDiv='1' showLegend='0' showCanvasBorder='0'
                showCanvasBg='0' canvasBaseDepth='0' canvasBgDepth='0' showBorder='0'
                animation='0' showZeroPlaneValue='0' legendShadow='0' legendPadding='0'
                interactiveLegend='1' placevaluesinside='0' showZeroPlane='1'
                plotBorderColor='#D6E1F0' usePlotGradientColor='0' axislinealpha='75'
                divlinealpha='50' crossLineAlpha='50' drawCrossLineOnTop='1' drawCrossLine='1'
                crosslinecolor='#0288D1' showShadow='0' showAlternateHGridColor='0'
                tooltipborderradius='5' tooltippadding='5' alignLegendWithCanvas='1'
                crossLineAnimation='0' plotColorinTooltip='0' toolTipBorderThickness='0'
                baseFont='Roboto' chartTopMargin='5' chartBottomMargin='5'
                chartRightMargin='5' chartLeftMargin='5' labelFontSize='10'
                skipOverlapLabels='1' enableSlicing='0' use3DLighting='0'
                showValue='0' radius3D='0' defaultcenterlabel='0%' 
                centerLabelToolText='0% ${__('Completed', 'swpanel-migrator')}' centerLabelFontSize='34'
                showPlotBorder='1' enableSmartLabels='1' useEllipsesWhenOverflow='1'
                doughnutRadius='75%' startingAngle='270' manageLabelOverflow='1'
                centerLabelBold='1' animateClockwise='0'
            >
                <set value='100' label='${__('Pending', 'swpanel-migrator')}' toolText='${__('Pending', 'swpanel-migrator')}' color='#4DC2F7' borderColor='#4DC2F7'/>
                <set value='0' label='${__('Completed', 'swpanel-migrator')}' toolText='${__('Completed', 'swpanel-migrator')}' color='#0278BE' borderColor='#0278BE'/>
            </chart>
        `
    }).render();
});

function updateChartValues(done, pending) {
    const chart = FusionCharts.items["myDoughnutChart"];
    if (!chart) {
        console.error("Chart not initialized or invalid");
        return;
    }
    const total = done + pending;
    const percent = total === 0 ? 0 : Math.round((done / total) * 100);
    chart.setXMLData(`
        <chart 
            bgAlpha='0' bgColor='#FFFFFF' canvasBgColor='#FFFFFF'
            anchorBgColor='#FFFFFF' legendBgColor='#FFFFFF'
            borderColor='#D6E1F0' xAxisLineColor='#D6E1F0' yAxisLineColor='#D6E1F0'
            divLineColor='#D6E1F0' baseFontColor='#000000' legendBorderColor='#D6E1F0'
            toolTipBorderColor='#0278BE' toolTipBgColor='#0278BE' toolTipColor='#FFFFFF'
            toolTipBgAlpha='80' palettecolors='#02569C,#0168AD,#0278BE,#0288D1,#039AE3,#03A9F5,#28B6F6,#4DC2F7,#72CFFA,#97DCFB,#BBE8FB,#E1F5FE'
            drawAnchors='0' anchorRadius='2' showLabels='1' showToolTip='1'
            allowSelection='1' captionpadding='0' showLimits='0' displayValue='1'
            showValues='0' adjustDiv='1' showLegend='0' showCanvasBorder='0'
            showCanvasBg='0' canvasBaseDepth='0' canvasBgDepth='0' showBorder='0'
            animation='0' showZeroPlaneValue='0' legendShadow='0' legendPadding='0'
            interactiveLegend='1' placevaluesinside='0' showZeroPlane='1'
            plotBorderColor='#D6E1F0' usePlotGradientColor='0' axislinealpha='75'
            divlinealpha='50' crossLineAlpha='50' drawCrossLineOnTop='1' drawCrossLine='1'
            crosslinecolor='#0288D1' showShadow='0' showAlternateHGridColor='0'
            tooltipborderradius='5' tooltippadding='5' alignLegendWithCanvas='1'
            crossLineAnimation='0' plotColorinTooltip='0' toolTipBorderThickness='0'
            baseFont='Roboto' chartTopMargin='5' chartBottomMargin='5'
            chartRightMargin='5' chartLeftMargin='5' labelFontSize='10'
            skipOverlapLabels='1' enableSlicing='0' use3DLighting='0'
            showValue='0' radius3D='0' defaultcenterlabel='${percent}%' 
            centerLabelToolText='${percent}% completado' centerLabelFontSize='34'
            showPlotBorder='1' enableSmartLabels='1' useEllipsesWhenOverflow='1'
            doughnutRadius='75%' startingAngle='270' manageLabelOverflow='1'
            centerLabelBold='1' animateClockwise='0'
        >
            <set value='${pending}' label='${__('Pending', 'swpanel-migrator')}' color='#4DC2F7'/>
            <set value='${done}' label='${__('Completed', 'swpanel-migrator')}' color='#0278BE'/>
        </chart>
    `);
    const message = sprintf(
    __('%1$d steps remaining out of %2$d', 'swpanel-migrator'),
    pending,
    total
    );
    document.getElementById('chart-text').textContent = message;
}

jQuery(document).ready(function($) {
    function createTask() {
        $('#error-retry').hide();
        $('#export-form').hide();
        $.ajax({
            url: swpanel_migrator_data.ajax_url,
            type: 'POST',
            data: {
                action: 'swpanel_migrator_create_task',
            },
            success: function(response) {
                migrationStatus();
            },
            error: function(response) {
                $('#migration-status').hide();
                $('#error-retry').show();
                $('#error-migration').text("AJAX failed.");
            }
        });
    }
    function renderSteps(steps) {
        const container = $('#progress-list');
        container.empty();
        
        let done = 0;
        let pending = 0;
        let runningStep = '';
        steps.forEach(step => {
            const status = (step.status || "").toLowerCase();
            if (status === "done") {
                done++;
                container.append(`
                    <div class="progress-step">
                        <div class="circle completed">
                            <i class="fa fa-check"></i>
                        </div>
                        <div class="label">${step.label}</div>
                    </div>
                `);
            } else if (step.status === 'running') {
                pending++;
                runningStep = step.label;
                container.append(`
                    <div class="progress-step">
                        <div class="circle">
                            <i class="fa fa-spinner fa-pulse"></i>
                        </div>
                        <div class="label">${step.label}</div>
                    </div>
                `);
            } else {
                pending++;
                container.append(`
                    <div class="progress-step">
                        <div class="circle">
                            <i class="fa fa-times"></i>
                        </div>
                        <div class="label">${step.label}</div>
                    </div>
                `);
            }
        });
        updateChartValues(done, pending);
        return {done, runningStep};
    }
    function migrationStatus() {
        $('#migration-status').show();
        $('#migration-status').css('display', 'flex');
        $('#error-retry').hide();
        $('#export-form').hide();
        $.ajax({
            url: swpanel_migrator_data.ajax_url,
            type: 'POST',
            data: {
                action: 'swpanel_migrator_migration_status',
            },
            success: function(response) {
                if (response.success) {
                    const data = response.data;
                    const {done, runningStep} = renderSteps(data.steps);
                    if (data.status == 'error'){
                        $('#migration-status').hide();
                        $('#error-retry').show();
                        $('#error-migration').text(data.current.message);
                    } else {
                        if (done == 0){
                            window.fakeProgress = undefined;
                            $('#migration-block').hide();
                        } else {
                            $('#migration-block').show();
                            $('#status-text').text(data.current.message);
                            if(data.current.percent || done==3) {
                                window.fakeProgress = undefined;
                                $('#progress-bar').show();
                                $('#progress-details').show();
                                $('#progress-details').html(data.current.details);
                                $('#progress-fill').css('width', data.current.percent + '%');
                            }
                            else {
                                if (window.currentStep !== runningStep) {
                                    window.fakeProgress = undefined;
                                    window.currentStep = runningStep;
                                }
                                if (typeof window.fakeProgress === 'undefined') {
                                    window.fakeProgress = Math.floor(Math.random() * 50);
                                } else {
                                    window.fakeProgress += Math.floor(Math.random() * 10) + 5;
                                    if (window.fakeProgress > 95) window.fakeProgress = 95;
                                }
                                $('#progress-details').hide();
                                $('#progress-bar').show();
                                $('#progress-hide').show();
                                $('#progress-fill').css('width', window.fakeProgress + '%');
                            }
                        }
                        if (data.status == 'finished'){
                            $('#status-text').text(data.current.message);
                            $('#back').show();
                            $('#progress-details').hide();
                            $('#progress-bar').hide();
                        } else {
                            setTimeout(function() {
                                migrationStatus();
                            }, 1000);
                        }
                    }
                } else {
                    $('#migration-status').hide();
                    $('#error-retry').show();
                    $('#error-migration').text(response.data.message);
                }
            },
            error: function(response) {
                $('#migration-status').hide();
                $('#error-retry').show();
                $('#error-migration').text("AJAX failed.");
            }
        });
    }
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('migration') === 'started') {
        if (swpanel_migrator_data.run_task === '1') {
            migrationStatus();
        } else {
            $('#export-form').hide();
            $('#error-retry').show();
            $('#retry-migration').hide();
        }
    }
    $('#retry-migration').on('click', function() {
        createTask();
    });
});
