<p align="center"><img src="https://github.com/swiftype/swiftype-wordpress/blob/master/logo-site-search.png?raw=true" alt="Elastic Site Search Logo"></p>

<p align="center"><a href="https://circleci.com/gh/swiftype/swiftype-wordpress"><img src="https://circleci.com/gh/swiftype/swiftype-wordpress.svg?style=svg" alt="CircleCI build"></a></p>

> The [Site Search WordPress Plugin](https://swiftype.com/wordpress) replaces WordPress's default search with a better search engine that is fully customizable via the Site Search dashboard.

## Contents

- [Getting started](#getting-started-)
- [Usage](#usage)
- [FAQ](#faq-)
- [Contribute](#contribute-)
- [License](#license-)

***

## Getting started 🐣

It is recommended that you install the plugin from the Wordpress Plugin Management screen of your Wordpress install (**Plugins -> Add New**);

Once the plugin is installed and enabled, you will see a new **Site Search** entry in the admin menu. Go to this entry to configure the Site Search plugins :

  1. Enter your Swiftype API key on the first screen.
  3. Name your search engine and optionally choose a language.
  3. Build your search index by clicking the "Synchronize" button.

**Note :**
  * Using this plugin assumes that you have already created a Site Search account. If you do not have one, [signup for a free 14 day trial](https://app.swiftype.com/signup?utm_channel=readme-web&utm_source=wordpress-web).
  * If you already have an account, you will need your API Key in order to configure the plugin. You can find it in on top of the Site Search [Account Settings](https://app.swiftype.com/settings/account) screen on the Site Search site.

## Usage

For additional information on how to use and extend the plugin, please
visit the [plugin notes
page](https://wordpress.org/plugins/swiftype-search/other_notes/).

## FAQ 🔮

### Where do I report issues with the plugin?

If something is not working as expected, please open an [issue](https://github.com/swiftype/swiftype-wordpress/issues/new).

### Where else can I go to get help?

You can checkout the [Site Search Plugin discuss forum](https://wordpress.org/support/plugin/swiftype-search/).

You can contact our support by sending an email to support@swiftype.com.

### How to start the development environment

#### Create the Docker stack

You can create a docker stack using:

```bash
docker stack deploy -c stack.yml wordpress-dev
```

Alternatively, you can use docker-compose instead of stack:

```bash
docker-compose -f stack.yml up
```

Your wordpress dev instance will boot up and be available at http://localhost:8080.

To enter the wordpress container, you can use the followin command:

```bash
docker exec -it $(docker ps -a -f label=com.docker.stack.namespace=wordpress-dev -f expose=80/tcp --format "{{.ID}}") /bin/bash
```


## Contribute 🚀

We welcome contributors to the project. Before you begin, a couple notes...

+ Before opening a pull request, please create an issue to [discuss the scope of your proposal](https://github.com/swiftype/swiftype-wordpress/issues).
+ Please write simple code and concise documentation, when appropriate.

## License 📗

[Apache 2.0](https://github.com/swiftype/swiftype-wordpress/blob/master/LICENSE) © [Elastic](https://github.com/elastic)

Thank you to all the [contributors](https://github.com/swiftype/swiftype-wordpress/graphs/contributors)!
