'use strict';
module.exports = function(grunt) {
  grunt.loadNpmTasks('grunt-contrib-uglify');
  grunt.loadNpmTasks('grunt-contrib-concat');

  grunt.initConfig({
    concat: {
      options: {
        banner: "/* DO NOT EDIT. THIS FILE IS AUTOMATICALLY GENERATED. */\n\n"
      },
      build: {
        src: ['assets/jquery-1.10.1.js', 
              'assets/begin_shim.js', 
              'assets/jquery.swiftype.autocomplete.js', 
              'assets/swiftype_config.js', 
              'assets/clickthroughs.js', 
              'assets/end_shim.js'],
        dest: 'assets/install_swiftype.js'
      }
    },
    uglify: {
      build: {
        src: ['assets/install_swiftype.js'],
        dest: 'assets/install_swiftype.min.js'
      }
    }
  });

  grunt.registerTask('build', ['concat:build', 'uglify:build']);
};
