<?php
/**
 * Plugin Name: SwiftAddons for Elementor
 * Description: Lightweight Elementor addon pack with Info Box, Team Member, and Testimonial widgets.
 * Version:     1.0.0
 * Author:      Sandeep
 * Author URI:  https://www.linkedin.com/in/sandeep-kumar-9878707368/
 * Text Domain: swiftaddons-for-elementor
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires Plugins: elementor
 * Requires at least: 5.8
 * Requires PHP:      7.4
 * Tested up to:      6.9
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define constants
define( 'SWIFFOEL_PATH', plugin_dir_path( __FILE__ ) );
define( 'SWIFFOEL_URL', plugin_dir_url( __FILE__ ) );
define( 'SWIFFOEL_VERSION', '1.0.0' );

// ⚠️ IMPORTANT: Include plugin loader FIRST!
require_once SWIFFOEL_PATH . 'includes/class-plugin-loader.php';

// Load plugin textdomain and initialize loader
add_action( 'plugins_loaded', function() {
    SWIFFOEL\Plugin_Loader::instance();  // Now the class exists!
});

// Enqueue main CSS with proper prefix
function swiffoel_enqueue_styles() {
    wp_enqueue_style(
        'swiftaddons-main',
        SWIFFOEL_URL . 'assets/css/swiftaddons.css',
        [],
        SWIFFOEL_VERSION
    );
}
add_action( 'wp_enqueue_scripts', 'swiffoel_enqueue_styles' );
add_action( 'elementor/editor/after_enqueue_scripts', 'swiffoel_enqueue_styles' );

// Enqueue Swiper + custom scripts (frontend)
function swiffoel_enqueue_frontend_scripts() {
    // Team carousel script
    wp_enqueue_script(
        'swiffoel-team-carousel',
        SWIFFOEL_URL . 'assets/js/swiftaddons-carousel.js',
        [ 'jquery', 'elementor-frontend', 'swiper' ],
        SWIFFOEL_VERSION,
        true
    );
}
add_action( 'wp_enqueue_scripts', 'swiffoel_enqueue_frontend_scripts', 20 );

// Enqueue scripts for Elementor editor preview
function swiffoel_enqueue_editor_scripts() {
    wp_enqueue_script(
        'swiffoel-team-carousel',
        SWIFFOEL_URL . 'assets/js/swiftaddons-carousel.js',
        [ 'jquery', 'elementor-frontend', 'swiper' ],
        SWIFFOEL_VERSION,
        true
    );
}
add_action( 'elementor/editor/after_enqueue_scripts', 'swiffoel_enqueue_editor_scripts', 20 );