<?php
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

use Elementor\Repeater;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
if ( ! defined( 'ABSPATH' ) ) exit;

// testimonial-style-controls.php

function swiffoel_testimonial_style_controls( $widget ) {
    $widget->start_controls_section(
        'style_section',
        [
            'label' => __( 'General', 'swiftaddons-for-elementor' ),
            'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        ]
    );

     

        $widget->add_control(
            'testimonial_bg_color',
            [
                'label' => __('Background Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'testimonial_bg_hover_color',
            [
                'label' => __('Background Hover Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'testimonial_border',
                'selector' => '{{WRAPPER}} .testimonial-item',
            ]
        );

        $widget->add_control(
            'testimonial_border_radius',
            [
                'label' => __('Border Radius', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'testimonial_box_shadow',
                'selector' => '{{WRAPPER}} .testimonial-item',
            ]
        );

        $widget->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'testimonial_box_shadow_hover',
                'label' => __('Box Shadow Hover', 'swiftaddons-for-elementor'),
                'selector' => '{{WRAPPER}} .testimonial-item:hover',
            ]
        );

        $widget->add_responsive_control(
            'testimonial_padding',
            [
                'label' => __('Padding', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_responsive_control(
            'testimonial_margin',
            [
                'label' => __('Margin', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
    


    $widget->end_controls_section();
//------------------------------------------------------------------------------------------------------------------------
    $widget->start_controls_section(
            'content_style_section',
            [
                'label' => __('Content', 'swiftaddons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'content_color',
            [
                'label' => __('Text Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'content_hover_color',
            [
                'label' => __('Text Hover Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item:hover .testimonial-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .testimonial-text',
            ]
        );

        $widget->add_responsive_control(
            'content_margin',
            [
                'label' => __('Margin', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->end_controls_section();
 //---------------------------------------------------------------------------------------------------------------------------------------------------------
 
  $widget->start_controls_section(
            'section_style_author',
            [
                'label' => __('Author', 'swiftaddons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'author_name_heading',
            [
                'label' => __('Name', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $widget->add_control(
            'name_color',
            [
                'label' => __('Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-author h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'name_hover_color',
            [
                'label' => __('Hover Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item:hover .testimonial-author h4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .testimonial-author h4',
            ]
        );

        $widget->add_control(
            'author_details_heading',
            [
                'label' => __('Details', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $widget->add_control(
            'details_color',
            [
                'label' => __('Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-author span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'details_hover_color',
            [
                'label' => __('Hover Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item:hover .testimonial-author span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'details_typography',
                'selector' => '{{WRAPPER}} .testimonial-author span',
            ]
        );

        $widget->end_controls_section();
     
//--------------------------------------------------------------------------------------------------
$widget->start_controls_section(
            'section_style_image',
            [
                'label' => __('Image', 'swiftaddons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
$widget->add_control(
    'swiffoel_testimonial_image_size',
    [
        'label' => __( 'Image Size', 'swiftaddons-for-elementor' ),
        'type'  => Controls_Manager::SLIDER,
        'size_units' => [ 'px', '%' ],
        'range' => [
            'px' => [
                'min' => 20,
                'max' => 200,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .testimonial-author img' =>
                'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
        ],
    ]
);


        $widget->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'selector' => '{{WRAPPER}} .testimonial-author img',
            ]
        );

        $widget->add_control(
            'image_border_radius',
            [
                'label' => __('Border Radius', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-author img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'selector' => '{{WRAPPER}} .testimonial-author img',
            ]
        );

        $widget->add_control(
            'image_spacing',
            [
                'label' => __('Spacing', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-author img' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->end_controls_section();

//------------------------------------------------------------

        $widget->start_controls_section(
            'section_style_rating',
            [
                'label' => __('Rating', 'swiftaddons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'rating_color',
            [
                'label' => __('Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-rating .star' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'rating_filled_color',
            [
                'label' => __('Filled Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-rating .star.filled' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'rating_hover_color',
            [
                'label' => __('Hover Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item:hover .testimonial-rating .star.filled' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'rating_size',
            [
                'label' => __('Size', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-rating .star' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'rating_spacing',
            [
                'label' => __('Spacing', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-rating .star' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'rating_margin',
            [
                'label' => __('Margin', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-rating' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->end_controls_section();

  //-------------------------------------------------------------------------------------------------
  
   $widget->start_controls_section(
            'section_style_quote',
            [
                'label' => __('Quote Icon', 'swiftaddons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'quote_color',
            [
                'label' => __('Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'color: {{VALUE}};',
                ],
                'condition' => ['show_quote_icon' => 'yes'],
            ]
        );

        $widget->add_control(
            'quote_hover_color',
            [
                'label' => __('Hover Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item:hover .quote-icon' => 'color: {{VALUE}};',
                ],
                'condition' => ['show_quote_icon' => 'yes'],
            ]
        );

        $widget->add_control(
            'quote_size',
            [
                'label' => __('Size', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .quote-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['show_quote_icon' => 'yes'],
            ]
        );

        $widget->add_control(
            'quote_opacity',
            [
                'label' => __('Opacity', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0.1,
                        'max' => 1,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'opacity: {{SIZE}};',
                ],
                'condition' => ['show_quote_icon' => 'yes'],
            ]
        );

        $widget->add_control(
            'quote_hover_opacity',
            [
                'label' => __('Hover Opacity', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0.1,
                        'max' => 1,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-item:hover .quote-icon' => 'opacity: {{SIZE}};',
                ],
                'condition' => ['show_quote_icon' => 'yes'],
            ]
        );

        $widget->end_controls_section();   

  //-----------------------------------------------------------------------------------------------------------------

  $widget->start_controls_section(
            'section_style_social',
            [
                'label' => __('Social Icons', 'swiftaddons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'social_icon_size',
            [
                'label' => __('Size', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-social a' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .testimonial-social svg' => 'width: calc({{SIZE}}{{UNIT}} / 2); height: calc({{SIZE}}{{UNIT}} / 2);',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_color',
            [
                'label' => __('Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-social a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_bg_color',
            [
                'label' => __('Background Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-social a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_hover_color',
            [
                'label' => __('Hover Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-social a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_bg_hover_color',
            [
                'label' => __('Background Hover Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-social a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_border_radius',
            [
                'label' => __('Border Radius', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-social a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_spacing',
            [
                'label' => __('Spacing', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-social a' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_margin',
            [
                'label' => __('Margin', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-social' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->end_controls_section();

//----------------------------------------------------------------------------------------------

 $widget->start_controls_section(
            'section_style_navigation',
            [
                'label' => __('Navigation', 'swiftaddons-for-elementor'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['display_mode' => 'slider'],
            ]
        );

        $widget->add_control(
            'arrows_size',
            [
                'label' => __('Arrows Size', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev, {{WRAPPER}} .swiper-button-next' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .swiper-button-prev:after, {{WRAPPER}} .swiper-button-next:after' => 'font-size: calc({{SIZE}}{{UNIT}} / 2);',
                ],
                'condition' => ['show_arrows' => 'yes'],
            ]
        );

        $widget->add_control(
            'arrows_color',
            [
                'label' => __('Arrows Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev, {{WRAPPER}} .swiper-button-next' => 'color: {{VALUE}};',
                ],
                'condition' => ['show_arrows' => 'yes'],
            ]
        );

        $widget->add_control(
            'arrows_bg_color',
            [
                'label' => __('Arrows Background', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev, {{WRAPPER}} .swiper-button-next' => 'background-color: {{VALUE}};',
                ],
                'condition' => ['show_arrows' => 'yes'],
            ]
        );

        $widget->add_control(
            'arrows_hover_color',
            [
                'label' => __('Arrows Hover Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev:hover, {{WRAPPER}} .swiper-button-next:hover' => 'color: {{VALUE}};',
                ],
                'condition' => ['show_arrows' => 'yes'],
            ]
        );

        $widget->add_control(
            'arrows_bg_hover_color',
            [
                'label' => __('Arrows Background Hover', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-button-prev:hover, {{WRAPPER}} .swiper-button-next:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => ['show_arrows' => 'yes'],
            ]
        );

        $widget->add_control(
            'dots_size',
            [
                'label' => __('Dots Size', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 20,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['show_dots' => 'yes'],
            ]
        );

        $widget->add_control(
            'dots_color',
            [
                'label' => __('Dots Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'background-color: {{VALUE}};',
                ],
                'condition' => ['show_dots' => 'yes'],
            ]
        );

        $widget->add_control(
            'dots_active_color',
            [
                'label' => __('Dots Active Color', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
                ],
                'condition' => ['show_dots' => 'yes'],
            ]
        );

        $widget->end_controls_section();                 
}
