<?php
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;



function swiffoel_teamMember_register_style_controls( $widget ) {

        $widget->start_controls_section(
            'team_member_style_section',
            [
                'label' => __( 'Style', 'swiftaddons-for-elementor' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'name_heading',
            [
                'label' => __( 'Name', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $widget->add_control(
            'name_color',
            [
                'label'     => __( 'Color', 'swiftaddons-for-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'selector' => '{{WRAPPER}} .sa-team .sa-member-name',
            ]
        );

        $widget->add_responsive_control(
            'name_spacing',
            [
                'label' => __( 'Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member-name' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'role_heading',
            [
                'label' => __( 'Designation', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $widget->add_control(
            'role_color',
            [
                'label'     => __( 'Color', 'swiftaddons-for-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member-role' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'role_typography',
                'selector' => '{{WRAPPER}} .sa-team .sa-member-role',
            ]
        );

        $widget->add_responsive_control(
            'role_spacing',
            [
                'label' => __( 'Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member-role' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'bio_heading',
            [
                'label' => __( 'Bio', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $widget->add_control(
            'bio_color',
            [
                'label'     => __( 'Color', 'swiftaddons-for-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member-bio' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'bio_typography',
                'selector' => '{{WRAPPER}} .sa-team .sa-member-bio',
            ]
        );

        $widget->add_responsive_control(
            'bio_spacing',
            [
                'label' => __( 'Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member-bio' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'item_heading',
            [
                'label' => __( 'Item', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $widget->add_control(
            'item_background',
            [
                'label'     => __( 'Background', 'swiftaddons-for-elementor' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .sa-team .sa-member',
            ]
        );

        $widget->add_control(
            'item_border_radius',
            [
                'label' => __( 'Border Radius', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'selector' => '{{WRAPPER}} .sa-team .sa-member',
            ]
        );

        $widget->add_responsive_control(
            'item_padding',
            [
                'label' => __( 'Padding', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

       $widget->end_controls_section();

// Image Style Section with unique ID
$widget->start_controls_section(
    'image_style_section',
    [
        'label' => __( 'Image', 'swiftaddons-for-elementor' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

$widget->add_control(
    'image_heading',
    [
        'label' => __( 'Image', 'swiftaddons-for-elementor' ),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

$widget->add_group_control(
    \Elementor\Group_Control_Border::get_type(),
    [
        'name' => 'image_border',
        'selector' => '{{WRAPPER}} .sa-team .sa-member-photo img',
    ]
);

$widget->add_control(
    'image_border_radius',
    [
        'label' => __( 'Border Radius', 'swiftaddons-for-elementor' ),
        'type' => Controls_Manager::SLIDER,
        'range' => [
            '%' => [ 'min' => 0, 'max' => 50 ],
        ],
        'default' => [
            'unit' => '%',
            'size' => 50,
        ],
        'selectors' => [
            '{{WRAPPER}} .sa-team .sa-member-photo img' => 'border-radius: {{SIZE}}{{UNIT}};',
        ],
    ]
);

        $widget->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'selector' => '{{WRAPPER}} .sa-team .sa-member-photo img',
            ]
        );

        $widget->add_responsive_control(
            'image_spacing',
            [
                'label' => __( 'Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member-photo' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'hover_effect_heading',
            [
                'label' => __( 'Hover Effect', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $widget->add_control(
            'enable_hover_effect',
            [
                'label' => __( 'Enable Hover Effect', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'swiftaddons-for-elementor' ),
                'label_off' => __( 'No', 'swiftaddons-for-elementor' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $widget->add_control(
            'hover_effect',
            [
                'label' => __( 'Hover Effect', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'lift',
                'options' => [
                    'lift' => __( 'Lift', 'swiftaddons-for-elementor' ),
                    'shadow' => __( 'Shadow', 'swiftaddons-for-elementor' ),
                    'scale' => __( 'Scale', 'swiftaddons-for-elementor' ),
                    'border' => __( 'Border Highlight', 'swiftaddons-for-elementor' ),
                    'fade' => __( 'Fade', 'swiftaddons-for-elementor' ),
                ],
                'condition' => [
                    'enable_hover_effect' => 'yes',
                ],
            ]
        );

        $widget->add_control(
            'hover_lift_amount',
            [
                'label' => __( 'Lift Amount (px)', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'default' => [
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team.sa-hover-lift .sa-member:hover' => 'transform: translateY(-{{SIZE}}{{UNIT}});',
                ],
                'condition' => [
                    'enable_hover_effect' => 'yes',
                    'hover_effect' => 'lift',
                ],
            ]
        );

        $widget->add_control(
            'hover_shadow_intensity',
            [
                'label' => __( 'Shadow Intensity', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team.sa-hover-shadow .sa-member:hover' => 'box-shadow: 0 {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} rgba(0,0,0,0.15) !important;',
                ],
                'condition' => [
                    'enable_hover_effect' => 'yes',
                    'hover_effect' => 'shadow',
                ],
            ]
        );

        $widget->add_control(
            'hover_scale_amount',
            [
                'label' => __( 'Scale Amount (%)', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 120,
                    ],
                ],
                'default' => [
                    'size' => 105,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team.sa-hover-scale .sa-member:hover' => 'transform: scale({{SIZE}}%);',
                ],
                'condition' => [
                    'enable_hover_effect' => 'yes',
                    'hover_effect' => 'scale',
                ],
            ]
        );

        $widget->add_control(
            'hover_border_color',
            [
                'label' => __( 'Border Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sa-team.sa-hover-border .sa-member:hover' => 'border-color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'enable_hover_effect' => 'yes',
                    'hover_effect' => 'border',
                ],
            ]
        );

        $widget->add_control(
            'hover_fade_amount',
            [
                'label' => __( 'Fade Amount', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 90,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team.sa-hover-fade .sa-member:hover' => 'opacity: {{SIZE}}%;',
                ],
                'condition' => [
                    'enable_hover_effect' => 'yes',
                    'hover_effect' => 'fade',
                ],
            ]
        );
$widget->end_controls_section();

// Social Icons Style Section with unique ID

$widget->start_controls_section(
    'social_icons_style_section',
    [
        'label' => __( 'Social Icons', 'swiftaddons-for-elementor' ),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

$widget->add_control(
    'social_style_heading',
    [
        'label' => __( 'Social Icons', 'swiftaddons-for-elementor' ),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
    ]
);

$widget->add_control(
    'social_icon_style',
    [
        'label' => __( 'Icon Style', 'swiftaddons-for-elementor' ),
        'type' => Controls_Manager::SELECT,
        'default' => 'default',
        'options' => [
            'default' => __( 'Default Colors', 'swiftaddons-for-elementor' ),
            'custom' => __( 'Custom Colors', 'swiftaddons-for-elementor' ),
        ],
    ]
);

        $widget->add_control(
            'social_icon_size',
            [
                'label' => __( 'Icon Size', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'size' => 14,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-social-icons a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_color',
            [
                'label' => __( 'Icon Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sa-social-icons a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .sa-social-icons a svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'social_icon_style' => 'custom',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_hover_color',
            [
                'label' => __( 'Icon Hover Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sa-social-icons a:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .sa-social-icons a:hover svg' => 'fill: {{VALUE}};',
                ],
                'condition' => [
                    'social_icon_style' => 'custom',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_background',
            [
                'label' => __( 'Icon Background', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sa-social-icons a' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'social_icon_style' => 'custom',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_hover_background',
            [
                'label' => __( 'Icon Hover Background', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sa-social-icons a:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'social_icon_style' => 'custom',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_border_radius',
            [
                'label' => __( 'Border Radius', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-social-icons a' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'social_icon_spacing',
            [
                'label' => __( 'Icon Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'default' => [
                    'size' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-social-icons a:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

     $widget->add_responsive_control(
            'social_icons_spacing',
            [
                'label' => __( 'Icons Container Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-social-icons' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


    $widget->end_controls_section();
}
