<?php
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;
// infobox-style-controls.php

function swiffoel_infobox_register_style_controls( $widget ) {
     $widget->start_controls_section(
            'section_style_general',
            [
                'label' => __( 'General', 'swiftaddons-for-elementor' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


     $widget->add_responsive_control(
            'box_spacing',
            [
                'label' => __( 'Box Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_responsive_control(
            'box_padding',
            [
                'label' => __( 'Box Padding', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_background',
                'label' => __( 'Background', 'swiftaddons-for-elementor' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .infobox-item',
            ]
        );

        $widget->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'label' => __( 'Border', 'swiftaddons-for-elementor' ),
                'selector' => '{{WRAPPER}} .infobox-item',
            ]
        );

        $widget->add_control(
            'box_border_radius',
            [
                'label' => __( 'Border Radius', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .infobox-item',
            ]
        );

        $widget->end_controls_section();

         // Style Tab - Icon/Image Section
        $widget->start_controls_section(
            'section_style_icon',
            [
                'label' => __( 'Icon/Image', 'swiftaddons-for-elementor' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'icon_size',
            [
                'label' => __( 'Icon Size', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'icon_type' => 'icon',
                ],
            ]
        );

        $widget->add_control(
            'image_size',
            [
                'label' => __( 'Image Size', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                    '%' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-image img' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
                ],
                'condition' => [
                    'icon_type' => 'image',
                ],
            ]
        );

        $widget->add_control(
            'icon_color',
            [
                'label' => __( 'Icon Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-icon i' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'icon_type' => 'icon',
                ],
            ]
        );

        $widget->add_control(
            'icon_background',
            [
                'label' => __( 'Background Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-icon, {{WRAPPER}} .infobox-image' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'icon_spacing',
            [
                'label' => __( 'Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-icon, {{WRAPPER}} .infobox-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'icon_padding',
            [
                'label' => __( 'Padding', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-icon, {{WRAPPER}} .infobox-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'icon_border_radius',
            [
                'label' => __( 'Border Radius', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-icon, {{WRAPPER}} .infobox-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
$widget->end_controls_section();

 // Style Tab - Title Section
        $widget->start_controls_section(
            'section_style_title',
            [
                'label' => __( 'Title', 'swiftaddons-for-elementor' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .infobox-title',
            ]
        );

        $widget->add_group_control(
            Group_Control_Text_Shadow::get_type(),
            [
                'name' => 'title_text_shadow',
                'selector' => '{{WRAPPER}} .infobox-title',
            ]
        );

        $widget->add_control(
            'title_spacing',
            [
                'label' => __( 'Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


    $widget->end_controls_section();

    // Style Tab - Description Section
        $widget->start_controls_section(
            'section_style_description',
            [
                'label' => __( 'Description', 'swiftaddons-for-elementor' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'description_color',
            [
                'label' => __( 'Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-desc' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'selector' => '{{WRAPPER}} .infobox-desc',
            ]
        );

        $widget->add_control(
            'description_spacing',
            [
                'label' => __( 'Spacing', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%', 'em' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-desc' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $widget->end_controls_section();

        // Style Tab - Button Section
        $widget->start_controls_section(
            'section_style_button',
            [
                'label' => __( 'Button', 'swiftaddons-for-elementor' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'selector' => '{{WRAPPER}} .infobox-btn',
            ]
        );

        $widget->start_controls_tabs( 'button_tabs' );

        $widget->start_controls_tab(
            'button_normal',
            [
                'label' => __( 'Normal', 'swiftaddons-for-elementor' ),
            ]
        );

        $widget->add_control(
            'button_color',
            [
                'label' => __( 'Text Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-btn' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'button_background',
            [
                'label' => __( 'Background Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-btn' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $widget->end_controls_tab();

        $widget->start_controls_tab(
            'button_hover',
            [
                'label' => __( 'Hover', 'swiftaddons-for-elementor' ),
            ]
        );

        $widget->add_control(
            'button_color_hover',
            [
                'label' => __( 'Text Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-btn:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'button_background_hover',
            [
                'label' => __( 'Background Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-btn:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'button_border_color_hover',
            [
                'label' => __( 'Border Color', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-btn:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $widget->end_controls_tab();

         $widget->end_controls_tabs();

        $widget->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'selector' => '{{WRAPPER}} .infobox-btn',
                'separator' => 'before',
            ]
        );

        $widget->add_control(
            'button_border_radius',
            [
                'label' => __( 'Border Radius', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_control(
            'button_padding',
            [
                'label' => __( 'Padding', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .infobox-btn',
            ]
        );

        $widget->end_controls_section();

        // Hover Effects Section
        $widget->start_controls_section(
            'section_hover_effects',
            [
                'label' => __( 'Hover Effects', 'swiftaddons-for-elementor' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $widget->add_control(
            'hover_animation',
            [
                'label' => __( 'Hover Animation', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $widget->add_control(
            'box_hover_background',
            [
                'label' => __( 'Box Background Hover', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-item:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'box_hover_border_color',
            [
                'label' => __( 'Box Border Hover', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-item:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_hover_shadow',
                'label' => __( 'Box Shadow Hover', 'swiftaddons-for-elementor' ),
                'selector' => '{{WRAPPER}} .infobox-item:hover',
            ]
        );

        $widget->add_control(
            'icon_hover_color',
            [
                'label' => __( 'Icon Color Hover', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-item:hover .infobox-icon i' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'icon_type' => 'icon',
                ],
            ]
        );

        $widget->add_control(
            'title_hover_color',
            [
                'label' => __( 'Title Color Hover', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .infobox-item:hover .infobox-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $widget->add_control(
            'hover_transition',
            [
                'label' => __( 'Transition Duration', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .infobox-item' => 'transition-duration: {{SIZE}}s;',
                ],
            ]
        );

        $widget->end_controls_section();
}
