<?php
namespace SWIFFOEL\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;

// ✅ Security check FIRST
if (!defined('ABSPATH')) exit;

// ✅ Include style controls AFTER security check
require_once __DIR__ . '/testimonial-style-controls.php';


class Testimonial extends Widget_Base {

    public function get_name() {
        return 'testimonial_widget';
    }

    public function get_title() {
        return __('Advanced Testimonial', 'swiftaddons-for-elementor');
    }

    public function get_icon() {
        return 'eicon-testimonial-carousel';
    }

    public function get_categories() {
        return ['swiftaddons-for-elementor'];
    }

    protected function register_controls() {

        // Layout Section
        $this->start_controls_section(
            'section_layout',
            ['label' => __('Layout', 'swiftaddons-for-elementor')]
        );

        $this->add_control(
            'layout_style',
            [
                'label'   => __('Preset Layout', 'swiftaddons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'layout1' => 'Layout 1 - Classic',
                    'layout2' => 'Layout 2 - Modern',
                    'layout3' => 'Layout 3 - Corporate',
                    'layout4' => 'Layout 4 - Creative',
                    'layout5' => 'Layout 5 - Boxed',
                    'layout6' => 'Layout 6 - Minimalist',
                ],
                'default' => 'layout1',
            ]
        );

        $this->add_control(
            'content_position',
            [
                'label'   => __('Content Position', 'swiftaddons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'above' => __('Above Author', 'swiftaddons-for-elementor'),
                    'below' => __('Below Author', 'swiftaddons-for-elementor'),
                ],
                'default' => 'above',
            ]
        );

        $this->add_control(
            'display_mode',
            [
                'label'   => __('Display Mode', 'swiftaddons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'grid'   => __('Grid', 'swiftaddons-for-elementor'),
                    'slider' => __('Slider', 'swiftaddons-for-elementor'),
                ],
                'default' => 'grid',
            ]
        );

        $this->add_control(
            'columns',
            [
                'label'     => __('Columns (Grid)', 'swiftaddons-for-elementor'),
                'type'      => Controls_Manager::SELECT,
                'options'   => ['1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6'],
                'default'   => '3',
                'condition' => ['display_mode' => 'grid'],
            ]
        );

        $this->add_control(
            'slides_per_view',
            [
                'label'     => __('Slides Per View (Slider)', 'swiftaddons-for-elementor'),
                'type'      => Controls_Manager::SELECT,
                'options'   => ['1' => '1', '2' => '2', '3' => '3', '4' => '4'],
                'default'   => '3',
                'condition' => ['display_mode' => 'slider'],
            ]
        );

        $this->add_control(
            'image_position',
            [
                'label'   => __('Image Position', 'swiftaddons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'top'   => __('Top', 'swiftaddons-for-elementor'),
                    'left'  => __('Left', 'swiftaddons-for-elementor'),
                    'right' => __('Right', 'swiftaddons-for-elementor'),
                ],
                'default' => 'top',
            ]
        );

        $this->end_controls_section();

        // Content Section
        $this->start_controls_section(
            'section_content',
            ['label' => __('Testimonials', 'swiftaddons-for-elementor')]
        );



        $repeater = new Repeater();

        $repeater->add_control(
            'name',
            ['label' => __('Name', 'swiftaddons-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => 'John Doe']
        );

        $repeater->add_control(
            'designation',
            ['label' => __('Designation', 'swiftaddons-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => 'CEO']
        );

        $repeater->add_control(
            'company',
            ['label' => __('Company', 'swiftaddons-for-elementor'), 'type' => Controls_Manager::TEXT, 'default' => 'Company Name']
        );

        $repeater->add_control(
            'testimonial_content',
            ['label' => __('Testimonial', 'swiftaddons-for-elementor'), 'type' => Controls_Manager::TEXTAREA, 'default' => 'This is a sample testimonial text that describes the experience with your product or service.']
        );

        $repeater->add_control(
            'show_image',
            [
                'label' => __('Show Image?', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'swiftaddons-for-elementor'),
                'label_off' => __('No', 'swiftaddons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'photo',
            [
                'label' => __('Photo', 'swiftaddons-for-elementor'), 
                'type' => Controls_Manager::MEDIA, 
                'default' => ['url' => \Elementor\Utils::get_placeholder_image_src()],
                'condition' => ['show_image' => 'yes']
            ]
        );

        // Rating
        $repeater->add_control(
            'show_rating',
            [
                'label' => __('Show Rating?', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'swiftaddons-for-elementor'),
                'label_off' => __('No', 'swiftaddons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'rating',
            [
                'label'   => __('Star Rating', 'swiftaddons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => ['1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5'],
                'default' => '5',
                'condition' => ['show_rating' => 'yes'],
            ]
        );

                // Social icons nested repeater (working code)
        $social_repeater = new Repeater();
        $social_repeater->add_control(
            'social_icon',
            [
                'label' => __('Icon', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook',
                    'library' => 'fa-brands',
                ],
            ]
        );
        $social_repeater->add_control(
            'social_link',
            [
                'label' => __('Link', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::URL,
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                    'custom_attributes' => '',
                ],
            ]
        );

          $repeater->add_control(
            'social_profiles',
            [
                'label' => __('Social Profiles', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $social_repeater->get_controls(),
                'default' => [
                    [
                        'social_icon' => [
                            'value' => 'fab fa-facebook',
                            'library' => 'fa-brands',
                        ],
                    ],
                    [
                        'social_icon' => [
                            'value' => 'fab fa-twitter',
                            'library' => 'fa-brands',
                        ],

                    ],
                ],
                'title_field' => '<# var migrated = "undefined" !== typeof __fa4_migrated, social = ( "undefined" === typeof social ) ? false : social; #>{{{ elementor.helpers.getSocialNetworkNameFromIcon( social_icon, social, true, migrated, true ) }}}',
                'limit'  => 5,  // Correct parameter to enforce
            ]
        );


        $this->add_control(
            'testimonials',
            [
                'label'       => __('Items', 'swiftaddons-for-elementor'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ name }}}',
                'default'     => [
                    [
                        'name' => 'John Doe',
                        'designation' => 'CEO',
                        'company' => 'Tech Solutions',
                        'testimonial_content' => 'This is a sample testimonial text that describes the experience with your product or service.',
                         
                    ],
                    [
                        'name' => 'Jane Smith',
                        'designation' => 'Marketing Director',
                        'company' => 'Creative Agency',
                        'testimonial_content' => 'Another sample testimonial text that describes the experience with your product or service.',
                        
                    ],
                    [
                        'name' => 'Robert Johnson',
                        'designation' => 'Product Manager',
                        'company' => 'Innovate Inc',
                        'testimonial_content' => 'A third sample testimonial text that describes the experience with your product or service.',
                         
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        // Quote Icon Section
        $this->start_controls_section(
            'section_quote',
            ['label' => __('Quote Icon', 'swiftaddons-for-elementor'), 'tab' => Controls_Manager::TAB_CONTENT]
        );

        $this->add_control(
            'show_quote_icon',
            [
                'label' => __('Show Quote Icon?', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'swiftaddons-for-elementor'),
                'label_off' => __('No', 'swiftaddons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'quote_icon',
            [
                'label'   => __('Quote Icon', 'swiftaddons-for-elementor'),
                'type'    => Controls_Manager::ICONS,
                'default' => ['value' => 'fas fa-quote-left', 'library' => 'fa-solid'],
                'condition' => ['show_quote_icon' => 'yes'],
            ]
        );

        $this->add_control(
            'quote_position',
            [
                'label'   => __('Quote Position', 'swiftaddons-for-elementor'),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'top-left'      => __('Top Left', 'swiftaddons-for-elementor'),
                    'top-right'     => __('Top Right', 'swiftaddons-for-elementor'),
                    'bottom-left'   => __('Bottom Left', 'swiftaddons-for-elementor'),
                    'bottom-right'  => __('Bottom Right', 'swiftaddons-for-elementor'),
                ],
                'default' => 'top-right',
                'condition' => ['show_quote_icon' => 'yes'],
            ]
        );

        $this->end_controls_section();

        // Slider Settings
        $this->start_controls_section(
            'section_slider_settings',
            [
                'label' => __('Slider Settings', 'swiftaddons-for-elementor'),
                'condition' => ['display_mode' => 'slider'],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => __('Autoplay', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'swiftaddons-for-elementor'),
                'label_off' => __('No', 'swiftaddons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay_speed',
            [
                'label' => __('Autoplay Speed (ms)', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1000,
                'max' => 10000,
                'step' => 100,
                'default' => 3000,
                'condition' => ['autoplay' => 'yes'],
            ]
        );

        $this->add_control(
            'loop',
            [
                'label' => __('Infinite Loop', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'swiftaddons-for-elementor'),
                'label_off' => __('No', 'swiftaddons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_arrows',
            [
                'label' => __('Show Arrows', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'swiftaddons-for-elementor'),
                'label_off' => __('No', 'swiftaddons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_dots',
            [
                'label' => __('Show Dots', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'swiftaddons-for-elementor'),
                'label_off' => __('No', 'swiftaddons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'pause_on_hover',
            [
                'label' => __('Pause on Hover', 'swiftaddons-for-elementor'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'swiftaddons-for-elementor'),
                'label_off' => __('No', 'swiftaddons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['autoplay' => 'yes'],
            ]
        );

        $this->end_controls_section();

        // General Styles
        // Content Styles
        // Author Styles
        // Image Styles        
        // Rating Styles        
        // Quote Icon Styles      
        // Social Icons Styles        
        // Navigation Styles

        //--------------

       swiffoel_testimonial_style_controls( $this );

        //------------------------------------

    }
protected function render() {
    $settings = $this->get_settings_for_display();
    $id = 'testimonial-' . $this->get_id();

    $this->add_render_attribute('wrapper', 'id', $id);
    $this->add_render_attribute('wrapper', 'class', [
        'testimonial-wrapper',
        'layout-' . $settings['layout_style'],
        'content-position-' . $settings['content_position'],
        'image-position-' . $settings['image_position'],
    ]);

    if ($settings['display_mode'] === 'slider') {
        // Custom slider container
$this->add_render_attribute('wrapper', 'class', 'sa-testimonial-slider');
$this->add_render_attribute('wrapper', 'data-autoplay', $settings['autoplay']);
$this->add_render_attribute('wrapper', 'data-autoplay-speed', intval($settings['autoplay_speed']));
$this->add_render_attribute('wrapper', 'data-loop', $settings['loop']);
$this->add_render_attribute('wrapper', 'data-pause-on-hover', $settings['pause_on_hover']);
$this->add_render_attribute('wrapper', 'data-slides-per-view', intval($settings['slides_per_view']));

// Conditionally add 'no-arrows' class if arrows disabled for CSS to hide
if ($settings['show_arrows'] !== 'yes') {
  $this->add_render_attribute('wrapper', 'class', 'no-arrows');
}

        ?>
        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
            <div class="sa-slider-wrapper">
                <?php foreach ($settings['testimonials'] as $item): ?>
                    <div class="sa-slide testimonial-item">
                        <?php if ($settings['content_position'] === 'above'): ?>
                            <div class="testimonial-content">
                                <?php if ($settings['show_quote_icon'] === 'yes' && !empty($settings['quote_icon']['value'])): ?>
                                    <div class="quote-icon quote-<?php echo esc_attr($settings['quote_position']); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon($settings['quote_icon'], ['aria-hidden' => 'true']); ?>
                                    </div>
                                <?php endif; ?>
                                <p class="testimonial-text"><?php echo esc_html($item['testimonial_content']); ?></p>
                            </div>
                        <?php endif; ?>

                        <div class="testimonial-author">
                            <?php if ($item['show_image'] === 'yes' && !empty($item['photo']['url'])): ?>
                                <img src="<?php echo esc_url($item['photo']['url']); ?>" alt="<?php echo esc_attr($item['name']); ?>">
                            <?php endif; ?>
                            <div class="author-details">
                                <h4><?php echo esc_html($item['name']); ?></h4>
                                <span class="designation"><?php echo esc_html($item['designation']); ?></span>
                                <?php if (!empty($item['company'])): ?>
                                    <span class="company"><?php echo esc_html($item['company']); ?></span>
                                <?php endif; ?>
                            </div>
                            <?php if ($item['show_rating'] === 'yes'): ?>
                                <div class="testimonial-rating">
                                    <?php for ($i = 1; $i <= 5; $i++): ?>
                                        <span class="star <?php echo ($i <= $item['rating']) ? 'filled' : ''; ?>">★</span>
                                    <?php endfor; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if ($settings['content_position'] === 'below'): ?>
                            <div class="testimonial-content">
                                <?php if ($settings['show_quote_icon'] === 'yes' && !empty($settings['quote_icon']['value'])): ?>
                                    <div class="quote-icon quote-<?php echo esc_attr($settings['quote_position']); ?>">
                                        <?php \Elementor\Icons_Manager::render_icon($settings['quote_icon'], ['aria-hidden' => 'true']); ?>
                                    </div>
                                <?php endif; ?>
                                <p class="testimonial-text"><?php echo esc_html($item['testimonial_content']); ?></p>
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($item['social_profiles'])): ?>
                            <div class="testimonial-social">
                                <?php
                                $count = 0;
                                foreach ($item['social_profiles'] as $profile) {
                                    if ($count >= 5) break;
                                    if (empty($profile['social_icon']['value']) || empty($profile['social_link']['url'])) continue;

                                    $link = $profile['social_link']['url'];
                                    ?>
                                    <a href="<?php echo esc_url($link); ?>"
                                       target="<?php echo !empty($profile['social_link']['is_external']) ? '_blank' : ''; ?>"
                                       rel="<?php echo !empty($profile['social_link']['nofollow']) ? 'nofollow' : ''; ?>">
                                        <?php \Elementor\Icons_Manager::render_icon($profile['social_icon'], ['aria-hidden' => 'true']); ?>
                                    </a>
                                    <?php
                                    $count++;
                                }
                                ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>

            <?php if ($settings['show_arrows'] === 'yes'): ?>
                <button class="sa-prev" aria-label="<?php esc_attr_e('Previous Slide', 'swiftaddons-for-elementor'); ?>">❮</button>
                <button class="sa-next" aria-label="<?php esc_attr_e('Next Slide', 'swiftaddons-for-elementor'); ?>">❯</button>
            <?php endif; ?>

            <?php if ($settings['show_dots'] === 'yes'): ?>
                <div class="sa-pagination"></div>
            <?php endif; ?>
        </div>
        <?php
    } else {
        // GRID MODE
        $this->add_render_attribute('wrapper', 'class', 'testimonial-grid columns-' . $settings['columns']);
        ?>
        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
            <?php foreach ($settings['testimonials'] as $item): ?>
                <div class="testimonial-item">
                    <!-- Your grid content remains the same -->
                    <?php if ($settings['content_position'] === 'above'): ?>
                        <div class="testimonial-content">
                            <?php if ($settings['show_quote_icon'] === 'yes' && !empty($settings['quote_icon']['value'])): ?>
                                <div class="quote-icon quote-<?php echo esc_attr($settings['quote_position']); ?>">
                                    <?php \Elementor\Icons_Manager::render_icon($settings['quote_icon'], ['aria-hidden' => 'true']); ?>
                                </div>
                            <?php endif; ?>
                            <p class="testimonial-text"><?php echo esc_html($item['testimonial_content']); ?></p>
                        </div>
                    <?php endif; ?>

                    <div class="testimonial-author">
                        <?php if ($item['show_image'] === 'yes' && !empty($item['photo']['url'])): ?>
                            <img src="<?php echo esc_url($item['photo']['url']); ?>" alt="<?php echo esc_attr($item['name']); ?>">
                        <?php endif; ?>
                        <div class="author-details">
                            <h4><?php echo esc_html($item['name']); ?></h4>
                            <span class="designation"><?php echo esc_html($item['designation']); ?></span>
                            <?php if (!empty($item['company'])): ?>
                                <span class="company"><?php echo esc_html($item['company']); ?></span>
                            <?php endif; ?>
                        </div>
                        <?php if ($item['show_rating'] === 'yes'): ?>
                            <div class="testimonial-rating">
                                <?php for ($i = 1; $i <= 5; $i++): ?>
                                    <span class="star <?php echo ($i <= $item['rating']) ? 'filled' : ''; ?>">★</span>
                                <?php endfor; ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if ($settings['content_position'] === 'below'): ?>
                        <div class="testimonial-content">
                            <?php if ($settings['show_quote_icon'] === 'yes' && !empty($settings['quote_icon']['value'])): ?>
                                <div class="quote-icon quote-<?php echo esc_attr($settings['quote_position']); ?>">
                                    <?php \Elementor\Icons_Manager::render_icon($settings['quote_icon'], ['aria-hidden' => 'true']); ?>
                                </div>
                            <?php endif; ?>
                            <p class="testimonial-text"><?php echo esc_html($item['testimonial_content']); ?></p>
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($item['social_profiles'])): ?>
                        <div class="testimonial-social">
                            <?php
                            $count = 0;
                            foreach ($item['social_profiles'] as $profile) {
                                if ($count >= 5) break;
                                if (empty($profile['social_icon']['value']) || empty($profile['social_link']['url'])) continue;

                                $link = $profile['social_link']['url'];
                                ?>
                                <a href="<?php echo esc_url($link); ?>"
                                   target="<?php echo !empty($profile['social_link']['is_external']) ? '_blank' : ''; ?>"
                                   rel="<?php echo !empty($profile['social_link']['nofollow']) ? 'nofollow' : ''; ?>">
                                    <?php \Elementor\Icons_Manager::render_icon($profile['social_icon'], ['aria-hidden' => 'true']); ?>
                                </a>
                                <?php
                                $count++;
                            }
                            ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
        <?php
    }
}

}