<?php
namespace SWIFFOEL\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Group_Control_Image_Size;
require_once __DIR__ . '/teamMember-style-controls.php';


if ( ! defined( 'ABSPATH' ) ) exit;

class Team_Member extends Widget_Base {

    public function get_name() {
        return 'sa-team-member';
    }

    public function get_title() {
        return __( 'Advanced Team Members swiftaddons', 'swiftaddons-for-elementor' );
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_categories() {
        return [ 'swiftaddons-for-elementor' ];
    }

    protected function register_controls() {

        // -------------------------
        // Team Members (Repeater)
        // -------------------------
        $this->start_controls_section(
            'section_members',
            [
                'label' => __( 'Team Members', 'swiftaddons-for-elementor' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'photo',
            [
                'label'   => __( 'Photo', 'swiftaddons-for-elementor' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [ 'url' => \Elementor\Utils::get_placeholder_image_src() ],
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label'       => __( 'Name', 'swiftaddons-for-elementor' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => __( 'John Doe', 'swiftaddons-for-elementor' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'role',
            [
                'label'   => __( 'Designation', 'swiftaddons-for-elementor' ),
                'type'    => Controls_Manager::TEXT,
                'default' => __( 'CEO', 'swiftaddons-for-elementor' ),
            ]
        );

        $repeater->add_control(
            'bio',
            [
                'label'   => __( 'Short Bio', 'swiftaddons-for-elementor' ),
                'type'    => Controls_Manager::TEXTAREA,
                'default' => __( 'Short description about this team member.', 'swiftaddons-for-elementor' ),
            ]
        );

        // Social Media Repeater
        $repeater->add_control(
            'social_heading',
            [
                'label' => __( 'Social Media', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $social_repeater = new Repeater();

        $social_repeater->add_control(
            'social_icon',
            [
                'label' => __( 'Icon', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fab fa-wordpress',
                    'library' => 'fa-brands',
                ],
                'recommended' => [
                    'fa-brands' => [
                        'facebook',
                        'twitter',
                        'linkedin',
                        'instagram',
                        'youtube',
                        'pinterest',
                    ],
                ],
            ]
        );

        $social_repeater->add_control(
            'social_link',
            [
                'label' => __( 'Link', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'swiftaddons-for-elementor' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $repeater->add_control(
            'social_icons',
            [
                'label' => __( 'Social Icons', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $social_repeater->get_controls(),
                'default' => [
                    [
                        'social_icon' => [
                            'value' => 'fab fa-facebook',
                            'library' => 'fa-brands',
                        ],
                    ],
                    [
                        'social_icon' => [
                            'value' => 'fab fa-twitter',
                            'library' => 'fa-brands',
                        ],
                    ],
                ],
                'title_field' => '<# var migrated = "undefined" !== typeof __fa4_migrated, social = ( "undefined" === typeof social ) ? false : social; #>{{{ elementor.helpers.getSocialNetworkNameFromIcon( social_icon, social, true, migrated, true ) }}}',
            ]
        );

        $this->add_control(
            'members',
            [
                'label'       => __( 'Members', 'swiftaddons-for-elementor' ),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ name }}}',
                'default'     => [
                    [ 'name' => 'John Doe', 'role' => 'CEO' ],
                    [ 'name' => 'Jane Smith', 'role' => 'Designer' ],
                    [ 'name' => 'Alex Brown', 'role' => 'Developer' ],
                ],
            ]
        );

        $this->end_controls_section();

        // -------------------------
        // Layout Preset
        // -------------------------
        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Layout', 'swiftaddons-for-elementor' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'preset_style',
            [
                'label'   => __( 'Preset Style', 'swiftaddons-for-elementor' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'card',
                'options' => [
                    'card'     => __( 'Card', 'swiftaddons-for-elementor' ),
                    'bordered' => __( 'Bordered', 'swiftaddons-for-elementor' ),
                    'shadowed' => __( 'Shadowed', 'swiftaddons-for-elementor' ),
                    'minimal'  => __( 'Minimal', 'swiftaddons-for-elementor' ),
                ],
            ]
        );

        $this->add_control(
    'enable_carousel',
    [
        'label'        => __( 'Enable Carousel', 'swiftaddons-for-elementor' ),
        'type'         => \Elementor\Controls_Manager::SWITCHER,
        'label_on'     => __( 'Yes', 'swiftaddons-for-elementor' ),
        'label_off'    => __( 'No', 'swiftaddons-for-elementor' ),
        'default'      => 'no',
    ]
);



$this->add_control(
    'carousel_slides',
    [
        'label' => __( 'Slides Per View', 'swiftaddons-for-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'options' => [
            '1' => '1 slides',
            '2' => '2 slides',
            '3' => '3 slides',
            '4' => '4 slides',
        ],
        'default' => '3',
        'condition' => [
            'enable_carousel' => 'yes',
        ],
    ]
);


$this->add_control(
    'autoplay',
    [
        'label' => __( 'Autoplay', 'swiftaddons-for-elementor' ),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => __( 'Yes', 'swiftaddons-for-elementor' ),
        'label_off' => __( 'No', 'swiftaddons-for-elementor' ),
        'default' => 'no',
        'condition' => [ 'enable_carousel' => 'yes' ],
    ]
);
$this->add_control(
    'autoplay_delay',
    [
        'label' => __( 'Autoplay Delay (ms)', 'swiftaddons-for-elementor' ),
        'type' => Controls_Manager::NUMBER,
        'default' => 2000,
        'min' => 500,
        'max' => 10000,
        'step' => 100,
        'condition' => [ 'enable_carousel' => 'yes', 'autoplay' => 'yes' ],
    ]
);
$this->add_control(
    'loop',
    [
        'label' => __( 'Infinite Loop', 'swiftaddons-for-elementor' ),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => __( 'Yes', 'swiftaddons-for-elementor' ),
        'label_off' => __( 'No', 'swiftaddons-for-elementor' ),
        'default' => 'no',
        'condition' => [ 'enable_carousel' => 'yes' ],
    ]
);
// Add these controls after your existing carousel controls



$this->add_control(
  'show_arrows',
  [
    'label' => __( 'Show Arrows', 'swiftaddons-for-elementor' ),
    'type' => Controls_Manager::SWITCHER,
    'default' => 'yes',
    'condition' => [ 'enable_carousel' => 'yes' ],
  ]
);

$this->add_control(
  'show_dots',
  [
    'label' => __( 'Show Dots', 'swiftaddons-for-elementor' ),
    'type' => Controls_Manager::SWITCHER,
    'default' => 'yes',
    'condition' => [ 'enable_carousel' => 'yes' ],
  ]
);

$this->add_control(
  'pause_on_hover',
  [
    'label' => __( 'Pause on Hover', 'swiftaddons-for-elementor' ),
    'type' => Controls_Manager::SWITCHER,
    'default' => 'yes',
    'condition' => [ 'enable_carousel' => 'yes' ],
  ]
);

        // Columns (responsive) — only applies when using GRID layout (not carousel)
$this->add_responsive_control(
    'columns',
    [
        'label' => __( 'Columns', 'swiftaddons-for-elementor' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => '3',
        'tablet_default' => '2',
        'mobile_default' => '1',
        'options' => [
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
        ],
        // IMPORTANT: target only the grid wrapper so carousel is unaffected
        'selectors' => [
            '{{WRAPPER}} .sa-team-grid' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
        ],
    ]
);


        $this->add_control(
            'image_size',
            [
                'label' => __( 'Image Size', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 50,
                        'max' => 200,
                        'step' => 5,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 110,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sa-team .sa-member-photo img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_alignment',
            [
                'label' => __( 'Content Alignment', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'swiftaddons-for-elementor' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'swiftaddons-for-elementor' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'swiftaddons-for-elementor' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .sa-member' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        //--------------

      swiffoel_testimonial_style_controls( $this );

        //------------------------------------
    }

protected function render() {
    $s = $this->get_settings_for_display();
    if ( empty( $s['members'] ) ) {
        return;
    }
    $preset = ! empty( $s['preset_style'] ) ? $s['preset_style'] : 'card';
    $is_carousel = !empty($s['enable_carousel']) && 'yes' === $s['enable_carousel'];
    $hover_class = (!empty($s['enable_hover_effect']) && $s['enable_hover_effect'] === 'yes') ? ' sa-hover-' . $s['hover_effect'] : '';
    $social_style_class = !empty($s['social_icon_style']) ? ' sa-social-' . $s['social_icon_style'] : '';
    $wrapper_classes = sprintf( 'sa-team sa-showcase-%s%s%s', esc_attr( $preset ), $hover_class, $social_style_class );
    
    if ( $is_carousel ) {
        $slides_per_view = !empty($s['carousel_slides']) ? intval($s['carousel_slides']) : 3;
        $autoplay = (!empty($s['autoplay']) && $s['autoplay'] === 'yes') ? 'yes' : 'no';
        $autoplay_delay = !empty($s['autoplay_delay']) ? intval($s['autoplay_delay']) : 2500;
        $loop = (!empty($s['loop']) && $s['loop'] === 'yes') ? 'yes' : 'no';
        $pause_on_hover = (!empty($s['pause_on_hover']) && $s['pause_on_hover'] === 'yes') ? 'yes' : 'no';
        $show_arrows = (!empty($s['show_arrows']) && $s['show_arrows'] === 'yes') ? 'yes' : 'no';
        $show_dots = (!empty($s['show_dots']) && $s['show_dots'] === 'yes') ? 'yes' : 'no';
        
        $slider_classes = 'sa-team-slider';
        if ($show_arrows !== 'yes') {
            $slider_classes .= ' no-arrows';
        }
        ?>
        <div class="<?php echo esc_attr($slider_classes); ?>" 
             data-autoplay="<?php echo esc_attr($autoplay); ?>" 
             data-autoplay-speed="<?php echo esc_attr($autoplay_delay); ?>" 
             data-loop="<?php echo esc_attr($loop); ?>" 
             data-pause-on-hover="<?php echo esc_attr($pause_on_hover); ?>" 
             data-slides-per-view="<?php echo esc_attr($slides_per_view); ?>">
            
            <div class="sa-slider-wrapper">
                <?php foreach ( $s['members'] as $m ) : 
                    $img_url = ! empty( $m['photo']['url'] ) ? $m['photo']['url'] : \Elementor\Utils::get_placeholder_image_src();
                    ?>
                    <div class="sa-slide">
                        <div class="sa-member">
                            <div class="sa-member-photo">
                                <img src="<?php echo esc_url( $img_url ); ?>" alt="<?php echo esc_attr( $m['name'] ?? '' ); ?>">
                            </div>
                            <h3 class="sa-member-name"><?php echo esc_html( $m['name'] ?? '' ); ?></h3>
                            <div class="sa-member-role"><?php echo esc_html( $m['role'] ?? '' ); ?></div>
                            <?php if ( ! empty( $m['bio'] ) ) : ?>
                                <div class="sa-member-bio"><?php echo esc_html( $m['bio'] ); ?></div>
                            <?php endif; ?>
                            <?php if ( ! empty( $m['social_icons'] ) ) : ?>
                                <div class="sa-social-icons">
                                    <?php 
                                    $social_count = 0;
                                    foreach ( $m['social_icons'] as $social ) : 
                                        if ($social_count >= 5) break;
                                        if ( ! empty( $social['social_icon']['value'] ) ) :
                                            $social_link = ! empty( $social['social_link']['url'] ) ? $social['social_link']['url'] : '#';
                                            $social_name = '';
                                            if (isset($social['social_icon']['value'])) {
                                                $icon_parts = explode(' ', $social['social_icon']['value']);
                                                if (count($icon_parts) > 1) {
                                                    $social_name = str_replace('fa-', '', $icon_parts[1]);
                                                }
                                            }
                                            ?>
                                            <a href="<?php echo esc_url( $social_link ); ?>"
                                               class="sa-social-<?php echo esc_attr( $social_name ); ?>"
                                               <?php echo ! empty( $social['social_link']['is_external'] ) ? 'target="_blank"' : ''; ?>
                                               <?php echo ! empty( $social['social_link']['nofollow'] ) ? 'rel="nofollow"' : ''; ?>>
                                                <?php \Elementor\Icons_Manager::render_icon( $social['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            </a>
                                            <?php
                                            $social_count++;
                                        endif;
                                    endforeach; 
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <?php if ($show_arrows === 'yes') : ?>
                <button class="sa-prev" aria-label="<?php esc_attr_e('Previous Slide', 'swiftaddons-for-elementor'); ?>">❮</button>
                <button class="sa-next" aria-label="<?php esc_attr_e('Next Slide', 'swiftaddons-for-elementor'); ?>">❯</button>
            <?php endif; ?>

            <?php if ($show_dots === 'yes') : ?>
                <div class="sa-pagination"></div>
            <?php endif; ?>
        </div>
        <?php
    } else {
        // Grid layout (unchanged)
        echo '<div class="sa-team-grid ' . esc_attr( $wrapper_classes ) . '">';
        
        foreach ( $s['members'] as $m ) {
            $img_url = ! empty( $m['photo']['url'] ) ? $m['photo']['url'] : \Elementor\Utils::get_placeholder_image_src();
            ?>
            <div class="sa-member">
                <div class="sa-member-photo">
                    <img src="<?php echo esc_url( $img_url ); ?>" alt="<?php echo esc_attr( $m['name'] ?? '' ); ?>">
                </div>
                <h3 class="sa-member-name"><?php echo esc_html( $m['name'] ?? '' ); ?></h3>
                <div class="sa-member-role"><?php echo esc_html( $m['role'] ?? '' ); ?></div>
                <?php if ( ! empty( $m['bio'] ) ) : ?>
                    <div class="sa-member-bio"><?php echo esc_html( $m['bio'] ); ?></div>
                <?php endif; ?>
                
                <?php if ( ! empty( $m['social_icons'] ) ) : ?>
                    <div class="sa-social-icons">
                        <?php 
                        $social_count = 0;
                        foreach ( $m['social_icons'] as $social ) : 
                            if ($social_count >= 5) break;
                            
                            if ( ! empty( $social['social_icon']['value'] ) ) :
                                $social_link = ! empty( $social['social_link']['url'] ) ? $social['social_link']['url'] : '#';
                                $social_name = '';
                                if (isset($social['social_icon']['value'])) {
                                    $icon_parts = explode(' ', $social['social_icon']['value']);
                                    if (count($icon_parts) > 1) {
                                        $social_name = str_replace('fa-', '', $icon_parts[1]);
                                    }
                                }
                                ?>
                                <a href="<?php echo esc_url( $social_link ); ?>"
                                   class="sa-social-<?php echo esc_attr( $social_name ); ?>"
                                   <?php echo ! empty( $social['social_link']['is_external'] ) ? 'target="_blank"' : ''; ?>
                                   <?php echo ! empty( $social['social_link']['nofollow'] ) ? 'rel="nofollow"' : ''; ?>>
                                    <?php \Elementor\Icons_Manager::render_icon( $social['social_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </a>
                                <?php
                                $social_count++;
                            endif;
                        endforeach; 
                        ?>
                    </div>
                <?php endif; ?>
            </div>
            <?php
        }
        
        echo '</div>'; // sa-team-grid
    }
}
}