<?php
namespace SWIFFOEL\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Image_Size;
require_once __DIR__ . '/infobox-style-controls.php';

if ( ! defined( 'ABSPATH' ) ) exit;

class InfoBox extends Widget_Base {

    public function get_name() {
        return 'showcase_infobox';
    }

    public function get_title() {
        return __( 'Advanced Info Box', 'swiftaddons-for-elementor' );
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_categories() {
        return [ 'general' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Info Boxes', 'swiftaddons-for-elementor' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        // Style presets
        $this->add_control(
            'preset_style',
            [
                'label' => __( 'Preset Style', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'card',
                'options' => [
                    'card'     => __( 'Card', 'swiftaddons-for-elementor' ),
                    'minimal'  => __( 'Minimal', 'swiftaddons-for-elementor' ),
                    'bordered' => __( 'Bordered', 'swiftaddons-for-elementor' ),
                    'shadowed' => __( 'Shadowed', 'swiftaddons-for-elementor' ),
                ],
            ]
        );

        // Repeater for multiple boxes
        $repeater = new Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => __( 'Icon Type', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'icon' => [
                        'title' => __( 'Icon', 'swiftaddons-for-elementor' ),
                        'icon' => 'eicon-star',
                    ],
                    'image' => [
                        'title' => __( 'Image', 'swiftaddons-for-elementor' ),
                        'icon' => 'eicon-image',
                    ],
                ],
                'default' => 'icon',
                'toggle' => true,
            ]
        );

        $repeater->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::ICONS,
                'condition' => [ 'icon_type' => 'icon' ],
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::MEDIA,
                'condition' => [ 'icon_type' => 'image' ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __( 'Title', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Info Box Title', 'swiftaddons-for-elementor' ),
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => __( 'Description', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::TEXTAREA,
                'placeholder' => __( 'This is the info box description.', 'swiftaddons-for-elementor' ),
            ]
        );

        $repeater->add_control(
    'show_button',
    [
        'label' => __( 'Show Button', 'swiftaddons-for-elementor' ),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => __( 'Yes', 'swiftaddons-for-elementor' ),
        'label_off' => __( 'No', 'swiftaddons-for-elementor' ),
        'return_value' => 'yes',
        'default' => 'yes',
    ]
);

$repeater->add_control(
    'button_text',
    [
        'label' => __( 'Button Text', 'swiftaddons-for-elementor' ),
        'type' => Controls_Manager::TEXT,
        'default' => __( 'Learn More', 'swiftaddons-for-elementor' ),
        'placeholder' => __( 'Learn More', 'swiftaddons-for-elementor' ),
        'condition' => [ 'show_button' => 'yes' ],
    ]
);


        $repeater->add_control(
            'button_link',
            [
                'label' => __( 'Button Link', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'swiftaddons-for-elementor' ),
            ]
        );

        $this->add_control(
            'infoboxes',
            [
                'label' => __( 'Info Boxes', 'swiftaddons-for-elementor' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __( 'First Box', 'swiftaddons-for-elementor' ),
                        'description' => __( 'Description for first box.', 'swiftaddons-for-elementor' ),
                    ],
                    [
                        'title' => __( 'Second Box', 'swiftaddons-for-elementor' ),
                        'description' => __( 'Description for second box.', 'swiftaddons-for-elementor' ),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

            // Call style controls from the included file
    swiffoel_infobox_register_style_controls( $this );
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        echo '<div class="showcase-infobox showcase-' . esc_attr( $settings['preset_style'] ) . '">';

        foreach ( $settings['infoboxes'] as $box ) {
            echo '<div class="infobox-item">';
            
            // Image or Icon
            if ( $box['icon_type'] === 'icon' && ! empty( $box['icon']['value'] ) ) {
                echo '<div class="infobox-icon"><i class="' . esc_attr( $box['icon']['value'] ) . '"></i></div>';
            } elseif ( $box['icon_type'] === 'image' && ! empty( $box['image']['url'] ) ) {
                echo '<div class="infobox-image"><img src="' . esc_url( $box['image']['url'] ) . '" alt="' . esc_attr( $box['title'] ) . '"></div>';
            }

            // Title
            if ( ! empty( $box['title'] ) ) {
                echo '<h3 class="infobox-title">' . esc_html( $box['title'] ) . '</h3>';
            }

            // Description
            if ( ! empty( $box['description'] ) ) {
                echo '<p class="infobox-desc">' . esc_html( $box['description'] ) . '</p>';
            }

            
            // Button
            if ( ! empty( $box['show_button'] ) && 'yes' === $box['show_button'] ) {
                $button_text = ! empty( $box['button_text'] ) ? $box['button_text'] : __( 'Learn More', 'swiftaddons-for-elementor' );
                $button_url = ! empty( $box['button_link']['url'] ) ? $box['button_link']['url'] : '#';

                echo '<a href="' . esc_url( $button_url ) . '" class="infobox-btn"';
                if ( ! empty( $box['button_link']['is_external'] ) ) {
                    echo ' target="_blank"';
                }
                if ( ! empty( $box['button_link']['nofollow'] ) ) {
                    echo ' rel="nofollow"';
                }
                echo '>' . esc_html( $button_text ) . '</a>';
            }



            echo '</div>';
        }

        echo '</div>';
    }
}