<?php
namespace SWIFFOEL;

if ( ! defined( 'ABSPATH' ) ) exit;

class Plugin_Loader {

    private static $_instance = null;

    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        // Hook into Elementor widget registration
        add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
    }

    public function register_widgets( $widgets_manager ) {
        // Include widget files if they are not already loaded
        if ( ! class_exists( '\SWIFFOEL\Widgets\InfoBox' ) ) { 
            require_once SWIFFOEL_PATH . 'includes/widgets/class-info-box.php';  
        }

        if ( ! class_exists( '\SWIFFOEL\Widgets\Team_Member' ) ) {  
            require_once SWIFFOEL_PATH . 'includes/widgets/class-team-member.php'; 
        }

        if ( ! class_exists( '\SWIFFOEL\Widgets\Testimonial' ) ) {  
            require_once SWIFFOEL_PATH . 'includes/widgets/class-testimonial.php';  
        }

        // Register widgets
        $widgets_manager->register( new \SWIFFOEL\Widgets\InfoBox() );  
        $widgets_manager->register( new \SWIFFOEL\Widgets\Team_Member() );  
        $widgets_manager->register( new \SWIFFOEL\Widgets\Testimonial() );  
    }
}