<?php
/**
 * Uninstall Swift Offload Plugin
 *
 * @package SwiftOffload
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Delete plugin options
$options_to_delete = array(
	'swift_offload_settings',
	'swift_offload_storage_config',
	'swift_offload_cdn_config',
	'swift_offload_rules_config',
	'swift_offload_version',
	'swift_offload_db_version',
	'swift_offload_activation_time',
);

foreach ( $options_to_delete as $option ) {
	delete_option( $option );
	delete_site_option( $option ); // For multisite
}

// Drop custom tables
global $wpdb;

$tables_to_drop = array(
	$wpdb->prefix . 'swift_offload_items',
	$wpdb->prefix . 'swift_offload_jobs',
	$wpdb->prefix . 'swift_offload_settings',
);

foreach ( $tables_to_drop as $table ) {
	// Table names are hardcoded with $wpdb->prefix above, not user input.
	// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared -- Table name is safely constructed from $wpdb->prefix constant.
	$wpdb->query( "DROP TABLE IF EXISTS `{$table}`" );
}

// Clear any scheduled cron events
wp_clear_scheduled_hook( 'swift_offload_process_jobs' );
wp_clear_scheduled_hook( 'swift_offload_cleanup_logs' );

// Remove user meta related to Swift Offload
$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->usermeta} WHERE meta_key LIKE %s", 'swift_offload_%' ) );

// Remove post meta related to Swift Offload
$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE %s", '_swift_offload_%' ) );

// Clear any cached data
wp_cache_flush();
