<?php
/**
 * Plugin Name: Swift Offload
 * Plugin URI: https://swiftplugins.pro/swift-offload
 * Description: Offload WordPress media files to Amazon S3, S3-compatible storage, and serve via CloudFront CDN with advanced management tools.
 * Version: 1.0.3
 * Requires at least: 5.6
 * Requires PHP: 7.4
 * Author: Swift Plugins
 * Author URI: https://swiftplugins.pro
 * Text Domain: swift-offload
 * Domain Path: /languages
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package SwiftOffload
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
define( 'SWIFT_OFFLOAD_VERSION', '1.0.3' );
define( 'SWIFT_OFFLOAD_PLUGIN_FILE', __FILE__ );
define( 'SWIFT_OFFLOAD_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'SWIFT_OFFLOAD_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'SWIFT_OFFLOAD_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );
define( 'SWIFT_OFFLOAD_TEXT_DOMAIN', 'swift-offload' );
define( 'SWIFT_OFFLOAD_SLUG', 'swift-offload' );
define( 'SWIFT_OFFLOAD_NAME', 'Swift Offload' );
define( 'SWIFT_OFFLOAD_ASSETS', SWIFT_OFFLOAD_PLUGIN_URL . 'assets/' );
define( 'SWIFT_OFFLOAD_IMAGES', SWIFT_OFFLOAD_PLUGIN_URL . 'assets/images/' );

// Check minimum PHP version.
if ( version_compare( PHP_VERSION, '7.4', '<' ) ) {
	add_action(
		'admin_notices',
		function () {
			echo '<div class="notice notice-error"><p>';
			echo esc_html(
				sprintf(
					/* translators: %s: Current PHP version. */
					__( 'Swift Offload requires PHP 7.4 or higher. You are running PHP %s.', 'swift-offload' ),
					PHP_VERSION
				)
			);
			echo '</p></div>';
		}
	);
	return;
}

// Check minimum WordPress version.
global $wp_version;
if ( version_compare( $wp_version, '5.0', '<' ) ) {
	add_action(
		'admin_notices',
		function () {
			echo '<div class="notice notice-error"><p>';
			echo esc_html(
				sprintf(
					/* translators: %s: Current WordPress version. */
					__( 'Swift Offload requires WordPress 5.0 or higher. You are running WordPress %s.', 'swift-offload' ),
					$GLOBALS['wp_version']
				)
			);
			echo '</p></div>';
		}
	);
	return;
}

// Load the bootstrap file.
require_once SWIFT_OFFLOAD_PLUGIN_DIR . 'includes/bootstrap.php';

// Plugin activation hook.
register_activation_hook( __FILE__, 'swift_offload_activate_plugin' );

// Plugin deactivation hook.
register_deactivation_hook( __FILE__, 'swift_offload_deactivate_plugin' );

/**
 * Plugin activation callback.
 *
 * @return void
 */
function swift_offload_activate_plugin() {
	if ( class_exists( 'SwiftOffload\Plugin' ) ) {
		SwiftOffload\Plugin::activate();
	}
}

/**
 * Plugin deactivation callback.
 *
 * @return void
 */
function swift_offload_deactivate_plugin() {
	if ( class_exists( 'SwiftOffload\Plugin' ) ) {
		SwiftOffload\Plugin::deactivate();
	}
}
