<?php
/**
 * Bootstrap file for Swift Offload plugin
 *
 * @package SwiftOffload
 */

namespace SwiftOffload;

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Load helper functions
require_once SWIFT_OFFLOAD_PLUGIN_DIR . 'includes/utils/helpers.php';

// Class autoloader for SwiftOffload namespace
spl_autoload_register(
	function ( $class ) {
		// Only autoload SwiftOffload classes
		if ( strpos( $class, 'SwiftOffload\\' ) !== 0 ) {
			return;
		}

		// Remove namespace prefix
		$class = str_replace( 'SwiftOffload\\', '', $class );

		// Convert class name to file path
		$class_parts = explode( '\\', $class );
		$class_name  = end( $class_parts );

		// Check if it's an interface
		if ( strpos( $class_name, '_Interface' ) !== false || strpos( $class_name, 'Interface' ) !== false ) {
			$class_file = 'interface-' . strtolower( str_replace( array( '_Interface', 'Interface', '_' ), array( '', '', '-' ), $class_name ) ) . '.php';
		} else {
			$class_file = 'class-' . strtolower( str_replace( '_', '-', $class_name ) ) . '.php';
		}

		// Build possible file paths with subdirectory support
		$subdirs     = array_slice( $class_parts, 0, -1 );
		$subdir_path = ! empty( $subdirs ) ? strtolower( implode( '/', $subdirs ) ) . '/' : '';

		$paths = array(
			SWIFT_OFFLOAD_PLUGIN_DIR . 'includes/' . $class_file,
			SWIFT_OFFLOAD_PLUGIN_DIR . 'includes/' . $subdir_path . $class_file,
		);

		// Try to load the class file
		foreach ( $paths as $path ) {
			if ( file_exists( $path ) ) {
				require_once $path;
				break;
			}
		}
	}
);

// Initialize the plugin
add_action(
	'plugins_loaded',
	function () {
		// Initialize the main plugin class
		if ( class_exists( 'SwiftOffload\\Plugin' ) ) {
			Plugin::get_instance();
		}
	}
);

// Initialize admin functionality
if ( is_admin() ) {
	add_action(
		'plugins_loaded',
		function () {
			if ( class_exists( 'SwiftOffload\\Admin' ) ) {
				Admin::get_instance();
			}
		}
	);
}
