/**
 * Swift Offload - List View Pointer
 *
 * Shows a WordPress pointer notification suggesting users switch to
 * list view in the Media Library for better optimization controls.
 *
 * Requires: jQuery, wp-pointer
 * Localized data: swiftOffloadPointer (via wp_localize_script)
 */
jQuery(document).ready(function($) {
	if (typeof swiftOffloadPointer === 'undefined') {
		return;
	}

	function initPointer() {
		// Try multiple selectors for the list view button
		var $target = $('.view-switch .view-list');
		if (!$target.length) $target = $('.media-toolbar .view-list');
		if (!$target.length) $target = $('a.view-list');
		if (!$target.length) $target = $('#view-switch-list');
		if (!$target.length) $target = $('[data-view="list"]');

		// Fallback: create an anchor near the media toolbar
		if (!$target.length) {
			$target = $('.media-toolbar-secondary, .media-toolbar, .wp-filter').first();
		}

		if (!$target.length) return;

		// Build pointer content - icon is inside the header div, not h3
		var pointerContent = '<div class="swift-offload-pointer-header">' +
			'<span class="swift-offload-pointer-icon"><svg width="20" height="20" viewBox="0 0 24 24" fill="none"><rect x="3" y="3" width="18" height="18" rx="2" stroke="currentColor" stroke-width="2"/><path d="M3 9h18M9 9v12" stroke="currentColor" stroke-width="2"/></svg></span>' +
			'<span class="swift-offload-pointer-title">' + swiftOffloadPointer.switchText + '</span>' +
			'</div>' +
			'<div class="swift-offload-pointer-body">' +
			'<p class="swift-offload-pointer-message">' + swiftOffloadPointer.bodyText + '</p>' +
			'<div class="swift-offload-pointer-footer">' +
			'<a class="swift-offload-switch-btn" href="' + swiftOffloadPointer.listViewUrl + '">' + swiftOffloadPointer.switchBtnText + '</a>' +
			'<a class="swift-offload-pointer-dismiss" href="#">' +
			'<svg width="14" height="14" viewBox="0 0 24 24" fill="currentColor"><circle cx="12" cy="12" r="10"/><path d="M15 9l-6 6M9 9l6 6" stroke="#fff" stroke-width="2" stroke-linecap="round"/></svg>' +
			swiftOffloadPointer.dismissText +
			'</a>' +
			'</div>' +
			'</div>';

		$target.pointer({
			content: pointerContent,
			position: { edge: 'top', align: 'left' },
			pointerClass: 'wp-pointer swift-offload-list-view-pointer',
			buttons: function() {
				// Return empty - we handle buttons in content
				return $('<span></span>');
			}
		}).pointer('open');

		// Bind dismiss click
		$(document).on('click', '.swift-offload-list-view-pointer .swift-offload-pointer-dismiss', function(e) {
			e.preventDefault();
			$target.pointer('close');
			$.post(swiftOffloadPointer.ajaxUrl, {
				action: 'swift_offload_dismiss_list_view_notice',
				nonce: swiftOffloadPointer.nonce
			});
		});
	}

	// Wait for media grid to initialize
	if (typeof wp !== 'undefined' && wp.media && wp.media.view) {
		setTimeout(initPointer, 500);
	} else {
		initPointer();
	}
});
