<?php
/**
 * Row Links class for Swift Offload.
 *
 * @package SwiftOffload
 */

namespace SwiftOffload\Libs;

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'RowLinks' ) ) {
	/**
	 * Row Links Class
	 *
	 * @since 1.0.0
	 */
	class RowLinks {


		/**
		 * Constructor.
		 */
		public function __construct() {
			add_filter( 'plugin_action_links_' . SWIFT_OFFLOAD_PLUGIN_BASENAME, array( $this, 'plugin_action_links' ) );
		}

		/**
		 * Plugin action links.
		 *
		 * @param array $links Plugin links.
		 *
		 * @author Swift Offload Team <support@swiftplugins.pro>
		 */
		public function plugin_action_links( $links ) {
			return $links;
		}
	}
}
