<?php
/**
 * Assets class for Swift Offload.
 *
 * @package SwiftOffload
 */

namespace SwiftOffload\Libs;

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'Assets' ) ) {

	/**
	 * Assets Class
	 *
	 * @since 1.0.0
	 */
	class Assets {

		/**
		 * Constructor method.
		 *
		 * @author Swift Offload Team <support@swiftplugins.pro>
		 */
		public function __construct() {
			add_action( 'wp_enqueue_scripts', array( $this, 'swift_offload_enqueue_scripts' ), 100 );
			add_action( 'admin_enqueue_scripts', array( $this, 'swift_offload_admin_enqueue_scripts' ), 100 );
		}


		/**
		 * Get environment mode.
		 *
		 * @author Swift Offload Team <support@swiftplugins.pro>
		 */
		public function get_mode() {
			return defined( 'WP_DEBUG' ) && WP_DEBUG ? 'development' : 'production';
		}

		/**
		 * Enqueue Scripts.
		 *
		 * @method wp_enqueue_scripts()
		 */
		public function swift_offload_enqueue_scripts() {

			// CSS Files.
			wp_enqueue_style( 'swift-offload-frontend', SWIFT_OFFLOAD_ASSETS . 'css/swift-offload-frontend.css', array(), SWIFT_OFFLOAD_VERSION, 'all' );

			// JS Files.
			wp_enqueue_script( 'swift-offload-frontend', SWIFT_OFFLOAD_ASSETS . 'js/swift-offload-frontend.js', array( 'jquery' ), SWIFT_OFFLOAD_VERSION, true );
		}


		/**
		 * Enqueue Scripts.
		 *
		 * @param string $hook Current admin page hook.
		 * @method admin_enqueue_scripts()
		 */
		public function swift_offload_admin_enqueue_scripts( $hook ) {
			// Only load on Swift Offload pages to avoid dashboard hijacking.
			if ( strpos( $hook, 'swift-offload' ) === false && strpos( $hook, 'swift_offload' ) === false ) {
				return;
			}

			// CSS Files.
			wp_enqueue_style( 'swift-offload-admin', SWIFT_OFFLOAD_ASSETS . 'css/swift-offload-admin.css', array( 'dashicons' ), SWIFT_OFFLOAD_VERSION, 'all' );

			// JS Files.
			wp_enqueue_script( 'swift-offload-admin', SWIFT_OFFLOAD_ASSETS . 'js/swift-offload-admin.js', array( 'jquery' ), SWIFT_OFFLOAD_VERSION, true );
			wp_localize_script(
				'swift-offload-admin',
				'SWIFT_OFFLOAD_CORE',
				array(
					'admin_ajax'        => admin_url( 'admin-ajax.php' ),
					'recommended_nonce' => wp_create_nonce( 'swift_offload_recommended_nonce' ),
					'is_premium'        => swift_offload_is_premium(),
					'is_agency'         => swift_offload_is_plan( 'agency' ),
				)
			);
		}
	}
}
