<?php
/**
 * Helper functions for Swift Offload.
 *
 * @package SwiftOffload
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'swift_offload_option' ) ) {
	/**
	 * Get setting database option.
	 *
	 * @param string $section Default section name swift_offload_general.
	 * @param string $key Option key.
	 * @param string $default Default value.
	 *
	 * @return string
	 */
	function swift_offload_option( $section = 'swift_offload_general', $key = '', $default = '' ) {
		$settings = get_option( $section );

		return isset( $settings[ $key ] ) ? $settings[ $key ] : $default;
	}
}

if ( ! function_exists( 'swift_offload_exclude_pages' ) ) {
	/**
	 * Get exclude pages setting option data.
	 *
	 * @return string|array
	 *
	 * @version 1.0.0
	 */
	function swift_offload_exclude_pages() {
		return swift_offload_option( 'swift_offload_triggers', 'exclude_pages', array() );
	}
}

if ( ! function_exists( 'swift_offload_exclude_pages_except' ) ) {
	/**
	 * Get exclude pages except setting option data.
	 *
	 * @return string|array
	 *
	 * @version 1.0.0
	 */
	function swift_offload_exclude_pages_except() {
		return swift_offload_option( 'swift_offload_triggers', 'exclude_pages_except', array() );
	}
}



// Check if Premium.
if ( ! function_exists( 'swift_offload_is_premium' ) ) {
	/**
	 * Check if the plugin is premium.
	 *
	 * @return bool
	 */
	function swift_offload_is_premium() {
		return ( class_exists( '\\SwiftOffload\\Pro\\Swift_Offload_Pro' ) && method_exists( '\\SwiftOffload\\Pro\\Swift_Offload_Pro', 'is_premium' ) && \SwiftOffload\Pro\Swift_Offload_Pro::is_premium() );
	}
}

// Check if Plan.
if ( ! function_exists( 'swift_offload_is_plan' ) ) {
	/**
	 * Check if the plugin is plan.
	 *
	 * @param string $plan Plan name.
	 *
	 * @return bool
	 */
	function swift_offload_is_plan( $plan = 'starter' ) {
		return ( class_exists( '\\SwiftOffload\\Pro\\Swift_Offload_Pro' ) && method_exists( '\\SwiftOffload\\Pro\\Swift_Offload_Pro', 'is_plan' ) && \SwiftOffload\Pro\Swift_Offload_Pro::is_plan( $plan ) );
	}
}
