<?php
/**
 * Plugin Name: Swell Smart Responsive Block Suite
 * Plugin URI: https://wordpress.org/plugins/swell-smart-responsive-blocks/
 * Description: The workflow-focused responsive plugin for WordPress blocks. Copy/paste responsive styles, quick action presets, and smart inheritance indicators make responsive design faster and easier.
 * Version: 1.0.0
 * Requires at least: 6.4
 * Requires PHP: 7.4
 * Author: Swell
 * Author URI: https://swellapps.ai
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: swell-smart-responsive-blocks
 *
 * @package SwellSmartResponsiveBlocks
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
define( 'SWELLSRB_VERSION', '1.0.0' );
define( 'SWELLSRB_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'SWELLSRB_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'SWELLSRB_PLUGIN_FILE', __FILE__ );

/**
 * Main plugin class.
 */
class Swell_Smart_Responsive_Blocks {

	/**
	 * Instance of this class.
	 *
	 * @var Swell_Smart_Responsive_Blocks
	 */
	private static $instance = null;

	/**
	 * Get the singleton instance.
	 *
	 * @return Swell_Smart_Responsive_Blocks
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor.
	 */
	private function __construct() {
		$this->load_dependencies();
		$this->init_hooks();
	}

	/**
	 * Load required dependencies.
	 */
	private function load_dependencies() {
		require_once SWELLSRB_PLUGIN_DIR . 'includes/class-attributes.php';
		require_once SWELLSRB_PLUGIN_DIR . 'includes/class-css-generator.php';
		require_once SWELLSRB_PLUGIN_DIR . 'includes/class-frontend.php';
	}

	/**
	 * Initialize WordPress hooks.
	 */
	private function init_hooks() {
		// Enqueue editor assets.
		add_action( 'enqueue_block_editor_assets', array( $this, 'enqueue_editor_assets' ) );

		// Initialize sub-classes.
		SWELLSRB_Attributes::get_instance();
		SWELLSRB_Frontend::get_instance();
	}

	/**
	 * Enqueue block editor assets.
	 */
	public function enqueue_editor_assets() {
		$asset_file = include SWELLSRB_PLUGIN_DIR . 'build/index.asset.php';

		// Enqueue editor JavaScript.
		wp_enqueue_script(
			'swell-smart-responsive-blocks-editor',
			SWELLSRB_PLUGIN_URL . 'build/index.js',
			$asset_file['dependencies'],
			$asset_file['version'],
			true
		);

		// Enqueue editor styles.
		wp_enqueue_style(
			'swell-smart-responsive-blocks-editor',
			SWELLSRB_PLUGIN_URL . 'build/index.css',
			array( 'wp-edit-blocks' ),
			$asset_file['version']
		);

		// Pass configuration to JavaScript.
		wp_localize_script(
			'swell-smart-responsive-blocks-editor',
			'swellsrbConfig',
			array(
			'breakpoints' => array(
				'desktop' => array(
					'label'     => __( 'Desktop', 'swell-smart-responsive-blocks' ),
					'maxWidth'  => null,
					'icon'      => 'desktop',
				),
				'tablet'  => array(
					'label'     => __( 'Tablet', 'swell-smart-responsive-blocks' ),
					'maxWidth'  => 1024,
					'icon'      => 'tablet',
				),
				'mobile'  => array(
					'label'     => __( 'Mobile', 'swell-smart-responsive-blocks' ),
					'maxWidth'  => 767,
					'icon'      => 'smartphone',
					),
				),
				'supportedBlocks' => array(
					'core/group',
					'core/columns',
					'core/column',
					'core/cover',
					'core/heading',
					'core/paragraph',
					'core/image',
					'core/buttons',
					'core/button',
					'core/spacer',
				),
			)
		);
	}

}

/**
 * Initialize the plugin.
 */
function swell_smart_responsive_blocks_init() {
	Swell_Smart_Responsive_Blocks::get_instance();
}
add_action( 'plugins_loaded', 'swell_smart_responsive_blocks_init' );
