/**
 * Get supported blocks configuration.
 */
export const getSupportedBlocks = () => {
	return window.swellsrbConfig?.supportedBlocks || [];
};

/**
 * Get breakpoints configuration.
 */
export const getBreakpoints = () => {
	return window.swellsrbConfig?.breakpoints || {
		desktop: { label: 'Desktop', maxWidth: null, icon: 'desktop' },
		tablet: { label: 'Tablet', maxWidth: 1024, icon: 'tablet' },
		mobile: { label: 'Mobile', maxWidth: 767, icon: 'smartphone' },
	};
};

/**
 * Check if a block supports responsive controls.
 *
 * @param {string} blockName - The block name.
 * @return {boolean} Whether the block is supported.
 */
export const isBlockSupported = ( blockName ) => {
	return getSupportedBlocks().includes( blockName );
};

/**
 * Check if a block supports typography controls.
 *
 * @param {string} blockName - The block name.
 * @return {boolean} Whether the block supports typography.
 */
export const supportsTypography = ( blockName ) => {
	const typographyBlocks = [ 'core/heading', 'core/paragraph', 'core/button' ];
	return typographyBlocks.includes( blockName );
};

/**
 * Generate a unique ID for a block.
 *
 * @return {string} Unique ID.
 */
export const generateUniqueId = () => {
	return Math.random().toString( 36 ).substring( 2, 10 );
};
