/**
 * WordPress Dependencies
 */
import { addFilter } from '@wordpress/hooks';

/**
 * Internal Dependencies
 */
import { addResponsiveAttributes } from './extensions/attributes';
import { withResponsiveControls } from './extensions/with-responsive-controls';
import { addResponsiveClasses } from './extensions/save-props';
import './extensions/editor-classes';
import './editor.scss';

/**
 * Register block attribute extensions.
 */
addFilter(
	'blocks.registerBlockType',
	'smart-responsive-block-suite/add-attributes',
	addResponsiveAttributes
);

/**
 * Add responsive controls panel to block edit.
 */
addFilter(
	'editor.BlockEdit',
	'smart-responsive-block-suite/with-responsive-controls',
	withResponsiveControls,
	20
);

/**
 * Add responsive classes to block wrapper on save.
 */
addFilter(
	'blocks.getSaveContent.extraProps',
	'smart-responsive-block-suite/add-classes',
	addResponsiveClasses
);
