/**
 * WordPress Dependencies
 */
import { isBlockSupported } from '../utils/config';

/**
 * Add responsive classes to block wrapper on save.
 *
 * @param {Object} props     - Block props.
 * @param {Object} blockType - Block type.
 * @param {Object} attributes - Block attributes.
 * @return {Object} Modified props.
 */
export function addResponsiveClasses( props, blockType, attributes ) {
	if ( ! isBlockSupported( blockType.name ) ) {
		return props;
	}

	const classes = [ props.className || '' ];

	// Add unique block class.
	if ( attributes.responsiveId ) {
		classes.push( `rbc-block-${ attributes.responsiveId }` );
	}

	// Add visibility classes.
	if ( attributes.responsiveVisibility ) {
		if ( attributes.responsiveVisibility.hideDesktop ) {
			classes.push( 'rbc-hide-desktop' );
		}
		if ( attributes.responsiveVisibility.hideTablet ) {
			classes.push( 'rbc-hide-tablet' );
		}
		if ( attributes.responsiveVisibility.hideMobile ) {
			classes.push( 'rbc-hide-mobile' );
		}
	}

	return {
		...props,
		className: classes.filter( Boolean ).join( ' ' ).trim(),
	};
}
