/**
 * Add responsive classes to blocks in the editor.
 */
import { addFilter } from '@wordpress/hooks';
import { createHigherOrderComponent } from '@wordpress/compose';
import { isBlockSupported } from '../utils/config';

/**
 * WordPress Dependencies
 */
const { createElement } = window.wp.element;

/**
 * Add responsive classes to BlockListBlock (editor wrapper).
 */
const addResponsiveClassesToEditor = createHigherOrderComponent( ( BlockListBlock ) => {
	return ( props ) => {
		const { block, className } = props;
		const { name, attributes } = block;

		// Skip if not supported
		if ( ! isBlockSupported( name ) ) {
			return createElement( BlockListBlock, props );
		}

		// Add responsive ID class if present
		if ( attributes.responsiveId ) {
			const responsiveClass = `rbc-block-${ attributes.responsiveId }`;
			const newClassName = className ? `${ className } ${ responsiveClass }` : responsiveClass;

			return createElement( BlockListBlock, { ...props, className: newClassName } );
		}

		return createElement( BlockListBlock, props );
	};
}, 'addResponsiveClassesToEditor' );

addFilter(
	'editor.BlockListBlock',
	'smart-responsive-block-suite/add-editor-classes',
	addResponsiveClassesToEditor
);
