/**
 * WordPress Dependencies
 */
import { isBlockSupported } from '../utils/config';

/**
 * Add responsive attributes to supported blocks.
 *
 * @param {Object} settings - Block settings.
 * @param {string} name     - Block name.
 * @return {Object} Modified settings.
 */
export function addResponsiveAttributes( settings, name ) {
	if ( ! isBlockSupported( name ) ) {
		return settings;
	}

	return {
		...settings,
		attributes: {
			...settings.attributes,
			responsiveId: {
				type: 'string',
				default: '',
			},
			responsivePadding: {
				type: 'object',
				default: {},
			},
			responsiveMargin: {
				type: 'object',
				default: {},
			},
			responsiveFontSize: {
				type: 'object',
				default: {},
			},
			responsiveVisibility: {
				type: 'object',
				default: {},
			},
		},
	};
}
