/**
 * WordPress Dependencies
 */
import { FontSizePicker } from '@wordpress/components';
import { __ } from '@wordpress/i18n';

/**
 * Typography Control Component
 *
 * Matches WordPress core Typography panel.
 */
const TypographyControl = ( { selectedDevice, attributes, setAttributes } ) => {
	const fontSizeValues = attributes.responsiveFontSize || {};
	const deviceValue = fontSizeValues[ selectedDevice ] || undefined;

	// Font size presets matching WordPress core
	const fontSizes = [
		{ name: __( 'Small', 'swell-smart-responsive-blocks' ), slug: 'small', size: '13px' },
		{ name: __( 'Medium', 'swell-smart-responsive-blocks' ), slug: 'medium', size: '20px' },
		{ name: __( 'Large', 'swell-smart-responsive-blocks' ), slug: 'large', size: '36px' },
		{ name: __( 'Extra Large', 'swell-smart-responsive-blocks' ), slug: 'x-large', size: '42px' },
	];

	const handleChange = ( newValue ) => {
		const updatedFontSize = {
			...fontSizeValues,
			[ selectedDevice ]: newValue,
		};

		// Clean up empty values
		if ( ! newValue ) {
			delete updatedFontSize[ selectedDevice ];
		}

		setAttributes( { responsiveFontSize: updatedFontSize } );
	};

	const hasValue = !! deviceValue;

	return (
		<div className="rbc-typography-control" style={{ marginBottom: '16px' }}>
			<FontSizePicker
				label={ __( 'Font size', 'swell-smart-responsive-blocks' ) }
				value={ deviceValue }
				onChange={ handleChange }
				fontSizes={ fontSizes }
				disableCustomFontSizes={ false }
				withSlider
			/>
			{ ! hasValue && (
				<p className="components-base-control__help">
					{ __( 'Inherits from larger breakpoint', 'swell-smart-responsive-blocks' ) }
				</p>
			) }
		</div>
	);
};

export default TypographyControl;
