/**
 * Copy/Paste Buttons Component
 */
import { Button, Notice } from '@wordpress/components';
import { useState } from '@wordpress/element';
import { __ } from '@wordpress/i18n';
import { copy } from '@wordpress/icons';
import { copyResponsiveStyles, pasteResponsiveStyles, hasClipboardData } from '../utils/rbc-clipboard-storage';

/**
 * Copy/Paste Responsive Styles Buttons
 */
const CopyPasteButtons = ( { attributes, setAttributes } ) => {
	const [ copied, setCopied ] = useState( false );
	const [ pasted, setPasted ] = useState( false );
	const hasData = hasClipboardData();

	/**
	 * Handle copy action
	 */
	const handleCopy = () => {
		const success = copyResponsiveStyles( attributes );
		
		if ( success ) {
			setCopied( true );
			setTimeout( () => setCopied( false ), 2000 );
		}
	};

	/**
	 * Handle paste action
	 */
	const handlePaste = () => {
		const styles = pasteResponsiveStyles();
		
		if ( styles ) {
			// Merge pasted styles with existing attributes
			setAttributes( {
				...styles,
			} );
			
			setPasted( true );
			setTimeout( () => setPasted( false ), 2000 );
		}
	};

	return (
		<div className="rbc-copy-paste-controls">
			<div className="rbc-button-group">
				<Button
					variant="secondary"
					icon={ copy }
					onClick={ handleCopy }
					className="rbc-copy-button"
				>
					{ __( 'Copy Styles', 'swell-smart-responsive-blocks' ) }
				</Button>

				<Button
					variant="secondary"
					icon={ copy }
					onClick={ handlePaste }
					disabled={ ! hasData }
					className="rbc-paste-button"
				>
					{ __( 'Paste Styles', 'swell-smart-responsive-blocks' ) }
				</Button>
			</div>

			{ copied && (
				<Notice 
					status="success" 
					isDismissible={ false }
					className="rbc-notice-compact"
				>
					{ __( '✓ Responsive styles copied!', 'swell-smart-responsive-blocks' ) }
				</Notice>
			) }

			{ pasted && (
				<Notice 
					status="success" 
					isDismissible={ false }
					className="rbc-notice-compact"
				>
					{ __( '✓ Responsive styles applied!', 'swell-smart-responsive-blocks' ) }
				</Notice>
			) }

			{ ! hasData && (
				<p className="rbc-help-text">
					{ __( 'Copy responsive styles from any block to paste them here.', 'swell-smart-responsive-blocks' ) }
				</p>
			) }
		</div>
	);
};

export default CopyPasteButtons;
