<?php
/**
 * Handle block attribute registration.
 *
 * @package SwellResponsiveBlockControls
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class SWELLSRB_Attributes
 *
 * Registers custom attributes for responsive controls on supported blocks.
 */
class SWELLSRB_Attributes {

	/**
	 * Instance of this class.
	 *
	 * @var SWELLSRB_Attributes
	 */
	private static $instance = null;

	/**
	 * Get the singleton instance.
	 *
	 * @return SWELLSRB_Attributes
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor.
	 */
	private function __construct() {
		// Note: Attribute registration is handled via JavaScript filters
		// This class can be used for server-side attribute validation if needed
	}

	/**
	 * Get supported block types.
	 *
	 * @return array List of supported core blocks.
	 */
	public static function get_supported_blocks() {
		return array(
			'core/group',
			'core/columns',
			'core/column',
			'core/cover',
			'core/heading',
			'core/paragraph',
			'core/image',
			'core/buttons',
			'core/button',
			'core/spacer',
		);
	}

	/**
	 * Check if a block supports typography controls.
	 *
	 * @param string $block_name The block name.
	 * @return bool Whether the block supports typography.
	 */
	public static function supports_typography( $block_name ) {
		$typography_blocks = array(
			'core/heading',
			'core/paragraph',
			'core/button',
		);

		return in_array( $block_name, $typography_blocks, true );
	}

	/**
	 * Validate responsive attribute structure.
	 *
	 * @param mixed $value The attribute value to validate.
	 * @return bool Whether the value is valid.
	 */
	public static function validate_responsive_attribute( $value ) {
		if ( ! is_array( $value ) ) {
			return false;
		}

		$valid_breakpoints = array( 'desktop', 'tablet', 'mobile' );

		foreach ( array_keys( $value ) as $key ) {
			if ( ! in_array( $key, $valid_breakpoints, true ) ) {
				return false;
			}
		}

		return true;
	}
}
